/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.olap.xmla.MissingMemberModeEnum;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import org.apache.commons.configuration.ConversionException;

public final class XMLAConfig
implements XQEConfigurationListener {
    private static final String LOAD_ERR_MSG = "Error loading XQEODP configuration: ";
    private boolean isRegistered = false;
    private static final Boolean DEFAULT_DISABLE_PREFETCH_FACTS = null;
    private static final boolean DEFAULT_USE_CACHING = true;
    private static final boolean DEFAULT_USE_PASSPORT = false;
    private static final boolean DEFAULT_USE_FULL_BIBUSHEADER = false;
    private static final boolean DEFAULT_PREFETCH_MODEL_METADATA = true;
    private static final boolean DEFAULT_PREFETCH_MODEL_PROPERTIES = true;
    private static final boolean DEFAULT_USE_CLUSTER_FORMAT = true;
    private static final String DEFAULT_MDX_MISSING_MEMBER_MODE = "";
    public static final int DEFAULT_SOCK_CONNECTION_TIMEOUT = 90000;
    public static final int DEFAULT_SOCK_IO_TIMEOUT = 1800000;
    private static final String DEFAULT_APPLICATION_NAME = "";
    private static final int DEFAULT_TIMEOUT_DATAQUERY = -1;
    private static final int DEFAULT_TIMEOUT_METADATAQUERY = -1;
    private static final String DEFAULT_UNKNOWN_CURRENCY_SYMBOL = "*";
    private static final boolean DEFAULT_USE_SESSIONS = true;
    private static final String CONFIG_ERROR_PREFIX = "Error converting value of configuration parameter: ";
    private static final int MIN_TIMEOUT = 0;
    private Boolean disablePrefetchFacts = DEFAULT_DISABLE_PREFETCH_FACTS;
    private String mdxMissingMemberMode = "";
    private String applicationName = "";
    private int timeoutDataQuery = -1;
    private int timeoutMetadataQuery = -1;
    private String unknownCurrencySymbol = "*";
    private String providerName;
    private boolean useCaching = true;
    private boolean usePassport = false;
    private boolean passportOverride = false;
    private boolean useFullBiBusHeader = false;
    private boolean prefetchModelMetadata = true;
    private boolean prefetchModelProperties = true;
    private boolean useClusterFormat = true;
    private int httpConnectionTimeout = 90000;
    private int httpSoTimeout = 1800000;
    private boolean useSessions = true;

    public XMLAConfig(String theProviderName) {
        this.providerName = this.getConfigProviderName(theProviderName);
        if (XMLALog.isOn("Configuration", LogLevel.TRACE)) {
            XMLALog.getLogger("Configuration").log(LogLevel.TRACE, "Constructing XMLAConfig for " + this.providerName);
        }
    }

    public XMLAConfig() {
    }

    private String getConfigProviderName(String theProviderName) {
        if (theProviderName.equals("XI")) {
            return "DB2CSXMLA";
        }
        if (theProviderName.equals("X5")) {
            return "YKXMLA";
        }
        if (theProviderName.equals("X8")) {
            return "M8XMLA";
        }
        if (theProviderName.equals("XO")) {
            return "XO";
        }
        return "OtherXMLA";
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate()) {
            return;
        }
        this.reload();
    }

    public void reload() {
        XQEConfiguration config;
        if (XMLALog.isOn("Configuration", LogLevel.TRACE)) {
            XMLALog.getLogger("Configuration").log(LogLevel.TRACE, "Loading XMLAConfig");
        }
        if ((config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP)) == null) {
            if (XMLALog.isOn("Configuration", LogLevel.TRACE)) {
                XMLALog.getLogger("Configuration").log(LogLevel.TRACE, "Constructing new XQEConfiguration instance for XQEODP");
            }
            try {
                if (XMLALog.isOn("Configuration", LogLevel.ERROR)) {
                    XMLALog.getLogger("Configuration").log(LogLevel.ERROR, "user.dir=" + System.getProperty("user.dir"));
                }
                config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            catch (ConfigException ce) {
                if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey()) {
                    if (XMLALog.isOn("Configuration", LogLevel.WARN)) {
                        XMLALog.getLogger("Configuration").log(LogLevel.WARN, LOAD_ERR_MSG, (Throwable)ce);
                    }
                } else if (XMLALog.isOn("Configuration", LogLevel.ERROR)) {
                    XMLALog.getLogger("Configuration").log(LogLevel.ERROR, LOAD_ERR_MSG, (Throwable)ce);
                }
                return;
            }
        } else if (!this.isRegistered) {
            config.registerConfigurationListener((XQEConfigurationListener)this);
            this.isRegistered = true;
        }
        XQESubConfiguration configXMLA = config.getConfigForXQEODPComponent(this.providerName);
        this.loadConfigSettings(configXMLA);
        this.writeToLog();
    }

    private void loadConfigSettings(XQESubConfiguration configXMLA) {
        block51: {
            if (configXMLA != null) {
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        block40: {
                                                            block39: {
                                                                block38: {
                                                                    block37: {
                                                                        configXMLA.next();
                                                                        try {
                                                                            this.useCaching = configXMLA.getBoolean("useCaching[@value]", Boolean.valueOf(true));
                                                                        }
                                                                        catch (ConversionException ce) {
                                                                            if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block37;
                                                                            XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": useCaching : ", (Throwable)ce);
                                                                        }
                                                                    }
                                                                    try {
                                                                        this.prefetchModelMetadata = configXMLA.getBoolean("prefetchModelMetadata[@value]", Boolean.valueOf(true));
                                                                    }
                                                                    catch (ConversionException ce) {
                                                                        if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block38;
                                                                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": prefetchModelMetadata : ", (Throwable)ce);
                                                                    }
                                                                }
                                                                try {
                                                                    this.prefetchModelProperties = configXMLA.getBoolean("prefetchModelProperties[@value]", Boolean.valueOf(true));
                                                                }
                                                                catch (ConversionException ce) {
                                                                    if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block39;
                                                                    XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": prefetchModelProperties : ", (Throwable)ce);
                                                                }
                                                            }
                                                            try {
                                                                this.disablePrefetchFacts = configXMLA.getBoolean("disablePrefetchFacts[@value]", DEFAULT_DISABLE_PREFETCH_FACTS);
                                                            }
                                                            catch (ConversionException ce) {
                                                                if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block40;
                                                                XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": disablePrefetchFacts : ", (Throwable)ce);
                                                            }
                                                        }
                                                        try {
                                                            String tmpMode = configXMLA.getString("MDXMissingMemberMode[@value]", "");
                                                            this.validateMissingMemberMode(tmpMode);
                                                            this.mdxMissingMemberMode = tmpMode;
                                                        }
                                                        catch (ConversionException ce) {
                                                            if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block41;
                                                            XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": mdxMissingMemberMode : ", (Throwable)ce);
                                                        }
                                                    }
                                                    try {
                                                        int tmpTimeout = configXMLA.getInteger("timeoutDataQuery[@value]", Integer.valueOf(-1));
                                                        this.validateTimeout(tmpTimeout);
                                                        this.timeoutDataQuery = tmpTimeout;
                                                    }
                                                    catch (ConversionException ce) {
                                                        if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block42;
                                                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": timeoutDataQuery : ", (Throwable)ce);
                                                    }
                                                }
                                                try {
                                                    int tmpTimeout = configXMLA.getInteger("timeoutMetadataQuery[@value]", Integer.valueOf(-1));
                                                    this.validateTimeout(tmpTimeout);
                                                    this.timeoutMetadataQuery = tmpTimeout;
                                                }
                                                catch (ConversionException ce) {
                                                    if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block43;
                                                    XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": timeoutMetadataQuery : ", (Throwable)ce);
                                                }
                                            }
                                            try {
                                                this.applicationName = configXMLA.getString("applicationName[@value]", "");
                                            }
                                            catch (ConversionException ce) {
                                                if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block44;
                                                XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": applicationName : ", (Throwable)ce);
                                            }
                                        }
                                        try {
                                            this.useClusterFormat = configXMLA.getBoolean("useClusterFormat[@value]", Boolean.valueOf(true));
                                        }
                                        catch (ConversionException ce) {
                                            if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block45;
                                            XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": useClusterFormat : ", (Throwable)ce);
                                        }
                                    }
                                    try {
                                        int tmpTimeout = configXMLA.getInteger("httpConnectionTimeout[@value]", Integer.valueOf(90000));
                                        this.validateTimeout(tmpTimeout);
                                        if (tmpTimeout != -1) {
                                            this.httpConnectionTimeout = tmpTimeout;
                                        }
                                    }
                                    catch (ConversionException ce) {
                                        if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block46;
                                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": httpConnectionTimeout : ", (Throwable)ce);
                                    }
                                }
                                try {
                                    int tmpTimeout = configXMLA.getInteger("httpSoTimeout[@value]", Integer.valueOf(1800000));
                                    this.validateTimeout(tmpTimeout);
                                    if (tmpTimeout != -1) {
                                        this.httpSoTimeout = tmpTimeout;
                                    }
                                }
                                catch (ConversionException ce) {
                                    if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block47;
                                    XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": httpSoTimeout : ", (Throwable)ce);
                                }
                            }
                            try {
                                this.unknownCurrencySymbol = configXMLA.getString("unknownCurrencySymbol[@value]", DEFAULT_UNKNOWN_CURRENCY_SYMBOL);
                            }
                            catch (ConversionException ce) {
                                if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block48;
                                XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": unknownCurrencySymbol : ", (Throwable)ce);
                            }
                        }
                        try {
                            this.useSessions = configXMLA.getBoolean("useSessions[@value]", Boolean.valueOf(true));
                        }
                        catch (ConversionException ce) {
                            if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block49;
                            XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": useSessions : ", (Throwable)ce);
                        }
                    }
                    try {
                        Boolean tmp = configXMLA.getBoolean("usePassport[@value]", null);
                        if (null != tmp) {
                            this.usePassport = tmp;
                            this.passportOverride = true;
                        } else {
                            this.passportOverride = false;
                        }
                    }
                    catch (ConversionException ce) {
                        if (!XMLALog.isOn("Configuration", LogLevel.ERROR)) break block50;
                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": usePassport : ", (Throwable)ce);
                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, "passportOverride is: " + this.passportOverride);
                    }
                }
                try {
                    this.useFullBiBusHeader = configXMLA.getBoolean("useFullBiBusHeader[@value]", Boolean.valueOf(false));
                }
                catch (ConversionException ce) {
                    if (XMLALog.isOn("Configuration", LogLevel.ERROR)) {
                        XMLALog.getLogger("Configuration").log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": useFullBiBusHeader : ", (Throwable)ce);
                    }
                    break block51;
                }
            }
            if (XMLALog.isOn("Configuration", LogLevel.TRACE)) {
                XMLALog.getLogger("Configuration").log(LogLevel.TRACE, "Configuration for " + this.providerName + " provider not found");
            }
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    private void validateTimeout(int tmpTimeout) {
        if (tmpTimeout != -1 && tmpTimeout < 0) {
            throw new ConversionException();
        }
    }

    private void validateMissingMemberMode(String theMDXMissingMemberMode) {
        try {
            MissingMemberModeEnum.stringToMissingMemberMode(theMDXMissingMemberMode);
        }
        catch (XMLAException ex) {
            throw new ConversionException((Throwable)((Object)ex));
        }
    }

    public Boolean getDisablePrefetchFacts() {
        return this.disablePrefetchFacts;
    }

    public boolean getUseCaching() {
        return this.useCaching;
    }

    public boolean getPrefetchModelMetadata() {
        return this.prefetchModelMetadata;
    }

    public boolean getPrefetchModelProperties() {
        return this.prefetchModelProperties;
    }

    public String getMDXMissingMemberMode() {
        return this.mdxMissingMemberMode;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getTimeoutDataQuery() {
        return this.timeoutDataQuery;
    }

    public int getTimeoutMetadataQuery() {
        return this.timeoutMetadataQuery;
    }

    public boolean getUseClusterFormat() {
        return this.useClusterFormat;
    }

    public int getHTTPConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public int getHTTPSoTimeout() {
        return this.httpSoTimeout;
    }

    public String getUnknownCurrencySymbol() {
        return this.unknownCurrencySymbol;
    }

    public boolean getUseSessions() {
        return this.useSessions;
    }

    public boolean getUsePassport() {
        return this.usePassport;
    }

    public boolean getUseFullBiBusHeader() {
        return this.useFullBiBusHeader;
    }

    public boolean getUsePassportOverride() {
        return this.passportOverride;
    }

    public void writeToLog() {
        if (XMLALog.isOn("Configuration", LogLevel.WARN)) {
            XQELogger logger = XMLALog.getLogger("Configuration");
            logger.log(LogLevel.WARN, this.providerName + ": useCaching: " + this.useCaching);
            logger.log(LogLevel.WARN, this.providerName + ": useSessions: " + this.useSessions);
            logger.log(LogLevel.WARN, this.providerName + ": usePassport: " + this.usePassport);
            logger.log(LogLevel.WARN, this.providerName + ": useFullBiBusHeader: " + this.useFullBiBusHeader);
            logger.log(LogLevel.WARN, this.providerName + ": passportOverride: " + this.passportOverride);
            logger.log(LogLevel.WARN, this.providerName + ": prefetchModelMetadata: " + this.prefetchModelMetadata);
            logger.log(LogLevel.WARN, this.providerName + ": prefetchModelProperties: " + this.prefetchModelProperties);
            logger.log(LogLevel.WARN, this.providerName + ": disablePrefetchFacts: " + this.disablePrefetchFacts);
            logger.log(LogLevel.WARN, this.providerName + ": mdxMissingMemberMode: " + this.mdxMissingMemberMode);
            logger.log(LogLevel.WARN, this.providerName + ": timeoutDataQuery: " + this.timeoutDataQuery);
            logger.log(LogLevel.WARN, this.providerName + ": timeoutMetadataQuery: " + this.timeoutMetadataQuery);
            logger.log(LogLevel.WARN, this.providerName + ": applicationName: " + this.applicationName);
            logger.log(LogLevel.WARN, this.providerName + ": useClusterFormat: " + this.useClusterFormat);
            logger.log(LogLevel.WARN, this.providerName + ": httpConnectionTimeout: " + this.httpConnectionTimeout);
            logger.log(LogLevel.WARN, this.providerName + ": httpSoTimeout: " + this.httpSoTimeout);
            logger.log(LogLevel.WARN, this.providerName + ": unknownCurrencySymbol: " + this.unknownCurrencySymbol);
        }
    }
}

