/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.olap.common.BiBusHeaderElementParameter;
import com.cognos.xqe.data.olap.common.CAMPassportElementParameter;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.xmla.KeyValueList;
import com.cognos.xqe.data.providers.olap.xmla.KeyValuePair;
import com.cognos.xqe.data.providers.olap.xmla.UseSSLParameter;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfig;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfigManager;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConnection;
import com.cognos.xqe.data.providers.olap.xmla.XMLACubeResultSet;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMetadataProvider;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ExceptionUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class XMLADataProvider
extends OLAPDataProviderBase {
    public static final String AMPERSAND_SEPARATOR = "].&[";
    public static final String DATAMEMBER_SUFFIX = ".DATAMEMBER]";
    private static final String DOT = ".";
    private static final String DOT_REGEX = "\\.";
    public static final String MSAS2005_MAJOR_VERSION = "9";
    public static final String MSAS2008_MAJOR_VERSION = "10";
    public static final String MSAS2012_MAJOR_VERSION = "11";
    public static final String MSAS2014_MAJOR_VERSION = "12";
    public static final String MSAS2016_MAJOR_VERSION = "13";
    public static final String MSAS2017_MAJOR_VERSION = "14";
    public static final String MSAS2019_MAJOR_VERSION = "15";
    public static final String MSAS_NAME = "Microsoft SQL Server Analysis Services";
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final XMLAConnectionFactory mXMLAConnectionFactory;
    private final IConnectionFactory mConnectionFactory;

    public XMLADataProvider(String instanceName, Properties properties) {
        super(instanceName, properties);
        if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
            XMLALog.getLogger("Metadata").log(LogLevel.INFO, "Constructing XMLADataProvider, instance=" + instanceName + ", properties=" + properties.toString());
        }
        this.mXMLAConnectionFactory = new XMLAConnectionFactory();
        this.mConnectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary((IConnectionFactory)new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mXMLAConnectionFactory, instanceName), (Properties)this.getProperties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArguments) {
        ICube cube = theQueryArguments.getCube();
        int nExpectedEdges = theQueryArguments.getMDXQuery().getNumberOfEdges();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)xDataContext.getEnvironment();
        ConnectionParameters connParams = this.createConnectionParameters((IExecutionEnvironment)execEnv, theQueryArguments);
        XMLAConnection xmlaConn = null;
        try {
            xmlaConn = (XMLAConnection)((Object)this.borrowConnection(connParams, (IExecutionEnvironment)execEnv).getConnection());
            KeyValueList resultProperties = new KeyValueList();
            XMLALogContext logCtx = XMLALogContext.enter();
            logCtx.setEnvironment((IExecutionEnvironment)execEnv);
            logCtx.setExecuteHint("Execute");
            try {
                XMLADataset dataset = xmlaConn.performExecuteRequest(execEnv, theQueryArguments.getMDXText(), nExpectedEdges, resultProperties);
                XMLACubeResultSet xMLACubeResultSet = new XMLACubeResultSet(this, xmlaConn, xDataContext, theQueryArguments, cube, dataset);
                return xMLACubeResultSet;
            }
            catch (RuntimeException ex) {
                xmlaConn.returnToPool();
                throw ex;
            }
            finally {
                logCtx.exit();
            }
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw e;
        }
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        boolean bMetadataQueryIntent = queryArgs.getMDXQuery().isQueryIntentMetadata();
        return XMLADataProvider.createConnectionParams(env, (QueryArguments)queryArgs, bMetadataQueryIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IExecutionEnvironment execEnv = theQueryArguments.getExecutionEnvironment();
        ConnectionParameters connParams = XMLADataProvider.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments, false);
        try {
            XMLAConnection conn = (XMLAConnection)((Object)this.mXMLAConnectionFactory.createConnection(connParams));
            try {
                conn.resolveDataSourceInfo(execEnv);
                conn.resolveDataSourceProperties(execEnv);
                IDataSource dataSource = (IDataSource)connParams.valueOf(DataSourceParameter.class, IDataSource.class);
                this.validateProviderVersion(conn, dataSource, execEnv);
            }
            finally {
                this.mXMLAConnectionFactory.destroyConnection(conn);
            }
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw e;
        }
        return null;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        ConnectionParameters connParams = XMLADataProvider.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments, true);
        XMLAMetadataProvider provider = new XMLAMetadataProvider(this, connParams);
        provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "XMLA", "XMLAMetadataProvider");
        return provider;
    }

    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        if (cognosUN.endsWith(DATAMEMBER_SUFFIX) || cognosUN.indexOf(AMPERSAND_SEPARATOR) >= 0) {
            StringBuilder strBuf = new StringBuilder(cognosUN);
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.deleteCharAt(0);
            int index = strBuf.indexOf("]]");
            while (index != -1) {
                strBuf.deleteCharAt(index);
                if (index >= strBuf.length()) break;
                index = strBuf.indexOf("]]", index);
            }
            return strBuf.toString();
        }
        return cognosUN;
    }

    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        String cognosMun;
        if (nativeUN == null) {
            return null;
        }
        int indexOfAmp = nativeUN.indexOf(AMPERSAND_SEPARATOR);
        if (indexOfAmp < 0 && nativeUN.endsWith("]")) {
            cognosMun = nativeUN;
        } else {
            StringBuilder newUN = new StringBuilder();
            newUN.append("[");
            int len = nativeUN.length();
            for (int i = 0; i < len; ++i) {
                char ch = nativeUN.charAt(i);
                newUN.append(ch);
                if (ch != "]".charAt(0)) continue;
                newUN.append("]");
            }
            newUN.append("]");
            cognosMun = newUN.toString();
        }
        return cognosMun;
    }

    protected static ConnectionParameters createConnectionParams(IExecutionEnvironment executionEnvironment, QueryArguments theQueryArgs, boolean bMetadataQueryIntent) {
        IDataSource dataSource = theQueryArgs.getDataSource();
        Locale runLocale = theQueryArgs.getRunLocale();
        IDataSourceConnection connection = dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon signon = connection.getSignon();
        String providerType = dataSource.getType();
        String connectionString = connection.getConnectionString(null);
        final boolean upperCaseCatalog = theQueryArgs.getDataSource().getCapabilities().isSupported("olap.metadata.caseInsensitiveCatalog");
        final ConnectionParameters parameters = new ConnectionParameters();
        ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){

            public void onKeyValueToken(String key, String value) {
                if (key.equals("SERVER")) {
                    parameters.put((IConnectionParameter)new ServerParameter(value));
                } else if (key.equals("CATALOG")) {
                    if (upperCaseCatalog) {
                        parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(value));
                        if (XMLALog.isOn("Connection", LogLevel.TRACE)) {
                            XMLALog.getLogger("Connection").log(LogLevel.TRACE, "XMLA Connection string has upper case catalog=" + value);
                        }
                    } else {
                        parameters.put((IConnectionParameter)new CatalogParameter(value));
                        if (XMLALog.isOn("Connection", LogLevel.TRACE)) {
                            XMLALog.getLogger("Connection").log(LogLevel.TRACE, "XMLA Connection string has catalog=" + value);
                        }
                    }
                } else if (key.equals("SSL") && "yes".equals(value)) {
                    parameters.put((IConnectionParameter)new UseSSLParameter());
                }
            }

            public void onSimpleToken(String value) {
            }
        });
        if (XMLADataProvider.isPassportRequired(theQueryArgs, providerType)) {
            XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
            if (currConfig.getUseFullBiBusHeader()) {
                BiBusHeaderElementParameter.resolveBiBusHeader((IExecutionEnvironment)executionEnvironment, (ConnectionParameters)parameters, (boolean)true);
            } else {
                CAMPassportElementParameter.resolveCAMPassport((IExecutionEnvironment)executionEnvironment, (ConnectionParameters)parameters, (boolean)true);
            }
        }
        parameters.put((IConnectionParameter)new DataSourceParameter(dataSource));
        parameters.put((IConnectionParameter)new ProviderTypeParameter(providerType));
        parameters.put((IConnectionParameter)new RunLocaleParameter(runLocale, true));
        Locale catalogLocale = runLocale;
        String catalog = upperCaseCatalog ? (String)parameters.valueOf(UpperCaseCatalogParameter.class, String.class) : (String)parameters.valueOf(CatalogParameter.class, String.class);
        if (null == catalog) {
            Map metadataProps = theQueryArgs.getDataSource().getMetadataProperties();
            catalog = (String)metadataProps.get("catalog");
            if (catalog != null) {
                if (upperCaseCatalog) {
                    catalog = catalog.toUpperCase(catalogLocale);
                    parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(catalog));
                    if (XMLALog.isOn("Connection", LogLevel.TRACE)) {
                        XMLALog.getLogger("Connection").log(LogLevel.TRACE, "XMLA upper case catalog from query arguments=" + catalog);
                    }
                } else {
                    parameters.put((IConnectionParameter)new CatalogParameter(catalog));
                    if (XMLALog.isOn("Connection", LogLevel.TRACE)) {
                        XMLALog.getLogger("Connection").log(LogLevel.TRACE, "XML catalog from query arguments=" + catalog);
                    }
                }
            }
        } else if (upperCaseCatalog) {
            catalog = catalog.toUpperCase(catalogLocale);
            parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(catalog));
        } else {
            parameters.put((IConnectionParameter)new CatalogParameter(catalog));
        }
        if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
            parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
            parameters.put((IConnectionParameter)new PasswordParameter(userPwdSignon.getPassword()));
        }
        return parameters;
    }

    private static boolean isPassportRequired(QueryArguments theQueryArgs, String providerType) {
        boolean passportRequired = false;
        boolean supportsPassports = theQueryArgs.getDataSource().getCapabilities().isSupported("xmla.supportCAMPassports");
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        if (currConfig.getUsePassportOverride()) {
            if (currConfig.getUsePassport()) {
                passportRequired = true;
            }
        } else if (supportsPassports) {
            passportRequired = true;
        }
        return passportRequired;
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters theConnParams, IExecutionEnvironment execEnv) {
        IDataSource dataSource = (IDataSource)theConnParams.valueOf(DataSourceParameter.class, IDataSource.class);
        IPooledConnection pooledConn = null;
        try {
            pooledConn = execEnv.getConnectionPool().borrowConnection(this.getProviderInstanceName(), theConnParams, this.selector, this.mConnectionFactory);
            XMLAConnection xmlaConn = (XMLAConnection)((Object)pooledConn.getConnection());
            try {
                xmlaConn.setPooledConnection(pooledConn);
                xmlaConn.resolveDataSourceInfo(execEnv);
                xmlaConn.resolveDataSourceProperties(execEnv);
                this.validateProviderVersion(xmlaConn, dataSource, execEnv);
                XMLADataProvider.initializeDataSourceCapabilities(xmlaConn, dataSource, (ExecutionEnvironment)execEnv);
            }
            catch (RuntimeException ex) {
                xmlaConn.setPooledConnection(null);
                pooledConn.setNotReusable();
                pooledConn.returnConnection();
                throw ex;
            }
        }
        catch (LogonFailureException ex) {
            if (XMLALog.isOn("Connection", LogLevel.ERROR)) {
                XMLALog.getLogger("Connection").log(LogLevel.ERROR, (Throwable)ex);
            }
            if (ex.getDataSource() == null) {
                ex.setDataSource(dataSource);
            }
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            throw ex;
        }
        return pooledConn;
    }

    private void validateProviderVersion(XMLAConnection connection, IDataSource dataSource, IExecutionEnvironment execEnv) {
        String dataSourceType = dataSource.getType();
        String version = null;
        KeyValueList dataSourceProps = connection.getDataSourceProperties();
        if (null != dataSourceProps) {
            for (KeyValuePair prop : dataSourceProps) {
                if (!((String)prop.getKey()).equals("ProviderVersion")) continue;
                version = (String)prop.getValue();
            }
        }
        if (version == null) {
            throw new XMLAException(XMLAMessageKeys.CON_UNSUPPORTED_PROVIDER_VERSION, "", MSAS_NAME);
        }
        int firstDot = version.indexOf(DOT);
        String majorVersion = firstDot > 0 ? version.substring(0, firstDot) : version;
        if (dataSourceType.equals("X5") && !majorVersion.equals(MSAS2005_MAJOR_VERSION)) {
            throw new XMLAException(XMLAMessageKeys.CON_PROVIDER_X5);
        }
        if (!(!dataSourceType.equals("X8") || majorVersion.equals(MSAS2008_MAJOR_VERSION) || majorVersion.equals(MSAS2012_MAJOR_VERSION) || majorVersion.equals(MSAS2014_MAJOR_VERSION) || majorVersion.equals(MSAS2016_MAJOR_VERSION) || majorVersion.equals(MSAS2017_MAJOR_VERSION) || majorVersion.equals(MSAS2019_MAJOR_VERSION))) {
            throw new XMLAException(XMLAMessageKeys.CON_UNSUPPORTED_PROVIDER_VERSION, version, MSAS_NAME);
        }
    }

    protected static void initializeDataSourceCapabilities(XMLAConnection connection, IDataSource dataSource, ExecutionEnvironment env) {
        String dataSourceType = dataSource.getType();
        String version = null;
        KeyValueList dataSourceProps = connection.getDataSourceProperties();
        if (null != dataSourceProps) {
            for (KeyValuePair prop : dataSourceProps) {
                if (!((String)prop.getKey()).equals("ProviderVersion")) continue;
                version = (String)prop.getValue();
            }
        }
        if (null != version) {
            version = XMLADataProvider.formatProviderVersion(version);
        }
        CapabilitiesKey key = new CapabilitiesKey(dataSourceType, version);
        IDataSourceCapabilities dataSourceCapabilities = ProviderCapabilites.getInstance().getCapabilities(key);
        dataSource.setCapabilities(dataSourceCapabilities);
        if (null == dataSourceCapabilities) {
            dataSourceCapabilities = dataSource.createCapabilities(new CapabilitiesKeyParts(version), null);
            ProviderCapabilites.getInstance().addCapabilities(key, dataSourceCapabilities);
        }
        if (null == connection.getCapabilities()) {
            connection.resolveCapabilities(dataSourceCapabilities);
        }
    }

    private static String formatProviderVersion(String version) {
        if (version.indexOf(DOT) < 0) {
            return version;
        }
        String[] parts = version.split(DOT_REGEX, 3);
        int major = Integer.MIN_VALUE;
        int minor = Integer.MIN_VALUE;
        int revision = Integer.MIN_VALUE;
        if (parts.length > 0) {
            try {
                major = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException ex) {
                return version;
            }
        }
        if (parts.length > 1) {
            try {
                minor = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ex) {
                return version;
            }
        }
        if (parts.length > 2) {
            try {
                revision = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException ex) {
                return version;
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(major);
        if (minor != Integer.MIN_VALUE) {
            buffer.append(DOT).append(minor);
        }
        if (revision != Integer.MIN_VALUE) {
            buffer.append(DOT).append(revision);
        }
        return buffer.toString();
    }

    public void releaseImpl() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        if (XMLALog.isOn("DataQuery", LogLevel.INFO)) {
            XMLALog.getLogger("DataQuery").log(LogLevel.INFO, "Releasing XMLA data provider.");
        }
    }

    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale designLocale) {
        MetadataQueryArguments queryArgs = new MetadataQueryArguments(dataSource, executionEnv, designLocale);
        ConnectionParameters connParams = XMLADataProvider.createConnectionParams(executionEnv, (QueryArguments)queryArgs, false);
        IPooledConnection pooledConnection = this.borrowConnection(connParams, executionEnv);
        pooledConnection.returnConnection();
    }

    protected final class XMLAConnectionFactory
    implements IConnectionFactory {
        protected XMLAConnectionFactory() {
        }

        public Object createConnection(ConnectionParameters connParams) {
            XMLAConnection xmlaConn = new XMLAConnection(XMLADataProvider.this);
            if (XMLALog.isOn("Connection", LogLevel.INFO)) {
                XMLALog.getLogger("Connection").log(LogLevel.INFO, "Creating new connection with parameters " + connParams.toString());
            }
            xmlaConn.open(connParams);
            return xmlaConn;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            this.destroyConnection((XMLAConnection)((Object)pooledConnection.getConnection()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroyConnection(XMLAConnection connection) {
            if (XMLALog.isOn("Connection", LogLevel.INFO)) {
                XMLALog.getLogger("Connection").log(LogLevel.INFO, "Destroying connection " + (Object)((Object)connection));
            }
            XMLALogContext logCtx = XMLALogContext.enter();
            logCtx.setEnvironment(null);
            logCtx.setExecuteHint("EndSession");
            try {
                connection.endSession();
            }
            catch (Throwable ex) {
                XMLALog.getLogger("Connection", LogLevel.ERROR).log(ExceptionUtil.getStackTrace((Throwable)ex));
            }
            finally {
                logCtx.exit();
                connection.close();
            }
        }
    }
}

