/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.olap.common.MSASCommonActions;
import com.cognos.xqe.data.olap.common.MSASCommonAggregators;
import com.cognos.xqe.data.olap.common.MSASCommonDatatypes;
import com.cognos.xqe.data.olap.common.MSASCommonDimTypes;
import com.cognos.xqe.data.olap.common.MSASCommonHierStructure;
import com.cognos.xqe.data.olap.common.MSASCommonMemberTypes;
import com.cognos.xqe.data.olap.common.MSASCommonTreeOp;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.OlapMetadataCacheService;
import com.cognos.xqe.data.providers.olap.xmla.KeyValueList;
import com.cognos.xqe.data.providers.olap.xmla.UseSSLParameter;
import com.cognos.xqe.data.providers.olap.xmla.XMLACapabilities;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfig;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfigManager;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConnection;
import com.cognos.xqe.data.providers.olap.xmla.XMLADataProvider;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAMember;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARow;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARowset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.metadata.ActionTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.PPDSCodeTypeEnum;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RankComparator;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class XMLAMetadataProvider
extends MetadataProviderEnvironmentHelper<XMLAConnection>
implements IOLAPMetadataProvider {
    private static final String MEASURES_STRING = "[Measures]";
    private static final String MEASURES_LUN_STRING = "[Measures].[MeasuresLevel]";
    private static final String STARTING_BRACKET = "[";
    private static final String ENDING_BRACKET = "]";
    private static final String COMMA_SEPARATOR = ",";
    private static final String KEY_SUFFIX = " - Key";
    private static final String MEMBER_KEY_PROPERTY_NAME = "MEMBER_KEY";
    private static final String DOT_MEMBER_KEY_PROPERTY_NAME = ".MEMBER_KEY";
    private static final String PC_LEVEL_PREFIX = "Level ";
    private static final String PC_ALL_LEVEL = "(All)";
    private static final String LOGMSG_MDCACHE_HIT = "Metadata cache satisfied query for ";
    private static final String LOGMSG_MDCACHE_MISS = "Metadata cache did not satisfy query for ";
    private static final String LOGMSG_WITH_RESTRICTIONS = " with restrictions ";
    private static final String FAKE_LEVEL_BASED_HIERARCHY = "isFakeLevelBasedHierarchy";
    private static final int MAX_SET_EXPRESSION_LENGTH = 1024;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private static final DateTimeValue TIMESTAMP = DataValueFactory.createTimestampValue();
    private final String providerType;
    private boolean forceRollupToComputed = false;

    XMLAMetadataProvider(XMLADataProvider provider, ConnectionParameters connectionParameters) {
        super((OLAPDataProviderBase)provider, connectionParameters);
        if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
            StringBuilder sTmp = new StringBuilder();
            sTmp.append("Constructing metadata provider for ");
            sTmp.append(this.getDataProvider().getProviderInstanceName());
            sTmp.append(", connectionParameters=");
            sTmp.append(connectionParameters);
            XMLALog.getLogger("Metadata").log(LogLevel.INFO, sTmp.toString());
        }
        this.providerType = (String)connectionParameters.valueOf(ProviderTypeParameter.class, String.class);
    }

    private <T extends MetadataRecord> List<T> getCachedMetadata(MetadataOperation mdOperation, IRestrictions restrictions) {
        IOLAPMetadataCache cache = OlapMetadataCacheService.getInstance().getCache(this.getCacheParameters(restrictions));
        List answer = cache.getMetadata(mdOperation, restrictions);
        if (null != answer) {
            XMLAMetadataProvider.logMetadataCacheHit(mdOperation, restrictions);
        } else {
            XMLAMetadataProvider.logMetadataCacheMiss(mdOperation, restrictions);
        }
        return answer;
    }

    private <T extends MetadataRecord> void putCachedMetadata(MetadataOperation mdOperation, IRestrictions restrictions, List<T> records) {
        IOLAPMetadataCache cache = OlapMetadataCacheService.getInstance().getCache(this.getCacheParameters(restrictions));
        cache.putMetadata(mdOperation, restrictions, records);
    }

    private boolean canUseCache() {
        XMLAConfig currConfig = XMLAConfigManager.getConfig(this.providerType);
        return currConfig.getUseCaching();
    }

    private boolean canPrefetchModelMetadata() {
        XMLAConfig currConfig = XMLAConfigManager.getConfig(this.providerType);
        return currConfig.getPrefetchModelMetadata();
    }

    private void fixCatalogNameCase(IRestrictions restrictions) {
        String catalogName;
        String upperCaseCatalogName = (String)this.connectionParameters.valueOf(UpperCaseCatalogParameter.class, String.class);
        if (null != upperCaseCatalogName && (catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class)) != null) {
            restrictions.add(RestrictionType.CATALOG, (Object)upperCaseCatalogName);
        }
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        this.fixCatalogNameCase(restrictions);
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(UpperCaseCatalogParameter.class);
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        connParams.remove(UseSSLParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(this.connectionParameters);
        cacheParams.put("FACTORY_NAME", (Object)"MSASCacheFactory");
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        return cacheParams;
    }

    protected KeyValueList getActionRestrictions(IRestrictions restrictions) {
        KeyValueList xmlaRestrictions = new KeyValueList();
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        xmlaRestrictions.add("CATALOG_NAME", resCatalogName);
        xmlaRestrictions.add("CUBE_NAME", resCubeName);
        return xmlaRestrictions;
    }

    private void getActionsInternal(ExecutionEnvironment executionEnvironment, XMLAConnection connection, List<ActionRecord> actionRecords, IRestrictions restrictions, KeyValueList xmlaRestrictions, String originalCoordinate) {
        KeyValueList xmlaProperties = new KeyValueList();
        XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_ACTIONS", xmlaRestrictions, xmlaProperties);
        int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
        int actionNameOrd = rowset.getColumnOrdinal("ACTION_NAME");
        int actionTypeOrd = rowset.getColumnOrdinal("ACTION_TYPE");
        int coordinateTypeOrd = rowset.getColumnOrdinal("COORDINATE_TYPE");
        int actionCaptionOrd = rowset.getColumnOrdinal("ACTION_CAPTION");
        int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
        int actionContentOrd = rowset.getColumnOrdinal("CONTENT");
        ActionTypeEnum actionType = null;
        for (int i = 0; i < rowset.numRows(); ++i) {
            XMLARow currentRow = rowset.getRow(i);
            boolean addAction = false;
            XMLAValue value = currentRow.getValue(actionTypeOrd);
            if (!value.isNull()) {
                actionType = MSASCommonActions.convertIntToActionTypeEnum((int)value.getInteger());
                if (actionType == ActionTypeEnum.HTML || actionType == ActionTypeEnum.URL) {
                    addAction = true;
                }
            } else {
                XMLAMetadataProvider.throwMissingColumnException("ACTION_TYPE");
            }
            if (!addAction) continue;
            ActionRecord action = new ActionRecord();
            action.setCommandType(actionType);
            action.setCatalogName(this.getCatalogNameFromConnection(connection));
            value = currentRow.getValue(cubeNameOrd);
            if (!value.isNull()) {
                action.setCubeName(value.toString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
            }
            value = currentRow.getValue(actionNameOrd);
            if (!value.isNull()) {
                action.setName(value.toString());
                action.setUniqueName(value.toString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("ACTION_NAME");
            }
            value = currentRow.getValue(actionCaptionOrd);
            if (!value.isNull()) {
                LocalizedString localizedCaption = this.getLocalizedString(connection, value.toString());
                action.setCaption((ILocalizedString)localizedCaption);
            } else {
                XMLAMetadataProvider.throwMissingColumnException("ACTION_CAPTION");
            }
            value = currentRow.getValue(actionContentOrd);
            if (!value.isNull()) {
                action.setCommand(value.toString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("Content");
            }
            value = currentRow.getValue(coordinateTypeOrd);
            if (!value.isNull()) {
                action.setCoordinateType(MSASCommonActions.convertIntToActionCoordinateTypeEnumSet((int)value.getInteger()));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("COORDINATE_TYPE");
            }
            action.setCoordinateValue(originalCoordinate);
            value = currentRow.getValue(descriptionOrd);
            if (!value.isNull()) {
                action.setDescription(value.toString());
            }
            actionRecords.add(action);
        }
    }

    private void getActionsForCubes(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, ArrayList<ActionRecord> actionRecords) {
        KeyValueList xmlaRestrictions = this.getActionRestrictions(restrictions);
        xmlaRestrictions.add("COORDINATE", (String)restrictions.getValueOf(RestrictionType.CUBE));
        int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.CUBE));
        xmlaRestrictions.add("COORDINATE_TYPE", Integer.toString(code));
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
            XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Actions for CUBE:" + cubeName);
        }
        this.getActionsInternal(executionEnvironment, connection, actionRecords, restrictions, xmlaRestrictions, cubeName);
    }

    private void getActionsForDimensions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, ArrayList<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        KeyValueList xmlaRestrictions = this.getActionRestrictions(restrictions);
        XMLACapabilities capabilities = connection.getCapabilities();
        for (String sTemp : resCoordinates) {
            if (null != sTemp) {
                if (capabilities.canUseMUNsForActionRestrictions()) {
                    if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                        XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Dimension Actions for MUN:" + sTemp);
                    }
                    xmlaRestrictions.add("COORDINATE", sTemp);
                } else {
                    MetadataRestriction newRestrictions = new MetadataRestriction();
                    newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
                    newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
                    newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)sTemp);
                    MemberRecord memberRec = this.getMemberRecord(executionEnvironment, connection, (IRestrictions)newRestrictions, sTemp);
                    if (null != memberRec) {
                        String hierarchyUniqueName = memberRec.getHierarchyUniqueName();
                        if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                            XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Dimension Actions for HUN:" + hierarchyUniqueName);
                        }
                        xmlaRestrictions.add("COORDINATE", hierarchyUniqueName);
                    } else {
                        throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_MEMBER, sTemp);
                    }
                }
            }
            int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.DIMENSION));
            xmlaRestrictions.add("COORDINATE_TYPE", Integer.toString(code));
            this.getActionsInternal(executionEnvironment, connection, actionRecords, restrictions, xmlaRestrictions, sTemp);
        }
    }

    private void getActionsForLevels(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, ArrayList<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        KeyValueList xmlaRestrictions = this.getActionRestrictions(restrictions);
        XMLACapabilities capabilities = connection.getCapabilities();
        for (String sTemp : resCoordinates) {
            if (null != sTemp) {
                if (capabilities.canUseMUNsForActionRestrictions()) {
                    if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                        XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Level Actions for MUN:" + sTemp);
                    }
                    xmlaRestrictions.add("COORDINATE", sTemp);
                } else {
                    MetadataRestriction newRestrictions = new MetadataRestriction();
                    newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
                    newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
                    newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)sTemp);
                    MemberRecord memberRec = this.getMemberRecord(executionEnvironment, connection, (IRestrictions)newRestrictions, sTemp);
                    if (null != memberRec) {
                        String levelUniqueName = memberRec.getLevelUniqueName();
                        if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                            XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Level Actions for LUN:" + levelUniqueName);
                        }
                        xmlaRestrictions.add("COORDINATE", levelUniqueName);
                    } else {
                        throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_MEMBER, sTemp);
                    }
                }
            }
            int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.LEVEL));
            xmlaRestrictions.add("COORDINATE_TYPE", Integer.toString(code));
            this.getActionsInternal(executionEnvironment, connection, actionRecords, restrictions, xmlaRestrictions, sTemp);
        }
    }

    private void getActionsForMembers(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        KeyValueList xmlaRestrictions = this.getActionRestrictions(restrictions);
        for (String sTemp : resCoordinates) {
            if (null != sTemp) {
                if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                    XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Actions for MEMBER:" + sTemp);
                }
                xmlaRestrictions.add("COORDINATE", sTemp);
            }
            int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.MEMBER));
            xmlaRestrictions.add("COORDINATE_TYPE", Integer.toString(code));
            this.getActionsInternal(executionEnvironment, connection, actionRecords, restrictions, xmlaRestrictions, sTemp);
        }
    }

    private void getActionsForCells(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        Collection resDimensionLine = (Collection)restrictions.getValueOf(RestrictionType.DIMENSION_LINE);
        KeyValueList xmlaRestrictions = this.getActionRestrictions(restrictions);
        StringBuilder sTuple = new StringBuilder();
        sTuple.append("(");
        boolean bAdded = false;
        if (null != resCoordinates) {
            for (String sTemp : resCoordinates) {
                if (null == sTemp) continue;
                if (bAdded) {
                    sTuple.append(COMMA_SEPARATOR);
                } else {
                    bAdded = true;
                }
                sTuple.append(sTemp);
            }
        }
        if (null != resDimensionLine) {
            for (String sTemp : resDimensionLine) {
                if (null == sTemp) continue;
                if (bAdded) {
                    sTuple.append(COMMA_SEPARATOR);
                } else {
                    bAdded = true;
                }
                sTuple.append(sTemp);
            }
        }
        sTuple.append(")");
        if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
            XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Actions for CELL:" + sTuple.toString());
        }
        xmlaRestrictions.add("COORDINATE", sTuple.toString());
        int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.CELL));
        xmlaRestrictions.add("COORDINATE_TYPE", Integer.toString(code));
        this.getActionsInternal(executionEnvironment, connection, actionRecords, restrictions, xmlaRestrictions, "");
    }

    protected List<ActionRecord> getActions(ExecutionEnvironment executionEnvironment, IRestrictions restrictions) {
        this.validateActionRestrictions(restrictions);
        List actions = super.getActions(executionEnvironment, restrictions);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = actions.size();
            if (size != 0) {
                size = Math.min(size, actions.size());
                toIndex = Math.min(from + size, actions.size());
            }
            if (from >= toIndex) {
                return Collections.emptyList();
            }
            return actions.subList(from, toIndex);
        }
        if (0 != size) {
            int toIndex = Math.min(size, actions.size());
            return actions.subList(from, toIndex);
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionRecord> getActions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        EnumSet resCoordinateType = (EnumSet)restrictions.getValueOf(RestrictionType.COORDINATE_TYPE);
        ArrayList<ActionRecord> actionRecords = new ArrayList<ActionRecord>();
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.ACTIONS);
        try {
            if (resCoordinateType.contains(ActionCoordinateTypeEnum.CUBE)) {
                this.getActionsForCubes(executionEnvironment, connection, restrictions, actionRecords);
            }
            Collection resCoordinates = (Collection)restrictions.getValueOf(RestrictionType.COORDINATE);
            if (resCoordinateType.contains(ActionCoordinateTypeEnum.DIMENSION)) {
                this.getActionsForDimensions(executionEnvironment, connection, restrictions, actionRecords, resCoordinates);
            }
            if (resCoordinateType.contains(ActionCoordinateTypeEnum.LEVEL)) {
                this.getActionsForLevels(executionEnvironment, connection, restrictions, actionRecords, resCoordinates);
            }
            if (resCoordinateType.contains(ActionCoordinateTypeEnum.MEMBER)) {
                this.getActionsForMembers(executionEnvironment, connection, restrictions, actionRecords, resCoordinates);
            }
            if (resCoordinateType.contains(ActionCoordinateTypeEnum.CELL)) {
                this.getActionsForCells(executionEnvironment, connection, restrictions, actionRecords, resCoordinates);
            }
        }
        finally {
            logCtx.exit();
        }
        return actionRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AliasRecord> getAliases(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.ALIASES);
        try {
            if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                XMLALog.getLogger("Metadata").log(LogLevel.WARN, "Aliases are not supported in XMLA.");
            }
            List<AliasRecord> list = Collections.emptyList();
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCubeDefaultMeasure(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateCubeDefaultMeasureRestrictions(restrictions);
        this.fixCatalogNameCase(restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.CUBEDEFAULTMEASURE);
        try {
            String string = this.getCubeDefaultMeasureInternal(executionEnvironment, connection, catalogName, cubeName);
            return string;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getDatasourceLocales(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateDatasourceLocalesRestrictions(restrictions);
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.DATASOURCELOCALES);
        try {
            if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                XMLALog.getLogger("Metadata").log(LogLevel.WARN, "Datasource Locales are not supported in XMLA.");
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CatalogRecord> getCatalogs(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        this.fixCatalogNameCase(restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (null != catalogName) {
            xmlaRestrictions.add("CATALOG_NAME", catalogName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.CATALOGS);
        try {
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "DBSCHEMA_CATALOGS", xmlaRestrictions, xmlaProperties);
            int catalogNameOrd = rowset.getColumnOrdinal("CATALOG_NAME");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            size = Math.min(size, rowset.numRows() - from);
            size = Math.max(size, 0);
            ArrayList<CatalogRecord> result = new ArrayList<CatalogRecord>(size);
            for (int i = from; i < from + size; ++i) {
                XMLARow currentRow = rowset.getRow(i);
                CatalogRecord catalogRec = new CatalogRecord();
                XMLAValue value = null;
                value = currentRow.getValue(catalogNameOrd);
                if (!value.isNull()) {
                    catalogRec.setName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CATALOG_NAME");
                }
                catalogRec.setUniqueName(catalogRec.getName());
                catalogRec.setCaption((ILocalizedString)this.getLocalizedString(connection, catalogRec.getName()));
                value = currentRow.getValue(descriptionOrd);
                if (!value.isNull()) {
                    catalogRec.setDescription(value.getString());
                }
                catalogRec.setUniqueId(RecordType.CATALOG, catalogRec.getUniqueName());
                result.add(catalogRec);
            }
            ArrayList<CatalogRecord> arrayList = result;
            return arrayList;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CubeRecord> getCubes(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        XMLACapabilities capabilities = connection.getCapabilities();
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        String catalogName = (String)newRestrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String schemaName = (String)newRestrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)newRestrictions.getValueOf(RestrictionType.CUBE);
        int from = (Integer)newRestrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)newRestrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        this.validateCubeRestrictions(newRestrictions);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        if (null != cubeName) {
            xmlaRestrictions.add("CUBE_NAME", cubeName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.CUBES);
        try {
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_CUBES", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int lastDataUpdateOrd = rowset.getColumnOrdinal("LAST_DATA_UPDATE");
            int lastSchemaUpdateOrd = rowset.getColumnOrdinal("LAST_SCHEMA_UPDATE");
            int cubeCaptionOrd = rowset.getColumnOrdinal("CUBE_CAPTION");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int createdOnOrd = rowset.getColumnOrdinal("CREATED_ON");
            size = Math.min(size, rowset.numRows() - from);
            size = Math.max(size, 0);
            ArrayList<CubeRecord> result = new ArrayList<CubeRecord>(size);
            for (int i = from; i < from + size; ++i) {
                XMLARow currentRow = rowset.getRow(i);
                CubeRecord cubeRec = new CubeRecord();
                XMLAValue value = null;
                value = currentRow.getValue(cubeNameOrd);
                if (!value.isNull()) {
                    cubeRec.setName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                cubeRec.setUniqueName(cubeRec.getName());
                value = currentRow.getValue(cubeCaptionOrd);
                if (!value.isNull()) {
                    cubeRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
                } else {
                    cubeRec.setCaption((ILocalizedString)this.getLocalizedString(connection, cubeRec.getName()));
                }
                value = currentRow.getValue(descriptionOrd);
                if (!value.isNull()) {
                    cubeRec.setDescription(value.getString());
                }
                cubeRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = currentRow.getValue(schemaNameOrd);
                if (!value.isNull()) {
                    cubeRec.setSchemaName(value.getString());
                }
                if (!(value = currentRow.getValue(createdOnOrd)).isNull()) {
                    if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
                        XMLALog.getLogger("Metadata").log(LogLevel.INFO, "CreatedDate:" + value);
                    }
                    cubeRec.setCreatedDate((DateTimeValue)value.getDateTime());
                }
                if (!(value = currentRow.getValue(lastDataUpdateOrd)).isNull()) {
                    if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
                        XMLALog.getLogger("Metadata").log(LogLevel.INFO, "LastDataUpdate:" + value);
                    }
                    cubeRec.setDataUpdateDate((DateTimeValue)value.getDateTime());
                } else if (capabilities.canSupportLastSchemaUpdate()) {
                    XMLAMetadataProvider.throwMissingColumnException("LAST_DATA_UPDATE");
                } else if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                    XMLALog.getLogger("Metadata").log(LogLevel.WARN, "LAST_DATA_UPDATE is null. ");
                    cubeRec.setDataUpdateDate(TIMESTAMP);
                }
                value = currentRow.getValue(lastSchemaUpdateOrd);
                if (!value.isNull()) {
                    if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
                        XMLALog.getLogger("Metadata").log(LogLevel.INFO, "LastSchemaUpdate:" + value);
                    }
                    cubeRec.setSchemaUpdateDate((DateTimeValue)value.getDateTime());
                } else if (capabilities.canSupportLastSchemaUpdate()) {
                    XMLAMetadataProvider.throwMissingColumnException("LAST_SCHEMA_UPDATE");
                } else if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                    XMLALog.getLogger("Metadata").log(LogLevel.WARN, "LAST_SCHEMA_UPDATE is null.");
                    cubeRec.setSchemaUpdateDate(TIMESTAMP);
                }
                cubeRec.setUniqueId(RecordType.CUBE, cubeRec.getUniqueName());
                cubeRec.setSuppressionType(ICube.CubeSuppressionTypeEnum.NULL);
                result.add(cubeRec);
            }
            ArrayList<CubeRecord> arrayList = result;
            return arrayList;
        }
        finally {
            logCtx.exit();
        }
    }

    private String getCubeDefaultMeasureInternal(ExecutionEnvironment executionEnvironment, XMLAConnection connection, String catalogName, String cubeName) {
        MeasureRecord measureRec;
        String defMUN;
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        newRestrictions.add(RestrictionType.CUBE, (Object)cubeName);
        HierarchyRecord measureHier = this.getHierarchyRecord(executionEnvironment, connection, (IRestrictions)newRestrictions, MEASURES_STRING);
        if (null == measureHier) {
            DimensionRecord measureDim = this.getMeasureDimension(executionEnvironment, connection, catalogName, cubeName);
            measureHier = this.getHierarchyRecord(executionEnvironment, connection, (IRestrictions)newRestrictions, measureDim.getDefaultHierarchyUniqueName());
        }
        if (measureHier != null && (defMUN = measureHier.getDefaultMemberUniqueName()) != null && defMUN.length() > 0 && (measureRec = this.getMeasureRecord(executionEnvironment, connection, (IRestrictions)newRestrictions, measureHier.getDefaultMemberUniqueName())) != null) {
            return measureRec.getUniqueName();
        }
        return "";
    }

    private MeasureRecord getMeasureRecord(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, String sMUN) {
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)sMUN);
        List<MeasureRecord> measures = this.getMeasures(executionEnvironment, connection, (IRestrictions)newRestrictions);
        if (!measures.isEmpty()) {
            return measures.get(0);
        }
        return null;
    }

    private DimensionRecord getMeasureDimension(ExecutionEnvironment executionEnvironment, XMLAConnection connection, String catalogName, String cubeName) {
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        restrictions.add(RestrictionType.CUBE, (Object)cubeName);
        List<DimensionRecord> dimRecords = this.getDimensions(executionEnvironment, connection, (IRestrictions)restrictions);
        for (DimensionRecord dimRec : dimRecords) {
            if (DimensionTypeEnum.MEASURE != dimRec.getType()) continue;
            return dimRec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DimensionRecord> getDimensions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        boolean useCache = this.canUseCache();
        XMLACapabilities capabilities = connection.getCapabilities();
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.HIERARCHY_UNIQUE_NAME);
        this.fixCatalogNameCase(newRestrictions);
        List<DimensionRecord> answer = null;
        if (useCache && null != (answer = this.getCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions))) {
            return answer;
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.DIMENSIONS);
        try {
            answer = capabilities.canReturnHierarchiesAsDimensions() ? this.getHierarchiesAsDimensions(executionEnvironment, connection, newRestrictions) : this.getDimensionsAsDimensions(executionEnvironment, connection, newRestrictions);
            Collections.sort(answer, new RankComparator());
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (useCache) {
                this.putCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions, answer);
            }
            if (from != 0) {
                int toIndex = answer.size();
                if (size != 0) {
                    toIndex = Math.min(from + size, answer.size());
                }
                List<DimensionRecord> list = answer.subList(from, toIndex);
                return list;
            }
            List<DimensionRecord> list = answer;
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    private List<DimensionRecord> getDimensionsAsDimensions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        this.validateDimensionRestrictions(restrictions);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (null != dimensionUniqueName) {
            xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
        }
        XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_DIMENSIONS", xmlaRestrictions, xmlaProperties);
        int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
        int dimensionNameOrd = rowset.getColumnOrdinal("DIMENSION_NAME");
        int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
        int dimensionCaptionOrd = rowset.getColumnOrdinal("DIMENSION_CAPTION");
        int dimensionTypeOrd = rowset.getColumnOrdinal("DIMENSION_TYPE");
        int dimensionCardinalityOrd = rowset.getColumnOrdinal("DIMENSION_CARDINALITY");
        int defaultHierarchyOrd = rowset.getColumnOrdinal("DEFAULT_HIERARCHY");
        int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
        int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
        int dimensionOrdinalOrd = rowset.getColumnOrdinal("DIMENSION_ORDINAL");
        ArrayList<DimensionRecord> result = new ArrayList<DimensionRecord>(rowset.numRows());
        XMLACapabilities capabilities = connection.getCapabilities();
        for (int i = 0; i < rowset.numRows(); ++i) {
            XMLARow currentRow = rowset.getRow(i);
            DimensionRecord dimRec = new DimensionRecord();
            XMLAValue value = currentRow.getValue(dimensionNameOrd);
            if (!value.isNull()) {
                dimRec.setName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_NAME");
            }
            value = currentRow.getValue(dimensionUniqueNameOrd);
            if (!value.isNull()) {
                dimRec.setUniqueName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
            }
            value = currentRow.getValue(dimensionCaptionOrd);
            if (!value.isNull()) {
                dimRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_CAPTION");
            }
            value = currentRow.getValue(descriptionOrd);
            if (!value.isNull()) {
                dimRec.setDescription(value.getString());
            }
            dimRec.setCatalogName(this.getCatalogNameFromConnection(connection));
            value = currentRow.getValue(schemaNameOrd);
            if (!value.isNull()) {
                dimRec.setSchemaName(value.getString());
            }
            if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                dimRec.setCubeName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
            }
            value = currentRow.getValue(dimensionTypeOrd);
            if (!value.isNull()) {
                dimRec.setType(MSASCommonDimTypes.convertOLEDBDimensionTypeToEnum((int)value.getInteger()));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_TYPE");
            }
            if (dimRec.getType() == DimensionTypeEnum.ACCOUNT || dimRec.getType() == DimensionTypeEnum.SCENARIO) {
                dimRec.setMembersRollup(false);
            }
            if (!(value = currentRow.getValue(dimensionCardinalityOrd)).isNull()) {
                dimRec.setCardinality(value.getInteger().intValue());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_CARDINALITY");
            }
            value = currentRow.getValue(dimensionOrdinalOrd);
            if (!value.isNull()) {
                if (capabilities.canSortHierarchiesByOrdinal()) {
                    dimRec.setRank(value.getInteger().intValue());
                } else {
                    dimRec.setRank(i);
                }
            }
            if (!(value = currentRow.getValue(defaultHierarchyOrd)).isNull()) {
                dimRec.setDefaultHierarchyUniqueName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DEFAULT_HIERARCHY");
            }
            dimRec.setDimensionGroupName("");
            dimRec.setDimensionGroupDescription("");
            dimRec.setUniqueId(RecordType.DIMENSION, dimRec.getUniqueName());
            if (dimRec.getType() == DimensionTypeEnum.MEASURE) {
                dimRec.setRank(Integer.MAX_VALUE);
            }
            result.add(dimRec);
        }
        return result;
    }

    private List<DimensionRecord> getHierarchiesAsDimensions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        this.validateDimensionRestrictions(restrictions);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (null != dimensionUniqueName) {
            xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", dimensionUniqueName);
        }
        XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_HIERARCHIES", xmlaRestrictions, xmlaProperties);
        int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
        int hierarchyCaptionOrd = rowset.getColumnOrdinal("HIERARCHY_CAPTION");
        int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
        int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
        int hierarchyCardinalityOrd = rowset.getColumnOrdinal("HIERARCHY_CARDINALITY");
        int hierarchyOrdinalOrd = rowset.getColumnOrdinal("HIERARCHY_ORDINAL");
        int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
        int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
        int hierarchyNameOrd = rowset.getColumnOrdinal("HIERARCHY_NAME");
        ArrayList<DimensionRecord> result = new ArrayList<DimensionRecord>(rowset.numRows());
        for (int i = 0; i < rowset.numRows(); ++i) {
            XMLARow currentRow = rowset.getRow(i);
            DimensionRecord dimRec = new DimensionRecord();
            String hierarchyCaption = null;
            String realDUN = null;
            dimRec.setRank(i);
            dimRec.setCatalogName(this.getCatalogNameFromConnection(connection));
            XMLAValue value = currentRow.getValue(schemaNameOrd);
            if (!value.isNull()) {
                dimRec.setSchemaName(value.getString());
            }
            if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                dimRec.setCubeName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
            }
            value = currentRow.getValue(hierarchyCaptionOrd);
            if (!value.isNull()) {
                hierarchyCaption = value.getString();
                dimRec.setCaption((ILocalizedString)this.getLocalizedString(connection, hierarchyCaption));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_CAPTION");
            }
            value = currentRow.getValue(hierarchyNameOrd);
            if (!value.isNull() && value.getString().length() > 0) {
                dimRec.setName(value.getString());
            } else {
                dimRec.setName(hierarchyCaption);
            }
            value = currentRow.getValue(hierarchyUniqueNameOrd);
            if (!value.isNull()) {
                dimRec.setUniqueName(value.getString());
                dimRec.setDefaultHierarchyUniqueName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
            }
            value = currentRow.getValue(dimensionUniqueNameOrd);
            if (!value.isNull()) {
                realDUN = value.getString();
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
            }
            value = currentRow.getValue(descriptionOrd);
            if (!value.isNull()) {
                dimRec.setDescription(value.getString());
            }
            if (!(value = currentRow.getValue(hierarchyCardinalityOrd)).isNull()) {
                dimRec.setCardinality(value.getInteger().intValue());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_CARDINALITY");
            }
            DimensionRecord realDimRecord = this.getDimensionRecord(executionEnvironment, connection, restrictions, realDUN);
            if (realDimRecord != null) {
                dimRec.setType(realDimRecord.getType());
                dimRec.setRank(realDimRecord.getRank());
                if (dimRec.getType() == DimensionTypeEnum.ACCOUNT || dimRec.getType() == DimensionTypeEnum.SCENARIO) {
                    dimRec.setMembersRollup(false);
                }
            } else {
                throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_DIMENSION, realDUN, (Object)cubeName, (Object)catalogName);
            }
            if (dimRec.getType() == DimensionTypeEnum.MEASURE) {
                dimRec.setRank(Integer.MAX_VALUE);
            } else {
                value = currentRow.getValue(hierarchyOrdinalOrd);
                if (!value.isNull()) {
                    dimRec.setRank(value.getInteger().intValue());
                }
            }
            long hierCount = this.getHierarchyCount(executionEnvironment, connection, restrictions, realDimRecord.getUniqueName());
            if (hierCount > 1L) {
                dimRec.setDimensionGroupName(realDimRecord.getName());
                dimRec.setDimensionGroupDescription(realDimRecord.getDescription());
            }
            dimRec.setUniqueId(RecordType.DIMENSION, dimRec.getUniqueName());
            if (dimRec.getName() == null || dimRec.getName().length() == 0) {
                try {
                    String name = UniqueNameParser.parseLastIdentifier((String)dimRec.getUniqueName());
                    dimRec.setName(name);
                }
                catch (UniqueNameParserException e) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
                }
            }
            result.add(dimRec);
        }
        return result;
    }

    private long getHierarchyCount(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, String dimensionUniqueName) {
        XMLACapabilities capabilities = connection.getCapabilities();
        if (capabilities.canReturnHierarchiesAsDimensions()) {
            KeyValueList xmlaProperties = new KeyValueList();
            KeyValueList xmlaRestrictions = new KeyValueList();
            String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
            String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            xmlaRestrictions.add("CATALOG_NAME", catalogName);
            if (null != schemaName) {
                xmlaRestrictions.add("SCHEMA_NAME", schemaName);
            }
            xmlaRestrictions.add("CUBE_NAME", cubeName);
            if (null != dimensionUniqueName) {
                xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
            }
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_HIERARCHIES", xmlaRestrictions, xmlaProperties);
            return rowset.numRows();
        }
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
        if (null != dimensionUniqueName) {
            newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimensionUniqueName);
        }
        List<HierarchyRecord> records = this.getHierarchies(executionEnvironment, connection, newRestrictions);
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimensionRecord getDimensionRecord(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, String dimensionUniqueName) {
        XMLACapabilities capabilities = connection.getCapabilities();
        boolean useCache = this.canUseCache() && !capabilities.canReturnHierarchiesAsDimensions();
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimensionUniqueName);
        boolean needToFilter = false;
        if (useCache) {
            List records = this.getCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions);
            if (null != records && !records.isEmpty()) {
                return (DimensionRecord)records.get(0);
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions.remove(RestrictionType.DIMENSION_UNIQUE_NAME);
                needToFilter = true;
            }
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.PROPERTIES);
        List<DimensionRecord> records = null;
        try {
            records = this.getDimensionsAsDimensions(executionEnvironment, connection, newRestrictions);
        }
        finally {
            logCtx.exit();
        }
        DimensionRecord dimRec = null;
        if (useCache) {
            Collections.sort(records, new RankComparator());
            this.putCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions, records);
            if (needToFilter && !(records = this.filterDimensionRecords(records, dimensionUniqueName)).isEmpty()) {
                dimRec = records.get(0);
            }
        } else if (!records.isEmpty()) {
            dimRec = records.get(0);
        }
        return dimRec;
    }

    private HierarchyRecord getHierarchyRecord(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, String sHUN) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)sHUN);
        List<HierarchyRecord> hiers = this.getHierarchies(executionEnvironment, connection, newRestrictions);
        if (null != hiers && !hiers.isEmpty()) {
            return hiers.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<HierarchyRecord> getHierarchies(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.HIERARCHIES);
        try {
            Object currentRow;
            this.validateHierarchyRestrictions(restrictions);
            boolean useCache = this.canUseCache();
            List<Object> answer = null;
            IRestrictions newRestrictions = restrictions.duplicate();
            this.fixCatalogNameCase(newRestrictions);
            String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
            String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
            String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
            String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            if (useCache && null != (answer = this.getCachedMetadata(MetadataOperation.HIERARCHIES, newRestrictions))) {
                List<HierarchyRecord> list = answer;
                return list;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
            }
            String dimensionUniqueName = (String)newRestrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
            String hierarchyUniqueName = (String)newRestrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            XMLACapabilities capabilities = connection.getCapabilities();
            KeyValueList xmlaProperties = new KeyValueList();
            KeyValueList xmlaRestrictions = new KeyValueList();
            answer = new ArrayList<HierarchyRecord>();
            xmlaRestrictions.add("CATALOG_NAME", catalogName);
            if (null != schemaName) {
                xmlaRestrictions.add("SCHEMA_NAME", schemaName);
            }
            xmlaRestrictions.add("CUBE_NAME", cubeName);
            if (capabilities.canReturnHierarchiesAsDimensions()) {
                if (null != hierarchyUniqueName) {
                    hunRes = hierarchyUniqueName;
                    xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
                } else if (null != dimensionUniqueName) {
                    hunRes = dimensionUniqueName;
                    xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", dimensionUniqueName);
                }
            } else {
                if (null != dimensionUniqueName) {
                    dunRes = dimensionUniqueName;
                    xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
                }
                if (null != hierarchyUniqueName) {
                    hunRes = hierarchyUniqueName;
                    xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
                }
            }
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_HIERARCHIES", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
            int defaultMemberOrd = rowset.getColumnOrdinal("DEFAULT_MEMBER");
            int hierarchyCaptionOrd = rowset.getColumnOrdinal("HIERARCHY_CAPTION");
            int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
            int hierarchyCardinalityOrd = rowset.getColumnOrdinal("HIERARCHY_CARDINALITY");
            int structureOrd = rowset.getColumnOrdinal("STRUCTURE");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int hierarchyNameOrd = rowset.getColumnOrdinal("HIERARCHY_NAME");
            int dimensionTypeOrd = rowset.getColumnOrdinal("DIMENSION_TYPE");
            int allMemberOrd = rowset.getColumnOrdinal("ALL_MEMBER");
            int hierarchyOriginOrd = rowset.getColumnOrdinal("HIERARCHY_ORIGIN");
            int hierarchyDisplayFolderOrd = rowset.getColumnOrdinal("HIERARCHY_DISPLAY_FOLDER");
            int hierarchyOrdinalOrd = rowset.getColumnOrdinal("HIERARCHY_ORDINAL");
            int parentChildOrd = rowset.getColumnOrdinal("PARENT_CHILD");
            for (int i = 0; i < rowset.numRows(); ++i) {
                currentRow = rowset.getRow(i);
                HierarchyRecord hierRec = new HierarchyRecord();
                XMLAValue value = null;
                String caption = null;
                hierRec.setRank(i);
                hierRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = ((XMLARow)currentRow).getValue(schemaNameOrd);
                if (!value.isNull()) {
                    hierRec.setSchemaName(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(cubeNameOrd)).isNull()) {
                    hierRec.setCubeName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                value = ((XMLARow)currentRow).getValue(hierarchyUniqueNameOrd);
                if (!value.isNull()) {
                    hierRec.setUniqueName(value.getString());
                    if (capabilities.canReturnHierarchiesAsDimensions()) {
                        hierRec.setDimensionUniqueName(hierRec.getUniqueName());
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
                }
                if (!(value = ((XMLARow)currentRow).getValue(hierarchyCaptionOrd)).isNull()) {
                    caption = value.getString();
                    hierRec.setCaption((ILocalizedString)this.getLocalizedString(connection, caption));
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_CAPTION");
                }
                value = ((XMLARow)currentRow).getValue(hierarchyNameOrd);
                if (!value.isNull() && value.getString().length() > 0) {
                    hierRec.setName(value.getString());
                } else {
                    hierRec.setName(caption);
                }
                value = ((XMLARow)currentRow).getValue(dimensionUniqueNameOrd);
                if (!value.isNull()) {
                    if (!capabilities.canReturnHierarchiesAsDimensions()) {
                        hierRec.setDimensionUniqueName(value.getString());
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
                }
                if (!(value = ((XMLARow)currentRow).getValue(dimensionTypeOrd)).isNull()) {
                    DimensionTypeEnum type = MSASCommonDimTypes.convertOLEDBDimensionTypeToEnum((int)value.getInteger());
                    if (type == DimensionTypeEnum.MEASURE) {
                        hierRec.setRank(Integer.MAX_VALUE);
                    } else if (capabilities.canApplyNewRankToHierarchies()) {
                        value = ((XMLARow)currentRow).getValue(hierarchyOrdinalOrd);
                        hierRec.setRank(value.getInteger().intValue());
                    }
                }
                if (!(value = ((XMLARow)currentRow).getValue(descriptionOrd)).isNull()) {
                    hierRec.setDescription(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(defaultMemberOrd)).isNull()) {
                    if (hierRec.getUniqueName().equals(MEASURES_STRING)) {
                        MetadataRestriction newMeasureRestrictions = new MetadataRestriction();
                        newMeasureRestrictions.add(RestrictionType.CATALOG, newRestrictions.getValueOf(RestrictionType.CATALOG));
                        newMeasureRestrictions.add(RestrictionType.CUBE, newRestrictions.getValueOf(RestrictionType.CUBE));
                        newMeasureRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
                        newMeasureRestrictions.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)value.getString());
                        if (this.validateDefaultMeasure(executionEnvironment, connection, (IRestrictions)newMeasureRestrictions)) {
                            hierRec.setDefaultMemberUniqueName(value.getString());
                        }
                    } else {
                        hierRec.setDefaultMemberUniqueName(value.getString());
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DEFAULT_MEMBER");
                }
                value = ((XMLARow)currentRow).getValue(allMemberOrd);
                if (!value.isNull()) {
                    hierRec.setHighestRollupMemberUniqueName(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(hierarchyCardinalityOrd)).isNull()) {
                    hierRec.setCardinality(value.getInteger().intValue());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_CARDINALITY");
                }
                value = ((XMLARow)currentRow).getValue(parentChildOrd);
                if (!value.isNull()) {
                    boolean boolValue = value.getBoolean();
                    if (hierRec.getUniqueName().equals(MEASURES_STRING)) {
                        hierRec.setParentChild(true);
                    } else if (boolValue && capabilities.canFakeExtraLevelForParentChildHierarchy()) {
                        hierRec.setParentChild(false);
                        hierRec.setDynamicFieldAsBoolean(FAKE_LEVEL_BASED_HIERARCHY, Boolean.valueOf(true));
                    } else {
                        hierRec.setParentChild(boolValue);
                    }
                } else if (hierRec.getUniqueName().equals(MEASURES_STRING)) {
                    hierRec.setParentChild(true);
                } else if (capabilities.canDetermineParentChildByLevelNames()) {
                    MetadataRestriction newPCRestrictions = new MetadataRestriction();
                    newPCRestrictions.add(RestrictionType.CATALOG, newRestrictions.getValueOf(RestrictionType.CATALOG));
                    newPCRestrictions.add(RestrictionType.CUBE, newRestrictions.getValueOf(RestrictionType.CUBE));
                    newPCRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
                    hierRec.setParentChild(this.isParentChildHierarchyBasedOnLevelNames(executionEnvironment, connection, (IRestrictions)newPCRestrictions));
                } else {
                    hierRec.setParentChild(false);
                }
                value = ((XMLARow)currentRow).getValue(hierarchyDisplayFolderOrd);
                if (!value.isNull()) {
                    hierRec.setDisplayPath(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(hierarchyOriginOrd)).isNull()) {
                    int intValue = value.getInteger();
                    if ((2 & intValue) != 0) {
                        hierRec.setAttributeHierarchy(true);
                        if ((1 & intValue) != 0) {
                            hierRec.setParentChild(true);
                        }
                    } else {
                        hierRec.setAttributeHierarchy(false);
                    }
                }
                if (!(value = ((XMLARow)currentRow).getValue(structureOrd)).isNull()) {
                    int intValue = value.getInteger();
                    MSASCommonHierStructure.convertHierarchyStructure((HierarchyRecord)hierRec, (int)intValue);
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("STRUCTURE");
                }
                if (capabilities.canForceRaggedToUnbalanced() && hierRec.isRagged()) {
                    hierRec.setBalanced(false);
                    if (XMLALog.getLogger("Metadata").isOn()) {
                        XMLALog.getLogger("Metadata").log("Ragged hierarchy changed to unbalanced:" + hierRec.getUniqueName());
                    }
                } else if (capabilities.canForceParentChildToUnbalanced() && hierRec.isParentChild()) {
                    hierRec.setBalanced(false);
                    if (XMLALog.getLogger("Metadata").isOn()) {
                        XMLALog.getLogger("Metadata").log("Parent-Child hierarchy changed to unbalanced:" + hierRec.getUniqueName());
                    }
                }
                if (hierRec.getName() == null || hierRec.getName().length() == 0) {
                    try {
                        String name = UniqueNameParser.parseLastIdentifier((String)hierRec.getUniqueName());
                        hierRec.setName(name);
                    }
                    catch (UniqueNameParserException e) {
                        if (XMLALog.isOn("Exception", LogLevel.ERROR)) {
                            XMLALog.getLogger("Exception").log(LogLevel.ERROR, "Unable to parse hierarchy name. Stack trace:", (Throwable)e);
                        }
                        throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
                    }
                }
                hierRec.setUniqueId(RecordType.HIERARCHY, hierRec.getUniqueName());
                answer.add(hierRec);
            }
            if (capabilities.canSortHierarchiesByOrdinal()) {
                Collections.sort(answer, new RankComparator());
            }
            if (useCache) {
                this.putCachedMetadata(MetadataOperation.HIERARCHIES, newRestrictions, answer);
                List cachedAnswer = this.getCachedMetadata(MetadataOperation.HIERARCHIES, restrictions);
                if (null != cachedAnswer) {
                    currentRow = cachedAnswer;
                    return currentRow;
                }
            }
            if (null == (answer = this.filterHierarchyRecords(answer, dunRes, hunRes))) {
                answer = Collections.emptyList();
            }
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (from != 0) {
                int toIndex = answer.size();
                if (size != 0) {
                    toIndex = Math.min(from + size, answer.size());
                }
                List<Object> list = answer.subList(from, toIndex);
                return list;
            }
            List<Object> list = answer;
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    private List<DimensionRecord> filterDimensionRecords(List<DimensionRecord> cachedAnswer, String dunRes) {
        if (dunRes == null) {
            if (cachedAnswer == null) {
                return Collections.emptyList();
            }
            return cachedAnswer;
        }
        ArrayList<DimensionRecord> answer = new ArrayList<DimensionRecord>();
        for (DimensionRecord dimRec : cachedAnswer) {
            if (!dunRes.equals(dimRec.getUniqueName())) continue;
            answer.add(dimRec);
        }
        return answer;
    }

    private List<HierarchyRecord> filterHierarchyRecords(List<HierarchyRecord> cachedAnswer, String dunRes, String hunRes) {
        if (dunRes == null && hunRes == null) {
            if (cachedAnswer == null) {
                return Collections.emptyList();
            }
            return cachedAnswer;
        }
        ArrayList<HierarchyRecord> answer = new ArrayList<HierarchyRecord>();
        for (HierarchyRecord hierRec : cachedAnswer) {
            if (dunRes != null) {
                if (!dunRes.equals(hierRec.getDimensionUniqueName())) continue;
                if (hunRes != null) {
                    if (!hunRes.equals(hierRec.getUniqueName())) continue;
                    answer.add(hierRec);
                    continue;
                }
                answer.add(hierRec);
                continue;
            }
            if (!hunRes.equals(hierRec.getUniqueName())) continue;
            answer.add(hierRec);
        }
        return answer;
    }

    private List<MeasureRecord> filterMeasureRecords(List<MeasureRecord> cachedAnswer, String munRes, boolean skipSelf, boolean includeSiblings) {
        if (munRes == null) {
            if (cachedAnswer == null) {
                return Collections.emptyList();
            }
            return cachedAnswer;
        }
        ArrayList<MeasureRecord> answer = new ArrayList<MeasureRecord>();
        for (MeasureRecord measureRec : cachedAnswer) {
            if (munRes.equals(measureRec.getUniqueName())) {
                if (skipSelf) continue;
                answer.add(measureRec);
                continue;
            }
            if (!includeSiblings) continue;
            answer.add(measureRec);
        }
        return answer;
    }

    private boolean validateDefaultMeasure(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        String measureUniqueName = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        MeasureRecord measureRec = this.getMeasureRecord(executionEnvironment, connection, restrictions, measureUniqueName);
        return null != measureRec;
    }

    private boolean isParentChildHierarchyBasedOnLevelNames(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        boolean isParentChild = true;
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierarchyUniqueName);
        List hierLevels = this.getLevels((IRestrictions)newRestrictions);
        for (LevelRecord levelRec : hierLevels) {
            String caption = levelRec.getCaption().toString();
            if (null == caption || caption.startsWith(PC_LEVEL_PREFIX) || caption.equals(PC_ALL_LEVEL)) continue;
            isParentChild = false;
            break;
        }
        return isParentChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LevelRecord> getLevels(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateLevelRestrictions(restrictions);
        boolean useCache = this.canUseCache();
        List<Object> levelRecords = null;
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        String catalogName = (String)newRestrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lunRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        int resLevelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        if (useCache) {
            levelRecords = this.getCachedMetadata(MetadataOperation.LEVELS, newRestrictions);
            if (null != levelRecords) {
                return levelRecords;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
            }
        }
        levelRecords = new ArrayList();
        XMLACapabilities capabilities = connection.getCapabilities();
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String dimensionUniqueName = (String)newRestrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hierarchyUniqueName = (String)newRestrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String levelUniqueName = (String)newRestrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (capabilities.canReturnHierarchiesAsDimensions()) {
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            } else if (null != dimensionUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", dimensionUniqueName);
            }
        } else {
            if (null != dimensionUniqueName) {
                xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
            }
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            }
        }
        if (null != levelUniqueName) {
            xmlaRestrictions.add("LEVEL_UNIQUE_NAME", levelUniqueName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.LEVELS);
        try {
            Object currentRow;
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_LEVELS", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int levelNameOrd = rowset.getColumnOrdinal("LEVEL_NAME");
            int levelUniqueNameOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_NAME");
            int levelCaptionOrd = rowset.getColumnOrdinal("LEVEL_CAPTION");
            int levelNumberOrd = rowset.getColumnOrdinal("LEVEL_NUMBER");
            int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
            int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
            int levelCardinalityOrd = rowset.getColumnOrdinal("LEVEL_CARDINALITY");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int levelUniqueSettingsOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_SETTINGS");
            int levelAttributeHierarchyNameOrd = rowset.getColumnOrdinal("LEVEL_ATTRIBUTE_HIERARCHY_NAME");
            String currentHierarchy = null;
            boolean createFakeLevelForPC = capabilities.canFakeExtraLevelForParentChildHierarchy();
            for (int i = 0; i < rowset.numRows(); ++i) {
                currentRow = rowset.getRow(i);
                LevelRecord levelRec = new LevelRecord();
                XMLAValue value = null;
                value = ((XMLARow)currentRow).getValue(levelNameOrd);
                if (!value.isNull()) {
                    levelRec.setName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_NAME");
                }
                value = ((XMLARow)currentRow).getValue(levelUniqueNameOrd);
                if (!value.isNull()) {
                    levelRec.setUniqueName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
                }
                value = ((XMLARow)currentRow).getValue(levelCaptionOrd);
                if (!value.isNull()) {
                    levelRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_CAPTION");
                }
                value = ((XMLARow)currentRow).getValue(descriptionOrd);
                if (!value.isNull()) {
                    levelRec.setDescription(value.getString());
                }
                levelRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = ((XMLARow)currentRow).getValue(schemaNameOrd);
                if (!value.isNull()) {
                    levelRec.setSchemaName(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(cubeNameOrd)).isNull()) {
                    levelRec.setCubeName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                value = ((XMLARow)currentRow).getValue(dimensionUniqueNameOrd);
                if (!value.isNull()) {
                    if (!capabilities.canReturnHierarchiesAsDimensions()) {
                        levelRec.setDimensionUniqueName(value.getString());
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
                }
                if (!(value = ((XMLARow)currentRow).getValue(hierarchyUniqueNameOrd)).isNull()) {
                    levelRec.setHierarchyUniqueName(value.getString());
                    if (capabilities.canReturnHierarchiesAsDimensions()) {
                        levelRec.setDimensionUniqueName(value.getString());
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
                }
                if (!(value = ((XMLARow)currentRow).getValue(levelNumberOrd)).isNull()) {
                    levelRec.setLevelNumber(value.getInteger().intValue());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_NUMBER");
                }
                value = ((XMLARow)currentRow).getValue(levelCardinalityOrd);
                if (!value.isNull()) {
                    levelRec.setCardinality(value.getInteger().intValue());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_CARDINALITY");
                }
                value = ((XMLARow)currentRow).getValue(levelUniqueSettingsOrd);
                if (!value.isNull()) {
                    int intValue = value.getInteger();
                    if ((2 & intValue) != 0) {
                        levelRec.setUniqueMemberNames(true);
                    } else {
                        levelRec.setUniqueMemberNames(false);
                    }
                }
                if (!(value = ((XMLARow)currentRow).getValue(levelAttributeHierarchyNameOrd)).isNull()) {
                    levelRec.setAttributeHierarchyName(value.getString());
                }
                levelRec.setUniqueId(RecordType.LEVEL, levelRec.getUniqueName());
                if (createFakeLevelForPC) {
                    String hun = levelRec.getHierarchyUniqueName();
                    if (currentHierarchy == null) {
                        currentHierarchy = hun;
                    } else if (!currentHierarchy.equals(hun) || i == rowset.numRows() - 1) {
                        boolean isProviderParentChild;
                        HierarchyRecord hierRec = this.getHierarchyRecord(executionEnvironment, connection, newRestrictions, currentHierarchy);
                        boolean bl = isProviderParentChild = hierRec.getDynamicField(FAKE_LEVEL_BASED_HIERARCHY) != null && hierRec.getDynamicFieldAsBoolean(FAKE_LEVEL_BASED_HIERARCHY) != false;
                        if (isProviderParentChild) {
                            if (currentHierarchy.equals(hun)) {
                                levelRecords.add(levelRec);
                            }
                            LevelRecord toCopy = (LevelRecord)levelRecords.get(levelRecords.size() - 1);
                            LevelRecord fakeLevelRec = new LevelRecord();
                            toCopy.copyTo(fakeLevelRec);
                            fakeLevelRec.setLevelNumber(toCopy.getLevelNumber() + 1);
                            fakeLevelRec.setName(toCopy.getName() + "_2");
                            fakeLevelRec.setUniqueName(toCopy.getUniqueName().substring(0, toCopy.getUniqueName().length() - 1) + "_2]");
                            fakeLevelRec.setHidden(Boolean.valueOf(true));
                            levelRecords.add(fakeLevelRec);
                            if (currentHierarchy.equals(hun)) continue;
                        }
                        currentHierarchy = hun;
                    }
                }
                levelRecords.add(levelRec);
            }
            if (useCache) {
                this.putCachedMetadata(MetadataOperation.LEVELS, newRestrictions, levelRecords);
                List cachedAnswer = this.getCachedMetadata(MetadataOperation.LEVELS, restrictions);
                if (null != cachedAnswer) {
                    currentRow = cachedAnswer;
                    return currentRow;
                }
                levelRecords = this.filterLevelRecords(levelRecords, dunRes, hunRes, lunRes, resLevelNumber);
            } else if (-1 != resLevelNumber) {
                levelRecords = this.filterLevelRecords(levelRecords, null, null, null, resLevelNumber);
            }
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (from != 0) {
                int toIndex = levelRecords.size();
                if (size != 0) {
                    toIndex = Math.min(from + size, levelRecords.size());
                }
                List<Object> list = levelRecords.subList(from, toIndex);
                return list;
            }
            List<Object> list = levelRecords;
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    private List<LevelRecord> filterLevelRecords(List<LevelRecord> cachedAnswer, String dunRes, String hunRes, String lunRes, int resLevelNumber) {
        if (dunRes == null && hunRes == null && lunRes == null && resLevelNumber == -1) {
            if (cachedAnswer == null) {
                return Collections.emptyList();
            }
            return cachedAnswer;
        }
        ArrayList<LevelRecord> answer = new ArrayList<LevelRecord>();
        for (LevelRecord levelRec : cachedAnswer) {
            if (dunRes != null && !dunRes.equals(levelRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(levelRec.getHierarchyUniqueName()) || lunRes != null && !lunRes.equals(levelRec.getUniqueName()) || resLevelNumber != -1 && resLevelNumber != levelRec.getLevelNumber()) continue;
            answer.add(levelRec);
        }
        return answer;
    }

    private List<PropertyRecord> filterPropertyRecords(List<PropertyRecord> cachedAnswer, String dunRes, String hunRes, String lunRes) {
        if (dunRes == null && hunRes == null && lunRes == null) {
            if (cachedAnswer == null) {
                return Collections.emptyList();
            }
            return cachedAnswer;
        }
        ArrayList<PropertyRecord> answer = new ArrayList<PropertyRecord>();
        for (PropertyRecord propRec : cachedAnswer) {
            if (dunRes != null && !dunRes.equals(propRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(propRec.getHierarchyUniqueName()) || lunRes != null && !lunRes.equals(propRec.getUniqueName())) continue;
            answer.add(propRec);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MacroRecord> getMacros(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.MACROS);
        try {
            if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                XMLALog.getLogger("Metadata").log(LogLevel.WARN, "Macros are not supported in XMLA.");
            }
            List<MacroRecord> list = Collections.emptyList();
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MeasureRecord> getMeasures(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateMeasureRestrictions(restrictions);
        IRestrictions originalRestrictions = restrictions.duplicate();
        EnumSet treeOps = (EnumSet)originalRestrictions.getValueOf(RestrictionType.TREEOP);
        String selfUniqueName = (String)originalRestrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        boolean skipSelf = false;
        boolean includeSiblings = false;
        if (treeOps != null) {
            if (!treeOps.contains(TreeOperatorEnum.SELF) && !treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                return Collections.emptyList();
            }
            if (treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                originalRestrictions.remove(RestrictionType.MEASURE_UNIQUE_NAME);
                includeSiblings = true;
                if (treeOps.size() == 1) {
                    skipSelf = true;
                }
            }
        }
        boolean useCache = this.canUseCache();
        List<Object> measureRecords = null;
        this.fixCatalogNameCase(originalRestrictions);
        String catalogName = (String)originalRestrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        IRestrictions newRestrictions = originalRestrictions;
        if (useCache) {
            measureRecords = this.getCachedMetadata(MetadataOperation.MEASURES, restrictions);
            if (null != measureRecords) {
                return measureRecords;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = originalRestrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
            }
        }
        XMLACapabilities capabilities = connection.getCapabilities();
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String schemaName = (String)newRestrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)newRestrictions.getValueOf(RestrictionType.CUBE);
        String measureName = (String)newRestrictions.getValueOf(RestrictionType.MEASURE);
        String measureGroupName = (String)newRestrictions.getValueOf(RestrictionType.MEASUREGROUP_NAME);
        measureRecords = new ArrayList<MeasureRecord>();
        String measureUniqueNameRes = (String)newRestrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (null != measureName) {
            xmlaRestrictions.add("MEASURE_NAME", measureName);
        }
        if (null != measureUniqueNameRes) {
            xmlaRestrictions.add("MEASURE_UNIQUE_NAME", measureUniqueNameRes);
        }
        if (null != measureGroupName) {
            xmlaRestrictions.add("MEASUREGROUP_NAME", measureGroupName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.MEASURES);
        try {
            Object currentRow;
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_MEASURES", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int measureUniqueNameOrd = rowset.getColumnOrdinal("MEASURE_UNIQUE_NAME");
            int measureNameOrd = rowset.getColumnOrdinal("MEASURE_NAME");
            int measureCaptionOrd = rowset.getColumnOrdinal("MEASURE_CAPTION");
            int dataTypeOrd = rowset.getColumnOrdinal("DATA_TYPE");
            int measureAggregatorOrd = rowset.getColumnOrdinal("MEASURE_AGGREGATOR");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
            int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
            int levelUniqueNameOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_NAME");
            int numericScaleOrd = rowset.getColumnOrdinal("NUMERIC_SCALE");
            int numericPrecisionOrd = rowset.getColumnOrdinal("NUMERIC_PRECISION");
            int measureUnitsOrd = rowset.getColumnOrdinal("MEASURE_UNITS");
            int measureDisplayFolderOrd = rowset.getColumnOrdinal("MEASURE_DISPLAY_FOLDER");
            int dbScale = -1;
            int dbPrecision = -1;
            int dbDatatype = 4;
            String measureUniqueName = null;
            for (int i = 0; i < rowset.numRows(); ++i) {
                currentRow = rowset.getRow(i);
                XMLAValue value = null;
                value = ((XMLARow)currentRow).getValue(measureUniqueNameOrd);
                if (!value.isNull()) {
                    measureUniqueName = value.getString();
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEASURE_UNIQUE_NAME");
                }
                MeasureRecord measRec = new MeasureRecord();
                measRec.setUniqueName(measureUniqueName);
                value = ((XMLARow)currentRow).getValue(measureNameOrd);
                if (!value.isNull()) {
                    measRec.setName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEASURE_NAME");
                }
                value = ((XMLARow)currentRow).getValue(measureCaptionOrd);
                if (!value.isNull()) {
                    measRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEASURE_CAPTION");
                }
                value = ((XMLARow)currentRow).getValue(descriptionOrd);
                if (!value.isNull()) {
                    measRec.setDescription(value.getString());
                }
                measRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = ((XMLARow)currentRow).getValue(schemaNameOrd);
                if (!value.isNull()) {
                    measRec.setSchemaName(value.getString());
                }
                if (!(value = ((XMLARow)currentRow).getValue(cubeNameOrd)).isNull()) {
                    measRec.setCubeName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                value = ((XMLARow)currentRow).getValue(dimensionUniqueNameOrd);
                if (!value.isNull()) {
                    if (!capabilities.canReturnHierarchiesAsDimensions()) {
                        measRec.setDimensionUniqueName(value.getString());
                    }
                } else {
                    measRec.setDimensionUniqueName(MEASURES_STRING);
                }
                if (!(value = ((XMLARow)currentRow).getValue(hierarchyUniqueNameOrd)).isNull()) {
                    measRec.setHierarchyUniqueName(value.getString());
                    if (capabilities.canReturnHierarchiesAsDimensions()) {
                        measRec.setDimensionUniqueName(value.getString());
                    }
                } else {
                    measRec.setHierarchyUniqueName(MEASURES_STRING);
                }
                if (!(value = ((XMLARow)currentRow).getValue(levelUniqueNameOrd)).isNull()) {
                    measRec.setLevelUniqueName(value.getString());
                } else {
                    measRec.setLevelUniqueName(MEASURES_LUN_STRING);
                }
                dbScale = 0;
                value = ((XMLARow)currentRow).getValue(numericScaleOrd);
                if (!value.isNull()) {
                    dbScale = value.getInteger();
                }
                dbPrecision = 0;
                value = ((XMLARow)currentRow).getValue(numericPrecisionOrd);
                if (!value.isNull()) {
                    dbPrecision = value.getInteger();
                }
                if (!(value = ((XMLARow)currentRow).getValue(dataTypeOrd)).isNull()) {
                    dbDatatype = value.getInteger();
                    this.setMeasureDatatypeInfo(measRec, dbDatatype, dbPrecision, dbScale);
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DATA_TYPE");
                }
                if (6 == dbDatatype) {
                    measRec.setUnits("Currency");
                } else {
                    value = ((XMLARow)currentRow).getValue(measureUnitsOrd);
                    if (!value.isNull()) {
                        measRec.setUnits(value.getString());
                    }
                }
                value = ((XMLARow)currentRow).getValue(measureAggregatorOrd);
                if (!value.isNull()) {
                    measRec.setRegularAggregate(MSASCommonAggregators.convertOLEDBAggregateTypeToEnum((int)value.getInteger()));
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEASURE_AGGREGATOR");
                }
                measRec.setSemiAggregate(measRec.getRegularAggregate());
                value = ((XMLARow)currentRow).getValue(measureDisplayFolderOrd);
                if (!value.isNull()) {
                    measRec.setDisplayPath(value.getString());
                }
                measRec.setUniqueId(RecordType.MEASURE, measRec.getUniqueName());
                measureRecords.add(measRec);
            }
            if (useCache) {
                this.putCachedMetadata(MetadataOperation.MEASURES, newRestrictions, measureRecords);
                List cachedAnswer = this.getCachedMetadata(MetadataOperation.MEASURES, restrictions);
                if (null != cachedAnswer) {
                    currentRow = cachedAnswer;
                    return currentRow;
                }
            }
            if (null == (measureRecords = this.filterMeasureRecords(measureRecords, selfUniqueName, skipSelf, includeSiblings))) {
                measureRecords = Collections.emptyList();
            }
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (from != 0) {
                int toIndex = measureRecords.size();
                if (size != 0) {
                    toIndex = Math.min(from + size, measureRecords.size());
                }
                List<Object> list = measureRecords.subList(from, toIndex);
                return list;
            }
            List<Object> list = measureRecords;
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.MEMBERS);
        try {
            Collection resPPDSCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
            if (resPPDSCodes != null && !resPPDSCodes.isEmpty()) {
                List<MemberRecord> list = this.getMembersFromPPDSCodes(executionEnvironment, connection, newRestrictions, resPPDSCodes);
                return list;
            }
            List<MemberRecord> list = this.getMembersInternal(executionEnvironment, connection, newRestrictions);
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    private List<MemberRecord> getMembersFromPPDSCodes(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, Collection<String> resPPDSCodes) {
        this.validateMemberRestrictions(restrictions);
        XMLACapabilities capabilities = connection.getCapabilities();
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        int numberSkipped = 0;
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        for (String ppdsCode : resPPDSCodes) {
            if (null != ppdsCode) {
                if (ppdsCode.length() < 2) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, RestrictionType.PPDS_CODES.name(), ppdsCode);
                }
                String ppdsCodeType = ppdsCode.substring(0, 1);
                String mun = ppdsCode.substring(1);
                if (XMLALog.isOn("Metadata", LogLevel.TRACE)) {
                    XMLALog.getLogger("Metadata").log(LogLevel.TRACE, "Getting Members for PPDS_CODE:" + ppdsCode);
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.DIMENSION.getPPDSCodePrefix())) {
                    HierarchyRecord hierRecord;
                    if (capabilities.canReturnHierarchiesAsDimensions()) {
                        hierRecord = this.getHierarchyRecord(executionEnvironment, connection, restrictions, mun);
                        if (hierRecord != null) {
                            MemberRecord memRec = this.getMemberRecord(executionEnvironment, connection, restrictions, hierRecord.getDefaultMemberUniqueName());
                            if (null == memRec) continue;
                            if (from != 0 && numberSkipped != from) {
                                ++numberSkipped;
                                continue;
                            }
                            if (size <= memberRecords.size()) break;
                            memRec.setUniqueId(ppdsCode);
                            memberRecords.add(memRec);
                            continue;
                        }
                        throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, mun, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
                    }
                    DimensionRecord dimRecord = this.getDimensionRecord(executionEnvironment, connection, restrictions, mun);
                    if (dimRecord != null) {
                        hierRecord = this.getHierarchyRecord(executionEnvironment, connection, restrictions, dimRecord.getDefaultHierarchyUniqueName());
                        if (hierRecord != null) {
                            MemberRecord memRec = this.getMemberRecord(executionEnvironment, connection, restrictions, hierRecord.getDefaultMemberUniqueName());
                            if (null == memRec) continue;
                            if (from != 0 && numberSkipped != from) {
                                ++numberSkipped;
                                continue;
                            }
                            if (size <= memberRecords.size()) break;
                            memRec.setUniqueId(ppdsCode);
                            memberRecords.add(memRec);
                            continue;
                        }
                        throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, dimRecord.getDefaultHierarchyUniqueName(), restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
                    }
                    throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_DIMENSION, mun, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.MEMBER.getPPDSCodePrefix())) {
                    if (null != resMUN && !resMUN.equals(mun)) {
                        if (!XMLALog.isOn("Metadata", LogLevel.INFO)) continue;
                        StringBuilder sBuf = new StringBuilder();
                        sBuf.append("PPDSCode restriction (");
                        sBuf.append(mun);
                        sBuf.append(")doesn't match MUN restriction (");
                        sBuf.append(resMUN);
                        sBuf.append(").");
                        XMLALog.getLogger("Metadata").log(LogLevel.INFO, sBuf.toString());
                        continue;
                    }
                    MemberRecord memRec = this.getMemberRecord(executionEnvironment, connection, restrictions, mun);
                    if (null == memRec) continue;
                    if (from != 0 && numberSkipped != from) {
                        ++numberSkipped;
                        continue;
                    }
                    if (size <= memberRecords.size()) break;
                    memberRecords.add(memRec);
                    continue;
                }
                if (!XMLALog.isOn("Metadata", LogLevel.INFO)) continue;
                XMLALog.getLogger("Metadata").log(LogLevel.INFO, "PPDSCode restriction was not a DUN or MUN: " + ppdsCode);
                continue;
            }
            if (!XMLALog.isOn("Metadata", LogLevel.INFO)) continue;
            XMLALog.getLogger("Metadata").log(LogLevel.INFO, "Empty PPDSCode restriction");
        }
        return memberRecords;
    }

    private MemberRecord getMemberRecord(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, String memberUniqueName) {
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)memberUniqueName);
        List<MemberRecord> members = this.getMembers(executionEnvironment, connection, (IRestrictions)newRestrictions);
        if (!members.isEmpty()) {
            return members.get(0);
        }
        return null;
    }

    private List<MemberRecord> getMembersInternal(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateMemberRestrictions(restrictions);
        XMLACapabilities capabilities = connection.getCapabilities();
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (capabilities.canReturnHierarchiesAsDimensions()) {
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            } else if (null != dimensionUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", dimensionUniqueName);
            }
        } else {
            if (null != dimensionUniqueName) {
                xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
            }
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            }
        }
        if (null != levelUniqueName) {
            xmlaRestrictions.add("LEVEL_UNIQUE_NAME", levelUniqueName);
        }
        if (-1 != levelNumber) {
            xmlaRestrictions.add("LEVEL_NUMBER", Integer.toString(levelNumber));
        }
        if (null != memberUniqueName) {
            xmlaRestrictions.add("MEMBER_UNIQUE_NAME", memberUniqueName);
        }
        if (null != treeOps) {
            xmlaRestrictions.add("TREE_OP", Integer.toString(MSASCommonTreeOp.convertTreeOperatorEnumSetToInt((EnumSet)treeOps)));
        }
        XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_MEMBERS", xmlaRestrictions, xmlaProperties);
        int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
        int memberNameOrd = rowset.getColumnOrdinal("MEMBER_NAME");
        int memberUniqueNameOrd = rowset.getColumnOrdinal("MEMBER_UNIQUE_NAME");
        int memberCaptionOrd = rowset.getColumnOrdinal("MEMBER_CAPTION");
        int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
        int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
        int levelUniqueNameOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_NAME");
        int levelNumberOrd = rowset.getColumnOrdinal("LEVEL_NUMBER");
        int childrenCardinalityOrd = rowset.getColumnOrdinal("CHILDREN_CARDINALITY");
        int parentCountOrd = rowset.getColumnOrdinal("PARENT_COUNT");
        int memberTypeOrd = rowset.getColumnOrdinal("MEMBER_TYPE");
        int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
        int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
        int parentLevelOrd = rowset.getColumnOrdinal("PARENT_LEVEL");
        int parentUniqueNameOrd = rowset.getColumnOrdinal("PARENT_UNIQUE_NAME");
        size = Math.min(size, rowset.numRows() - from);
        size = Math.max(size, 0);
        ArrayList<MemberRecord> result = new ArrayList<MemberRecord>(size);
        String dun = null;
        DimensionRecord currDim = null;
        for (int i = from; i < from + size; ++i) {
            XMLARow currentRow = rowset.getRow(i);
            MemberRecord memRec = new MemberRecord();
            XMLAValue value = currentRow.getValue(memberNameOrd);
            if (!value.isNull()) {
                memRec.setName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("MEMBER_NAME");
            }
            value = currentRow.getValue(memberUniqueNameOrd);
            if (!value.isNull()) {
                String mun = value.getString();
                memRec.setUniqueName(mun);
            } else {
                XMLAMetadataProvider.throwMissingColumnException("MEMBER_UNIQUE_NAME");
            }
            value = currentRow.getValue(memberCaptionOrd);
            if (!value.isNull()) {
                memRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("MEMBER_CAPTION");
            }
            value = currentRow.getValue(descriptionOrd);
            if (!value.isNull()) {
                memRec.setDescription(value.getString());
            }
            memRec.setCatalogName(this.getCatalogNameFromConnection(connection));
            value = currentRow.getValue(schemaNameOrd);
            if (!value.isNull()) {
                memRec.setSchemaName(value.getString());
            }
            if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                memRec.setCubeName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
            }
            value = currentRow.getValue(dimensionUniqueNameOrd);
            if (!value.isNull()) {
                dun = value.getString();
                if (!capabilities.canReturnHierarchiesAsDimensions()) {
                    memRec.setDimensionUniqueName(dun);
                }
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
            }
            if (!(value = currentRow.getValue(hierarchyUniqueNameOrd)).isNull()) {
                String hun = value.getString();
                memRec.setHierarchyUniqueName(hun);
                if (capabilities.canReturnHierarchiesAsDimensions()) {
                    memRec.setDimensionUniqueName(hun);
                }
            } else {
                XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
            }
            if (!(value = currentRow.getValue(levelUniqueNameOrd)).isNull()) {
                memRec.setLevelUniqueName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
            }
            value = currentRow.getValue(levelNumberOrd);
            if (!value.isNull()) {
                memRec.setLevelNumber(value.getInteger().intValue());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("LEVEL_NUMBER");
            }
            value = currentRow.getValue(childrenCardinalityOrd);
            if (!value.isNull()) {
                memRec.setChildCardinality(value.getInteger().intValue());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CHILDREN_CARDINALITY");
            }
            value = currentRow.getValue(parentCountOrd);
            if (!value.isNull()) {
                int intValue = value.getInteger();
                if (intValue > 1) {
                    memRec.setParentCount(1);
                } else {
                    memRec.setParentCount(intValue);
                }
            } else {
                XMLAMetadataProvider.throwMissingColumnException("PARENT_COUNT");
            }
            value = currentRow.getValue(parentLevelOrd);
            if (!value.isNull()) {
                memRec.setParentLevelNumber(value.getInteger().intValue());
            }
            if (!(value = currentRow.getValue(parentUniqueNameOrd)).isNull()) {
                memRec.setParentUniqueName(value.getString());
            }
            if (!(value = currentRow.getValue(memberTypeOrd)).isNull()) {
                int dbMemberType = value.getInteger();
                memRec.setType(MSASCommonMemberTypes.convertIntToMemberType((int)dbMemberType));
            } else {
                XMLAMetadataProvider.throwMissingColumnException("MEMBER_TYPE");
            }
            memRec.setDataMemberUniqueName(null);
            if (this.forceRollupToComputed) {
                memRec.setRollupType(RollupTypeEnum.COMPUTED);
            } else {
                if (null == currDim || !currDim.getUniqueName().equals(dun)) {
                    currDim = this.getDimensionRecord(executionEnvironment, connection, restrictions, dun);
                }
                this.calculateMemberRollup(currDim, memRec);
            }
            memRec.setUniqueId(RecordType.MEMBER, memRec.getUniqueName());
            result.add(memRec);
        }
        return result;
    }

    private void calculateMemberRollup(DimensionRecord currDim, MemberRecord member) {
        DimensionTypeEnum dimType = currDim.getType();
        if (dimType == DimensionTypeEnum.ACCOUNT || dimType == DimensionTypeEnum.SCENARIO) {
            member.setRollupType(RollupTypeEnum.COMPUTED);
        } else {
            member.setRollupType(RollupTypeEnum.ROLLUP);
        }
    }

    private LevelRecord getLevelRecord(XMLAConnection connection, IRestrictions restrictions, String sLUN) {
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)sLUN);
        List levels = this.getLevels((IRestrictions)newRestrictions);
        if (!levels.isEmpty()) {
            return (LevelRecord)levels.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NamedSetRecord> getNamedSets(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        this.fixCatalogNameCase(restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String setName = (String)restrictions.getValueOf(RestrictionType.SET);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        this.validateNamedSetRestrictions(restrictions);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (null != setName) {
            xmlaRestrictions.add("SET_NAME", setName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.NAMEDSETS);
        try {
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_SETS", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int dimensionsOrd = rowset.getColumnOrdinal("DIMENSIONS");
            int setNameOrd = rowset.getColumnOrdinal("SET_NAME");
            int expressionOrd = rowset.getColumnOrdinal("EXPRESSION");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int setCaptionOrd = rowset.getColumnOrdinal("SET_CAPTION");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int displayFolderOrd = rowset.getColumnOrdinal("SET_DISPLAY_FOLDER");
            size = Math.min(size, rowset.numRows() - from);
            size = Math.max(size, 0);
            ArrayList<NamedSetRecord> result = new ArrayList<NamedSetRecord>(size);
            String hierarchyList = null;
            String originalName = null;
            for (int i = from; i < from + size; ++i) {
                XMLARow currentRow = rowset.getRow(i);
                XMLAValue value = null;
                value = currentRow.getValue(dimensionsOrd);
                if (!value.isNull()) {
                    hierarchyList = value.getString();
                    if (hierarchyList.contains(COMMA_SEPARATOR)) {
                        if (!XMLALog.isOn("Metadata", LogLevel.WARN)) continue;
                        XMLALog.getLogger("Metadata").log(LogLevel.WARN, "Dropped Named List: " + value);
                        continue;
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DIMENSIONS");
                }
                NamedSetRecord setRec = new NamedSetRecord();
                value = currentRow.getValue(setNameOrd);
                if (!value.isNull()) {
                    originalName = value.getString();
                    String newName = this.massageNamedSetName(value.getString());
                    setRec.setName(newName);
                    setRec.setUniqueName(setRec.getName());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("SET_NAME");
                }
                value = currentRow.getValue(setCaptionOrd);
                if (!value.isNull()) {
                    setRec.setCaption((ILocalizedString)this.getLocalizedString(connection, value.getString()));
                } else {
                    setRec.setCaption((ILocalizedString)this.getLocalizedString(connection, originalName));
                }
                value = currentRow.getValue(descriptionOrd);
                if (!value.isNull()) {
                    setRec.setDescription(value.getString());
                }
                setRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = currentRow.getValue(schemaNameOrd);
                if (!value.isNull()) {
                    setRec.setSchemaName(value.getString());
                }
                if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                    setRec.setCubeName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                value = currentRow.getValue(expressionOrd);
                if (!value.isNull()) {
                    String expression = value.getString();
                    if (expression.length() > 1024) {
                        expression = expression.substring(0, 1024);
                    }
                    setRec.setExpression(expression);
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("EXPRESSION");
                }
                value = currentRow.getValue(displayFolderOrd);
                if (!value.isNull()) {
                    setRec.setDisplayPath(value.getString());
                }
                setRec.setUniqueId(RecordType.NAMEDSET, setRec.getUniqueName());
                result.add(setRec);
            }
            ArrayList<NamedSetRecord> arrayList = result;
            return arrayList;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MemberRecord> getNamedSetMembers(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateNamedSetMembersRestrictions(restrictions);
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        XMLACapabilities capabilities = connection.getCapabilities();
        KeyValueList xmlaProperties = new KeyValueList();
        String cubeName = (String)newRestrictions.getValueOf(RestrictionType.CUBE);
        String namedSetName = (String)newRestrictions.getValueOf(RestrictionType.SET);
        int from = (Integer)newRestrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)newRestrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        StringBuilder mdxString = new StringBuilder();
        mdxString.append("WITH MEMBER [Measures].[XQE_NULL_CM2] AS 'NULL', SOLVE_ORDER = 65535 SELECT ");
        mdxString.append(namedSetName);
        mdxString.append(" DIMENSION PROPERTIES DIMENSION_UNIQUE_NAME, HIERARCHY_UNIQUE_NAME, ");
        mdxString.append("PARENT_UNIQUE_NAME, PARENT_LEVEL ON AXIS(0), ");
        mdxString.append("{[Measures].[XQE_NULL_CM2]} ON AXIS(1) FROM [");
        mdxString.append(cubeName);
        mdxString.append("] CELL PROPERTIES VALUE ");
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.NAMEDSETMEMBERS);
        try {
            XMLADataset cellset = connection.performExecuteRequest(executionEnvironment, mdxString.toString(), 1, xmlaProperties);
            XMLADataset.Axis res = cellset.getAxis(0);
            ITupleSet tuples = res.getTupleSet();
            XMLAPropertyInfo dunProp = null;
            XMLAPropertyInfo hunProp = null;
            XMLAPropertyInfo lunProp = null;
            XMLAPropertyInfo lnumProp = null;
            XMLAPropertyInfo capProp = null;
            XMLAPropertyInfo munProp = null;
            XMLAPropertyInfo plnumProp = null;
            XMLAPropertyInfo punProp = null;
            if (tuples.size() > 0) {
                XMLATuple tuple0 = tuples.get(0);
                for (int hierIdx = 0; hierIdx < tuple0.size(); ++hierIdx) {
                    XMLAPropertyInfo[] properties;
                    for (XMLAPropertyInfo prop : properties = res.getAxisInfo().getHierarchy(hierIdx).getProperties()) {
                        if (prop.getUnqualifiedName().equals("DIMENSION_UNIQUE_NAME")) {
                            dunProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("HIERARCHY_UNIQUE_NAME")) {
                            hunProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("LEVEL_UNIQUE_NAME")) {
                            lunProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("LEVEL_NUMBER")) {
                            lnumProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("MEMBER_CAPTION")) {
                            capProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("MEMBER_UNIQUE_NAME")) {
                            munProp = prop;
                            continue;
                        }
                        if (prop.getUnqualifiedName().equals("PARENT_LEVEL")) {
                            plnumProp = prop;
                            continue;
                        }
                        if (!prop.getUnqualifiedName().equals("PARENT_UNIQUE_NAME")) continue;
                        punProp = prop;
                    }
                }
            }
            size = Math.min(size, tuples.size() - from);
            size = Math.max(size, 0);
            ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
            XMLAValue value = null;
            for (int i = from; i < from + size; ++i) {
                XMLATuple tuple = tuples.get(i);
                XMLAMember member = tuple.getMember(0);
                MemberRecord memRec = new MemberRecord();
                memRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                memRec.setCubeName((String)newRestrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
                value = member.getProperty(dunProp);
                if (!value.isNull()) {
                    String dun = value.getString();
                    if (!capabilities.canReturnHierarchiesAsDimensions()) {
                        memRec.setDimensionUniqueName(dun);
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
                }
                value = member.getProperty(hunProp);
                if (!value.isNull()) {
                    String hun = value.getString();
                    memRec.setHierarchyUniqueName(hun);
                    if (capabilities.canReturnHierarchiesAsDimensions()) {
                        memRec.setDimensionUniqueName(hun);
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
                }
                value = member.getProperty(lunProp);
                if (!value.isNull()) {
                    memRec.setLevelUniqueName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
                }
                value = member.getProperty(lnumProp);
                if (!value.isNull()) {
                    memRec.setLevelNumber(value.getInteger().intValue());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_NUMBER");
                }
                value = member.getProperty(capProp);
                if (!value.isNull()) {
                    memRec.setCaption(value.getString());
                    memRec.setName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEMBER_CAPTION");
                }
                value = member.getProperty(munProp);
                if (!value.isNull()) {
                    memRec.setUniqueName(value.getString());
                    memRec.setUniqueId(RecordType.MEMBER, value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("MEMBER_UNIQUE_NAME");
                }
                value = member.getProperty(plnumProp);
                if (!value.isNull()) {
                    memRec.setParentLevelNumber(value.getInteger().intValue());
                } else {
                    memRec.setParentLevelNumber(-1);
                }
                value = member.getProperty(punProp);
                if (!value.isNull()) {
                    memRec.setParentUniqueName(value.getString());
                } else {
                    memRec.setParentUniqueName(null);
                }
                result.add(memRec);
            }
            ArrayList<MemberRecord> arrayList = result;
            return arrayList;
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getNamedSetLevelUniqueNames(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateNamedSetMembersRestrictions(restrictions);
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        KeyValueList xmlaProperties = new KeyValueList();
        String cubeName = (String)newRestrictions.getValueOf(RestrictionType.CUBE);
        String namedSetName = (String)newRestrictions.getValueOf(RestrictionType.SET);
        StringBuilder mdxString = new StringBuilder();
        mdxString.append("WITH MEMBER [Measures].[XQE_NULL_CM3] AS 'NULL', SOLVE_ORDER = 65535 SELECT ");
        mdxString.append(namedSetName);
        mdxString.append(" ON AXIS(0), {[Measures].[XQE_NULL_CM3]} ON AXIS(1) FROM [");
        mdxString.append(cubeName);
        mdxString.append("] CELL PROPERTIES VALUE");
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.NAMEDSETLEVELUNIQUENAMES);
        try {
            XMLADataset cellset = connection.performExecuteRequest(executionEnvironment, mdxString.toString(), 1, xmlaProperties);
            XMLADataset.Axis res = cellset.getAxis(0);
            ITupleSet tuples = res.getTupleSet();
            XMLAPropertyInfo lunProp = null;
            if (tuples.size() > 0) {
                XMLATuple tuple0 = tuples.get(0);
                block3: for (int hierIdx = 0; hierIdx < tuple0.size(); ++hierIdx) {
                    XMLAPropertyInfo[] properties;
                    for (XMLAPropertyInfo prop : properties = res.getAxisInfo().getHierarchy(hierIdx).getProperties()) {
                        if (!prop.getUnqualifiedName().equals("LEVEL_UNIQUE_NAME")) continue;
                        lunProp = prop;
                        continue block3;
                    }
                }
            }
            HashSet<String> result = new HashSet<String>();
            ArrayList<String> returnedList = new ArrayList<String>();
            XMLAValue value = null;
            String tempValue = null;
            for (int i = 0; i < tuples.size(); ++i) {
                XMLATuple tuple = tuples.get(i);
                XMLAMember member = tuple.getMember(0);
                value = member.getProperty(lunProp);
                if (!value.isNull()) {
                    tempValue = value.getString();
                    if (result.contains(tempValue)) continue;
                    result.add(tempValue);
                    returnedList.add(tempValue);
                    continue;
                }
                XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
            }
            ArrayList<String> arrayList = returnedList;
            return arrayList;
        }
        finally {
            logCtx.exit();
        }
    }

    private String massageNamedSetName(String originalName) {
        int firstBracket = originalName.indexOf(STARTING_BRACKET);
        if (firstBracket < 0) {
            StringBuilder newName = new StringBuilder();
            newName.append(STARTING_BRACKET);
            newName.append(originalName);
            newName.append(ENDING_BRACKET);
            return newName.toString();
        }
        return originalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyRecord> getProperties(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validatePropertiesRestrictions(restrictions);
        String sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String sDUNRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        if (null != sHUNRes && sHUNRes.equals(MEASURES_STRING)) {
            return Collections.emptyList();
        }
        if (null != sDUNRes && sDUNRes.equals(MEASURES_STRING)) {
            return Collections.emptyList();
        }
        boolean useCache = this.canUseCache();
        XMLACapabilities capabilities = connection.getCapabilities();
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (useCache && (null == propertyRestriction || propertyRestriction.length() == 0)) {
            return this.getAndReturnCachedProperties(executionEnvironment, connection, restrictions);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.PROPERTIES);
        try {
            LevelRecord levelRec;
            String sLUNRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
            if (capabilities.canReturnHierarchiesAsDimensions()) {
                if (null == sHUNRes || sHUNRes.length() == 0) {
                    sHUNRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
                    if (null != sHUNRes) {
                        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)sHUNRes);
                    }
                } else if ((null == sDUNRes || sDUNRes.length() == 0) && null != (sDUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME))) {
                    restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)sDUNRes);
                }
            }
            this.fixCatalogNameCase(restrictions);
            List<PropertyRecord> propertyRecords = new ArrayList<PropertyRecord>();
            HierarchyRecord hierRec = this.getHierarchyRecordFromPropRestrictions(executionEnvironment, connection, restrictions);
            if (null != hierRec) {
                sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
            }
            if (null != (levelRec = this.getLevelRecordFromPropRestrictions(executionEnvironment, connection, restrictions, hierRec, propertyRestriction))) {
                if (levelRec.getHierarchyUniqueName().equals(MEASURES_STRING)) {
                    ArrayList<PropertyRecord> arrayList = propertyRecords;
                    return arrayList;
                }
                String levelHUN = levelRec.getHierarchyUniqueName();
                sLUNRes = levelRec.getUniqueName();
                if (null == sHUNRes || sHUNRes.length() == 0) {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)levelHUN);
                    sHUNRes = levelHUN;
                }
            }
            if (null == hierRec && null != sHUNRes && null == (hierRec = this.getHierarchyRecord(executionEnvironment, connection, restrictions, sHUNRes))) {
                throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, sHUNRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
            }
            if (null != propertyRestriction) {
                if (null == hierRec) {
                    throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, sHUNRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
                }
                if (hierRec.isParentChild()) {
                    this.getPropertiesInternal(executionEnvironment, connection, restrictions, propertyRecords, hierRec, null);
                } else {
                    this.getPropertiesInternal(executionEnvironment, connection, restrictions, propertyRecords, hierRec, levelRec);
                }
                this.addFakePropertyForOneProperty(executionEnvironment, connection, restrictions, propertyRecords, hierRec, levelRec);
            } else if (null != sLUNRes) {
                if (!hierRec.isParentChild()) {
                    this.getPropertiesInternal(executionEnvironment, connection, restrictions, propertyRecords, hierRec, levelRec);
                }
                this.addFakeIntrinsicHierProperties(executionEnvironment, connection, propertyRecords, restrictions, hierRec);
            } else if (null != sHUNRes) {
                this.getPropertiesForHierarchy(executionEnvironment, connection, restrictions, propertyRecords, hierRec);
            } else if (null != sDUNRes) {
                propertyRecords = this.getAllProperties(executionEnvironment, connection, restrictions);
                propertyRecords = this.filterPropertyRecords(propertyRecords, sDUNRes, sHUNRes, sLUNRes);
            } else {
                propertyRecords = this.getAllProperties(executionEnvironment, connection, restrictions);
            }
            int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
            int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
            if (null != propertyRecords) {
                if (from != 0) {
                    int toIndex = propertyRecords.size();
                    if (size != 0) {
                        size = Math.min(size, propertyRecords.size());
                        toIndex = Math.min(from + size, propertyRecords.size());
                    }
                    if (from >= toIndex) {
                        List<PropertyRecord> list = Collections.emptyList();
                        return list;
                    }
                    List<PropertyRecord> list = propertyRecords.subList(from, toIndex);
                    return list;
                }
                if (0 != size) {
                    int toIndex = propertyRecords.size();
                    toIndex = Math.min(size, propertyRecords.size());
                    List<PropertyRecord> list = propertyRecords.subList(from, toIndex);
                    return list;
                }
            } else {
                List<PropertyRecord> list = Collections.emptyList();
                return list;
            }
            List<PropertyRecord> list = propertyRecords;
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    private void addFakePropertyForOneProperty(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        if (hierRec == null) {
            String sHUNRes;
            if (XMLALog.isOn("Metadata", LogLevel.ERROR)) {
                XMLALog.getLogger("Metadata").log(LogLevel.ERROR, "Missing hierarchy record in addFakePropertyForOneProperty, res=" + restrictions.toString());
            }
            if ((sHUNRes = (String)restrictions.getTypedValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, String.class)) != null && sHUNRes.length() > 0) {
                throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, sHUNRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
            }
            String propertyRes = (String)restrictions.getTypedValueOf(RestrictionType.PROPERTY, String.class);
            throw new XMLAException(XMLAMessageKeys.MET_INVALID_PROPERTY_NAME, propertyRes);
        }
        XMLACapabilities capabilities = connection.getCapabilities();
        String propertyRes = (String)restrictions.getTypedValueOf(RestrictionType.PROPERTY, String.class);
        if (propertyRes.equals(MEMBER_KEY_PROPERTY_NAME)) {
            if (capabilities.canFakeMemberKey()) {
                if (hierRec.isParentChild()) {
                    this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.BUSINESS_KEY);
                } else {
                    this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.BUSINESS_KEY);
                }
            }
        } else if (propertyRes.equals("_rollupType")) {
            if (hierRec.isParentChild()) {
                this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.MEMBER_ROLLUP);
            } else {
                this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.MEMBER_ROLLUP);
            }
        } else if (propertyRes.equals("PPDS_CODE")) {
            if (hierRec.isParentChild()) {
                this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.PPDS_CODE);
            } else {
                this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.PPDS_CODE);
            }
        }
    }

    private void addFakePropertiesForAllHierarchies(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords) {
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.FROM);
        newRestrictions.remove(RestrictionType.SIZE);
        List<HierarchyRecord> hierRecords = this.getHierarchies(executionEnvironment, connection, newRestrictions);
        for (HierarchyRecord hierRec : hierRecords) {
            if (hierRec.getUniqueName().equals(MEASURES_STRING)) continue;
            newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)hierRec.getDimensionUniqueName());
            newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
            this.addFakeIntrinsicHierProperties(executionEnvironment, connection, propertyRecords, newRestrictions, hierRec);
        }
    }

    private void addFakeIntrinsicHierProperties(ExecutionEnvironment executionEnvironment, XMLAConnection connection, List<PropertyRecord> propertyRecords, IRestrictions restrictions, HierarchyRecord hierRec) {
        XMLACapabilities capabilities = connection.getCapabilities();
        if (hierRec.isParentChild()) {
            if (capabilities.canFakeMemberKey()) {
                this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.BUSINESS_KEY);
            }
            this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.MEMBER_ROLLUP);
            this.addFakeIntrinsicPropertyForHierarchy(connection, restrictions, propertyRecords, hierRec, RoleTypeEnum.PPDS_CODE);
        } else {
            IRestrictions newRestrictions = restrictions.duplicate();
            newRestrictions.remove(RestrictionType.FROM);
            newRestrictions.remove(RestrictionType.SIZE);
            List<LevelRecord> levelRecords = this.getLevels(executionEnvironment, connection, newRestrictions);
            for (LevelRecord levelRec : levelRecords) {
                if (capabilities.canFakeMemberKey()) {
                    this.addFakeIntrinsicPropertyForLevel(connection, newRestrictions, propertyRecords, levelRec, RoleTypeEnum.BUSINESS_KEY);
                }
                this.addFakeIntrinsicPropertyForLevel(connection, newRestrictions, propertyRecords, levelRec, RoleTypeEnum.MEMBER_ROLLUP);
                this.addFakeIntrinsicPropertyForLevel(connection, newRestrictions, propertyRecords, levelRec, RoleTypeEnum.PPDS_CODE);
            }
        }
    }

    private void addFakeIntrinsicLevelProperties(ExecutionEnvironment executionEnvironment, XMLAConnection connection, List<PropertyRecord> propertyRecords, IRestrictions restrictions, LevelRecord levelRec) {
        if (levelRec.getHierarchyUniqueName().equals(MEASURES_STRING)) {
            return;
        }
        XMLACapabilities capabilities = connection.getCapabilities();
        if (capabilities.canFakeMemberKey()) {
            this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.BUSINESS_KEY);
        }
        this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.MEMBER_ROLLUP);
        this.addFakeIntrinsicPropertyForLevel(connection, restrictions, propertyRecords, levelRec, RoleTypeEnum.PPDS_CODE);
    }

    private void addFakeIntrinsicPropertyForLevel(XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, LevelRecord levelRec, RoleTypeEnum roleType) {
        String propertyName = "";
        String caption = "";
        if (roleType == RoleTypeEnum.BUSINESS_KEY) {
            propertyName = MEMBER_KEY_PROPERTY_NAME;
            StringBuilder newCaption = new StringBuilder();
            newCaption.append(levelRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            caption = newCaption.toString();
        } else if (roleType == RoleTypeEnum.MEMBER_ROLLUP) {
            propertyName = "_rollupType";
            caption = "_rollupType";
        } else if (roleType == RoleTypeEnum.PPDS_CODE) {
            propertyName = "PPDS_CODE";
            caption = "PPDS_CODE";
        }
        LocalizedString propCaption = this.getLocalizedString(connection, caption);
        PropertyRecord property = this.createFakeProperty(propertyName, levelRec.getDimensionUniqueName(), levelRec.getHierarchyUniqueName(), levelRec.getUniqueName(), roleType, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
        property.setCatalogName(this.getCatalogNameFromConnection(connection));
        property.setCubeName((String)restrictions.getValueOf(RestrictionType.CUBE, null));
        propertyRecords.add(property);
    }

    private void addFakeIntrinsicPropertyForHierarchy(XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, RoleTypeEnum roleType) {
        String propertyName = "";
        String caption = "";
        if (roleType == RoleTypeEnum.BUSINESS_KEY) {
            propertyName = MEMBER_KEY_PROPERTY_NAME;
            StringBuilder newCaption = new StringBuilder();
            newCaption.append(hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            caption = newCaption.toString();
        } else if (roleType == RoleTypeEnum.MEMBER_ROLLUP) {
            propertyName = "_rollupType";
            caption = "_rollupType";
        } else if (roleType == RoleTypeEnum.PPDS_CODE) {
            propertyName = "PPDS_CODE";
            caption = "PPDS_CODE";
        }
        LocalizedString propCaption = this.getLocalizedString(connection, caption);
        PropertyRecord property = this.createFakeProperty(propertyName, hierRec.getDimensionUniqueName(), hierRec.getUniqueName(), null, roleType, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
        property.setCatalogName(this.getCatalogNameFromConnection(connection));
        property.setCubeName((String)restrictions.getValueOf(RestrictionType.CUBE, null));
        propertyRecords.add(property);
    }

    private List<PropertyRecord> getAndReturnCachedProperties(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        String dunRes = (String)restrictions.getTypedValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, String.class);
        String hunRes = (String)restrictions.getTypedValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, String.class);
        String lunRes = (String)restrictions.getTypedValueOf(RestrictionType.LEVEL_UNIQUE_NAME, String.class);
        XMLACapabilities capabilities = connection.getCapabilities();
        if (capabilities.canReturnHierarchiesAsDimensions()) {
            if (null != dunRes && null == hunRes) {
                hunRes = dunRes;
            }
            dunRes = null;
        }
        DimensionRecord dimRec = null;
        HierarchyRecord hierRec = null;
        LevelRecord levelRec = null;
        if (null != dunRes && null == (dimRec = this.getDimensionRecord(executionEnvironment, connection, restrictions, dunRes))) {
            throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_DIMENSION, hunRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
        }
        if (null != hunRes && null == (hierRec = this.getHierarchyRecord(executionEnvironment, connection, restrictions, hunRes))) {
            throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, hunRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
        }
        if (null != lunRes && null == (levelRec = this.getLevelRecord(connection, restrictions, lunRes))) {
            throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_LEVEL, lunRes);
        }
        List<PropertyRecord> answer = this.getCachedMetadata(MetadataOperation.PROPERTIES, restrictions);
        if (null != answer) {
            this.addFakePropertiesForRestrictions(executionEnvironment, connection, restrictions, answer, dimRec, hierRec, levelRec);
            answer = this.applyFromAndSizeForProperties(restrictions, answer);
            return answer;
        }
        IRestrictions newRestrictions = this.canPrefetchModelMetadata() ? restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE}) : restrictions.duplicate();
        answer = this.getAllProperties(executionEnvironment, connection, newRestrictions);
        Collections.sort(answer, new RankComparator());
        this.putCachedMetadata(MetadataOperation.PROPERTIES, newRestrictions, answer);
        List<PropertyRecord> cachedAnswer = this.getCachedMetadata(MetadataOperation.PROPERTIES, restrictions);
        if (null != cachedAnswer) {
            this.addFakePropertiesForRestrictions(executionEnvironment, connection, restrictions, cachedAnswer, dimRec, hierRec, levelRec);
            cachedAnswer = this.applyFromAndSizeForProperties(restrictions, cachedAnswer);
            return cachedAnswer;
        }
        answer = this.filterPropertyRecords(answer, dunRes, hunRes, lunRes);
        this.addFakePropertiesForRestrictions(executionEnvironment, connection, restrictions, answer, dimRec, hierRec, levelRec);
        answer = this.applyFromAndSizeForProperties(restrictions, answer);
        return answer;
    }

    private List<PropertyRecord> applyFromAndSizeForProperties(IRestrictions restrictions, List<PropertyRecord> answer) {
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = answer.size();
            if (from >= toIndex) {
                return Collections.emptyList();
            }
            if (size != 0) {
                toIndex = Math.min(from + size, answer.size());
            }
            return answer.subList(from, toIndex);
        }
        if (size != Integer.MAX_VALUE) {
            return answer.subList(0, size);
        }
        return answer;
    }

    private void addFakePropertiesForRestrictions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> answer, DimensionRecord dimRec, HierarchyRecord hierRec, LevelRecord levelRec) {
        if (levelRec != null) {
            this.addFakeIntrinsicLevelProperties(executionEnvironment, connection, answer, restrictions, levelRec);
        } else if (hierRec != null) {
            this.addFakeIntrinsicHierProperties(executionEnvironment, connection, answer, restrictions, hierRec);
        } else {
            this.addFakePropertiesForAllHierarchies(executionEnvironment, connection, restrictions, answer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyRecord> getAllProperties(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        XMLACapabilities capabilities = connection.getCapabilities();
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.FROM);
        newRestrictions.remove(RestrictionType.SIZE);
        String catalogName = (String)newRestrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String schemaName = (String)newRestrictions.getTypedValueOf(RestrictionType.SCHEMA, String.class);
        String cubeName = (String)newRestrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        logCtx.setMetadataOp(MetadataOperation.PROPERTIES);
        ArrayList<PropertyRecord> propertyRecords = null;
        try {
            XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_PROPERTIES", xmlaRestrictions, xmlaProperties);
            int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
            int propertyNameOrd = rowset.getColumnOrdinal("PROPERTY_NAME");
            int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
            int hierarchyUniqueNameOrd = rowset.getColumnOrdinal("HIERARCHY_UNIQUE_NAME");
            int levelUniqueNameOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_NAME");
            int propertyCaptionOrd = rowset.getColumnOrdinal("PROPERTY_CAPTION");
            int dataTypeOrd = rowset.getColumnOrdinal("DATA_TYPE");
            int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
            int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
            int numericScaleOrd = rowset.getColumnOrdinal("NUMERIC_SCALE");
            int numericPrecisionOrd = rowset.getColumnOrdinal("NUMERIC_PRECISION");
            String propertyName = null;
            String sDUN = null;
            String sHUN = null;
            String sLUN = null;
            int dbScale = -1;
            int dbPrecision = -1;
            LevelRecord levelRec = null;
            DimensionRecord dimRec = null;
            HierarchyRecord hierRec = null;
            propertyRecords = new ArrayList<PropertyRecord>(rowset.numRows());
            for (int i = 0; i < rowset.numRows(); ++i) {
                String uniqueName;
                XMLARow currentRow = rowset.getRow(i);
                XMLAValue value = null;
                value = currentRow.getValue(propertyNameOrd);
                if (!value.isNull()) {
                    propertyName = value.getString();
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("PROPERTY_NAME");
                }
                value = currentRow.getValue(dimensionUniqueNameOrd);
                if (!value.isNull()) {
                    sDUN = value.getString();
                    if (sDUN.equals(MEASURES_STRING)) {
                        continue;
                    }
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DIMENSION_UNIQUE_NAME");
                }
                if (null == dimRec || !sDUN.equals(dimRec.getUniqueName())) {
                    dimRec = this.getDimensionRecord(executionEnvironment, connection, newRestrictions, sDUN);
                    hierRec = null;
                    levelRec = null;
                }
                if (!(value = currentRow.getValue(hierarchyUniqueNameOrd)).isNull()) {
                    sHUN = value.getString();
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("HIERARCHY_UNIQUE_NAME");
                }
                if (null == hierRec || !sHUN.equals(hierRec.getUniqueName())) {
                    hierRec = this.getHierarchyRecord(executionEnvironment, connection, newRestrictions, sHUN);
                    levelRec = null;
                }
                if (!(value = currentRow.getValue(levelUniqueNameOrd)).isNull()) {
                    sLUN = value.getString();
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
                }
                if (null == levelRec || !sLUN.equals(levelRec.getUniqueName())) {
                    levelRec = this.getLevelRecord(connection, newRestrictions, sLUN);
                }
                if (capabilities.canReturnHierarchiesAsDimensions()) {
                    sDUN = hierRec.getUniqueName();
                }
                if (!capabilities.canFakeMemberKey()) {
                    if (propertyName.equals("KEY0")) {
                        this.createKey0Property(connection, newRestrictions, propertyRecords, hierRec, levelRec, sDUN, sLUN);
                    } else if (propertyName.equals("KEY1")) {
                        this.updateMultiPartKeyProperty(propertyRecords, hierRec, sLUN);
                    }
                }
                if (this.skipProperty(executionEnvironment, connection, propertyName, null) || this.doesPropertyRecordExist(propertyRecords, hierRec, uniqueName = this.createPropertyUniqueName(hierRec, propertyName, sLUN))) continue;
                PropertyRecord propRec = new PropertyRecord();
                propRec.setUniqueName(uniqueName);
                propRec.setName(propertyName);
                propRec.setDimensionUniqueName(sDUN);
                propRec.setHierarchyUniqueName(hierRec.getUniqueName());
                if (!hierRec.isParentChild()) {
                    propRec.setLevelUniqueName(sLUN);
                }
                String newCaption = null;
                if (!capabilities.canFakeMemberKey() && propertyName.equals(MEMBER_KEY_PROPERTY_NAME)) {
                    newCaption = this.constructMemberKeyCaption(executionEnvironment, connection, newRestrictions, hierRec, sLUN, levelRec);
                } else {
                    value = currentRow.getValue(propertyCaptionOrd);
                    if (!value.isNull()) {
                        newCaption = value.getString();
                    }
                }
                if (null == newCaption) {
                    XMLAMetadataProvider.throwMissingColumnException("PROPERTY_CAPTION");
                }
                propRec.setCaption((ILocalizedString)this.getLocalizedString(connection, newCaption));
                value = currentRow.getValue(descriptionOrd);
                if (!value.isNull()) {
                    propRec.setDescription(value.getString());
                }
                propRec.setCatalogName(this.getCatalogNameFromConnection(connection));
                value = currentRow.getValue(schemaNameOrd);
                if (!value.isNull()) {
                    propRec.setSchemaName(value.getString());
                }
                if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                    propRec.setCubeName(value.getString());
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
                }
                dbScale = 0;
                value = currentRow.getValue(numericScaleOrd);
                if (!value.isNull()) {
                    dbScale = value.getInteger();
                }
                dbPrecision = 0;
                value = currentRow.getValue(numericPrecisionOrd);
                if (!value.isNull()) {
                    dbPrecision = value.getInteger();
                }
                if (!(value = currentRow.getValue(dataTypeOrd)).isNull()) {
                    int intValue = value.getInteger();
                    this.setPropertyDatatypeInfo(propRec, intValue, dbPrecision, dbScale);
                } else {
                    XMLAMetadataProvider.throwMissingColumnException("DATA_TYPE");
                }
                if (propertyName.equals(MEMBER_KEY_PROPERTY_NAME)) {
                    propRec.setRoleType(RoleTypeEnum.BUSINESS_KEY);
                }
                propRec.setUniqueId(RecordType.PROPERTY, propRec.getUniqueName());
                propertyRecords.add(propRec);
            }
        }
        finally {
            logCtx.exit();
        }
        return propertyRecords;
    }

    private LevelRecord getLevelRecordFromPropRestrictions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, HierarchyRecord hierRec, String originalPUN) {
        int lastLeftBracket;
        LevelRecord levelRec = null;
        String originalLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String sLUNRes = originalLUN;
        if (null != sLUNRes && null == (levelRec = this.getLevelRecord(connection, restrictions, sLUNRes))) {
            throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_LEVEL, sLUNRes);
        }
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && (lastLeftBracket = originalPUN.lastIndexOf(STARTING_BRACKET)) >= 0) {
            String tempRes = originalPUN;
            originalPUN = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sLUNRes = tempRes.substring(0, lastLeftBracket - 1);
            levelRec = this.getLevelRecord(connection, restrictions, sLUNRes);
            if (null != levelRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)originalPUN);
                if (null != originalLUN) {
                    if (!originalLUN.equals(levelRec.getUniqueName())) {
                        throw new XMLAException(XMLAMessageKeys.MET_LUN_AND_PUN_MISMATCH, levelRec.getUniqueName(), originalLUN);
                    }
                } else {
                    restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)levelRec.getUniqueName());
                }
            } else {
                if (null != originalLUN && null != hierRec && !hierRec.isParentChild()) {
                    throw new XMLAException(XMLAMessageKeys.MET_LUN_AND_PUN_MISMATCH, originalLUN, sLUNRes);
                }
                if (null == hierRec) {
                    String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
                    String val = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
                    if (null != originalHUN) {
                        throw new XMLAException(XMLAMessageKeys.MET_HUN_AND_PUN_MISMATCH, originalHUN, val);
                    }
                }
            }
        }
        return levelRec;
    }

    private HierarchyRecord getHierarchyRecordFromPropRestrictions(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        int lastLeftBracket;
        HierarchyRecord hierRec = null;
        String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String sHUNRes = originalHUN;
        if (null != sHUNRes && null == (hierRec = this.getHierarchyRecord(executionEnvironment, connection, restrictions, sHUNRes))) {
            throw new XMLAException(XMLAMessageKeys.MET_CANNOT_FIND_HIERARCHY, sHUNRes, restrictions.getTypedValueOf(RestrictionType.CUBE, String.class), restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class));
        }
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && (lastLeftBracket = propertyRestriction.lastIndexOf(STARTING_BRACKET)) >= 0) {
            String tempRes = propertyRestriction;
            propertyRestriction = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sHUNRes = tempRes.substring(0, lastLeftBracket - 1);
            hierRec = this.getHierarchyRecord(executionEnvironment, connection, restrictions, sHUNRes);
            if (null != hierRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)propertyRestriction);
                if (null != originalHUN) {
                    if (!originalHUN.equals(hierRec.getUniqueName())) {
                        throw new XMLAException(XMLAMessageKeys.MET_HUN_AND_PUN_MISMATCH, originalHUN, hierRec.getUniqueName());
                    }
                } else {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
                }
            }
        }
        return hierRec;
    }

    private void getPropertiesForHierarchy(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec) {
        if (!hierRec.getUniqueName().equals(MEASURES_STRING)) {
            this.getPropertiesInternal(executionEnvironment, connection, restrictions, propertyRecords, hierRec, null);
            this.addFakeIntrinsicHierProperties(executionEnvironment, connection, propertyRecords, restrictions, hierRec);
        }
    }

    private void getPropertiesInternal(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        XMLACapabilities capabilities = connection.getCapabilities();
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        xmlaRestrictions.add("CATALOG_NAME", catalogName);
        if (null != schemaName) {
            xmlaRestrictions.add("SCHEMA_NAME", schemaName);
        }
        xmlaRestrictions.add("CUBE_NAME", cubeName);
        if (capabilities.canReturnHierarchiesAsDimensions()) {
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            } else if (null != dimensionUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", dimensionUniqueName);
            }
        } else {
            if (null != dimensionUniqueName) {
                xmlaRestrictions.add("DIMENSION_UNIQUE_NAME", dimensionUniqueName);
            }
            if (null != hierarchyUniqueName) {
                xmlaRestrictions.add("HIERARCHY_UNIQUE_NAME", hierarchyUniqueName);
            }
        }
        if (null != levelUniqueName) {
            xmlaRestrictions.add("LEVEL_UNIQUE_NAME", levelUniqueName);
        }
        if (null != memberUniqueName) {
            xmlaRestrictions.add("MEMBER_UNIQUE_NAME", memberUniqueName);
        }
        if (null != propertyRestriction) {
            if (propertyRestriction.equals(MEMBER_KEY_PROPERTY_NAME)) {
                if (capabilities.canUseMEMBERKEYRestriction()) {
                    xmlaRestrictions.add("PROPERTY_NAME", propertyRestriction);
                }
            } else {
                xmlaRestrictions.add("PROPERTY_NAME", propertyRestriction);
            }
        }
        XMLARowset rowset = connection.performDiscoverRequest((IExecutionEnvironment)executionEnvironment, "MDSCHEMA_PROPERTIES", xmlaRestrictions, xmlaProperties);
        int cubeNameOrd = rowset.getColumnOrdinal("CUBE_NAME");
        int propertyNameOrd = rowset.getColumnOrdinal("PROPERTY_NAME");
        int dimensionUniqueNameOrd = rowset.getColumnOrdinal("DIMENSION_UNIQUE_NAME");
        int levelUniqueNameOrd = rowset.getColumnOrdinal("LEVEL_UNIQUE_NAME");
        int propertyCaptionOrd = rowset.getColumnOrdinal("PROPERTY_CAPTION");
        int dataTypeOrd = rowset.getColumnOrdinal("DATA_TYPE");
        int descriptionOrd = rowset.getColumnOrdinal("DESCRIPTION");
        int schemaNameOrd = rowset.getColumnOrdinal("SCHEMA_NAME");
        int numericScaleOrd = rowset.getColumnOrdinal("NUMERIC_SCALE");
        int numericPrecisionOrd = rowset.getColumnOrdinal("NUMERIC_PRECISION");
        String propertyName = null;
        String sDUN = null;
        String sLUN = null;
        for (int i = 0; i < rowset.numRows(); ++i) {
            String uniqueName;
            XMLARow currentRow = rowset.getRow(i);
            XMLAValue value = currentRow.getValue(propertyNameOrd);
            if (!value.isNull()) {
                propertyName = value.getString();
            } else {
                XMLAMetadataProvider.throwMissingColumnException("PROPERTY_NAME");
            }
            value = currentRow.getValue(levelUniqueNameOrd);
            if (!value.isNull()) {
                sLUN = value.getString();
            } else {
                XMLAMetadataProvider.throwMissingColumnException("LEVEL_UNIQUE_NAME");
            }
            if (capabilities.canReturnHierarchiesAsDimensions()) {
                sDUN = hierRec.getUniqueName();
            } else {
                value = currentRow.getValue(dimensionUniqueNameOrd);
                if (!value.isNull()) {
                    sDUN = value.getString();
                }
            }
            if (!capabilities.canFakeMemberKey()) {
                if (propertyName.equals("KEY0")) {
                    this.createKey0Property(connection, restrictions, propertyRecords, hierRec, levelRec, sDUN, sLUN);
                } else if (propertyName.equals("KEY1")) {
                    this.updateMultiPartKeyProperty(propertyRecords, hierRec, sLUN);
                }
            }
            if (this.skipProperty(executionEnvironment, connection, propertyName, propertyRestriction) || this.doesPropertyRecordExist(propertyRecords, hierRec, uniqueName = this.createPropertyUniqueName(hierRec, propertyName, sLUN))) continue;
            PropertyRecord propRec = new PropertyRecord();
            propRec.setUniqueName(uniqueName);
            propRec.setName(propertyName);
            propRec.setDimensionUniqueName(sDUN);
            propRec.setHierarchyUniqueName(hierRec.getUniqueName());
            if (!hierRec.isParentChild()) {
                propRec.setLevelUniqueName(sLUN);
            }
            String newCaption = null;
            if (!capabilities.canFakeMemberKey() && propertyName.equals(MEMBER_KEY_PROPERTY_NAME)) {
                newCaption = this.constructMemberKeyCaption(executionEnvironment, connection, restrictions, hierRec, sLUN, levelRec);
            } else {
                value = currentRow.getValue(propertyCaptionOrd);
                if (!value.isNull()) {
                    newCaption = value.getString();
                }
            }
            if (null == newCaption) {
                XMLAMetadataProvider.throwMissingColumnException("PROPERTY_CAPTION");
            }
            propRec.setCaption((ILocalizedString)this.getLocalizedString(connection, newCaption));
            value = currentRow.getValue(descriptionOrd);
            if (!value.isNull()) {
                propRec.setDescription(value.getString());
            }
            propRec.setCatalogName(this.getCatalogNameFromConnection(connection));
            value = currentRow.getValue(schemaNameOrd);
            if (!value.isNull()) {
                propRec.setSchemaName(value.getString());
            }
            if (!(value = currentRow.getValue(cubeNameOrd)).isNull()) {
                propRec.setCubeName(value.getString());
            } else {
                XMLAMetadataProvider.throwMissingColumnException("CUBE_NAME");
            }
            int dbScale = 0;
            value = currentRow.getValue(numericScaleOrd);
            if (!value.isNull()) {
                dbScale = value.getInteger();
            }
            int dbPrecision = 0;
            value = currentRow.getValue(numericPrecisionOrd);
            if (!value.isNull()) {
                dbPrecision = value.getInteger();
            }
            if (!(value = currentRow.getValue(dataTypeOrd)).isNull()) {
                int intValue = value.getInteger();
                this.setPropertyDatatypeInfo(propRec, intValue, dbPrecision, dbScale);
            } else {
                XMLAMetadataProvider.throwMissingColumnException("DATA_TYPE");
            }
            if (propertyName.equals(MEMBER_KEY_PROPERTY_NAME)) {
                propRec.setRoleType(RoleTypeEnum.BUSINESS_KEY);
            }
            propRec.setUniqueId(RecordType.PROPERTY, propRec.getUniqueName());
            propertyRecords.add(propRec);
        }
    }

    private boolean doesPropertyRecordExist(List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, String uniqueName) {
        boolean foundProp = false;
        if (hierRec.isParentChild()) {
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getUniqueName().equals(uniqueName) || !prop.getHierarchyUniqueName().equals(hierRec.getUniqueName())) continue;
                foundProp = true;
                break;
            }
        }
        return foundProp;
    }

    private String createPropertyUniqueName(HierarchyRecord hierRec, String propertyName, String sLUN) {
        StringBuilder uniqueName = new StringBuilder();
        if (!hierRec.isParentChild()) {
            uniqueName.append(sLUN);
        } else {
            uniqueName.append(hierRec.getUniqueName());
        }
        uniqueName.append(".[");
        uniqueName.append(propertyName);
        uniqueName.append(ENDING_BRACKET);
        return uniqueName.toString();
    }

    private void updateMultiPartKeyProperty(List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, String sLUN) {
        if (!hierRec.isParentChild()) {
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getName().equals(MEMBER_KEY_PROPERTY_NAME) || null == prop.getLevelUniqueName() || !prop.getLevelUniqueName().equals(sLUN)) continue;
                prop.setRoleType(RoleTypeEnum.MULTI_PART_BUSINESS_KEY);
            }
        }
    }

    private void createKey0Property(XMLAConnection connection, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord currLevelRec, String sDUN, String levelUniqueName) {
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && !propertyRestriction.equals(MEMBER_KEY_PROPERTY_NAME)) {
            return;
        }
        StringBuilder newCaption = new StringBuilder();
        if (!hierRec.isParentChild()) {
            LocalizedString levelCaption;
            if (null == currLevelRec) {
                currLevelRec = this.getLevelRecord(connection, restrictions, levelUniqueName);
            }
            if ((levelCaption = currLevelRec.getCaption()) != null) {
                newCaption.append(levelCaption.toString());
            }
            newCaption.append(KEY_SUFFIX);
        } else {
            newCaption.append(hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            String sCaption = newCaption.toString();
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getCaption().equals((Object)sCaption) || !prop.getHierarchyUniqueName().equals(hierRec.getUniqueName())) continue;
                return;
            }
        }
        LocalizedString localizedCaption = this.getLocalizedString(connection, newCaption.toString());
        String sLUN = null;
        if (!hierRec.isParentChild()) {
            sLUN = levelUniqueName;
        }
        PropertyRecord property = this.createFakeProperty(MEMBER_KEY_PROPERTY_NAME, sDUN, hierRec.getUniqueName(), sLUN, RoleTypeEnum.BUSINESS_KEY, (IDataType)StringType.DEFAULTSTRINGTYPE, localizedCaption);
        property.setCatalogName(this.getCatalogNameFromConnection(connection));
        property.setCubeName((String)restrictions.getValueOf(RestrictionType.CUBE, null));
        propertyRecords.add(property);
    }

    private String constructMemberKeyCaption(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions, HierarchyRecord hierRec, String lunRestriction, LevelRecord level) {
        StringBuilder newCaption = new StringBuilder();
        if (null != lunRestriction && lunRestriction.length() > 0) {
            if (null == level) {
                level = this.getLevelRecord(connection, restrictions, lunRestriction);
            }
            if (null != level) {
                if (null != hierRec && hierRec.isParentChild()) {
                    newCaption.append(hierRec.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                } else {
                    newCaption.append(level.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                }
            }
        } else if (null != hierRec) {
            newCaption.append(hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
        }
        return newCaption.toString();
    }

    private LocalizedString getLocalizedString(XMLAConnection connection, String value) {
        return new LocalizedString(connection.getLocale(), value);
    }

    private void setMeasureDatatypeInfo(MeasureRecord measure, int datatype, int precision, int scale) {
        if (this.shouldCheckPrecisionScale(datatype)) {
            if (scale == 255 || scale == -1) {
                scale = 0;
            }
            if (scale == 0 && datatype == 6) {
                scale = 4;
            }
            if (precision == 65535 || precision == -1) {
                precision = 0;
            }
        }
        IDataType dataType = MSASCommonDatatypes.convertMSASDatatype((long)datatype, (int)precision, (int)scale);
        measure.setDataType(dataType);
    }

    private void setPropertyDatatypeInfo(PropertyRecord property, int datatype, int precision, int scale) {
        if (this.shouldCheckPrecisionScale(datatype)) {
            if (scale == 255 || scale == -1) {
                scale = 0;
            }
            if (scale == 0 && datatype == 6) {
                scale = 4;
            }
            if (precision == 65535 || precision == -1) {
                precision = 0;
            }
        }
        IDataType dataType = MSASCommonDatatypes.convertMSASDatatype((long)datatype, (int)precision, (int)scale);
        property.setDataType(dataType);
    }

    private boolean shouldCheckPrecisionScale(long datatype) {
        switch ((int)datatype) {
            case 6: 
            case 12: 
            case 131: 
            case 135: 
            case 139: {
                return false;
            }
        }
        return true;
    }

    private PropertyRecord createFakeProperty(String propertyName, String sDUN, String sHUN, String sLUN, RoleTypeEnum roleType, IDataType dataType, LocalizedString caption) {
        PropertyRecord property = new PropertyRecord();
        property.setUniqueName(propertyName);
        if (null != sDUN) {
            property.setDimensionUniqueName(sDUN);
        }
        if (null != sHUN) {
            property.setHierarchyUniqueName(sHUN);
        }
        if (null != sLUN) {
            property.setLevelUniqueName(sLUN);
        }
        property.setName(propertyName);
        property.setRoleType(roleType);
        property.setUniqueId(RecordType.PROPERTY, propertyName);
        property.setDataType(dataType);
        property.setCaption((ILocalizedString)caption);
        return property;
    }

    private boolean skipProperty(ExecutionEnvironment executionEnvironment, XMLAConnection connection, String propertyName, String propertyRestriction) {
        boolean skipThisProperty = false;
        XMLACapabilities capabilities = connection.getCapabilities();
        if ((capabilities.canFakeMemberKey() || !capabilities.canUseMEMBERKEYRestriction()) && propertyRestriction != null && propertyRestriction.equals(MEMBER_KEY_PROPERTY_NAME)) {
            skipThisProperty = true;
        } else if (propertyName.equals("MEMBER_VALUE")) {
            skipThisProperty = true;
        } else if (propertyName.equals("SKIPPED_LEVELS")) {
            skipThisProperty = true;
        } else if (propertyName.equals("CUSTOM_ROLLUP")) {
            skipThisProperty = true;
        } else if (propertyName.equals("NAME")) {
            skipThisProperty = true;
        } else if (propertyName.equals("UNARY_OPERATOR")) {
            skipThisProperty = true;
        } else if (capabilities.canFakeMemberKey() && propertyName.equals(MEMBER_KEY_PROPERTY_NAME)) {
            skipThisProperty = true;
        } else if (capabilities.canSkipDotMemberKey() && propertyName.endsWith(DOT_MEMBER_KEY_PROPERTY_NAME)) {
            skipThisProperty = true;
        } else if (propertyName.startsWith("KEY")) {
            String afterKey = propertyName.substring("KEY".length());
            skipThisProperty = true;
            try {
                Integer.parseInt(afterKey);
            }
            catch (NumberFormatException e) {
                skipThisProperty = false;
            }
        } else if (propertyName.startsWith("TRAN")) {
            String afterKey = propertyName.substring("TRAN".length());
            skipThisProperty = true;
            try {
                Integer.parseInt(afterKey);
            }
            catch (NumberFormatException e) {
                skipThisProperty = false;
            }
        }
        return skipThisProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<VariableRecord> getVariables(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        this.validateVariableRestrictions(restrictions);
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment((IExecutionEnvironment)executionEnvironment);
        try {
            if (XMLALog.isOn("Metadata", LogLevel.WARN)) {
                XMLALog.getLogger("Metadata").log(LogLevel.WARN, "Variables are not supported in XMLA.");
            }
            List<VariableRecord> list = Collections.emptyList();
            return list;
        }
        finally {
            logCtx.exit();
        }
    }

    public void releaseImpl() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        if (XMLALog.isOn("Metadata", LogLevel.INFO)) {
            XMLALog.getLogger("Metadata").log(LogLevel.INFO, "Releasing metadata connection.");
        }
    }

    protected static void throwMissingColumnException(String columnName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.MET_MISSING_ROWSET_COLUMN, columnName);
    }

    protected static void throwRestrictionIllegalValue(RestrictionType restrictionType, Object restrictionValue) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, restrictionType.toString(), restrictionValue.toString());
    }

    protected static void throwRestrictionMissing(RestrictionType restrictionType) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, restrictionType.toString());
    }

    protected List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, XMLAConnection connection, IRestrictions restrictions) {
        List<Object> rootMembers;
        this.validateRootMemberRestrictions(restrictions);
        boolean useCache = this.canUseCache();
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        IRestrictions newRestrictions = restrictions.duplicate();
        this.fixCatalogNameCase(newRestrictions);
        newRestrictions.add(RestrictionType.LEVEL_NUMBER, (Object)0);
        if (useCache) {
            rootMembers = this.getCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, newRestrictions);
            if (null != rootMembers) {
                return rootMembers;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = newRestrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE, RestrictionType.LEVEL_NUMBER});
            }
        }
        rootMembers = this.getMembers(executionEnvironment, connection, newRestrictions);
        if (useCache) {
            if (this.canPrefetchModelMetadata()) {
                IRestrictions hierRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
                List<HierarchyRecord> hiers = this.getHierarchies(executionEnvironment, connection, hierRestrictions);
                for (HierarchyRecord currHier : hiers) {
                    IRestrictions rootMemRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
                    rootMemRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)currHier.getUniqueName());
                    List<MemberRecord> currRootMembers = this.getRootMembersForHier(rootMembers, currHier.getUniqueName());
                    this.putCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, rootMemRestrictions, currRootMembers);
                }
            } else {
                this.putCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, newRestrictions, rootMembers);
            }
            List<MemberRecord> cachedAnswer = this.getCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, restrictions);
            if (null != cachedAnswer) {
                return cachedAnswer;
            }
            rootMembers = this.filterRootMemberRecords(rootMembers, dunRes, hunRes);
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = rootMembers.size();
            if (size != 0) {
                toIndex = Math.min(from + size, rootMembers.size());
            }
            return rootMembers.subList(from, toIndex);
        }
        return rootMembers;
    }

    private List<MemberRecord> getRootMembersForHier(List<MemberRecord> rootMembers, String uniqueName) {
        ArrayList<MemberRecord> currList = new ArrayList<MemberRecord>();
        for (MemberRecord memRec : rootMembers) {
            if (!memRec.getHierarchyUniqueName().equals(uniqueName)) continue;
            currList.add(memRec);
        }
        return currList;
    }

    private List<MemberRecord> filterRootMemberRecords(List<MemberRecord> rootMembers, String dunRes, String hunRes) {
        if (dunRes == null && hunRes == null) {
            if (rootMembers == null) {
                return Collections.emptyList();
            }
            return rootMembers;
        }
        ArrayList<MemberRecord> answer = new ArrayList<MemberRecord>();
        for (MemberRecord rootMemberRec : rootMembers) {
            if (dunRes != null && !dunRes.equals(rootMemberRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(rootMemberRec.getUniqueName())) continue;
            answer.add(rootMemberRec);
        }
        return answer;
    }

    private void validateActionRestrictions(IRestrictions restrictions) {
        Collection coords = (Collection)restrictions.getValueOf(RestrictionType.COORDINATE);
        EnumSet coordTypes = (EnumSet)restrictions.getValueOf(RestrictionType.COORDINATE_TYPE);
        Collection resDimensionLine = (Collection)restrictions.getValueOf(RestrictionType.DIMENSION_LINE);
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        if (null == coordTypes || coordTypes.isEmpty()) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.COORDINATE_TYPE);
        } else {
            if ((coordTypes.contains(ActionCoordinateTypeEnum.DIMENSION) || coordTypes.contains(ActionCoordinateTypeEnum.LEVEL) || coordTypes.contains(ActionCoordinateTypeEnum.MEMBER)) && (null == coords || coords.isEmpty())) {
                XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.COORDINATE);
            }
            if (coordTypes.contains(ActionCoordinateTypeEnum.CELL) && (null == coords || coords.isEmpty()) && (null == resDimensionLine || resDimensionLine.isEmpty())) {
                XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.COORDINATE);
            }
        }
    }

    private void validateCubeRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateCubeDefaultMeasureRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
    }

    private void validateDatasourceLocalesRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateDimensionRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateHierarchyRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateLevelRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateMeasureRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateMemberRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        if (restrictions.contains(RestrictionType.TREEOP) && !restrictions.contains(RestrictionType.MEMBER_UNIQUE_NAME)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.MEMBER_UNIQUE_NAME);
        }
    }

    private void validateRootMemberRestrictions(IRestrictions restrictions) {
        this.validateMemberRestrictions(restrictions);
        if (!restrictions.contains(RestrictionType.HIERARCHY_UNIQUE_NAME)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.HIERARCHY_UNIQUE_NAME);
        }
    }

    private void validateNamedSetMembersRestrictions(IRestrictions restrictions) {
        this.validateNamedSetRestrictions(restrictions);
        if (!restrictions.contains(RestrictionType.SET)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.SET);
        }
    }

    private void validateNamedSetRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validatePropertiesRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private void validateVariableRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            XMLAMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    private static void logMetadataCacheHit(MetadataOperation mdOperation, IRestrictions restrictions) {
        XQELogger logger = XMLALog.getLogger("Metadata.Cache");
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_MDCACHE_HIT).append(mdOperation);
            buffer.append(LOGMSG_WITH_RESTRICTIONS).append(restrictions);
            logger.log(LogLevel.INFO, buffer.toString());
        }
    }

    private static void logMetadataCacheMiss(MetadataOperation mdOperation, IRestrictions restrictions) {
        XQELogger logger = XMLALog.getLogger("Metadata.Cache");
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_MDCACHE_MISS).append(mdOperation);
            buffer.append(LOGMSG_WITH_RESTRICTIONS).append(restrictions);
            logger.log(LogLevel.INFO, buffer.toString());
        }
    }

    private String getCatalogNameFromConnection(XMLAConnection conn) {
        String connCatalog = conn.getCapabilities().canSupportCaseInsensitiveCatalog() ? (String)((UpperCaseCatalogParameter)conn.getConnectionParameters().get(UpperCaseCatalogParameter.class)).value() : (String)((CatalogParameter)conn.getConnectionParameters().get(CatalogParameter.class)).value();
        return connCatalog;
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    static {
        TIMESTAMP.set("2010-01-01 00:00:00");
    }
}

