/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;

public final class XMLAValueConverter {
    public static Value convert(XMLAValue xmlaValue) {
        return XMLAValueConverter.convert(xmlaValue, null);
    }

    public static Value convert(XMLAValue xmlaValue, IDataType expectedDataType) {
        FloatValue result;
        ValueTypeEnum expectedValueType;
        ValueTypeEnum valueType = xmlaValue.getDataType();
        if (null != expectedDataType && (expectedValueType = ValueTypeEnum.fromDataType(expectedDataType)) != ValueTypeEnum.UNKNOWN) {
            valueType = expectedValueType;
        }
        switch (valueType) {
            case TIME_WITH_TZ: {
                result = xmlaValue.getTime();
                break;
            }
            case DATE_WITH_TZ: {
                result = xmlaValue.getDate();
                break;
            }
            case DATETIME_WITH_TZ: {
                result = xmlaValue.getDateTime();
                break;
            }
            case FLOAT32: {
                result = DataValueFactory.createFloatValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getFloat().floatValue());
                break;
            }
            case FLOAT64: {
                result = DataValueFactory.createDoubleValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getDouble().doubleValue());
                break;
            }
            case INT16: {
                result = DataValueFactory.createSmallintValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getShort().shortValue());
                break;
            }
            case INT32: {
                result = DataValueFactory.createIntegerValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getInteger().intValue());
                break;
            }
            case INT64: {
                result = DataValueFactory.createLongValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getLong().longValue());
                break;
            }
            case BIG_DECIMAL: 
            case BIG_INTEGER: {
                int precision;
                if (xmlaValue.isNull()) {
                    result = DataValueFactory.createDecimalValue();
                    result.setNull();
                    break;
                }
                int scale = xmlaValue.getBigDecimal().scale();
                if (scale > (precision = xmlaValue.getBigDecimal().precision())) {
                    precision = scale;
                }
                result = DataValueFactory.createDecimalValue((DecimalType)new DecimalType(precision, scale));
                result.set(xmlaValue.getBigDecimal());
                break;
            }
            case BOOLEAN: {
                result = DataValueFactory.createBooleanValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getBoolean().booleanValue());
                break;
            }
            case STRING: {
                result = DataValueFactory.createStringValue();
                if (xmlaValue.isNull()) {
                    result.setNull();
                    break;
                }
                result.set(xmlaValue.getString());
                break;
            }
            default: {
                if (xmlaValue.isNull() || xmlaValue.isError()) {
                    result = DataValueFactory.createDoubleValue();
                    result.setNull();
                    break;
                }
                result = DataValueFactory.createStringValue();
                result.set(xmlaValue.getString());
            }
        }
        if (xmlaValue.isError()) {
            result.setState(ValueState.ERROR);
        } else if (xmlaValue.isFloatingPointType()) {
            if (xmlaValue.isInfinity()) {
                result.setState(ValueState.DIV_BY_ZERO);
            } else if (xmlaValue.isNan()) {
                result.setState(ValueState.ERROR);
            }
        }
        return result;
    }

    private XMLAValueConverter() {
    }
}

