/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import java.util.HashMap;
import java.util.Map;

public class XMLSchemaConstants {
    private static final Map<String, ValueTypeEnum> XSD_TYPE_MAP = new HashMap<String, ValueTypeEnum>();
    public static final String NAMESPACE_PREFIX_XSI = "xsi";
    public static final String NAMESPACE_PREFIX_XSD = "xsd";
    public static final String NAMESPACE_URI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NAMESPACE_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SPACE = "xml:space";
    public static final String PRESERVE = "preserve";
    public static final String TYPE = "type";
    public static final String NIL = "nil";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String DATE_TIME = "dateTime";
    public static final String BOOLEAN = "boolean";
    public static final String XSD_BOOLEAN = "xsd:boolean";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String STRING = "string";
    public static final String XSD_STRING = "xsd:string";
    public static final String DECIMAL = "decimal";
    public static final String INTEGER = "integer";
    public static final String LONG = "long";
    public static final String UNSIGNED_LONG = "unsignedLong";
    public static final String INT = "int";
    public static final String XSD_INT = "xsd:int";
    public static final String UNSIGNED_INT = "unsignedInt";
    public static final String SHORT = "short";
    public static final String UNSIGNED_SHORT = "unsignedShort";
    public static final String BYTE = "byte";
    public static final String UNSIGNED_BYTE = "unsignedByte";

    public static ValueTypeEnum convertXSDType(String xsdType) {
        ValueTypeEnum result;
        int colonPos = xsdType.indexOf(58);
        if (colonPos >= 0) {
            xsdType = xsdType.substring(colonPos + 1);
        }
        if (null == (result = XSD_TYPE_MAP.get(xsdType))) {
            result = ValueTypeEnum.UNKNOWN;
        }
        return result;
    }

    static {
        XSD_TYPE_MAP.put(BOOLEAN, ValueTypeEnum.BOOLEAN);
        XSD_TYPE_MAP.put(STRING, ValueTypeEnum.STRING);
        XSD_TYPE_MAP.put(DATE, ValueTypeEnum.DATE_WITH_TZ);
        XSD_TYPE_MAP.put(TIME, ValueTypeEnum.TIME_WITH_TZ);
        XSD_TYPE_MAP.put(DATE_TIME, ValueTypeEnum.DATETIME_WITH_TZ);
        XSD_TYPE_MAP.put(SHORT, ValueTypeEnum.INT16);
        XSD_TYPE_MAP.put(UNSIGNED_SHORT, ValueTypeEnum.INT16);
        XSD_TYPE_MAP.put(BYTE, ValueTypeEnum.INT16);
        XSD_TYPE_MAP.put(UNSIGNED_BYTE, ValueTypeEnum.INT16);
        XSD_TYPE_MAP.put(INT, ValueTypeEnum.INT32);
        XSD_TYPE_MAP.put(UNSIGNED_INT, ValueTypeEnum.INT32);
        XSD_TYPE_MAP.put(LONG, ValueTypeEnum.INT64);
        XSD_TYPE_MAP.put(UNSIGNED_LONG, ValueTypeEnum.INT64);
        XSD_TYPE_MAP.put(FLOAT, ValueTypeEnum.FLOAT32);
        XSD_TYPE_MAP.put(DOUBLE, ValueTypeEnum.FLOAT64);
        XSD_TYPE_MAP.put(DECIMAL, ValueTypeEnum.BIG_DECIMAL);
        XSD_TYPE_MAP.put(INTEGER, ValueTypeEnum.BIG_INTEGER);
    }
}

