/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser;

import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.ArrayUtils;

public abstract class ComponentHandlerBase
implements IStaxComponentHandler,
IReleasable {
    private static final boolean ENABLE_ASSERTIONS = false;
    private static final int STRING_BUFFER_INITIAL_CAPACITY = 100;
    private static final int CHAR_BUFFER_LENGTH = 256;
    private final Set<ComponentHandlerBase> subHandlers = new HashSet<ComponentHandlerBase>();
    private final StringBuilder stringBuffer = new StringBuilder(100);
    private final char[] charBuffer = new char[256];
    private boolean released = false;

    public StringBuilder getStringBuilder() {
        this.stringBuffer.delete(0, this.stringBuffer.length());
        return this.stringBuffer;
    }

    public char[] getCharacterBuffer() {
        return this.charBuffer;
    }

    public void reset() {
        for (ComponentHandlerBase handler : this.subHandlers) {
            handler.reset();
        }
        this.resetImpl();
    }

    public void release() {
        if (this.released) {
            return;
        }
        for (ComponentHandlerBase handler : this.subHandlers) {
            handler.release();
        }
        this.releaseImpl();
        this.released = true;
    }

    protected void registerSubHandler(ComponentHandlerBase subHandler) {
        this.subHandlers.add(subHandler);
    }

    protected void unregisterSubHandler(ComponentHandlerBase subHandler) {
        this.subHandlers.remove(subHandler);
    }

    protected abstract void resetImpl();

    protected abstract void releaseImpl();

    public String readText(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, null);
        StringBuilder buffer = this.getStringBuilder();
        char[] cbuf = this.getCharacterBuffer();
        int depth = 1;
        block0: while (depth > 0) {
            reader.next();
            if (reader.isStartElement()) {
                ++depth;
                continue;
            }
            if (reader.isEndElement()) {
                --depth;
                continue;
            }
            if (!reader.isCharacters()) continue;
            int sourceStart = 0;
            while (true) {
                int nCopied;
                if ((nCopied = reader.getTextCharacters(sourceStart, cbuf, 0, cbuf.length)) > 0) {
                    buffer.append(cbuf, 0, nCopied);
                }
                if (nCopied < cbuf.length) continue block0;
                sourceStart += cbuf.length;
            }
        }
        return buffer.toString();
    }

    public static void assertAtStartElement(XMLStreamReader reader) throws XMLAException {
    }

    public static void assertAtStartElement(XMLStreamReader reader, String localName) throws XMLAException {
    }

    public static void assertAtStartElement(XMLStreamReader reader, QName qualifiedName) throws XMLAException {
    }

    public static void throwUnexpectedXMLEventException(int expectedEvent, int actualEvent) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_UNEXPECTED_XML_EVENT, StaxUtil.eventTypeToString((int)expectedEvent), StaxUtil.eventTypeToString((int)actualEvent));
    }

    public static void throwUnexpectedElementException(String expectedName, String actualName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_UNEXPECTED_XML_ELEMENT, expectedName, actualName);
    }

    public static void throwUnexpectedElementException(String[] expectedNames, String actualName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_UNEXPECTED_XML_ELEMENT, ArrayUtils.toString((Object)expectedNames), actualName);
    }

    public static void throwUnexpectedElementException(QName expectedName, QName actualName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_UNEXPECTED_XML_ELEMENT, expectedName.toString(), actualName.toString());
    }

    public static void throwUnexpectedElementException(QName[] expectedNames, QName actualName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_UNEXPECTED_XML_ELEMENT, ArrayUtils.toString((Object)expectedNames), actualName.toString());
    }

    public static void throwStreamError(XMLStreamException cause) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_XML_STREAM_ERROR, cause);
    }

    public static void throwMissingAttributeException(String elementName, String attributeName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.PAR_MISSING_ATTRIBUTE, attributeName, elementName);
    }
}

