/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.soap;

import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SoapEnvelopeHandler
extends ComponentHandlerBase {
    private static final QName SOAP_ENVELOPE_QNAME1 = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    private static final QName SOAP_ENVELOPE_QNAME2 = new QName("http://www.w3.org/2001/12/soap-envelope/", "Envelope");
    private static final QName[] SOAP_ENVELOPES = new QName[]{SOAP_ENVELOPE_QNAME1, SOAP_ENVELOPE_QNAME2};
    private static final String[] EXPECTED_CHILDREN = new String[]{"Header", "Body"};
    private ComponentHandlerBase soapHeaderHandler = null;
    private ComponentHandlerBase soapBodyHandler = null;
    private boolean consumedEnvelope = false;

    @Override
    protected void releaseImpl() {
        this.setSoapHeaderHandler(null);
        this.setSoapBodyHandler(null);
    }

    @Override
    protected void resetImpl() {
        this.consumedEnvelope = false;
    }

    public boolean hasConsumedEnvelope() {
        return this.consumedEnvelope;
    }

    public ComponentHandlerBase getSoapHeaderHandler() {
        return this.soapHeaderHandler;
    }

    public ComponentHandlerBase getSoapBodyHandler() {
        return this.soapBodyHandler;
    }

    public void setSoapHeaderHandler(ComponentHandlerBase theHandler) {
        if (null != this.soapHeaderHandler) {
            this.unregisterSubHandler(this.soapHeaderHandler);
        }
        if (null != theHandler) {
            this.registerSubHandler(theHandler);
        }
        this.soapHeaderHandler = theHandler;
    }

    public void setSoapBodyHandler(ComponentHandlerBase theHandler) {
        if (null != this.soapBodyHandler) {
            this.unregisterSubHandler(this.soapBodyHandler);
        }
        if (null != theHandler) {
            this.registerSubHandler(theHandler);
        }
        this.soapBodyHandler = theHandler;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        if (!StaxUtil.testOnStartElement((XMLStreamReader)reader)) {
            SoapEnvelopeHandler.throwUnexpectedXMLEventException(1, reader.getEventType());
        }
        if (!SOAP_ENVELOPE_QNAME1.equals(reader.getName()) && !SOAP_ENVELOPE_QNAME2.equals(reader.getName())) {
            SoapEnvelopeHandler.throwUnexpectedElementException(SOAP_ENVELOPES, reader.getName());
        }
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            SoapEnvelopeHandler.assertAtStartElement(reader);
            String localName = reader.getLocalName();
            if ("Header".equals(localName)) {
                this.consumeSoapHeader(reader);
                continue;
            }
            if ("Body".equals(localName)) {
                this.consumeSoapBody(reader);
                continue;
            }
            SoapEnvelopeHandler.throwUnexpectedElementException(EXPECTED_CHILDREN, localName);
        }
        this.consumedEnvelope = true;
    }

    private void consumeSoapHeader(XMLStreamReader reader) throws XMLStreamException {
        if (null == this.soapHeaderHandler) {
            StaxUtil.skipElement((XMLStreamReader)reader);
        } else {
            this.soapHeaderHandler.consume(reader);
        }
    }

    private void consumeSoapBody(XMLStreamReader reader) throws XMLStreamException {
        if (null == this.soapBodyHandler) {
            StaxUtil.skipElement((XMLStreamReader)reader);
        } else {
            this.soapBodyHandler.consume(reader);
        }
    }
}

