/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.StringPool;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLSchemaConstants;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.DatasetAwareComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLACell;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAErrorValue;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CellDataHandler
extends DatasetAwareComponentHandler {
    private boolean consumedCellData = false;

    public boolean hasConsumedCellData() {
        return this.consumedCellData;
    }

    @Override
    protected void releaseImpl() {
        this.setDataset(null);
    }

    @Override
    protected void resetImpl() {
        this.consumedCellData = false;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        CellDataHandler.assertAtStartElement(reader, "CellData");
        XMLADataset.CellInfo cellInfo = this.dataset.getCellInfo();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Cell")) {
                this.consumeCell(reader, cellInfo);
                continue;
            }
            CellDataHandler.throwUnexpectedElementException("Cell", reader.getLocalName());
        }
        cellInfo.clearTagMappings();
        cellInfo.clearStringPools();
        this.consumedCellData = true;
    }

    public void consumeCell(XMLStreamReader reader, XMLADataset.CellInfo cellInfo) throws XMLStreamException {
        CellDataHandler.assertAtStartElement(reader, "Cell");
        String ordinal = reader.getAttributeValue(null, "CellOrdinal");
        if (null == ordinal) {
            CellDataHandler.throwMissingAttributeException("Cell", "CellOrdinal");
        }
        XMLACell cell = new XMLACell(cellInfo, Integer.valueOf(ordinal));
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String xsiNil;
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            String propertyTag = reader.getLocalName();
            XMLAPropertyInfo propertyInfo = cellInfo.propertyFromTag(propertyTag);
            if (null == propertyInfo) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            String xsdDataType = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            ValueTypeEnum valueType = ValueTypeEnum.UNKNOWN;
            boolean isNull = false;
            XMLAValue value = null;
            if (null != xsdDataType) {
                valueType = XMLSchemaConstants.convertXSDType(xsdDataType);
            }
            if (null != (xsiNil = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
                isNull = xsiNil.equals("true");
            }
            value = this.readValue(reader, valueType, isNull, propertyInfo.getStringPool());
            cell.setProperty(propertyInfo, value);
        }
        XMLALogContext.get().incrementCellCount();
        this.dataset.putCell(cell);
    }

    public XMLAValue readValue(XMLStreamReader reader, ValueTypeEnum valueType, boolean isNull, StringPool stringPool) throws XMLStreamException {
        reader.require(1, null, null);
        XMLAErrorValue error = null;
        XMLAValue result = null;
        boolean readCharacters = false;
        StringBuilder buffer = this.getStringBuilder();
        char[] cbuf = this.getCharacterBuffer();
        int depth = 1;
        block0: while (depth > 0) {
            reader.next();
            if (reader.isStartElement()) {
                ++depth;
                if (!reader.getLocalName().equals("Error")) continue;
                error = this.consumeError(reader);
                --depth;
                continue;
            }
            if (reader.isEndElement()) {
                --depth;
                continue;
            }
            if (!reader.isCharacters()) continue;
            readCharacters = true;
            int sourceStart = 0;
            while (true) {
                int nCopied;
                if ((nCopied = reader.getTextCharacters(sourceStart, cbuf, 0, cbuf.length)) > 0) {
                    buffer.append(cbuf, 0, nCopied);
                }
                if (nCopied < cbuf.length) continue block0;
                sourceStart += cbuf.length;
            }
        }
        result = null != error ? XMLAValue.errorOf(error) : (isNull ? XMLAValue.nullOf(valueType) : (!readCharacters ? XMLAValue.errorOf(error) : XMLAValue.valueOf(stringPool.intern(buffer.toString()), valueType)));
        return result;
    }

    public XMLAErrorValue consumeError(XMLStreamReader reader) throws XMLStreamException {
        CellDataHandler.assertAtStartElement(reader, "Error");
        String errorCode = null;
        String description = null;
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"ErrorCode")) {
                errorCode = this.readText(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Description")) {
                description = this.readText(reader);
                continue;
            }
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
        return new XMLAErrorValue(errorCode, description);
    }
}

