/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.StringPool;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLSchemaConstants;
import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.data.providers.olap.xmla.parser.DelegatingComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.SimpleQNameAdvisor;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.IPropertyFilter;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.MessagesHandler;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARow;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARowset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DiscoverResponseHandler
extends ComponentHandlerBase {
    private static final QName DISCOVER_RESPONSE_QNAME = new QName("urn:schemas-microsoft-com:xml-analysis", "DiscoverResponse");
    private static final QName EMPTY_ROOT_QNAME = new QName("urn:schemas-microsoft-com:xml-analysis:empty", "root");
    private static final QName EMPTY_ROOT_QNAME_CSTYPO = new QName("urn:scshemas-microsoft-com:xml-analysis:empty", "root");
    private static final QName ROWSET_ROOT_QNAME = new QName("urn:schemas-microsoft-com:xml-analysis:rowset", "root");
    private boolean consumedResponse = false;
    private XMLARowset rowset = null;
    private IPropertyFilter columnFilter = null;
    private MessagesHandler messagesHandler = null;

    public void registerAsDelegate(DelegatingComponentHandler handler) {
        handler.registerDelegate(this, new SimpleQNameAdvisor(DISCOVER_RESPONSE_QNAME));
    }

    public MessagesHandler getMessagesHandler() {
        return this.messagesHandler;
    }

    public void setMessagesHandler(MessagesHandler theMessagesHandler) {
        this.messagesHandler = theMessagesHandler;
    }

    public boolean hasConsumedResponse() {
        return this.consumedResponse;
    }

    public XMLARowset getRowset() {
        return this.rowset;
    }

    public IPropertyFilter getColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(IPropertyFilter theColumnFilter) {
        this.columnFilter = theColumnFilter;
    }

    private boolean canRetainColumn(String columnName) {
        return null == this.columnFilter || this.columnFilter.canRetain(columnName);
    }

    @Override
    protected void releaseImpl() {
        this.rowset = null;
    }

    @Override
    protected void resetImpl() {
        this.rowset = null;
        this.consumedResponse = false;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        DiscoverResponseHandler.assertAtStartElement(reader, DISCOVER_RESPONSE_QNAME);
        StaxUtil.moveToElement((XMLStreamReader)reader, (String)"return");
        this.consumeReturn(reader);
        XMLALogContext.get().setRowCount(this.rowset.numRows());
        this.consumedResponse = true;
    }

    private void consumeReturn(XMLStreamReader reader) throws XMLStreamException {
        DiscoverResponseHandler.assertAtStartElement(reader, "return");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (QName)ROWSET_ROOT_QNAME) || StaxUtil.testOnStartElement((XMLStreamReader)reader, (QName)EMPTY_ROOT_QNAME) || StaxUtil.testOnStartElement((XMLStreamReader)reader, (QName)EMPTY_ROOT_QNAME_CSTYPO)) {
                this.consumeRowsetRoot(reader);
                continue;
            }
            DiscoverResponseHandler.throwUnexpectedElementException(ROWSET_ROOT_QNAME, reader.getName());
        }
    }

    private void consumeRowsetRoot(XMLStreamReader reader) throws XMLStreamException {
        this.rowset = new XMLARowset();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"row")) {
                this.consumeRow(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Messages")) {
                if (null == this.messagesHandler) continue;
                this.messagesHandler.consume(reader);
                continue;
            }
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
    }

    private void consumeRow(XMLStreamReader reader) throws XMLStreamException {
        DiscoverResponseHandler.assertAtStartElement(reader, "row");
        XMLARow currentRow = this.rowset.newRow();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            int columnOrdinal;
            String xsiNil;
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            String columnName = reader.getLocalName();
            if (!this.canRetainColumn(columnName)) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            String xsdDataType = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            ValueTypeEnum valueType = ValueTypeEnum.STRING;
            boolean isNull = false;
            XMLAValue value = null;
            if (null != xsdDataType) {
                valueType = XMLSchemaConstants.convertXSDType(xsdDataType);
            }
            if (null != (xsiNil = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
                isNull = xsiNil.equals("true");
            }
            if ((columnOrdinal = this.rowset.getColumnOrdinal(columnName)) < 0) {
                columnOrdinal = this.rowset.addColumn(columnName);
            }
            String stringValue = DiscoverResponseHandler.readTextOrChildName(reader);
            if (isNull || null == stringValue) {
                value = XMLAValue.nullOf(valueType);
            } else {
                StringPool stringPool = this.rowset.getColumnStringPool(columnOrdinal);
                value = XMLAValue.valueOf(stringPool.intern(stringValue), valueType);
            }
            currentRow.setValue(columnOrdinal, value);
        }
    }

    private static String readTextOrChildName(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, null);
        QName parentName = reader.getName();
        StringBuilder buffer = new StringBuilder();
        String childName = null;
        reader.next();
        while (!StaxUtil.testOnEndElement((XMLStreamReader)reader, (QName)parentName)) {
            if (reader.getEventType() == 1) {
                childName = reader.getLocalName();
                StaxUtil.skipElement((XMLStreamReader)reader);
            } else if (reader.isCharacters()) {
                buffer.append(reader.getText());
            }
            reader.next();
        }
        if (null != childName) {
            return childName;
        }
        return buffer.toString();
    }
}

