/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.XMLAMessage;
import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class FaultDetailHandler
extends ComponentHandlerBase {
    private static final String DETAIL = "detail";
    private static final QName SPEC_ERROR = new QName(null, "Error");
    private static final QName MONDRIAN_ERROR = new QName("http://mondrian.sourceforge.net", "error");
    private boolean consumedDetail = false;
    private XMLAMessage detailMessage = null;

    public boolean hasConsumedDetail() {
        return this.consumedDetail;
    }

    public XMLAMessage getDetailMessage() {
        return this.detailMessage;
    }

    @Override
    protected void releaseImpl() {
        this.detailMessage = null;
    }

    @Override
    protected void resetImpl() {
        this.detailMessage = null;
        this.consumedDetail = false;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        FaultDetailHandler.assertAtStartElement(reader, DETAIL);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (QName)MONDRIAN_ERROR)) {
                this.consumeMondrianError(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (QName)SPEC_ERROR)) {
                this.consumeSpecError(reader);
                continue;
            }
            if (!StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) continue;
            StaxUtil.skipElement((XMLStreamReader)reader);
            childIter.skipToEnd();
            break;
        }
        this.consumedDetail = true;
    }

    private void consumeSpecError(XMLStreamReader reader) throws XMLStreamException {
        String errorCode = reader.getAttributeValue(null, "ErrorCode");
        String description = reader.getAttributeValue(null, "Description");
        String source = reader.getAttributeValue(null, "Source");
        String helpFile = reader.getAttributeValue(null, "HelpFile");
        this.detailMessage = new XMLAMessage(XMLAMessage.MessageTypeEnum.ERROR, errorCode, description, source, helpFile);
        StaxUtil.skipElement((XMLStreamReader)reader);
    }

    private void consumeMondrianError(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        String errorCode = null;
        String description = null;
        while (childIter.next()) {
            String name = reader.getLocalName();
            if ("code".equals(name)) {
                errorCode = reader.getElementText();
                continue;
            }
            if (!"desc".equals(name)) continue;
            description = reader.getElementText();
        }
        this.detailMessage = new XMLAMessage(XMLAMessage.MessageTypeEnum.ERROR, errorCode, description, null, null);
    }
}

