/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.XMLAMessage;
import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.data.providers.olap.xmla.parser.DelegatingComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.SimpleLocalNameAdvisor;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class MessagesHandler
extends ComponentHandlerBase {
    private boolean consumedMessages = false;
    private List<XMLAMessage> warningMessages = new ArrayList<XMLAMessage>();
    private List<XMLAMessage> errorMessages = new ArrayList<XMLAMessage>();

    public void registerAsDelegate(DelegatingComponentHandler handler) {
        handler.registerDelegate(this, new SimpleLocalNameAdvisor("Messages"));
    }

    public boolean hasConsumedMessages() {
        return this.consumedMessages;
    }

    public int numWarnings() {
        return this.warningMessages.size();
    }

    public int numErrors() {
        return this.errorMessages.size();
    }

    public XMLAMessage[] getWarnings() {
        return this.warningMessages.toArray(new XMLAMessage[0]);
    }

    public XMLAMessage[] getErrors() {
        return this.errorMessages.toArray(new XMLAMessage[0]);
    }

    @Override
    protected void releaseImpl() {
        this.warningMessages.clear();
        this.errorMessages.clear();
    }

    @Override
    protected void resetImpl() {
        this.consumedMessages = false;
        this.warningMessages.clear();
        this.errorMessages.clear();
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        MessagesHandler.assertAtStartElement(reader, "Messages");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Warning")) {
                this.consumeWarning(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Error")) {
                this.consumeError(reader);
                continue;
            }
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
        this.consumedMessages = true;
    }

    private void consumeWarning(XMLStreamReader reader) throws XMLStreamException {
        MessagesHandler.assertAtStartElement(reader, "Warning");
        String warningCode = reader.getAttributeValue(null, "WarningCode");
        String description = reader.getAttributeValue(null, "Description");
        String source = reader.getAttributeValue(null, "Source");
        String helpFile = reader.getAttributeValue(null, "HelpFile");
        StaxUtil.skipElement((XMLStreamReader)reader);
        XMLAMessage message = new XMLAMessage(XMLAMessage.MessageTypeEnum.WARNING, warningCode, description, source, helpFile);
        this.warningMessages.add(message);
    }

    private void consumeError(XMLStreamReader reader) throws XMLStreamException {
        MessagesHandler.assertAtStartElement(reader, "Error");
        String errorCode = reader.getAttributeValue(null, "ErrorCode");
        String description = reader.getAttributeValue(null, "Description");
        String source = reader.getAttributeValue(null, "Source");
        String helpFile = reader.getAttributeValue(null, "HelpFile");
        StaxUtil.skipElement((XMLStreamReader)reader);
        XMLAMessage message = new XMLAMessage(XMLAMessage.MessageTypeEnum.ERROR, errorCode, description, source, helpFile);
        this.errorMessages.add(message);
    }
}

