/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.query.IQueryListener;
import com.cognos.xqe.data.providers.olap.xmla.query.QueryListenerList;
import com.cognos.xqe.data.providers.olap.xmla.query.QueryState;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.IReleasable;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class QueryBase
implements ICancelable,
IReleasable {
    private volatile QueryState state = QueryState.NOT_STARTED;
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final QueryListenerList listenerList = new QueryListenerList();

    public final QueryState getState() {
        return this.state;
    }

    protected QueryListenerList getListeners() {
        return this.listenerList;
    }

    public final void registerListener(IQueryListener theListener) {
        this.listenerList.addListener(theListener);
    }

    public final void deregisterListener(IQueryListener theListener) {
        this.listenerList.removeListener(theListener);
    }

    public final void execute() throws OperationCanceledException {
        this.checkCancelRequested();
        this.state = QueryState.RUNNING;
        this.getListeners().onExecuteBegin(this);
        try {
            this.executeImpl();
            this.checkCancelRequested();
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        finally {
            if (!this.isCancelRequested()) {
                this.state = QueryState.COMPLETED;
            }
            this.getListeners().onExecuteEnd(this);
        }
    }

    protected abstract void executeImpl() throws OperationCanceledException;

    public final boolean isCancelRequested() {
        return this.cancelRequested.get();
    }

    protected final void checkCancelRequested() throws OperationCanceledException {
        if (this.isCancelRequested()) {
            throw new OperationCanceledException();
        }
    }

    public final void cancel() throws CancelUnsuccessfulException {
        if (!this.cancelRequested.compareAndSet(false, true)) {
            throw new CancelUnsuccessfulException();
        }
        this.state = QueryState.CANCELED;
        this.getListeners().onCancelBegin(this);
        try {
            this.cancelImpl();
        }
        catch (Throwable ex) {
            if (XMLALog.isOn("Cancel", LogLevel.ERROR)) {
                XMLALog.getLogger("Cancel").log(LogLevel.ERROR, ex);
            }
            this.getListeners().onError(this, ex);
            throw new CancelUnsuccessfulException(ex);
        }
        finally {
            this.getListeners().onCancelEnd(this);
        }
    }

    protected abstract void cancelImpl() throws Throwable;

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    public final void release() {
        block4: {
            if (!this.released.compareAndSet(false, true)) {
                return;
            }
            if (QueryState.RUNNING == this.state) {
                throw new IllegalStateException("Query was still running.");
            }
            try {
                this.releaseImpl();
            }
            catch (Throwable ex) {
                if (!XMLALog.isOn(LogLevel.ERROR)) break block4;
                XMLALog.getLogger().log(LogLevel.ERROR, ex);
            }
        }
    }

    protected abstract void releaseImpl() throws Throwable;
}

