/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.xmla.HTTPCodes;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapDocumentHandler;
import com.cognos.xqe.data.providers.olap.xmla.query.HTTPPostQuery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public abstract class SOAPQuery
extends HTTPPostQuery {
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String NEWLINE = System.getProperty("line.separator");
    private final SoapDocumentHandler documentHandler = new SoapDocumentHandler();
    private QName soapAction = null;

    public final QName getSOAPAction() {
        return this.soapAction;
    }

    public final void setSOAPAction(QName theSoapAction) {
        this.soapAction = theSoapAction;
    }

    @Override
    protected void setupPostMethod(PostMethod theHttpMethod) {
        if (null == this.soapAction) {
            throw new IllegalStateException("SoapAction was null.");
        }
        theHttpMethod.setRequestHeader(new Header(SOAP_ACTION, this.formatSOAPActionString()));
    }

    private String formatSOAPActionString() {
        StringBuilder buf = new StringBuilder(this.soapAction.getNamespaceURI().length() + this.soapAction.getLocalPart().length());
        return buf.append('\"').append(this.soapAction.getNamespaceURI()).append(':').append(this.soapAction.getLocalPart()).append('\"').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RequestEntity createRequestEntity() throws Throwable {
        StringWriter requestWriter = new StringWriter();
        XMLStreamWriter streamWriter = StaxUtil.createXMLStreamWriter((Writer)requestWriter);
        try {
            this.writeSoapDocument(streamWriter);
        }
        finally {
            block8: {
                try {
                    streamWriter.close();
                }
                catch (XMLStreamException ex) {
                    if (!XMLALog.isOn(LogLevel.ERROR)) break block8;
                    XMLALog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                }
            }
        }
        return new StringRequestEntity(requestWriter.toString(), "text/xml", "UTF-8");
    }

    private void writeSoapDocument(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartDocument("1.0");
        this.writeHeaderComments(streamWriter);
        this.writeSoapEnvelope(streamWriter);
        streamWriter.writeEndDocument();
    }

    private void writeHeaderComments(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (XMLALog.isOn("Soap.Request", LogLevel.INFO)) {
            XMLALogContext logCtx = XMLALogContext.get();
            StringBuilder commentBuffer = new StringBuilder();
            commentBuffer.append("UserId = ").append(logCtx.getUserId()).append(NEWLINE).append("CAMPassport = ").append(logCtx.getCAMPassport()).append(NEWLINE);
            streamWriter.writeComment(commentBuffer.toString());
        }
    }

    private void writeSoapEnvelope(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("SOAP-ENV", "Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
        streamWriter.writeNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        streamWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        streamWriter.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.writeSoapHeader(streamWriter);
        this.writeSoapBody(streamWriter);
        streamWriter.writeEndElement();
    }

    private void writeSoapHeader(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("SOAP-ENV", "Header", "http://schemas.xmlsoap.org/soap/envelope/");
        this.writeSoapHeaderChildren(streamWriter);
        streamWriter.writeEndElement();
    }

    protected abstract void writeSoapHeaderChildren(XMLStreamWriter var1) throws XMLStreamException;

    private void writeSoapBody(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("SOAP-ENV", "Body", "http://schemas.xmlsoap.org/soap/envelope/");
        this.writeSoapBodyChildren(streamWriter);
        streamWriter.writeEndElement();
    }

    protected abstract void writeSoapBodyChildren(XMLStreamWriter var1) throws XMLStreamException;

    @Override
    protected void handleHttpStatusLine(StatusLine theStatusLine) throws Throwable {
        int statusCode = theStatusLine.getStatusCode();
        if (HTTPCodes.testBadRequestStatus(statusCode)) {
            if (401 == statusCode || 403 == statusCode) {
                throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
            }
            if (404 == statusCode || 405 == statusCode) {
                throw new XMLAException(XMLAMessageKeys.CON_BAD_HTTP_CONTEXT_PATH, this.getHttpMethod().getPath());
            }
            throw new XMLAException(XMLAMessageKeys.CON_BAD_HTTP_REQUEST, Integer.toString(statusCode), theStatusLine.getReasonPhrase());
        }
        if (HTTPCodes.testServerErrorStatus(statusCode)) {
            if (500 == statusCode) {
                return;
            }
            throw new XMLAException(XMLAMessageKeys.CON_INTERNAL_SERVER_ERROR, Integer.toString(statusCode), theStatusLine.getReasonPhrase());
        }
        if (!HTTPCodes.testSuccessStatus(statusCode)) {
            throw new XMLAException(XMLAMessageKeys.CON_UNEXPECTED_STATUS, Integer.toString(statusCode), theStatusLine.getReasonPhrase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleHttpResponseBody(InputStream responseStream) throws Throwable {
        XMLStreamReader streamReader = StaxUtil.createXMLStreamReader((InputStream)responseStream);
        try {
            this.setupSoapHandlers(this.documentHandler);
            try {
                try {
                    long startTime = System.currentTimeMillis();
                    this.documentHandler.consume(streamReader);
                    XMLALogContext.get().setParseTime(System.currentTimeMillis() - startTime);
                }
                catch (XMLAException ex) {
                    if (500 == this.getLastHttpStatus().getStatusCode()) {
                        SOAPQuery.throwServerInternalError(this.getLastHttpStatus().getStatusCode(), this.getLastHttpStatus().getReasonPhrase());
                    }
                    throw ex;
                }
                this.extractSoapResult(this.documentHandler);
                if (500 == this.getLastHttpStatus().getStatusCode()) {
                    SOAPQuery.throwServerInternalError(this.getLastHttpStatus().getStatusCode(), this.getLastHttpStatus().getReasonPhrase());
                }
            }
            finally {
                this.documentHandler.release();
            }
        }
        finally {
            block15: {
                try {
                    streamReader.close();
                }
                catch (XMLStreamException ex) {
                    if (!XMLALog.isOn(LogLevel.ERROR)) break block15;
                    XMLALog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                }
            }
        }
    }

    protected abstract void setupSoapHandlers(SoapDocumentHandler var1);

    protected abstract void extractSoapResult(SoapDocumentHandler var1) throws Throwable;

    protected static void throwServerInternalError(int statusCode, String reasonPhrase) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.CON_INTERNAL_SERVER_ERROR, Integer.toString(statusCode), reasonPhrase);
    }
}

