/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLASession;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapDocumentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.AxesHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.CellDataHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.IPropertyFilter;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.OlapInfoHandler;
import com.cognos.xqe.data.providers.olap.xmla.query.XMLAExecuteQuery;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public final class XMLAExecuteStatementQuery
extends XMLAExecuteQuery {
    private String mdxStatement = null;
    private int expectedEdgeCount = 0;
    private XMLADataset dataset = null;

    public IPropertyFilter getHierarchyPropertyFilter() {
        return this.executeHandler.getHierarchyPropertyFilter();
    }

    public void setHierarchyPropertyFilter(IPropertyFilter propertyFilter) {
        this.executeHandler.setHierarchyPropertyFilter(propertyFilter);
    }

    public IPropertyFilter getCellPropertyFilter() {
        return this.executeHandler.getCellPropertyFilter();
    }

    public void setCellPropertyFilter(IPropertyFilter propertyFilter) {
        this.executeHandler.setCellPropertyFilter(propertyFilter);
    }

    public String getMDXStatement() {
        return this.mdxStatement;
    }

    public void setMDXStatement(String theMDXStatement) {
        this.mdxStatement = theMDXStatement;
    }

    public int getExpectedEdgeCount() {
        return this.expectedEdgeCount;
    }

    public void setExpectedEdgeCount(int nExpectedEdges) {
        this.expectedEdgeCount = nExpectedEdges;
    }

    public XMLADataset getDataset() {
        return this.dataset;
    }

    @Override
    protected void setupSoapHandlers(SoapDocumentHandler theDocumentHandler) {
        super.setupSoapHandlers(theDocumentHandler);
        this.executeHandler.setOlapInfoHandler(new OlapInfoHandler(this.expectedEdgeCount));
        this.executeHandler.setAxesHandler(new AxesHandler());
        this.executeHandler.setCellDataHandler(new CellDataHandler());
    }

    @Override
    protected RequestEntity createRequestEntity() throws Throwable {
        StringRequestEntity entity = (StringRequestEntity)super.createRequestEntity();
        if (null != this.getSession()) {
            if (XMLASession.SessionState.BEGIN == this.getSession().getState()) {
                XMLALog.dumpBeginSessionRequest(entity.getContent());
            } else if (XMLASession.SessionState.END == this.getSession().getState()) {
                XMLALog.dumpEndSessionRequest(entity.getContent());
            } else {
                XMLALog.dumpExecuteRequest(entity.getContent());
            }
        } else {
            XMLALog.dumpExecuteRequest(entity.getContent());
        }
        return entity;
    }

    @Override
    protected void writeCommandBody(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (null == this.mdxStatement) {
            throw new IllegalStateException("MDXStatement was null.");
        }
        streamWriter.writeStartElement("urn:schemas-microsoft-com:xml-analysis", "Statement");
        streamWriter.writeCharacters(this.mdxStatement);
        streamWriter.writeEndElement();
    }

    @Override
    protected InputStream prepareResponseStream(InputStream responseStream) throws IOException {
        responseStream = super.prepareResponseStream(responseStream);
        if (null != this.getSession()) {
            if (XMLASession.SessionState.BEGIN == this.getSession().getState()) {
                return XMLALog.dumpBeginSessionResponse(responseStream);
            }
            if (XMLASession.SessionState.END == this.getSession().getState()) {
                return XMLALog.dumpEndSessionResponse(responseStream);
            }
            return XMLALog.dumpExecuteResponse(responseStream);
        }
        return XMLALog.dumpExecuteResponse(responseStream);
    }

    @Override
    protected void extractXmlaResult(SoapDocumentHandler theDocumentHandler) throws Throwable {
        this.dataset = null;
        if (this.executeHandler.hasConsumedResponse()) {
            this.dataset = this.executeHandler.getDataset();
        }
    }
}

