/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.KeyValueList;
import com.cognos.xqe.data.providers.olap.xmla.KeyValuePair;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessage;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLASession;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapDocumentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapFaultHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.FaultDetailHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.MessagesHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.SessionHandler;
import com.cognos.xqe.data.providers.olap.xmla.query.SOAPQuery;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.STAXEventWriter;

public abstract class XMLAQuery
extends SOAPQuery {
    protected static final String ONE = "1";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String MESSAGE_BULLET = "* ";
    protected final MessagesHandler messagesHandler = new MessagesHandler();
    private final FaultDetailHandler faultDetailHandler = new FaultDetailHandler();
    private KeyValueList properties = null;
    private String camPassport = null;
    private Element camPassportElement = null;
    private Element biBusHeaderElement = null;
    private String reportPath = null;
    private XMLASession session = null;
    protected String requestId = null;
    protected String providerType = "";

    public void setProviderType(String type) {
        this.providerType = type;
    }

    public final KeyValueList getProperties() {
        return this.properties;
    }

    public final void setProperties(KeyValueList theProperties) {
        this.properties = theProperties;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(String theReportPath) {
        this.reportPath = theReportPath;
    }

    public void setRequestId(String requestID) {
        this.requestId = requestID;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getCAMPassport() {
        return this.camPassport;
    }

    public void setCAMPassport(String theCAMPassport) {
        this.camPassport = theCAMPassport;
    }

    public Element getCAMPassportElement() {
        return this.camPassportElement;
    }

    public void setCAMPassportElement(Element theCAMPassportElement) {
        this.camPassportElement = theCAMPassportElement;
    }

    public Element getBiBusHeaderElement() {
        return this.biBusHeaderElement;
    }

    public void setBiBusHeaderElement(Element theBiBusHeaderElement) {
        this.biBusHeaderElement = theBiBusHeaderElement;
    }

    public XMLASession getSession() {
        return this.session;
    }

    public void setSession(XMLASession theSession) {
        this.session = theSession;
    }

    @Override
    protected void setupSoapHandlers(SoapDocumentHandler theDocumentHandler) {
        theDocumentHandler.getFaultHandler().setDetailsHandler(this.faultDetailHandler);
        if (null != this.session && XMLASession.SessionState.BEGIN == this.session.getState()) {
            SessionHandler sessionHandler = new SessionHandler(this.session);
            sessionHandler.registerAsDelegate(theDocumentHandler.getHeaderHandler());
        }
    }

    @Override
    protected void writeSoapHeaderChildren(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (null != this.camPassportElement) {
            this.writeBIBusHeaderWithCAM(streamWriter);
        }
        if (null != this.biBusHeaderElement) {
            this.writeFullBIBusHeader(streamWriter);
        }
        if (null != this.reportPath) {
            this.writeMondrianReportPath(streamWriter);
        }
        if (DataSourceTypeEnum.isMondrian((String)this.providerType) && null != this.requestId) {
            this.writeMondrianRequestID(streamWriter);
        }
        if (null != this.session) {
            switch (this.session.getState()) {
                case ESTABLISHED: {
                    this.writeSession(streamWriter, this.session.getSessionId());
                    break;
                }
                case BEGIN: {
                    this.writeBeginSession(streamWriter);
                    break;
                }
                case END: {
                    this.writeEndSession(streamWriter, this.session.getSessionId());
                    break;
                }
            }
        }
    }

    private void writeBIBusHeaderWithCAM(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        streamWriter.writeStartElement("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "bus:biBusHeader");
        streamWriter.writeStartElement("CAM");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "bus:CAM");
        streamWriter.writeStartElement("CAMPassport");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "bus:CAMPassport");
        streamWriter.writeStartElement("canCallLogon");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:boolean");
        streamWriter.writeCharacters(this.camPassportElement.elementText("canCallLogon"));
        streamWriter.writeEndElement();
        streamWriter.writeStartElement("generation");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "int");
        streamWriter.writeCharacters(this.camPassportElement.elementText("generation"));
        streamWriter.writeEndElement();
        streamWriter.writeStartElement("logEnabled");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:boolean");
        streamWriter.writeCharacters(this.camPassportElement.elementText("logEnabled"));
        streamWriter.writeEndElement();
        streamWriter.writeStartElement("isAnonymous");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:boolean");
        streamWriter.writeCharacters(this.camPassportElement.elementText("isAnonymous"));
        streamWriter.writeEndElement();
        streamWriter.writeStartElement("id");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:string");
        streamWriter.writeAttribute("xml:space", "preserve");
        streamWriter.writeCharacters(this.camPassportElement.elementText("id"));
        streamWriter.writeEndElement();
        String shareable = this.camPassportElement.elementText("shareable");
        if (null != shareable) {
            streamWriter.writeStartElement("shareable");
            streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:boolean");
            streamWriter.writeAttribute("xml:space", "preserve");
            streamWriter.writeCharacters(shareable);
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
    }

    private static void element2XMLStream(XMLStreamWriter streamWriter, Element elem) throws XMLStreamException {
        XMLEventWriter eventWriter = StaxUtil.createXMLEventWriter((XMLStreamWriter)streamWriter);
        STAXEventWriter dom2EventWriter = new STAXEventWriter(eventWriter){

            public void writeNamespace(Namespace ns) throws XMLStreamException {
            }
        };
        dom2EventWriter.writeElement(elem);
        eventWriter.flush();
    }

    private void writeFullBIBusHeader(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        XMLAQuery.element2XMLStream(streamWriter, this.biBusHeaderElement);
    }

    private void writeMondrianReportPath(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("MD", "ReportPath", "http://mondrian.sourceforge.net");
        streamWriter.writeNamespace("MD", "http://mondrian.sourceforge.net");
        streamWriter.writeCharacters(this.reportPath);
        streamWriter.writeEndElement();
    }

    private void writeBeginSession(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("XA", "BeginSession", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeNamespace("XA", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:int");
        streamWriter.writeAttribute("mustUnderstand", ONE);
        streamWriter.writeEndElement();
    }

    private void writeMondrianRequestID(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("MD", "RequestId", "http://mondrian.sourceforge.net");
        streamWriter.writeNamespace("MD", "http://mondrian.sourceforge.net");
        streamWriter.writeCharacters(this.requestId);
        streamWriter.writeEndElement();
    }

    private void writeSession(XMLStreamWriter streamWriter, String sessionId) throws XMLStreamException {
        streamWriter.writeStartElement("XA", "Session", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeNamespace("XA", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeAttribute("mustUnderstand", ONE);
        streamWriter.writeAttribute("SessionId", sessionId);
        streamWriter.writeEndElement();
    }

    private void writeEndSession(XMLStreamWriter streamWriter, String sessionId) throws XMLStreamException {
        streamWriter.writeStartElement("XA", "EndSession", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeNamespace("XA", "urn:schemas-microsoft-com:xml-analysis");
        streamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:int");
        streamWriter.writeAttribute("mustUnderstand", ONE);
        streamWriter.writeAttribute("SessionId", sessionId);
        streamWriter.writeEndElement();
    }

    protected final void writeProperties(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("urn:schemas-microsoft-com:xml-analysis", "Properties");
        streamWriter.writeStartElement("urn:schemas-microsoft-com:xml-analysis", "PropertyList");
        if (null != this.properties) {
            for (KeyValuePair pair : this.properties) {
                streamWriter.writeStartElement((String)pair.getKey());
                streamWriter.writeCharacters((String)pair.getValue());
                streamWriter.writeEndElement();
            }
        }
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
    }

    @Override
    protected void extractSoapResult(SoapDocumentHandler theDocumentHandler) throws Throwable {
        StringBuilder buffer;
        if (theDocumentHandler.getFaultHandler().hasConsumedFault()) {
            XMLAQuery.throwServerFault(theDocumentHandler.getFaultHandler());
        }
        if (this.messagesHandler.numWarnings() > 0 && XMLALog.isOn("Soap.Response", LogLevel.WARN)) {
            buffer = new StringBuilder();
            buffer.append("Response returned one or more warning messages:").append(NEWLINE);
            for (XMLAMessage msg : this.messagesHandler.getWarnings()) {
                buffer.append(MESSAGE_BULLET).append(msg.toString()).append(NEWLINE);
            }
            XMLALog.getLogger("Soap.Response").log(LogLevel.WARN, buffer.toString());
        }
        if (this.messagesHandler.numErrors() > 0) {
            if (XMLALog.isOn("Soap.Response", LogLevel.ERROR)) {
                buffer = new StringBuilder();
                buffer.append("Response returned one or more error messages:").append(NEWLINE);
                for (XMLAMessage msg : this.messagesHandler.getErrors()) {
                    buffer.append(MESSAGE_BULLET).append(msg.toString()).append(NEWLINE);
                }
                XMLALog.getLogger("Soap.Response").log(LogLevel.ERROR, buffer.toString());
            }
            XMLAQuery.throwServerExceptions(this.messagesHandler.getErrors());
        }
        this.extractXmlaResult(theDocumentHandler);
    }

    protected abstract void extractXmlaResult(SoapDocumentHandler var1) throws Throwable;

    private static void throwServerFault(SoapFaultHandler faultHandler) throws XMLAException {
        XMLAMessage details = ((FaultDetailHandler)faultHandler.getDetailsHandler()).getDetailMessage();
        if (details != null) {
            throw new XMLAException(XMLAMessageKeys.XMA_SERVER_FAULT, faultHandler.getFaultCode(), faultHandler.getFaultString(), details.getCode(), details.getDescription(), details.getSource(), details.getHelpFile());
        }
        throw new XMLAException(XMLAMessageKeys.XMA_SERVER_FAULT, faultHandler.getFaultCode(), faultHandler.getFaultString(), "", "", "", "");
    }

    private static void throwServerExceptions(XMLAMessage[] messages) throws XMLAException {
        XMLAMessage details = messages[0];
        throw new XMLAException(XMLAMessageKeys.XMA_SERVER_EXCEPTION, details.getCode(), (Object)details.getDescription(), (Object)details.getSource(), (Object)details.getHelpFile());
    }
}

