/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractTupleSet
implements ITupleSet {
    @Override
    public int cardinality() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.get(0).cardinality();
    }

    @Override
    public boolean contains(XMLATuple tuple) {
        for (XMLATuple t : this) {
            if (t != tuple && !t.equals(tuple)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public Iterator<XMLATuple> iterator() {
        return new Iter();
    }

    @Override
    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("TupleSet");
        writer.writeAttribute("size", Integer.toString(this.size()));
        for (int index = 0; index < this.size(); ++index) {
            XMLATuple tuple = this.get(index);
            tuple.dumpXML(writer);
        }
        writer.writeEndElement();
    }

    protected void checkBounds(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
    }

    private final class Iter
    implements Iterator<XMLATuple> {
        private int nextIndex = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < AbstractTupleSet.this.size();
        }

        @Override
        public XMLATuple next() {
            if (!this.hasNext()) {
                return null;
            }
            return AbstractTupleSet.this.get(this.nextIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

