/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.AbstractTupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAMember;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import java.util.Collection;

public final class CrossProductTupleSet
extends AbstractTupleSet {
    private static final String NEWLINE = "\n";
    private final ITupleSet[] sets;
    private final int tupleCount;
    private final int tupleCardinality;
    private final int[] divisors;

    public CrossProductTupleSet(ITupleSet[] theSets) {
        this.sets = theSets;
        this.divisors = new int[theSets.length];
        int count = 1;
        int cardinality = 0;
        for (int i = theSets.length - 1; i >= 0; --i) {
            this.divisors[i] = count;
            cardinality += this.sets[i].get(0).size();
            count *= this.sets[i].size();
        }
        this.tupleCount = count;
        this.tupleCardinality = cardinality;
    }

    public CrossProductTupleSet(Collection<? extends ITupleSet> theSets) {
        this(theSets.toArray(new ITupleSet[0]));
    }

    @Override
    public XMLATuple get(int index) throws IndexOutOfBoundsException {
        this.checkBounds(index);
        XMLAMember[] members = new XMLAMember[this.tupleCardinality];
        int offset = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            int coordinate = index / this.divisors[i];
            index -= coordinate * this.divisors[i];
            XMLATuple tuple = this.sets[i].get(coordinate);
            int tupleSize = tuple.size();
            for (int j = 0; j < tupleSize; ++j) {
                members[offset + j] = tuple.getMember(j);
            }
            offset += tupleSize;
        }
        return new XMLATuple(members);
    }

    @Override
    public int size() {
        return this.tupleCount;
    }

    public void release() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i] = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CrossProductTupleSet{");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(NEWLINE).append(this.get(i));
        }
        sb.append(NEWLINE).append('}');
        return sb.toString();
    }
}

