/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XMLACell
implements Comparable<XMLACell> {
    private static final int HASH_BIT_SHIFT = 32;
    private final XMLADataset.CellInfo cellInfo;
    private final int ordinal;
    private final XMLAValue[] properties;

    public XMLACell(XMLADataset.CellInfo theCellInfo, int theOrdinal) {
        this.cellInfo = theCellInfo;
        this.ordinal = theOrdinal;
        this.properties = new XMLAValue[theCellInfo.numProperties()];
    }

    public XMLADataset.CellInfo getCellInfo() {
        return this.cellInfo;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public XMLAPropertyInfo propertyInfo(String name) {
        return this.cellInfo.propertyFromName(name);
    }

    public XMLAValue getProperty(String name) {
        XMLAPropertyInfo propertyInfo = this.cellInfo.propertyFromName(name);
        if (null == propertyInfo) {
            throw new XMLAException(XMLAMessageKeys.XMA_INVALID_CELL_PROPERTY_NAME, name);
        }
        return this.getProperty(propertyInfo);
    }

    public XMLAValue getProperty(XMLAPropertyInfo propertyInfo) {
        XMLAValue result = this.properties[propertyInfo.getIndex()];
        if (null == result) {
            result = propertyInfo.getDefaultValue();
        }
        return result;
    }

    public void setProperty(String name, XMLAValue value) {
        XMLAPropertyInfo propertyInfo = this.cellInfo.propertyFromName(name);
        if (null == propertyInfo) {
            throw new XMLAException(XMLAMessageKeys.XMA_INVALID_CELL_PROPERTY_NAME, name);
        }
        this.setProperty(propertyInfo, value);
    }

    public void setProperty(XMLAPropertyInfo propertyInfo, XMLAValue value) {
        if (null != value) {
            propertyInfo.updateDataType(value.getDataType());
        }
        this.properties[propertyInfo.getIndex()] = value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XMLACell)) {
            return false;
        }
        XMLACell otherCell = (XMLACell)other;
        return this.getOrdinal() == otherCell.getOrdinal();
    }

    @Override
    public int compareTo(XMLACell otherCell) {
        if (this == otherCell) {
            return 0;
        }
        if (this.getOrdinal() < otherCell.getOrdinal()) {
            return -1;
        }
        if (this.getOrdinal() > otherCell.getOrdinal()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.ordinal ^ this.ordinal >>> 32;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        XMLAPropertyInfo[] propInfo = this.cellInfo.getProperties();
        sb.append("XMLACell[");
        if (propInfo.length > 0) {
            XMLAValue val = this.getProperty(propInfo[0]);
            sb.append(propInfo[0].getFullName()).append('=').append(val.toString());
            for (int i = 1; i < propInfo.length; ++i) {
                val = this.getProperty(propInfo[i]);
                sb.append(", ").append(propInfo[i].getFullName()).append('=').append(val.toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLACell");
        writer.writeAttribute("ordinal", Long.toString(this.ordinal));
        for (XMLAPropertyInfo propInfo : this.cellInfo.getProperties()) {
            XMLAValue propValue = this.properties[propInfo.getIndex()];
            if (null == propValue) continue;
            writer.writeStartElement(propInfo.getUnqualifiedName());
            writer.writeAttribute("fullName", propInfo.getFullName());
            propValue.dumpXML(writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

