/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class XMLAMember {
    private final XMLADataset.HierarchyInfo hierarchyInfo;
    private final XMLAValue[] properties;
    private int cachedHashCode = Integer.MIN_VALUE;

    public XMLAMember(XMLADataset.HierarchyInfo theHierarchyInfo) {
        this.hierarchyInfo = theHierarchyInfo;
        this.properties = new XMLAValue[theHierarchyInfo.numProperties()];
    }

    public XMLADataset.HierarchyInfo getHierarchyInfo() {
        return this.hierarchyInfo;
    }

    public XMLAPropertyInfo propertyInfo(String name) {
        return this.hierarchyInfo.propertyFromName(name);
    }

    public XMLAValue getProperty(String name) {
        XMLAPropertyInfo propertyInfo = this.hierarchyInfo.propertyFromName(name);
        if (null == propertyInfo) {
            throw new XMLAException(XMLAMessageKeys.XMA_INVALID_MEMBER_PROPERTY_NAME, name);
        }
        return this.getProperty(propertyInfo);
    }

    public XMLAValue getProperty(XMLAPropertyInfo propertyInfo) {
        XMLAValue result = this.properties[propertyInfo.getIndex()];
        if (null == result) {
            result = propertyInfo.getDefaultValue();
        }
        return result;
    }

    public void setProperty(String name, XMLAValue value) {
        XMLAPropertyInfo propertyInfo = this.hierarchyInfo.propertyFromName(name);
        if (null == propertyInfo) {
            throw new XMLAException(XMLAMessageKeys.XMA_INVALID_MEMBER_PROPERTY_NAME, name);
        }
        this.setProperty(propertyInfo, value);
    }

    public void setProperty(XMLAPropertyInfo propertyInfo, XMLAValue value) {
        if (null != value) {
            propertyInfo.updateDataType(value.getDataType());
        }
        this.properties[propertyInfo.getIndex()] = value;
        this.cachedHashCode = Integer.MIN_VALUE;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XMLAMember)) {
            return false;
        }
        XMLAMember otherMember = (XMLAMember)other;
        if (this.hierarchyInfo != otherMember.hierarchyInfo) {
            return false;
        }
        if (this.properties.length != otherMember.properties.length) {
            return false;
        }
        EqualsBuilder eb = new EqualsBuilder();
        for (int i = 0; i < this.properties.length; ++i) {
            eb.append((Object)this.properties[i], (Object)otherMember.properties[i]);
            if (eb.isEquals()) continue;
            return false;
        }
        return eb.isEquals();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append(this.hierarchyInfo.hashCode());
            for (int i = 0; i < this.properties.length; ++i) {
                hcb.append((Object)this.properties[i]);
            }
            this.cachedHashCode = hcb.toHashCode();
            if (Integer.MIN_VALUE == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        XMLAPropertyInfo[] propInfo = this.hierarchyInfo.getProperties();
        sb.append("XMLAMember[");
        if (propInfo.length > 0) {
            XMLAValue val = this.getProperty(propInfo[0]);
            sb.append(propInfo[0].getFullName()).append('=').append(val.toString());
            for (int i = 1; i < propInfo.length; ++i) {
                val = this.getProperty(propInfo[i]);
                sb.append(", ").append(propInfo[i].getFullName()).append('=').append(val.toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLAMember");
        writer.writeAttribute("hierarchy", this.hierarchyInfo.getName());
        for (XMLAPropertyInfo propInfo : this.hierarchyInfo.getProperties()) {
            XMLAValue propValue = this.properties[propInfo.getIndex()];
            if (null == propValue) continue;
            writer.writeStartElement(propInfo.getUnqualifiedName());
            writer.writeAttribute("fullName", propInfo.getFullName());
            propValue.dumpXML(writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

