/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.StringPool;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLAPropertyInfo {
    private static final String EMPTY_STRING = "";
    private final String fullName;
    private final String qualifier;
    private final String unqualifiedName;
    private ValueTypeEnum dataType = ValueTypeEnum.UNKNOWN;
    private final XMLAValue defaultValue;
    private final int index;
    private final StringPool stringPool = new StringPool();

    public XMLAPropertyInfo(String theFullName, XMLAValue theDefaultValue, int theIndex) {
        this.fullName = theFullName;
        int lastDotOffset = theFullName.lastIndexOf(46);
        if (lastDotOffset < 0) {
            this.qualifier = EMPTY_STRING;
            this.unqualifiedName = theFullName;
        } else {
            this.qualifier = theFullName.substring(0, lastDotOffset);
            int openBracketOffset = theFullName.indexOf(91, lastDotOffset);
            if (openBracketOffset >= 0) {
                if (theFullName.lastIndexOf(93) < openBracketOffset) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unterminated bracket detected.");
                }
                this.unqualifiedName = theFullName.substring(openBracketOffset + 1, theFullName.length() - 1);
            } else {
                if (theFullName.indexOf(93, lastDotOffset) >= 0) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unbalanced brackets detected.");
                }
                this.unqualifiedName = theFullName.substring(lastDotOffset + 1, theFullName.length());
            }
        }
        this.defaultValue = theDefaultValue;
        if (null != theDefaultValue) {
            this.dataType = theDefaultValue.getDataType();
        }
        this.index = theIndex;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getUnqualifiedName() {
        return this.unqualifiedName;
    }

    public ValueTypeEnum getDataType() {
        return this.dataType;
    }

    ValueTypeEnum updateDataType(ValueTypeEnum theDataType) {
        if (ValueTypeEnum.UNKNOWN != theDataType) {
            if (ValueTypeEnum.UNKNOWN == this.dataType) {
                this.dataType = theDataType;
            } else if (theDataType != this.dataType) {
                this.dataType = ValueTypeEnum.VARIANT;
            }
        }
        return this.dataType;
    }

    public XMLAValue getDefaultValue() {
        if (null == this.defaultValue) {
            return XMLAValue.nullOf(this.dataType);
        }
        return this.defaultValue;
    }

    public int getIndex() {
        return this.index;
    }

    public StringPool getStringPool() {
        return this.stringPool;
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLAPropertyInfo");
        writer.writeAttribute("index", Integer.toString(this.getIndex()));
        writer.writeAttribute("fullName", this.getFullName());
        writer.writeAttribute("dataType", this.getDataType().toString());
        writer.writeStartElement("defaultValue");
        this.getDefaultValue().dumpXML(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

