/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.StringPool;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARow;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLARowset
implements Iterable<XMLARow>,
IReleasable {
    private final Map<String, Integer> columnNameToOrdinalMap = new TreeMap<String, Integer>();
    private final List<XMLARow> rowList = new ArrayList<XMLARow>();
    private final List<StringPool> columnStringPools = new ArrayList<StringPool>();

    public int numColumns() {
        return this.columnNameToOrdinalMap.size();
    }

    public int numRows() {
        return this.rowList.size();
    }

    public int addColumn(String columnName) {
        Integer columnOrdinal = this.columnNameToOrdinalMap.get(columnName);
        if (null != columnOrdinal) {
            return columnOrdinal;
        }
        this.columnStringPools.add(new StringPool());
        columnOrdinal = this.numColumns();
        this.columnNameToOrdinalMap.put(columnName, columnOrdinal);
        return columnOrdinal;
    }

    public String getColumnName(int columnOrdinal) {
        if (columnOrdinal < 0 || columnOrdinal >= this.numColumns()) {
            throw new IndexOutOfBoundsException("columnOrdinal");
        }
        String result = null;
        for (Map.Entry<String, Integer> entry : this.columnNameToOrdinalMap.entrySet()) {
            if (entry.getValue() != columnOrdinal) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    public int getColumnOrdinal(String columnName) {
        Integer columnOrdinal = this.columnNameToOrdinalMap.get(columnName);
        if (null != columnOrdinal) {
            return columnOrdinal;
        }
        return -1;
    }

    public StringPool getColumnStringPool(int ordinal) {
        return this.columnStringPools.get(ordinal);
    }

    public XMLARow newRow() {
        XMLARow row = new XMLARow(this);
        this.rowList.add(row);
        return row;
    }

    public XMLARow getRow(int rowOrdinal) throws IndexOutOfBoundsException {
        return this.rowList.get(rowOrdinal);
    }

    @Override
    public Iterator<XMLARow> iterator() {
        return Collections.unmodifiableCollection(this.rowList).iterator();
    }

    public void release() {
        this.columnNameToOrdinalMap.clear();
        this.rowList.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<rowset>\n");
        for (XMLARow row : this.rowList) {
            int numCols = row.numStoredColumns();
            sb.append('\t').append("<row>\n");
            for (int col = 0; col < numCols; ++col) {
                String columnName = this.getColumnName(col);
                XMLAValue columnValue = row.getValue(col);
                sb.append("\t\t<");
                if (columnValue.isNull()) {
                    sb.append(columnName).append(" xsi:nil=\"true\"/>\n");
                    continue;
                }
                sb.append(columnName).append(">");
                sb.append(columnValue.toString());
                sb.append("</").append(columnName).append(">\n");
            }
            sb.append('\t').append("</row>\n");
        }
        sb.append("</rowset>");
        return sb.toString();
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLARowset");
        for (XMLARow row : this) {
            row.dumpXML(writer);
        }
        writer.writeEndElement();
    }
}

