/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import java.util.ArrayList;
import java.util.List;

public class SAPBWGenerateRestriction {
    private String value;
    private MASearchCriteria.SearchCondition condition;
    private List<String> sapRestriction;
    private static final int FIVE = 5;
    private String propertyName = null;

    public SAPBWGenerateRestriction(String theValue, MASearchCriteria.SearchCondition theCondition, String thePropertyName) {
        this.value = theValue;
        this.condition = theCondition;
        this.propertyName = thePropertyName;
        this.sapRestriction = this.createRestrictionForValue();
    }

    private List<String> createRestrictionForValue() {
        ArrayList<String> restriction = new ArrayList<String>(5);
        restriction.add(this.propertyName);
        restriction.add("I");
        if (this.condition == MASearchCriteria.SearchCondition.NOTEQUAL) {
            restriction.add("NP");
        } else {
            restriction.add("CP");
        }
        if (this.condition == MASearchCriteria.SearchCondition.EQUALS || this.condition == MASearchCriteria.SearchCondition.NOTEQUAL) {
            restriction.add(this.value);
        } else if (this.condition == MASearchCriteria.SearchCondition.STARTS_WITH) {
            restriction.add(this.value + "*");
        } else if (this.condition == MASearchCriteria.SearchCondition.ENDS_WITH) {
            restriction.add("*" + this.value);
        } else {
            restriction.add("*" + this.value + "*");
        }
        restriction.add("");
        return restriction;
    }

    public String printRestriction() {
        StringBuilder restriction = new StringBuilder();
        for (String res : this.sapRestriction) {
            restriction.append(res);
            restriction.append(";");
        }
        restriction.append(";");
        return restriction.toString();
    }

    public List<String> getSapRestriction() {
        return this.sapRestriction;
    }
}

