/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPResultSet;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSAPData;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public final class SBWODPAxisInfo {
    private static final String STR_OF = " of ";
    private static final int INT_SLICER_AXIS_NO = 255;
    private int mTotalAxes;
    private int mAxisNum;
    private int mAxisCoord;
    private int mDimensionNums;
    private IDimension[] mDimensions;

    public SBWODPAxisInfo(int axisNum, int totalAxes, int axisCoord, int dimensionNums, IDimension[] dimensions) {
        this.mAxisNum = axisNum;
        this.mTotalAxes = totalAxes;
        this.mAxisCoord = axisCoord;
        this.mDimensionNums = dimensionNums;
        this.mDimensions = dimensions;
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing AxisInfo for axis " + this.mAxisNum + STR_OF + this.mTotalAxes);
        }
    }

    public static SBWODPAxisInfo[] getAllAxes(SBWODPSAPData sapData, SBWODPResultSet resultSet) {
        ArrayList<SBWODPAxisInfo> axes;
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getAllAxes called");
        }
        JBapiTable axisTable = sapData.getData(0);
        try {
            if (SBWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.INFO, axisTable.traceToString(SBWODPConfig.instance().getMaxTableDumpRows()));
                SBWODPLog.getLogger("DataQuery").log(LogLevel.INFO, sapData.getData(1).traceToString(SBWODPConfig.instance().getMaxTableDumpRows()));
            }
            int rowCount = axisTable.getNumRows();
            axes = new ArrayList<SBWODPAxisInfo>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                axisTable.setRow(i);
                int axisNum = axisTable.getAsInt(0);
                int axisCoord = axisTable.getAsInt(2);
                int dimensionNums = axisTable.getAsInt(1);
                IDimension[] dimensions = SBWODPAxisInfo.getDimensions(sapData, axisNum, dimensionNums);
                SBWODPAxisInfo axis = new SBWODPAxisInfo(axisNum, rowCount, axisCoord, dimensionNums, dimensions);
                axes.add(axis);
                if (!axis.isSlicer()) continue;
                resultSet.setHasSlicer();
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_ALL_AXES, e);
        }
        return axes.toArray(new SBWODPAxisInfo[0]);
    }

    public static IDimension[] getDimensions(SBWODPSAPData sapData, int axisNumber, int numDims) {
        ArrayList<Dimension> dims;
        JBapiTable dimTable = sapData.getData(1);
        try {
            int rowCount = dimTable.getNumRows();
            dims = new ArrayList<Dimension>(numDims);
            for (int i = 0; i < rowCount; ++i) {
                dimTable.setRow(i);
                int axisNum = dimTable.getAsInt(0);
                if (axisNumber != axisNum) continue;
                String dimensionName = dimTable.getString(1, false);
                Dimension dim = new Dimension(dimensionName);
                dim.setUniqueName(dimensionName);
                dim.setProperty("DIM_KEY", (Object)XQEIntegerPool.getInteger((int)dimTable.getAsInt(2)));
                dims.add(dim);
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_DIMS, e);
        }
        return dims.toArray(new IDimension[0]);
    }

    public IDimension getDimension(int dimKey) {
        for (int i = 0; i < this.mDimensions.length; ++i) {
            IDimension dim = this.mDimensions[i];
            Integer dimensionKey = (Integer)dim.getProperty("DIM_KEY");
            if (dimensionKey != dimKey) continue;
            if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getDimension: Dimension found for key: " + dimKey);
            }
            return dim;
        }
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getDimension: Dimension not found for key: " + dimKey);
        }
        return null;
    }

    public IDimension[] getDimensions() {
        return this.mDimensions;
    }

    public int getDimensionNum() {
        return this.mDimensionNums;
    }

    public boolean isSlicer() {
        return this.mAxisNum == 255;
    }

    public int getAxisCoord() {
        return this.mAxisCoord;
    }

    public int getAxisKey() {
        return this.mAxisNum;
    }

    public int getNumAxes() {
        return this.mTotalAxes;
    }

    public void release() {
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing AxisInfo for axis " + this.mAxisNum + STR_OF + this.mTotalAxes);
        }
    }
}

