/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPFormatInfo;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.TextFormatPropertyValue;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.FormatStringException;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.Locale;

public class SBWODPCellFormatParser
implements IFormatParser {
    private static final String SCALE_STR = "scale";
    private final FormatService mService;

    public SBWODPCellFormatParser(FormatService service) {
        this.mService = service;
    }

    public Object getFormatCacheKey(IFormatInfo info, Locale locale) {
        return FormatServiceUtils.generateFormatCacheKey((FormatParserType)FormatParserType.SBWODP, (boolean)this.isFormatInfoValid(info), (IFormatInfo)info, (Locale)locale);
    }

    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        if (!this.isFormatInfoValid(info)) {
            return null;
        }
        SBWODPFormatInfo formatInfo = (SBWODPFormatInfo)info;
        String currencyCode = formatInfo.getCurrencyCode();
        String unitOfMeasure = formatInfo.getUnitOfMeasure();
        int scale = formatInfo.getScale();
        int sapFormatType = formatInfo.getFormatType();
        String sapFormatString = formatInfo.getSAPFormatString();
        XQELogger spLogger = XQEFormatService.FSLOGGER_STRING_PARSING;
        if (spLogger.isOn(LogLevel.TRACE)) {
            spLogger.log(LogLevel.TRACE, " sapFormatString " + sapFormatString);
        }
        FormatPropertySet set = new FormatPropertySet(this.mService);
        if (sapFormatString != null) {
            switch (sapFormatType) {
                case 3: {
                    this.sbwodpValueFormatCurrency(currencyCode, sapFormatString, locale, set);
                    if (!spLogger.isOn(LogLevel.TRACE)) break;
                    spLogger.log(LogLevel.TRACE, "Currency Format is parsed.");
                    break;
                }
                case 0: {
                    this.sbwodpValueFormatNumeric(unitOfMeasure, sapFormatString, locale, set);
                    if (!spLogger.isOn(LogLevel.TRACE)) break;
                    spLogger.log(LogLevel.TRACE, "Numeric Format is paresed.");
                    break;
                }
                case 2: {
                    if (!spLogger.isOn(LogLevel.TRACE)) break;
                    spLogger.log(LogLevel.TRACE, "Date Format is not supported.");
                    break;
                }
                case 1: {
                    if (!spLogger.isOn(LogLevel.TRACE)) break;
                    spLogger.log(LogLevel.TRACE, "String Format is not supported.");
                    break;
                }
            }
        }
        if (scale != 0) {
            set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue(SCALE_STR, (double)scale));
        }
        return set;
    }

    private boolean isFormatInfoValid(IFormatInfo info) {
        SBWODPFormatInfo sapInfo = (SBWODPFormatInfo)info;
        if (XQEFormatService.FSLOGGER_STRING_PARSING.isOn(LogLevel.TRACE)) {
            XQEFormatService.FSLOGGER_STRING_PARSING.log(LogLevel.TRACE, "sapFormatString:" + sapInfo.getSAPFormatString());
        }
        return true;
    }

    private void sbwodpValueFormatNumeric(String unitOfMeasure, String sapFormatString, Locale locale, FormatPropertySet set) throws FormatStringException {
        char temp;
        NumericFormat number = new NumericFormat(locale);
        try {
            number.setPattern(sapFormatString);
        }
        catch (IllegalArgumentException e) {
            throw new FormatStringException(SBWODPMessageKeys.ERR_INVALID_FORMAT_STRING, sapFormatString);
        }
        if (null != unitOfMeasure && unitOfMeasure.length() > 0) {
            if (unitOfMeasure.equals("%")) {
                set.setFormatType("percentFormat");
            } else {
                set.setFormatType("numberFormat");
                set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("unitOfMeasure", unitOfMeasure));
            }
        } else {
            set.setFormatType("numberFormat");
        }
        int decimalSize = number.getMaximumFractionDigits();
        set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("decimalSize", (double)decimalSize));
        if (decimalSize > 0) {
            temp = number.getDecimalSeparator();
            set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("decimalDelimiter", String.valueOf(temp)));
        }
        if (sapFormatString.indexOf(44) >= 0) {
            set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useGrouping", true));
            temp = number.getGroupingSeparator();
            set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("groupDelimiter", String.valueOf(temp)));
        }
    }

    private void sbwodpValueFormatCurrency(String currencyCode, String sapFormatString, Locale locale, FormatPropertySet set) throws FormatStringException {
        if (currencyCode != null) {
            NumericFormat currency = new NumericFormat(11, locale);
            set.setFormatType("currencyFormat");
            if (null != currencyCode && currencyCode.length() > 0) {
                set.setCurrencyCode(currencyCode);
            }
            if (!sapFormatString.equals("\"*\"")) {
                try {
                    currency.setPattern(sapFormatString);
                }
                catch (IllegalArgumentException e) {
                    throw new FormatStringException(SBWODPMessageKeys.ERR_INVALID_FORMAT_STRING, sapFormatString);
                }
            }
            currency.setCurrency(currencyCode);
            int decimalSize = currency.getMaximumFractionDigits();
            set.addPropertyValue((FormatPropertyValue)new NumberFormatPropertyValue("decimalSize", (double)decimalSize));
            if (decimalSize > 0) {
                char temp = currency.getDecimalSeparator();
                set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("decimalDelimiter", String.valueOf(temp)));
            }
            String tempS = currency.getCurrencySymbol();
            set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("currencySymbol", tempS));
            if (sapFormatString.indexOf(44) >= 0) {
                set.addPropertyValue((FormatPropertyValue)new BooleanFormatPropertyValue("useGrouping", true));
                char temp = currency.getGroupingSeparator();
                set.addPropertyValue((FormatPropertyValue)new TextFormatPropertyValue("groupDelimiter", String.valueOf(temp)));
            }
        }
    }
}

