/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.ProviderCellIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPCell;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPFormatInfo;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPResultSet;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSAPData;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.commons.collections.map.LRUMap;

public class SBWODPCellIterator
extends ProviderCellIteratorBase {
    private volatile boolean isReleased = false;
    private SBWODPSAPData cellData;
    private boolean hasNext = false;
    private int axisSize = 0;
    private HashMap<Integer, Map<String, Object>> properties = null;
    private SBWODPResultSet sapResultSet;
    private final int id;
    private static final int STRING_POOL_SIZE = 100;
    private LRUMap stringPool = new LRUMap(100);
    private int sapFormatType = 5;

    private String poolString(String string) {
        String pooledString = (String)this.stringPool.get((Object)string);
        if (pooledString != null) {
            return pooledString;
        }
        this.stringPool.put((Object)string, (Object)string);
        return string;
    }

    SBWODPCellIterator(SBWODPResultSet resultSet, XDataContext xDataContext, SBWODPSAPData data, Integer theNodeId, int iterID) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        this.id = iterID;
        this.sapResultSet = resultSet;
        this.cellData = data;
        this.axisSize = this.getAxisSize();
        if (SBWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.INFO, this.getCellDataTable().traceToString(SBWODPConfig.instance().getMaxTableDumpRows()));
        }
        if (this.axisSize > 0) {
            this.hasNext = true;
        }
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing CellIterator.");
        }
    }

    private void checkForCancel() throws OperationCanceledException {
        this.sapResultSet.checkForCancel();
    }

    private HashMap<Integer, Map<String, Object>> getProperties() {
        HashMap<Integer, Flat3Map> cellProperties = null;
        JBapiTable propTable = this.getPropertyTable();
        try {
            int rowCount;
            if (SBWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.INFO, propTable.traceToString(SBWODPConfig.instance().getMaxTableDumpRows()));
            }
            if ((rowCount = propTable.getNumRows()) > 0) {
                cellProperties = new HashMap<Integer, Flat3Map>(rowCount);
                int i = 0;
                propTable.setRow(i);
                while (i < rowCount) {
                    int cellOrdinal;
                    int curOrdinal = cellOrdinal = propTable.getAsInt(1);
                    Flat3Map propMap = new Flat3Map();
                    while (curOrdinal == cellOrdinal) {
                        this.checkForCancel();
                        propMap.put(this.poolString(propTable.getString(0, false)), this.poolString(propTable.getString(2, true)));
                        if (++i >= rowCount) break;
                        propTable.setRow(i);
                        curOrdinal = propTable.getAsInt(1);
                    }
                    cellProperties.put(XQEIntegerPool.getInteger((int)cellOrdinal), propMap);
                }
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_CELL_PROPS, e);
        }
        return cellProperties;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public ICell nextImpl() throws SBWODPException {
        SBWODPCell c = null;
        try {
            if (this.hasNext) {
                if (this.properties == null) {
                    this.properties = this.getProperties();
                }
                IValue value = null;
                JBapiTable table = this.getCellDataTable();
                int nextOrdinal = (int)(this.currentOrdinal + 1L);
                table.setRow(nextOrdinal);
                String valueStatus = table.getString(9, false);
                if (!valueStatus.equals("E") && !valueStatus.equals("N")) {
                    c = new SBWODPCell();
                    c.setCellProperty("CELL_STATUS", valueStatus);
                    c.setOrdinal(nextOrdinal);
                    String type = table.getString(3, false);
                    String currency = table.getString(4, false);
                    String cellUnit = table.getString(5, false);
                    String tempScale = table.getString(7, false);
                    int scale = 0;
                    if (null != tempScale && !tempScale.equals("")) {
                        scale = Integer.parseInt(tempScale);
                    }
                    this.setProperties(c);
                    value = this.convertValue(c, table, type, currency, cellUnit, scale);
                    c.setCellProperty("UNIT", cellUnit);
                    c.setCellProperty("NUM_SCALE", XQEIntegerPool.getInteger((int)scale));
                    c.setCellProperty("NUM_PREC", table.getString(8, false));
                    c.setCellProperty("CURRENCY", currency);
                    if (!value.isNull()) {
                        c.setValue(value);
                        String formattedValue = table.getString(2);
                        c.setFormattedValue(formattedValue);
                        c.setCellProperty("NUM_SCALE", tempScale);
                    }
                }
                this.currentOrdinal = nextOrdinal;
                this.hasNext = nextOrdinal + 1 < this.axisSize;
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_NEXT_CELL_ERROR, e);
        }
        return c;
    }

    private void setProperties(SBWODPCell cell) {
        if (this.properties != null) {
            cell.setProperties(this.properties.get(XQEIntegerPool.getInteger((int)((int)cell.getOrdinal()))));
        }
    }

    private IValue convertValue(SBWODPCell cell, JBapiTable table, String type, String currency, String cellUnit, int scale) {
        FormatService service;
        String sapFormatString;
        DoubleValue value;
        String currencyCode = null;
        String unitOfMeasure = null;
        try {
            if (type.equals("F")) {
                this.sapFormatType = 0;
                value = DataValueFactory.createDoubleValue();
                value.set(table.getAsDouble(1));
                scale *= -1;
                if (cellUnit.equals("%")) {
                    scale -= 2;
                }
                currencyCode = currency;
                unitOfMeasure = cellUnit;
            } else if (type.equals("I") || type.equals("b") || type.equals("s")) {
                this.sapFormatType = 0;
                value = DataValueFactory.createIntegerValue();
                ((IntegerValue)value).set(table.getAsInt(1));
                scale *= -1;
                if (cellUnit.equals("%")) {
                    scale -= 2;
                }
                currencyCode = currency;
                unitOfMeasure = cellUnit;
            } else if (type.equals("T")) {
                this.sapFormatType = 2;
                value = DataValueFactory.createTimeValue();
                ((TimeValue)value).set((IValue)SBWODPUtility.DateUtils.convertSAPTSToTimestampValue(table.getString(1, false)));
            } else if (type.equals("D")) {
                try {
                    this.sapFormatType = 2;
                    value = DataValueFactory.createDateValue();
                    ((DateValue)value).set((IValue)SBWODPUtility.DateUtils.convertSAPDateToDateValue(table.getString(1, false)));
                }
                catch (IllegalArgumentException arg) {
                    this.sapFormatType = 0;
                    value = DataValueFactory.createDoubleValue();
                    value.setState(ValueState.ERROR);
                    SBWODPLog.getLogger("Exception").log(LogLevel.WARN, "Invalid date encountered returning error cell instead " + table.getString(1, false) + " Exception: " + arg);
                }
            } else if (type.equals("g") || type.equals("C") || type.equals("N")) {
                this.sapFormatType = 1;
                value = DataValueFactory.createStringValue();
                ((StringValue)value).set(table.getString(1));
            } else {
                if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "CellIterator.convertValue - default (Double) type.");
                }
                this.sapFormatType = 0;
                value = DataValueFactory.createDoubleValue();
                value.setNull();
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_CONVERT_CELL_VAL, e);
        }
        if (currency != null && !currency.equals("")) {
            this.sapFormatType = 3;
        }
        if ((sapFormatString = cell.getFormatString()) != null && !sapFormatString.isEmpty() && !sapFormatString.equals("\"*\"")) {
            sapFormatString = sapFormatString.replace("\"", "'");
        }
        if (null != (service = FormatService.getInstance())) {
            SBWODPFormatInfo info = new SBWODPFormatInfo(currencyCode, unitOfMeasure, scale, this.sapFormatType, sapFormatString);
            ((Value)value).setFormatId(service.registerSBWODPCellFormat((IFormatInfo)info, this.getFormatLocale()));
        }
        return value;
    }

    private int getAxisSize() {
        JBapiTable table = this.getCellDataTable();
        try {
            return table.getNumRows();
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_SIZE, e);
        }
    }

    public int getID() {
        return this.id;
    }

    private JBapiTable getPropertyTable() {
        return this.cellData.getData(1);
    }

    private JBapiTable getCellDataTable() {
        return this.cellData.getData(0);
    }

    public synchronized void releaseImpl() {
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing SBWODPCellIterator with ID: " + this.id);
        }
        if (this.isReleased) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.ERROR, "Attempt to Release previously released SBWODPCellIterator with ID: " + this.id);
            return;
        }
        this.isReleased = true;
        this.cellData.release();
        this.cellData = null;
        this.sapResultSet = null;
    }
}

