/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.data.providers.olap.DefaultConnectionSelector;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;

class SBWODPConnectionSelector
extends DefaultConnectionSelector {
    SBWODPConnectionSelector() {
    }

    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        SBWODPConnection connection = (SBWODPConnection)((Object)pooledConnection.getConnection());
        if (connection.getActiveDataQuery()) {
            if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPConnectionSelector skipping connection already in use for data query");
            }
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        if (connection.getClient().isValid()) {
            return super.selectConnection(connectionParameters, context, pooledConnection);
        }
        if (SBWODPLog.isOn("Connection", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Connection").log(LogLevel.WARN, "SBWODPConnectionSelector removing connection that SAP BW says is invalid");
        }
        pooledConnection.setNotReusable();
        connection.disconnect();
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

