/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IDelegatedCredentialSignon;
import com.cognos.xqe.data.model.ITicketSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.JAASSubjectParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.ClientParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.CodePageParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.LogonGroupParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.RouteParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SAPServerParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnectionSelector;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMDXHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMetadataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPResultSet;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSSOCache;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.data.providers.olap.sbwodp.SSOTicketParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.ServerTypeParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SystemIDParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SystemNumberParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiSAPException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.sapbw.LOLAPSAPCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class SBWODPDataProvider
extends OLAPDataProviderBase {
    final SBWODPConnectionFactory mSBWODPConnectionFactory = new SBWODPConnectionFactory();
    final IConnectionFactory mConnectionFactory;

    public SBWODPDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties, (IConnectionSelector)new SBWODPConnectionSelector());
        this.mConnectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary((IConnectionFactory)new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mSBWODPConnectionFactory, instanceName), (Properties)this.getProperties());
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing SBWODPDataProvider");
        }
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        return executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.selector, this.mConnectionFactory);
    }

    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArgument) throws SBWODPException, LogonFailureException {
        SBWODPMDXHandler mdxHandler = null;
        try {
            if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "SBWODPDataProvider.query called");
            }
            SBWODPResultSet ret = null;
            ExecutionEnvironment environment = (ExecutionEnvironment)xDataContext.getEnvironment();
            Integer nodeId = xDataContext.getNodeId();
            MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            MDXQuery mdxQuery = theQueryArgument.getMDXQuery();
            String mdxString = mdxQuery.getMDX();
            ICube cube = mdxQuery.getReferencedCube();
            String effectiveDate = null;
            effectiveDate = cube instanceof LOLAPSAPCube ? ((LOLAPSAPCube)cube).getKeyDate() : theQueryArgument.getKeyDate();
            effectiveDate = effectiveDate != null ? SBWODPUtility.DateUtils.convertDateToSAPDateFormat(effectiveDate) : SBWODPUtility.DateUtils.getLocalDateInSAPFormat();
            ConnectionParameters parameters = this.createConnectionParameters((IExecutionEnvironment)environment, theQueryArgument);
            IPooledConnection pooledConnection = this.borrowConnection(parameters, (IExecutionEnvironment)environment);
            ((SBWODPConnection)((Object)pooledConnection.getConnection())).setActiveDataQuery(true);
            mdxHandler = new SBWODPMDXHandler(pooledConnection, theQueryArgument, mdxString, nodeId, environment.getCancelManager());
            ret = mdxHandler.executeMDX(this, xDataContext, effectiveDate);
            MetricsService.endCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            return ret;
        }
        catch (JBapiSAPException se) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw se;
        }
        catch (SBWODPException se) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw se;
        }
        catch (LogonFailureException e) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw e;
        }
        catch (RuntimeException rte) {
            if (mdxHandler != null) {
                mdxHandler.release();
            }
            throw rte;
        }
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return this.createConnectionParams(env, (QueryArguments)queryArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        SBWODPConnection connection = null;
        try {
            connection = (SBWODPConnection)((Object)this.mSBWODPConnectionFactory.createConnection(this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments)));
            connectionDetails = connection.getConnectionDetails();
        }
        catch (Throwable throwable) {
            this.mSBWODPConnectionFactory.destroyConnection(connection);
            throw throwable;
        }
        this.mSBWODPConnectionFactory.destroyConnection(connection);
        return connectionDetails;
    }

    protected ConnectionParameters createConnectionParams(IExecutionEnvironment executionEnvironment, QueryArguments theQueryArguments) {
        if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "SBWODPDataProvider.createConnectionParams called");
        }
        IDataSource dataSource = theQueryArguments.getDataSource();
        IDataSourceConnection connection = dataSource.getDataSourceConnection();
        String connectionString = connection.getConnectionString(null);
        final ConnectionParameters parameters = new ConnectionParameters();
        ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){

            public void onKeyValueToken(String key, String value) {
                if (key.equalsIgnoreCase("serverType")) {
                    parameters.put((IConnectionParameter)new ServerTypeParameter(value));
                } else if (key.equalsIgnoreCase("server") || key.equalsIgnoreCase("Data Source")) {
                    parameters.put((IConnectionParameter)new SAPServerParameter(value));
                } else if (key.equalsIgnoreCase("sysid")) {
                    parameters.put((IConnectionParameter)new SystemIDParameter(value));
                } else if (key.equalsIgnoreCase("sysnr")) {
                    parameters.put((IConnectionParameter)new SystemNumberParameter(value));
                } else if (key.equalsIgnoreCase("logonGroup")) {
                    parameters.put((IConnectionParameter)new LogonGroupParameter(value));
                } else if (key.equalsIgnoreCase("client")) {
                    parameters.put((IConnectionParameter)new ClientParameter(value));
                } else if (key.equalsIgnoreCase("codePage")) {
                    parameters.put((IConnectionParameter)new CodePageParameter(value));
                } else if (key.equalsIgnoreCase("routerString")) {
                    parameters.put((IConnectionParameter)new RouteParameter(value));
                }
            }

            public void onSimpleToken(String value) {
            }
        });
        parameters.put((IConnectionParameter)new DataSourceParameter(dataSource));
        parameters.put((IConnectionParameter)new ProviderTypeParameter(dataSource.getType()));
        if (theQueryArguments instanceof MetadataQueryArguments) {
            parameters.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.toString((Locale)theQueryArguments.getDesignLocale())));
        } else {
            parameters.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.toString((Locale)theQueryArguments.getRunLocale())));
        }
        IDataSourceConnectionSignon signon = connection.getSignon();
        RequestEnvironment reqEnv = (RequestEnvironment)executionEnvironment.getRequestEnvironment();
        String ticket = null;
        if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
            parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
            parameters.put((IConnectionParameter)new PasswordParameter(userPwdSignon.getPassword()));
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.COMBINED) {
            IDataSourceConnectionSignon[] signons;
            parameters.put((IConnectionParameter)new UserIDParameter(((ICombinedSignon)signon).getUserID()));
            for (IDataSourceConnectionSignon currentSignon : signons = ((ICombinedSignon)signon).getSignons()) {
                if (null == currentSignon || currentSignon.getType() != IDataSourceConnectionSignon.SignonType.TICKET || null == (ticket = ((ITicketSignon)currentSignon).getTicket()) || ticket.length() <= 0) continue;
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
            }
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.TICKET) {
            ticket = ((ITicketSignon)signon).getTicket();
            if (null != ticket && ticket.length() > 0) {
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
            }
        } else if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.JAASSUBJECT) {
            IDelegatedCredentialSignon jaasSignon = (IDelegatedCredentialSignon)signon;
            parameters.put((IConnectionParameter)new JAASSubjectParameter(jaasSignon.getDelegatedCredential().getSubject()));
        } else {
            ticket = reqEnv.getSAPLogonTicket();
            if (ticket != null && ticket.length() > 0) {
                parameters.put((IConnectionParameter)new SSOTicketParameter(ticket));
                if (null != signon && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                    IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
                    parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
                }
            }
        }
        return parameters;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) throws LogonFailureException, SBWODPException {
        if (SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "SBWODPDataProvider.getMetadataProvider called");
        }
        ConnectionParameters parameters = this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments);
        IExecutionEnvironment executionEnvironment = theQueryArguments.getExecutionEnvironment();
        Locale locale = executionEnvironment.getRequestEnvironment().getRunLocale();
        SBWODPMetadataProvider provider = new SBWODPMetadataProvider(this, parameters, locale);
        provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "SBWODP");
        return provider;
    }

    public void releaseImpl() {
        SBWODPSSOCache.releaseInstance();
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "releasing SBWODPDataProvider");
        }
    }

    private class SBWODPConnectionFactory
    implements IConnectionFactory {
        private SBWODPConnectionFactory() {
        }

        public Object createConnection(ConnectionParameters connectionParameters) {
            SBWODPConnection connection = null;
            try {
                if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPDataProvider.createConnection: attempting to create a connection.");
                }
                connection = new SBWODPConnection((IOLAPDataProvider)SBWODPDataProvider.this, connectionParameters);
            }
            catch (LogonFailureException e) {
                DataSourceParameter param = (DataSourceParameter)connectionParameters.get(DataSourceParameter.class);
                if (param != null) {
                    IDataSource ds = param.getDataSource();
                    IDataSourceConnection dsConnection = ds.getDataSourceConnection();
                    dsConnection.invalidateResolvedSignon();
                    if (e.getDataSource() == null) {
                        e.setDataSource(ds);
                    }
                }
                throw e;
            }
            finally {
                if (null == connection) {
                    if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPDataProvider.createConnection: FAILED");
                    }
                } else {
                    List<XQEMessage> blackList;
                    if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPDataProvider.createConnection: OK SAPKernelVersion: " + connection.getSAPKernelVersion() + " SAPSystemVersion: " + connection.getSAPSystemVersion());
                    }
                    if (!(blackList = connection.getConnectionBlackListDetails()).isEmpty()) {
                        this.destroyConnection(connection);
                        connection = null;
                        XQEMessage message = blackList.get(0);
                        if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                            if (SBWODPLog.isOn("Connection", LogLevel.ERROR).booleanValue()) {
                                SBWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SBWODPDataProvider.createConnection: The driver version " + message.getParams()[0] + " is black listed.");
                            }
                            throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                        }
                        if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                            if (SBWODPLog.isOn("Connection", LogLevel.ERROR).booleanValue()) {
                                SBWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SBWODPDataProvider.createConnection: The server version " + message.getParams()[1] + "  is black listed.");
                            }
                            throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                        }
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                    }
                }
            }
            return connection;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            this.destroyConnection((SBWODPConnection)((Object)pooledConnection.getConnection()));
        }

        private void destroyConnection(SBWODPConnection connection) {
            if (null == connection) {
                if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPDataProvider.destroyConnection: There is no connection to destroy.");
                }
            } else {
                try {
                    if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SBWODPDataProvider.destroyConnection: OK");
                    }
                    connection.disconnect();
                }
                catch (SBWODPException e) {
                    SBWODPLog.getLogger("Exception").log(LogLevel.ERROR, "Error Destroying Connection: ", (Throwable)((Object)e));
                }
            }
        }
    }
}

