/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiCancelException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiClient;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiFunction;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiSAPException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiStructure;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public abstract class SBWODPFunctionHandler
implements ICancelable,
IReleasable {
    private static final String STR_TIMING_START_MSG = "Start Execution of ";
    private static final String STR_TIMING_END_MSG = "End Execution of ";
    private static final String STR_EXECUTE_MSG = "Executing: ";
    private static final String STR_SET_KEYDATE_MSG = ": setting Keydate: ";
    private static final String STR_SET_PARAM_MSG = ": setting Input Parameter \"";
    private static final String STR_ENDQUOTE = "\"";
    private static final String STR_CORRUPTED_SID_TAG = "CL_RSDM_READ_MASTER_DATA";
    protected SBWODPConnection connection;
    protected JBapiFunction function = null;
    protected JBapiClient client;
    protected boolean cancelReceived = false;

    protected SBWODPFunctionHandler(SBWODPConnection sbwodpConnection, String functionName) throws LogonFailureException, SBWODPException {
        this.connection = sbwodpConnection;
        try {
            this.client = this.connection.getClient();
            this.function = this.client.getFunction(functionName);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_FNC_HANDLE_ERROR, e, functionName);
        }
        if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Initializing SBWODPFunctionHandler for: " + functionName);
        }
    }

    protected SBWODPFunctionHandler(SBWODPConnection sbwodpConnection, JBapiClient clnt, String functionName) throws SBWODPException {
        this.connection = sbwodpConnection;
        this.client = clnt;
        try {
            this.function = this.client.getFunction(functionName);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_FNC_HANDLE_ERROR, e, functionName);
        }
        if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Initializing SBWODPFunctionHandler on existing connection for: " + functionName);
        }
    }

    public void cancel() throws CancelUnsuccessfulException {
        if (!this.cancelReceived) {
            try {
                this.cancelReceived = true;
                if (this.function != null) {
                    if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                        SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Cancelling: " + this.function.getFunctionName());
                    }
                    this.function.cancelSoft();
                }
            }
            catch (JBapiException e) {
                throw new CancelUnsuccessfulException();
            }
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    protected void checkForCancel() throws OperationCanceledException {
        if (this.cancelReceived) {
            throw new OperationCanceledException();
        }
    }

    private void execute(boolean retry, boolean checkRtn) throws SBWODPException, OperationCanceledException {
        block21: {
            XQELogger logger = null;
            try {
                if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("Function").log(LogLevel.TRACE, STR_EXECUTE_MSG + this.function.getFunctionName());
                }
                if (SBWODPLog.isOn("Timing", LogLevel.INFO).booleanValue()) {
                    logger = SBWODPLog.getLogger("Timing");
                    logger.log(LogLevel.INFO, OperationEnum.START, STR_TIMING_START_MSG + this.function.getFunctionName());
                }
                if (SBWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.INFO, "Executing BAPI: " + this.function.getFunctionName() + " on connection: " + this.client.getConnectionHandle());
                }
                this.client.execute(this.function, checkRtn);
            }
            catch (JBapiCancelException ce) {
                throw new OperationCanceledException();
            }
            catch (JBapiSAPException se) {
                if (se.getErrorKey().equals("012")) {
                    throw se;
                }
                if (se.getErrorKey().equals("887")) {
                    throw se;
                }
                if (se.getErrorKey().equals("201")) {
                    throw se;
                }
                if (se.getErrorKey().equals("520")) {
                    throw se;
                }
                if (se.getErrorKey().equals("037")) {
                    throw se;
                }
                if (se.getErrorKey().equals("RFC_ERROR_SYSTEM_FAILURE")) {
                    SBWODPLog.getLogger("Exception").log(LogLevel.ERROR, this.function.getFunctionName() + " failed with error " + "RFC_ERROR_SYSTEM_FAILURE");
                    throw se;
                }
                if (se.getErrorKey().equals("299")) {
                    if (se.getRFCMessage().contains(STR_CORRUPTED_SID_TAG)) {
                        if (retry) {
                            this.clearSAPMetadataCache();
                            this.clearSAPUserCache();
                            SBWODPLog.getLogger("Connection").log(LogLevel.WARN, "Flushing SAP server caches and re-trying BAPI in response to SIDS Table corruption");
                            this.execute(false, checkRtn);
                            break block21;
                        }
                        this.client.invalidateConnection();
                        SBWODPLog.getLogger("Connection").log(LogLevel.WARN, "Invalidating connection in response to SIDS Table corruption");
                        throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.function.getFunctionName());
                    }
                    this.client.invalidateConnection();
                    SBWODPLog.getLogger("Connection").log(LogLevel.WARN, "Invalidating connection in response to ABAP error on server");
                    throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.function.getFunctionName());
                }
                this.client.invalidateConnection();
                throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, se, this.function.getFunctionName());
            }
            catch (JBapiException e) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, e, this.function.getFunctionName());
            }
            finally {
                if (logger != null) {
                    logger.log(LogLevel.INFO, OperationEnum.END, STR_TIMING_END_MSG + this.function.getFunctionName());
                }
            }
        }
    }

    protected void executeFunction() throws SBWODPException, OperationCanceledException {
        this.execute(true, SBWODPConfig.instance().getCheckReturnCode());
    }

    protected void executeFunctionNoCheck() throws SBWODPException, OperationCanceledException {
        this.execute(true, false);
    }

    protected void clearSAPMetadataCache() {
        JBapiFunction clearCache = this.client.getFunction("BAPI_MDPROVIDER_REFRESH");
        try {
            if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing SAP Metadata Cache");
            }
            this.client.execute(clearCache, false);
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, e, clearCache.getFunctionName());
        }
        finally {
            clearCache.release();
        }
    }

    protected void clearSAPUserCache() {
        JBapiFunction clearCache = this.client.getFunction("RSCR_API_USER_CACHE_CLEAR");
        try {
            if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing SAP User Cache");
            }
            this.client.execute(clearCache, false);
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, e, clearCache.getFunctionName());
        }
        finally {
            clearCache.release();
        }
    }

    protected JBapiFunction installAndRunABAP(String mode, String progName, String code) throws SBWODPException {
        if (!this.function.getFunctionName().equals("RFC_ABAP_INSTALL_AND_RUN")) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_WRONG_FUNCTION, "RFC_ABAP_INSTALL_AND_RUN", this.function.getFunctionName());
        }
        try {
            if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Install and Run ABAP");
            }
            if (SBWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.INFO, "Dynamic ABAP Trace: " + code);
            }
            if (mode != null && mode.length() > 0) {
                this.setImportParameter("MODE", mode);
            }
            if (progName != null && progName.length() > 0) {
                this.setImportParameter("PROGRAMNAME", progName);
            }
            JBapiTable program = this.getTable("PROGRAM");
            program.clear();
            int lineSz = program.getRowLength();
            int start = 0;
            int count = 0;
            int progSize = code.length();
            String progPart = null;
            while (start < progSize) {
                this.checkForCancel();
                if (count >= start + lineSz || count >= progSize || code.charAt(count) == '\n' || code.charAt(count) == '\r') {
                    if (count > start) {
                        program.appendRow();
                        progPart = code.substring(start, count);
                        if (progPart.length() > 0) {
                            program.setValue(0, progPart);
                        }
                    } else if (count == start) {
                        // empty if block
                    }
                    start = ++count;
                    continue;
                }
                ++count;
            }
            JBapiTable writes = this.getTable("WRITES");
            writes.clear();
            writes.release();
            program.release();
            this.executeFunctionNoCheck();
        }
        catch (JBapiCancelException ce) {
            throw new OperationCanceledException();
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_ERROR, e, this.function.getFunctionName());
        }
        return this.function;
    }

    protected JBapiTable getTable(String tableName) throws SBWODPException {
        try {
            return this.function.getTableParameter(tableName);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_TABLE_FAILED, e, tableName);
        }
    }

    protected Object getExportParameter(String name) throws SBWODPException {
        try {
            return this.function.getExportParameterValue(name);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_EXPORT_PARAM_FAILED, e, name);
        }
    }

    protected JBapiStructure getExportStructure(String name) throws SBWODPException {
        try {
            return this.function.getExportStructure(name);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_EXPORT_STRUCT_FAILED, e, name);
        }
    }

    protected void setKeyDateParam(String keyDate) throws SBWODPException {
        if (keyDate != null) {
            if (SBWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.INFO, this.function.getFunctionName() + STR_SET_KEYDATE_MSG + keyDate);
            }
            this.setImportParameter("KEY_DATE", keyDate);
        } else {
            if (SBWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.INFO, this.function.getFunctionName() + STR_SET_KEYDATE_MSG + "00000000");
            }
            this.setImportParameter("KEY_DATE", "00000000");
        }
    }

    protected void setImportParameter(String name, Object value) throws SBWODPException {
        try {
            if (SBWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.INFO, this.function.getFunctionName() + STR_SET_PARAM_MSG + name + "\" to \"" + value.toString() + STR_ENDQUOTE);
            }
            this.function.setImportParameter(name, value.toString());
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_SET_IMPORT_PARAM_FAILED, e, name);
        }
    }

    protected void setImportParameter(String name, int value) throws SBWODPException {
        try {
            if (SBWODPLog.isOn("Function", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.INFO, this.function.getFunctionName() + STR_SET_PARAM_MSG + name + "\" to (integer) \"" + value + STR_ENDQUOTE);
            }
            this.function.setImportParameter(name, XQEIntegerPool.getInteger((int)value).toString());
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_SET_IMPORT_PARAM_FAILED, e, name);
        }
    }

    protected JBapiStructure getImportStructure(String name) throws SBWODPException {
        try {
            return this.function.getImportStructure(name);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_EXPORT_STRUCT_FAILED, e, name);
        }
    }

    protected void clearTable(String tableName) throws SBWODPException {
        try {
            if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Clearing Table: " + tableName);
            }
            this.getTable(tableName).clear();
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_CLEAR_TABLE, e);
        }
    }

    public void release() {
        if (this.function != null) {
            JBapiFunction localFunc = this.function;
            this.function = null;
            localFunc.release();
        }
    }
}

