/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.data.providers.connection.parameters.JAASSubjectParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.ClientParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.CodePageParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.LogonGroupParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.RouteParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SAPServerParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSSOCache;
import com.cognos.xqe.data.providers.olap.sbwodp.SSOTicketParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.ServerTypeParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SystemIDParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.SystemNumberParameter;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.trace.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.Subject;

class SBWODPLogonInfo
extends Properties {
    private static final String STARS = "*****";
    public static final String STR_SERVER = "server";
    public static final String STR_SERVER_TYPE = "serverType";
    public static final String STR_DATA_SOURCE = "Data Source";
    public static final String STR_SYSNR = "sysnr";
    public static final String STR_LOGONGROUP = "logonGroup";
    public static final String STR_SYSID = "sysid";
    public static final String STR_CLIENT = "client";
    public static final String STR_CODEPAGE = "codePage";
    public static final String STR_ROUTERSTRING = "routerString";
    public static final String STR_UID = "username";
    public static final String STR_PWD = "password";
    public static final String STR_CUBE = "cube";
    public static final String STR_CATALOG = "catalog";
    public static final String STR_SSO = "sapSSO";
    public static final String STR_KEYDATE = "keyDate";
    public static final String STR_SIGNON = "signon";
    public static final String STR_APP_SERVER = "applicationServer";
    public static final String STR_MSG_SERVER = "messageServer";
    public static final String STR_DEST_SERVER = "destination";
    public static final String STR_PLACEHOLDER = "%s";
    public static final String STR_COGNOS_SAP_HOST = "cognos.sap.host";
    public static final String STR_COGNOS_SAP_SERVER_TYPE = "cognos.sap.serverType";
    public static final String STR_SAP_USER = "USER";
    public static final String STR_SAP_ASHOST = "ASHOST";
    public static final String STR_SAP_MSHOST = "MSHOST";
    public static final String STR_SAP_DEST = "DEST";
    public static final String STR_SAP_PASSWD = "PASSWD";
    public static final String STR_SAP_SSO = "MYSAPSSO2";
    public static final String STR_SAP_SYSNR = "SYSNR";
    public static final String STR_SAP_R3NAME = "R3NAME";
    public static final String STR_SAP_LANG = "LANG";
    public static final String CONTROL_CHARS = "[\"\\;=]";
    private static final long serialVersionUID = 1L;

    SBWODPLogonInfo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseConnectionParams(ConnectionParameters connectionParameters) throws SBWODPException {
        String value;
        if (!connectionParameters.contains(ServerTypeParameter.class)) throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_SERVER_TYPE);
        String route = "";
        String host = "";
        String type = (String)connectionParameters.valueOf(ServerTypeParameter.class);
        this.setProperty(STR_COGNOS_SAP_SERVER_TYPE, type);
        if (connectionParameters.contains(RouteParameter.class)) {
            route = (String)connectionParameters.valueOf(RouteParameter.class);
        }
        if (type.equals(STR_DEST_SERVER)) {
            if (!connectionParameters.contains(SAPServerParameter.class)) throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_DEST_HOST);
            value = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_SAP_DEST, value);
            this.setProperty(STR_COGNOS_SAP_HOST, value);
        } else if (type.equals(STR_APP_SERVER)) {
            if (!connectionParameters.contains(SAPServerParameter.class)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_APP_HOST);
            }
            host = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_COGNOS_SAP_HOST, host);
            this.setProperty(STR_SAP_ASHOST, route + host);
            if (!connectionParameters.contains(SystemNumberParameter.class)) throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_SYS_NUMBER);
            this.setProperty(STR_SAP_SYSNR, (String)connectionParameters.valueOf(SystemNumberParameter.class));
        } else {
            if (!type.equals(STR_MSG_SERVER)) throw new SBWODPException(SBWODPMessageKeys.ERR_UNKNOWN_SRVR_TYPE, type);
            if (!connectionParameters.contains(SAPServerParameter.class)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_MSG_HOST);
            }
            value = (String)connectionParameters.valueOf(SAPServerParameter.class);
            this.setProperty(STR_SAP_MSHOST, value);
            this.setProperty(STR_COGNOS_SAP_HOST, value);
            if (!connectionParameters.contains(SystemIDParameter.class)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_SYS_ID);
            }
            this.setProperty(STR_SAP_R3NAME, route + (String)connectionParameters.valueOf(SystemIDParameter.class));
            if (!connectionParameters.contains(LogonGroupParameter.class)) throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_LOGON_GRP);
            this.setProperty("GROUP", (String)connectionParameters.valueOf(LogonGroupParameter.class));
        }
        if (!connectionParameters.contains(ClientParameter.class)) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_CLIENT_NUMBER);
        }
        this.setProperty("CLIENT", (String)connectionParameters.valueOf(ClientParameter.class));
        if (!connectionParameters.contains(CodePageParameter.class)) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_MISSING_CODEPAGE);
        }
        this.setProperty("CODEPAGE", (String)connectionParameters.valueOf(CodePageParameter.class));
        String pwd = null;
        if (connectionParameters.contains(UserIDParameter.class)) {
            String uid = (String)connectionParameters.valueOf(UserIDParameter.class);
            if (uid.equals("") || uid.equals(STR_PLACEHOLDER)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_NO_USERID);
            }
            this.setProperty(STR_SAP_USER, uid);
            if (connectionParameters.contains(PasswordParameter.class)) {
                pwd = (String)connectionParameters.valueOf(PasswordParameter.class);
                if (pwd != null) {
                    String[] controlChars;
                    if (SBWODPConfig.instance().getUppercasePwd()) {
                        pwd = pwd.toUpperCase();
                    }
                    if ((controlChars = pwd.split(CONTROL_CHARS)).length > 1) {
                        throw new JBapiException("Unsupported character(s) \"\\;= found in the password for user " + uid);
                    }
                    this.setProperty(STR_SAP_PASSWD, pwd);
                } else if (this.isHTTPSSOEnabled()) {
                    this.getSSOTicket(false);
                }
            }
            if (pwd == null && !connectionParameters.contains(SSOTicketParameter.class) && null == this.getProperty(STR_SAP_SSO)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_NO_PASSWD);
            }
        }
        if (connectionParameters.contains(JAASSubjectParameter.class)) {
            ByteArrayOutputStream os = null;
            if (SBWODPLog.isOn(LogLevel.TRACE).booleanValue()) {
                os = new ByteArrayOutputStream();
            }
            if (this.isHTTPSSOEnabled()) {
                SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "JAASSubject Kerberos signon");
                Subject subject = (Subject)connectionParameters.valueOf(JAASSubjectParameter.class, Subject.class);
                this.setProperty(STR_SAP_USER, subject.getPrincipals().toString());
                class KerberosTask
                implements PrivilegedAction<Exception> {
                    ByteArrayOutputStream os;
                    Exception ex = null;

                    KerberosTask(ByteArrayOutputStream theOs) {
                        this.os = theOs;
                    }

                    @Override
                    public Exception run() {
                        PrintStream old = System.out;
                        if (this.os != null) {
                            PrintStream ps = new PrintStream(this.os);
                            System.setOut(ps);
                        }
                        try {
                            SBWODPLogonInfo.this.getSSOTicket(true);
                        }
                        catch (Exception e) {
                            this.ex = e;
                        }
                        finally {
                            System.setOut(old);
                        }
                        return this.ex;
                    }

                    public Exception getException() {
                        return this.ex;
                    }
                }
                KerberosTask kerberosTask = new KerberosTask(os);
                Subject.doAs(subject, kerberosTask);
                if (this.getProperty(STR_SAP_SSO) == null) {
                    Exception e = kerberosTask.getException();
                    String message = "";
                    if (e != null) {
                        message = e.getMessage();
                    }
                    if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "JAASSubject Kerberos Signon failed. " + message);
                    }
                }
            }
        }
        if (connectionParameters.contains(SSOTicketParameter.class) && null == this.getProperty(STR_SAP_SSO) && (null == pwd || pwd.equals(""))) {
            this.setProperty(STR_SAP_SSO, (String)connectionParameters.valueOf(SSOTicketParameter.class));
        }
        if (null == this.getProperty(STR_SAP_SSO)) {
            if (!connectionParameters.contains(UserIDParameter.class)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_NO_USERID);
            }
            if (!connectionParameters.contains(PasswordParameter.class)) {
                throw new SBWODPException(SBWODPMessageKeys.ERR_NO_PASSWD);
            }
        }
        if (connectionParameters.contains(RunLocaleParameter.class)) {
            this.setProperty(STR_SAP_LANG, (String)connectionParameters.valueOf(RunLocaleParameter.class));
        }
        this.setProperty("TYPE", "3");
        if (!SBWODPConfig.instance().getTraceRFC()) return;
        this.setProperty("TRACE", "1");
    }

    private boolean isHTTPSSOEnabled() {
        if (this.getProperty(STR_COGNOS_SAP_SERVER_TYPE).equals(STR_DEST_SERVER)) {
            return false;
        }
        SBWODPSSOCache ssoCache = SBWODPSSOCache.getInstance();
        return ssoCache.isHTTPSSOEnabled();
    }

    private void getSSOTicket(boolean isKerberos) {
        SBWODPSSOCache ssoCache;
        String ticket;
        String user = this.getProperty(STR_SAP_USER);
        if (user == null || user.isEmpty()) {
            return;
        }
        String server = this.getProperty(STR_COGNOS_SAP_HOST);
        if (server == null || server.isEmpty()) {
            return;
        }
        if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "GetSSOTicket: " + server + " / " + user);
        }
        if ((ticket = (ssoCache = SBWODPSSOCache.getInstance()).getSSOTicket(server, user, isKerberos)) != null && !ticket.isEmpty()) {
            this.setProperty(STR_SAP_SSO, ticket);
            if (SBWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                if (isKerberos) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.INFO, "Kerberos SSO successful");
                } else {
                    SBWODPLog.getLogger("Connection").log(LogLevel.INFO, "HTTP SSO successful");
                }
            }
        } else if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSO Ticket was empty!");
        }
    }

    void obfuscatePassword() {
        if (null != this.getProperty(STR_SAP_PASSWD)) {
            this.setProperty(STR_SAP_PASSWD, STARS);
        }
    }

    void obfuscateSSO() {
        if (null != this.getProperty(STR_SAP_SSO)) {
            this.setProperty(STR_SAP_SSO, STARS);
        }
    }
}

