/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPDataHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPDataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPResultSet;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSAPData;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiClient;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiSAPException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import org.apache.commons.lang.StringUtils;

public class SBWODPMDXHandler
implements ICancelable {
    private final IPooledConnection mPooledConnection;
    private final MDXQueryArguments mQueryArgs;
    private final String mdx;
    private SBWODPConnection connection = null;
    private final JBapiClient client;
    private Integer nodeId = 0;
    private boolean canceled = false;
    private CancelManager cancelManager;

    public SBWODPMDXHandler(IPooledConnection pooledConnection, MDXQueryArguments queryArgs, String sapMDX, Integer ndID, CancelManager cancelMgr) throws SBWODPException, LogonFailureException {
        this.mdx = sapMDX;
        this.nodeId = ndID;
        this.mPooledConnection = pooledConnection;
        this.mQueryArgs = queryArgs;
        this.cancelManager = cancelMgr;
        this.cancelManager.addCancelHandler((ICancelable)this);
        this.connection = (SBWODPConnection)((Object)this.mPooledConnection.getConnection());
        this.client = this.connection.getClient();
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing SBWODPMDXHandler");
        }
    }

    public synchronized void addCancelListener(ICancelable listener) {
        this.cancelManager.addCancelHandler(listener);
    }

    public synchronized void removeCancelListener(ICancelable listener) {
        this.cancelManager.removeCancelHandler(listener);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() throws CancelUnsuccessfulException {
        this.canceled = true;
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    public SBWODPResultSet executeMDX(SBWODPDataProvider provider, XDataContext xDataContext, String effectiveDate) throws SBWODPException {
        if (this.mdx.equals("")) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_EMPTY_MDX);
        }
        SBWODPSAPData axisData = null;
        try {
            if (SBWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.INFO, "MDX Trace: " + StringUtils.replace((String)this.mdx, (String)"\n", (String)""));
            }
            this.resolveEffectiveDate(effectiveDate);
            this.executeCreateObjectFunction();
            this.executeCheckSyntaxFunction();
            this.executeSelectDataFunction();
            axisData = this.executeGetAxisInfoFunction();
        }
        catch (JBapiException be) {
            if (SBWODPLog.isOn("MDXEngine", LogLevel.ERROR).booleanValue()) {
                SBWODPLog.getLogger("MDXEngine").log(LogLevel.ERROR, "ERR_EXECUTE_MDX_FAILED");
            }
            throw be;
        }
        return new SBWODPResultSet(provider, xDataContext, this.mQueryArgs, this, axisData);
    }

    public void checkDataSetID() throws SBWODPException {
        if (this.connection.getDataSetID() == null) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_INVALID_DATASETID);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCreateObjectFunction() throws SBWODPException {
        if (this.connection.getDataSetID() != null) {
            this.executeDeleteObjectFunction();
            this.connection.setDataSetID(null);
        }
        SBWODPFunctionHandler dataHandler = null;
        try {
            dataHandler = SBWODPConfig.instance().getUseRSOB() ? new SBWODPDataHandler(this.connection, this.client, "RSR_MDX_CREATE_OBJECT") : new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_CREATE_OBJECT");
            this.addCancelListener(dataHandler);
            ((SBWODPDataHandler)dataHandler).createObject(this.mdx);
            dataHandler.executeFunction();
            ((SBWODPDataHandler)dataHandler).extractDataSetID();
            this.connection.setDataSetID(((SBWODPDataHandler)dataHandler).getDataSetID());
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SBWODPException(SBWODPMessageKeys.ERR_CREATE_OBJECT_FAILED, be);
                catch (SBWODPException e) {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_CREATE_OBJECT_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCheckSyntaxFunction() throws SBWODPException {
        SBWODPFunctionHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_CHECK_SYNTAX");
            this.addCancelListener(dataHandler);
            ((SBWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
            dataHandler.executeFunction();
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SBWODPException(SBWODPMessageKeys.ERR_CHECK_SYNTAX_FAILED, be);
                catch (SBWODPException e) {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_CHECK_SYNTAX_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    public void executeSelectDataFunction() throws SBWODPException {
        block5: {
            SBWODPFunctionHandler dataHandler = null;
            try {
                this.checkDataSetID();
                dataHandler = new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_SELECT_DATA");
                this.addCancelListener(dataHandler);
                ((SBWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
                dataHandler.executeFunction();
                if (dataHandler == null) break block5;
                this.removeCancelListener(dataHandler);
            }
            catch (SBWODPException e) {
                try {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_EXECUTE_MDX_FAILED, (Throwable)((Object)e));
                }
                catch (Throwable throwable) {
                    if (dataHandler != null) {
                        this.removeCancelListener(dataHandler);
                        dataHandler.release();
                    }
                    throw throwable;
                }
            }
            dataHandler.release();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SBWODPSAPData executeGetAxisInfoFunction() throws SBWODPException {
        SBWODPSAPData sBWODPSAPData;
        block8: {
            SBWODPFunctionHandler dataHandler = null;
            try {
                this.checkDataSetID();
                dataHandler = SBWODPConfig.instance().getUseRSOB() ? new SBWODPDataHandler(this.connection, this.client, "RSR_MDX_GET_AXIS_INFO") : new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_GET_AXIS_INFO");
                this.addCancelListener(dataHandler);
                ((SBWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
                dataHandler.executeFunction();
                SBWODPSAPData axisInfo = new SBWODPSAPData();
                sBWODPSAPData = ((SBWODPDataHandler)dataHandler).getAxisTables(axisInfo);
                if (dataHandler == null) break block8;
                this.removeCancelListener(dataHandler);
            }
            catch (JBapiSAPException se) {
                try {
                    if (!se.getErrorKey().equals("804") && !se.getErrorKey().equals("813")) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_INFO_FAILED, se);
                    }
                    throw new SBWODPException(SBWODPMessageKeys.ERR_ACCESS_DENIED, this.mQueryArgs.getCube().getCaption());
                    catch (JBapiException be) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_INFO_FAILED, be);
                    }
                    catch (SBWODPException e) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_INFO_FAILED, (Throwable)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    if (dataHandler != null) {
                        this.removeCancelListener(dataHandler);
                        dataHandler.release();
                    }
                    throw throwable;
                }
            }
            dataHandler.release();
        }
        return sBWODPSAPData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeDeleteObjectFunction() throws SBWODPException {
        SBWODPFunctionHandler dataHandler = null;
        try {
            this.checkDataSetID();
            dataHandler = new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_DELETE_OBJECT");
            this.addCancelListener(dataHandler);
            ((SBWODPDataHandler)dataHandler).setDataSetID(this.connection.getDataSetID());
            dataHandler.executeFunction();
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SBWODPException(SBWODPMessageKeys.ERR_DELETE_OBJECT_FAILED, be);
                catch (SBWODPException e) {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_DELETE_OBJECT_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SBWODPSAPData executeGetAxisDataFunction(int axis, int iStartTuple, int iEndTuple) throws SBWODPException {
        SBWODPSAPData sBWODPSAPData;
        block6: {
            SBWODPFunctionHandler dataHandler = null;
            try {
                this.checkDataSetID();
                dataHandler = SBWODPConfig.instance().getUseRSOB() ? new SBWODPDataHandler(this.connection, this.client, "RSR_MDX_GET_AXIS_DATA") : new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_GET_AXIS_DATA");
                this.addCancelListener(dataHandler);
                ((SBWODPDataHandler)dataHandler).setAxisDataParams(this.connection.getDataSetID(), axis, iStartTuple, iEndTuple);
                dataHandler.executeFunction();
                SBWODPSAPData axisData = new SBWODPSAPData();
                sBWODPSAPData = ((SBWODPDataHandler)dataHandler).getAxisDataTables(axisData);
                if (dataHandler == null) break block6;
                this.removeCancelListener(dataHandler);
            }
            catch (JBapiException be) {
                try {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_DATA_FAILED, be);
                    catch (SBWODPException e) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_DATA_FAILED, (Throwable)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    if (dataHandler != null) {
                        this.removeCancelListener(dataHandler);
                        dataHandler.release();
                    }
                    throw throwable;
                }
            }
            dataHandler.release();
        }
        return sBWODPSAPData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SBWODPSAPData executeGetCellDataFunction(int iStartCell, int iEndCell) throws SBWODPException {
        SBWODPSAPData sBWODPSAPData;
        block6: {
            SBWODPFunctionHandler dataHandler = null;
            try {
                this.checkDataSetID();
                dataHandler = SBWODPConfig.instance().getUseRSOB() ? new SBWODPDataHandler(this.connection, this.client, "RSR_MDX_GET_CELL_DATA") : new SBWODPDataHandler(this.connection, this.client, "BAPI_MDDATASET_GET_CELL_DATA");
                this.addCancelListener(dataHandler);
                ((SBWODPDataHandler)dataHandler).setCellDataParams(this.connection.getDataSetID(), iStartCell, iEndCell);
                dataHandler.executeFunction();
                SBWODPSAPData cellData = new SBWODPSAPData();
                sBWODPSAPData = ((SBWODPDataHandler)dataHandler).getCellTables(cellData);
                if (dataHandler == null) break block6;
                this.removeCancelListener(dataHandler);
            }
            catch (JBapiException be) {
                try {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_GET_CELL_DATA_FAILED, be);
                    catch (SBWODPException e) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_CELL_DATA_FAILED, (Throwable)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    if (dataHandler != null) {
                        this.removeCancelListener(dataHandler);
                        dataHandler.release();
                    }
                    throw throwable;
                }
            }
            dataHandler.release();
        }
        return sBWODPSAPData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeSetKeyDateFunction(String keyDate) throws SBWODPException {
        SBWODPDataHandler dataHandler = null;
        try {
            dataHandler = new SBWODPDataHandler(this.connection, this.client, "BAPI_MDPROVIDER_SET_KEY_DATE");
            this.addCancelListener(dataHandler);
            dataHandler.setKeyDateParam(keyDate);
            dataHandler.executeFunction();
            if (dataHandler == null) return;
            this.removeCancelListener(dataHandler);
        }
        catch (JBapiException be) {
            try {
                throw new SBWODPException(SBWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, be);
                catch (SBWODPException e) {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_SET_KEY_DATE_FAILED, (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (dataHandler == null) throw throwable;
                this.removeCancelListener(dataHandler);
                dataHandler.release();
                throw throwable;
            }
        }
        dataHandler.release();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeGetKeyDateFunction() throws SBWODPException {
        String string;
        block6: {
            SBWODPDataHandler dataHandler = null;
            try {
                dataHandler = new SBWODPDataHandler(this.connection, this.client, "BAPI_MDPROVIDER_GET_KEY_DATE");
                this.addCancelListener(dataHandler);
                dataHandler.executeFunction();
                string = (String)dataHandler.getExportParameter("KEY_DATE");
                if (dataHandler == null) break block6;
                this.removeCancelListener(dataHandler);
            }
            catch (JBapiException be) {
                try {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_GET_KEY_DATE_FAILED, be);
                    catch (SBWODPException e) {
                        throw new SBWODPException(SBWODPMessageKeys.ERR_GET_KEY_DATE_FAILED, (Throwable)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    if (dataHandler != null) {
                        this.removeCancelListener(dataHandler);
                        dataHandler.release();
                    }
                    throw throwable;
                }
            }
            dataHandler.release();
        }
        return string;
    }

    public void resolveEffectiveDate(String effectiveDate) throws SBWODPException {
        String cDate = this.connection.getEffectiveDate();
        String currentDate = SBWODPUtility.DateUtils.getLocalDateInSAPFormat();
        String date = effectiveDate != null ? SBWODPUtility.DateUtils.convertDateToSAPDateFormat(effectiveDate) : currentDate;
        if (cDate == null) {
            cDate = this.executeGetKeyDateFunction();
            this.connection.setEffectiveDate(cDate);
        }
        if (date.compareTo(cDate) != 0 && (effectiveDate == null || date.compareTo(currentDate) != 0)) {
            this.connection.setEffectiveDate(date);
            this.executeSetKeyDateFunction(date);
        }
    }

    public String getKeyDate() {
        return this.connection.getEffectiveDate();
    }

    public Integer getNodeID() {
        return this.nodeId;
    }

    public void release() {
        if (this.connection != null) {
            this.connection.setActiveDataQuery(false);
            this.connection = null;
            this.cancelManager.removeCancelHandler((ICancelable)this);
            if (!this.client.isValid()) {
                if (SBWODPLog.isOn("Connection", LogLevel.WARN).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.WARN, "SBWODPMDXHandler: invalidating connection");
                }
                this.mPooledConnection.setNotReusable();
            }
            this.mPooledConnection.returnConnection();
        }
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "releasing SBWODPMDXHandler");
        }
    }
}

