/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.sbwodp.SAPBWGenerateRestriction;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPDataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPInfoObjDetails;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPInfoObjectCache;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMetadataHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.transformation.olap.provider.sapbw.MemberFilterCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SBWODPMetadataProvider
extends MetadataProviderEnvironmentHelper<SBWODPConnection>
implements IOLAPMetadataProvider,
ICancelable {
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final Locale runLocale;
    private static final String MEASURES_STRING = "[Measures]";
    private static final int SEC_MODE_PROF = 2;
    private static final int SEC_MODE_MIXED = 3;
    private static final String MDX_NON_EMPTY_RETRIEVAL_CONTEXT = "MDX NON EMPTY";

    public SBWODPMetadataProvider(SBWODPDataProvider provider, ConnectionParameters connectionParameters, Locale locale) {
        super((OLAPDataProviderBase)provider, connectionParameters);
        this.runLocale = locale;
        if (SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Constructing SBWODPMetadataProvider");
        }
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(connParams);
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        return cacheParams;
    }

    public SALContext getMetadataQueryContext(ExecutionEnvironment theEexecutionEnvironment, SBWODPConnection connection, String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        List<String> unSecDims;
        if (SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Entering getMetadataQueryContext");
        }
        String securityContext = null;
        boolean secContextAssigned = false;
        String dim = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        if (dim != null && (unSecDims = SBWODPConfig.instance().getUnsecuredDimensions()) != null && unSecDims.contains(dim)) {
            secContextAssigned = true;
        }
        if (!secContextAssigned) {
            securityContext = securityContextMode == 3 ? (dim == null ? connection.getUserID() : connection.getUserProfileHashCode()) : (securityContextMode == 2 ? connection.getUserProfileHashCode() : connection.getUserID());
        }
        if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
            if (securityContext != null && securityContext.length() > 0) {
                SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "Got Security Context for connection: " + connection.getSAPConnectionHandle());
            } else {
                String uid = connection.getUserID();
                if (uid != null && uid.length() > 0) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "Got EMPTY Security Context for connection: " + connection.getSAPConnectionHandle());
                } else {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "Got EMPTY Security Context for unknown user on connection: " + connection.getSAPConnectionHandle());
                }
            }
        }
        String effectiveKeyDateRange = null;
        String effectiveDate = (String)restrictions.getValueOf(RestrictionType.KEY_DATE, null);
        String additionalMetadataRetrievalContext = null;
        if (opType == MetadataOperation.MEMBERS) {
            ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
            if (cube != null) {
                if (effectiveDate != null) {
                    effectiveKeyDateRange = this.getEffectiveKeyDateRange(restrictions);
                }
                boolean isMDXQuery = this.isMDXQuery(restrictions, connection, theEexecutionEnvironment);
                String variables = (String)restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null);
                if (isMDXQuery) {
                    additionalMetadataRetrievalContext = variables != null ? variables : MDX_NON_EMPTY_RETRIEVAL_CONTEXT;
                }
            } else {
                effectiveKeyDateRange = effectiveDate;
            }
        } else {
            effectiveKeyDateRange = effectiveDate;
        }
        return new SALContext(securityContext, effectiveKeyDateRange, additionalMetadataRetrievalContext);
    }

    public synchronized void addCancelListener(ICancelable listener, ExecutionEnvironment theExecutionEnvironment) {
        theExecutionEnvironment.getCancelManager().addCancelHandler(listener);
    }

    public synchronized void removeCancelListener(ICancelable listener, ExecutionEnvironment theExecutionEnvironment) {
        theExecutionEnvironment.getCancelManager().removeCancelHandler(listener);
    }

    public void cancel() throws CancelUnsuccessfulException {
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    public void releaseImpl() {
        if (this.released.compareAndSet(false, true) && SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Releasing SBWODPMetadataProvider");
        }
    }

    public Locale getRunLocale() {
        return this.runLocale;
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        if (SBWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SBWODPMetadataProvider does not support getActions");
        }
        return Collections.emptyList();
    }

    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        if (SBWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SBWODPMetadataProvider does not support getAliases");
        }
        return Collections.emptyList();
    }

    public List<String> getDatasourceLocales(ExecutionEnvironment theExecutionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        SBWODPMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new SBWODPMetadataHandler(this, connection, "RS_UNI_INSTALLED_LANGU_GET");
            this.addCancelListener(metadataHandler, theExecutionEnvironment);
            if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getLocales restrictions: " + restrictions.toString());
            }
            List<String> list = metadataHandler.getLocales(restrictions);
            return list;
        }
        catch (SBWODPException ex) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getDatasourceLocales failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                this.removeCancelListener(metadataHandler, theExecutionEnvironment);
                metadataHandler.release();
            }
        }
    }

    public List<CatalogRecord> getCatalogs(ExecutionEnvironment theExecutionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<CatalogRecord> list;
        block6: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                this.resolveEffectiveDate(restrictions, connection, theExecutionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_CATALOGS");
                this.addCancelListener(metadataHandler, theExecutionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getCatalogs restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getCatalogs(restrictions);
                if (metadataHandler == null) break block6;
                this.removeCancelListener(metadataHandler, theExecutionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getCatalogs failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, theExecutionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public List<CubeRecord> getCubes(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<CubeRecord> list;
        block7: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
                if (null == catalogName || catalogName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_CUBES");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getCubes restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getCubes(restrictions, executionEnvironment);
                if (metadataHandler == null) break block7;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getCubes failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public String getCubeDefaultMeasure(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        String string;
        block8: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String cubeName;
                String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
                if (null == catalogName || catalogName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
                }
                if (null == (cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE)) || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_HIERARCHYS");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getCubeDefaultMeasure restrictions: " + restrictions.toString());
                }
                string = ((SBWODPMetadataHandler)metadataHandler).getDefaultMeasureExternal(cubeName, catalogName, executionEnvironment);
                if (metadataHandler == null) break block8;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getCubeDefaultMeasure failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return string;
    }

    public List<DimensionRecord> getDimensions(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<DimensionRecord> list;
        block7: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_DIMENSIONS");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getDimensions restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getDimensions(restrictions, executionEnvironment);
                if (metadataHandler == null) break block7;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getDimensions failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public List<HierarchyRecord> getHierarchies(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<HierarchyRecord> list;
        block8: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String dimName;
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                if (null == (dimName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME)) || dimName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.DIMENSION_UNIQUE_NAME);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_HIERARCHYS");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getHierarchies restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getHierarchy(restrictions, executionEnvironment);
                if (metadataHandler == null) break block8;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getHierarchies failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public List<LevelRecord> getLevels(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<LevelRecord> list;
        block8: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String dimName;
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                if (null == (dimName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME)) || dimName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.DIMENSION_UNIQUE_NAME);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_LEVELS");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getLevels restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getLevels(restrictions);
                if (metadataHandler == null) break block8;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getLevels failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<MeasureRecord> getMeasures(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<MeasureRecord> list;
        block7: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_MEASURES");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getMeasures restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getMeasures(restrictions, executionEnvironment);
                if (metadataHandler == null) break block7;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getMeasures failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        if (SBWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SBWODPMetadataProvider does not support getNamedSets");
        }
        return Collections.emptyList();
    }

    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        if (SBWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SBWODPMetadataProvider does not support getNamedSetMembers");
        }
        return Collections.emptyList();
    }

    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        if (SBWODPLog.isOn("Metadata", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.WARN, "SBWODPMetadataProvider does not support getNamedSetLevelUniqueNames");
        }
        return Collections.emptyList();
    }

    public List<PropertyRecord> getProperties(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<PropertyRecord> list;
        block7: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_PROPERTIES");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getProperties restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getProperties(restrictions);
                if (metadataHandler == null) break block7;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getProperties failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public List<VariableRecord> getVariables(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        List<VariableRecord> list;
        block7: {
            SBWODPFunctionHandler metadataHandler = null;
            try {
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
                if (null == cubeName || cubeName.length() == 0) {
                    SBWODPMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
                }
                this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
                metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_VARIABLES");
                this.addCancelListener(metadataHandler, executionEnvironment);
                if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getVariables restrictions: " + restrictions.toString());
                }
                list = ((SBWODPMetadataHandler)metadataHandler).getVariables(restrictions, executionEnvironment);
                if (metadataHandler == null) break block7;
                this.removeCancelListener(metadataHandler, executionEnvironment);
            }
            catch (SBWODPException ex) {
                try {
                    SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "SBWODPMetadataProvider.getVariables failed: ", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (metadataHandler != null) {
                        this.removeCancelListener(metadataHandler, executionEnvironment);
                        metadataHandler.release();
                    }
                    throw throwable;
                }
            }
            metadataHandler.release();
        }
        return list;
    }

    public void resolveEffectiveDate(IRestrictions restrictions, SBWODPConnection connection, ExecutionEnvironment executionEnvironment) throws SBWODPException {
        String effectiveDate = (String)restrictions.getValueOf(RestrictionType.KEY_DATE, null);
        String cDate = connection.getEffectiveDate();
        String currentDate = SBWODPUtility.DateUtils.getLocalDateInSAPFormat();
        String date = effectiveDate != null ? SBWODPUtility.DateUtils.convertDateToSAPDateFormat(effectiveDate) : currentDate;
        if (cDate == null) {
            cDate = this.getKeyDate(connection, executionEnvironment);
            connection.setEffectiveDate(cDate);
        }
        if (date.compareTo(cDate) != 0 && (effectiveDate == null || date.compareTo(currentDate) != 0)) {
            connection.setEffectiveDate(date);
            this.setKeyDate(connection, date, executionEnvironment);
        }
    }

    protected void setKeyDate(SBWODPConnection connection, String keyDate, ExecutionEnvironment executionEnvironment) throws SBWODPException {
        SBWODPMetadataHandler metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_SET_KEY_DATE");
        this.addCancelListener(metadataHandler, executionEnvironment);
        metadataHandler.setKeyDate(keyDate);
        this.removeCancelListener(metadataHandler, executionEnvironment);
        metadataHandler.release();
    }

    private String getKeyDate(SBWODPConnection connection, ExecutionEnvironment executionEnvironment) throws SBWODPException {
        SBWODPMetadataHandler metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_KEY_DATE");
        this.addCancelListener(metadataHandler, executionEnvironment);
        String ret = metadataHandler.getKeyDate();
        this.removeCancelListener(metadataHandler, executionEnvironment);
        metadataHandler.release();
        return ret;
    }

    private boolean hasVariableRestriction(IRestrictions restrictions) {
        String strVal = (String)restrictions.getValueOf(RestrictionType.VARIABLE, null);
        return strVal != null;
    }

    private boolean hasSearchRestriction(IRestrictions restrictions) {
        MASearchCriteria strVal = (MASearchCriteria)restrictions.getValueOf(RestrictionType.MEMBERSEARCH, null);
        return strVal != null;
    }

    private void modifyRestrictionForVariable(IRestrictions restrictions, SBWODPConnection connection) throws SBWODPException {
        String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        if (dimUName != null && hierUName != null) {
            if (dimUName.equals(hierUName)) {
                EnumSet treeOp;
                restrictions.replace(RestrictionType.LEVEL_NUMBER, (Object)1);
                int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
                int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0);
                if (from != 0) {
                    restrictions.replace(RestrictionType.FROM, (Object)0);
                }
                if (size != 0) {
                    restrictions.replace(RestrictionType.SIZE, (Object)0);
                }
                if ((treeOp = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null)) != null) {
                    restrictions.remove(RestrictionType.TREEOP);
                }
            }
        } else {
            throw new SBWODPException(SBWODPMessageKeys.ERR_RESTRICTION);
        }
        this.modifyRestrictionForMARequest(restrictions, connection);
    }

    private void modifyRestrictionForMARequest(IRestrictions restrictions, SBWODPConnection connection) throws SBWODPException {
        String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String memUName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        if (levelNumber == -1 && dimUName != null && hierUName != null && memUName == null) {
            if (dimUName.equals(hierUName)) {
                restrictions.replace(RestrictionType.LEVEL_NUMBER, (Object)1);
                levelNumber = 1;
            } else {
                restrictions.replace(RestrictionType.LEVEL_NUMBER, (Object)0);
                levelNumber = 0;
            }
            restrictions.remove(RestrictionType.TREEOP);
        }
    }

    private List<SAPBWGenerateRestriction> createRestrictionForValues(MASearchCriteria searchCriteria) throws SBWODPException {
        MARequestedPropertiesEnum property = searchCriteria.getProperty();
        if (!(searchCriteria instanceof MemberFilterCriteria) && property != MARequestedPropertiesEnum.CAPTION) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_SEARCH_RESTRICTION);
        }
        List searchValues = searchCriteria.getSearchValues();
        ArrayList<SAPBWGenerateRestriction> searchRestrictions = new ArrayList<SAPBWGenerateRestriction>(searchValues.size());
        MASearchCriteria.SearchCondition condition = searchCriteria.getSearchCondition();
        String pUniqueName = null;
        pUniqueName = searchCriteria.isDynamicProperty() ? searchCriteria.getPropertyName() : searchCriteria.getPropertyUniqueName();
        for (String value : searchValues) {
            SAPBWGenerateRestriction sapRestriction = new SAPBWGenerateRestriction(value, condition, pUniqueName);
            searchRestrictions.add(sapRestriction);
        }
        return searchRestrictions;
    }

    protected static void throwRestrictionMissing(RestrictionType restrictionType) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, restrictionType.toString());
    }

    private boolean canUseFastGetMemberMetadata(IRestrictions restrictions) {
        boolean result = false;
        String dimUname = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        if (null == dimUname || dimUname.length() == 0) {
            return result;
        }
        if (!this.getUseFastGetMembers(dimUname)) {
            return result;
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)0x7FFFFFFE);
        if (from != 0 || size != 0) {
            return result;
        }
        String hirUname = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        if (!dimUname.equals(hirUname)) {
            return result;
        }
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String memUname = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
        if (levelNumber != -1) {
            if (levelNumber != 1) {
                return result;
            }
        } else if (treeOpSet != null && treeOpSet.size() == 1 && null != memUname && memUname.length() != 0) {
            if (!treeOpSet.contains(TreeOperatorEnum.CHILDREN)) {
                return result;
            }
        } else {
            return result;
        }
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        if (null == cubeName || cubeName.length() == 0 || null == catalogName || catalogName.length() == 0) {
            return result;
        }
        result = true;
        return result;
    }

    public boolean getUseFastGetMembers(String dimName) {
        SBWODPConfig config = SBWODPConfig.instance();
        boolean fastGetMembers = config.getUseFastGetMembers();
        List<String> dimList = config.getUseFastGetMembersFor();
        if (fastGetMembers && (dimList == null || dimList.size() == 0)) {
            return true;
        }
        return fastGetMembers && dimList.contains(dimName);
    }

    public List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, SBWODPConnection connection, IRestrictions restrictions) {
        String resCube = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String resHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        if (SBWODPLog.isOn("Metadata", LogLevel.INFO).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.INFO, "SBWODPMetadataProvider.getHierarchyRootMembers restrictions: " + restrictions.toString());
        }
        if (resHUN.equals(MEASURES_STRING)) {
            return Collections.emptyList();
        }
        SBWODPMetadataHandler metadataHandler = null;
        this.resolveEffectiveDate(restrictions, connection, executionEnvironment);
        metadataHandler = new SBWODPMetadataHandler(this, connection, "BAPI_MDPROVIDER_GET_MEMBERS");
        this.addCancelListener(metadataHandler, executionEnvironment);
        List<LevelRecord> levels = metadataHandler.loadLevels(resCube, resDUN, resHUN, executionEnvironment);
        this.removeCancelListener(metadataHandler, executionEnvironment);
        metadataHandler.release();
        if (!levels.isEmpty()) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)levels.get(0).getUniqueName());
        }
        return this.getMembers(restrictions);
    }

    private boolean isMembersExceedLimit(IHierarchy hierarchy) {
        IDimension dim = hierarchy.getDimension();
        IHierarchy defaultHierarchy = dim.getDefaultHierarchy();
        int cardinality = dim.getCardinality();
        if (defaultHierarchy.getLevels().size() <= 2 && !defaultHierarchy.isMultiRoot()) {
            return hierarchy.getUniqueName().equals(defaultHierarchy.getUniqueName()) && SBWODPConfig.instance().getMDXToRetrieveMembersLimit() < cardinality;
        }
        return false;
    }

    private boolean isMDXQuery(IRestrictions restrictions, SBWODPConnection connection, ExecutionEnvironment executionEnvironment) {
        boolean answer = false;
        ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        Boolean useMetadatCallOnly = (Boolean)restrictions.getValueOf(RestrictionType.USE_METADATA_CALL_ONLY, (Object)Boolean.FALSE);
        Boolean supressNulls = (Boolean)restrictions.getValueOf(RestrictionType.SUPRESS_NULLS, (Object)Boolean.TRUE);
        if (cube != null && !useMetadatCallOnly.booleanValue() && supressNulls.booleanValue()) {
            String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            IDimension dimension = cube.getDimension(dimUName);
            if (dimension == null || dimension.isMeasuresDimension()) {
                return false;
            }
            EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
            if (treeOpSet != null) {
                boolean containsSelf = treeOpSet.contains(TreeOperatorEnum.SELF);
                boolean containsAncestors = treeOpSet.contains(TreeOperatorEnum.ANCESTORS);
                if (containsSelf && treeOpSet.size() == 1 || containsAncestors) {
                    return answer;
                }
            }
            String variables = (String)restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null);
            String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            boolean hasMandatoryVariables = this.hasMandatoryVariables(cube.getVariables());
            IHierarchy hierarchy = dimension.getHierarchy(hierUName);
            if (!hasMandatoryVariables || hasMandatoryVariables && variables != null && variables.length() != 0) {
                SBWODPInfoObjectCache iObjCache = SBWODPInfoObjectCache.getInstance(this);
                String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE, null);
                boolean isDateType = false;
                String dName = SBWODPUtility.SBWODPNameUtils.removeBrackets(dimUName);
                SBWODPInfoObjDetails details = iObjCache.getDimensionDetails(connection, connection.getSystemKey(), cubeName, dName, executionEnvironment);
                if (details != null) {
                    isDateType = details.isDateType();
                }
                String memUName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
                int levNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
                if (!isDateType && memUName == null) {
                    String effectiveDate;
                    String levelUName;
                    if (levNumber == 0) {
                        return answer;
                    }
                    if (levNumber == -1 && this.isRootLevel(cube, dimUName, hierUName, levelUName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null), effectiveDate = (String)restrictions.getValueOf(RestrictionType.KEY_DATE, null))) {
                        return answer;
                    }
                }
                boolean bl = answer = isDateType || this.isMembersExceedLimit(hierarchy);
                if (!answer && (this.isInfoObjectIncludedInUseMDX(dimUName) || this.isInfoObjectIncludedInUseMDX(hierUName) || this.isInfoObjectIncludedInUseMDX(memUName))) {
                    answer = true;
                }
            }
        }
        return answer;
    }

    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        ICube cube;
        boolean answer = false;
        if (this.isReplacementVariableSpecified() && (cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null)) != null) {
            String cubeDimName = cube.getName();
            String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            if (dimUName != null) {
                cubeDimName = SBWODPUtility.SBWODPNameUtils.makeCubeDimensionName(cubeDimName, dimUName);
            }
            if (SBWODPConfig.instance().getUseReplacementVariablesFor().contains(cubeDimName)) {
                answer = true;
            }
        }
        return answer;
    }

    public boolean isReplacementVariableSpecified() {
        List<String> useReplacementVariablesFor = SBWODPConfig.instance().getUseReplacementVariablesFor();
        return useReplacementVariablesFor != null && !useReplacementVariablesFor.isEmpty();
    }

    private boolean isInfoObjectIncludedInUseMDX(String name) {
        List<String> mdxList;
        return name != null && name.length() != 0 && (mdxList = SBWODPConfig.instance().getMDXToRetrieveMembersFor()) != null && mdxList.size() != 0 && mdxList.contains(name);
    }

    private List<MemberRecord> getMemberRecords(XIterator membersIterator, String cubeName, Set<String> dimProperties) {
        ITuple aTuple = (ITuple)membersIterator.next();
        ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
        HashSet<String> propsMissingInMDXResult = new HashSet<String>();
        Boolean hasMissingPropsInMDXResult = null;
        while (aTuple != null) {
            IMember member = aTuple.getMember(0);
            result.add(this.convertMetadatMember(member, cubeName, dimProperties, propsMissingInMDXResult, hasMissingPropsInMDXResult));
            aTuple = (ITuple)membersIterator.next();
        }
        return result;
    }

    private MemberRecord convertMetadatMember(IMember member, String cubeName, Set<String> dimProperties, Set<String> propsMissingInMDXResult, Boolean hasMissingPropsInMDXResult) {
        MemberRecord memberRecord = new MemberRecord();
        memberRecord.setName(member.getName());
        memberRecord.setCubeName(cubeName);
        memberRecord.setUniqueName(member.getUniqueName());
        memberRecord.setCaption(member.getCaptionValue().toString());
        memberRecord.setChildCardinality(member.getChildrenCardinality());
        memberRecord.setDescription(member.getDescription());
        memberRecord.setParentUniqueName(member.getParentUniqueName());
        memberRecord.setParentLevelNumber(member.getParentLevelNumber());
        memberRecord.setUniqueId(member.getUniqueName());
        memberRecord.setRollupType(member.getRollupType());
        memberRecord.setParentUniqueName(member.getParentUniqueName());
        memberRecord.setParentLevelNumber(member.getParentLevelNumber());
        ILevel level = member.getLevel();
        memberRecord.setLevelNumber(level.getIndex());
        memberRecord.setLevelUniqueName(level.getUniqueName());
        if (memberRecord.getLevelNumber() == 0) {
            memberRecord.setParentLevelNumber(-1);
            memberRecord.setParentCount(0);
        } else {
            memberRecord.setParentCount(1);
        }
        String dimName = member.getDimension().getUniqueName();
        memberRecord.setHierarchyUniqueName(member.getHierarchy().getUniqueName());
        memberRecord.setDimensionUniqueName(dimName);
        memberRecord.setCubeName(cubeName);
        Set propertyNames = member.getAvailableProperties();
        if (hasMissingPropsInMDXResult == Boolean.TRUE) {
            for (String propertyName : propsMissingInMDXResult) {
                propertyNames.add(propertyName);
            }
        } else if (hasMissingPropsInMDXResult == null) {
            for (String propertyName : dimProperties) {
                if (propertyNames.contains(propertyName) || propertyName.equals(RoleTypeEnum.PARENT_UNIQUE_NAME.toMDXKeyword()) || propertyName.equals(RoleTypeEnum.PARENT_LEVEL_NUMBER.toMDXKeyword())) continue;
                propsMissingInMDXResult.add(propertyName);
                propertyNames.add(propertyName);
            }
            hasMissingPropsInMDXResult = propsMissingInMDXResult.isEmpty() ? Boolean.FALSE : Boolean.TRUE;
        }
        for (String field : propertyNames) {
            memberRecord.setDynamicField(field, member.getProperty(field));
        }
        return memberRecord;
    }

    private ILevel determineLevel(ICube cube, int levelNumber, String dimUName, String memberUName, String keyDate) {
        IDimension aDimension = cube.getDimension(dimUName);
        IHierarchy aHierarchy = null;
        String hierUName = memberUName.substring(0, memberUName.indexOf("].[") + 1);
        aHierarchy = aDimension.getHierarchy(hierUName, keyDate, null, null);
        ILevel level = aHierarchy.getLevel(levelNumber);
        if (SBWODPLog.isOn("Function", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Function").log(LogLevel.TRACE, "Level " + level.getUniqueName() + " found in dimension " + aDimension.getUniqueName() + " at level number " + levelNumber);
        }
        return level;
    }

    private boolean isRootLevel(ICube cube, String dimUName, String hierUName, String levelUName, String keyDate) {
        if (levelUName != null && levelUName.length() != 0) {
            IDimension aDimension = cube.getDimension(dimUName);
            if (hierUName != null && hierUName.length() != 0) {
                IHierarchy hier;
                IHierarchy aHierarchy = aDimension.getHierarchy(hierUName, keyDate, null, null);
                if (aHierarchy == null && !aDimension.isDefaultHierarchyExistInModel() && (hier = aDimension.getDefaultHierarchy()).getUniqueName().equals(hierUName)) {
                    aHierarchy = hier;
                }
                ILevel level = aHierarchy.getLevel(levelUName);
                return level.isRootLevel();
            }
        }
        return false;
    }

    public boolean hasMandatoryVariables(List<IVariable> variables) {
        if (variables != null) {
            for (IVariable variable : variables) {
                if (variable.getEntryType() != VariableEntryTypeEnum.MANDATORY) continue;
                return true;
            }
        }
        return false;
    }

    private String getEffectiveKeyDateRange(IRestrictions restrictions) {
        String effectiveDate;
        String space = " ";
        ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dimUname = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String result = effectiveDate = (String)restrictions.getValueOf(RestrictionType.KEY_DATE, null);
        if (cube != null && effectiveDate != null) {
            Matcher m;
            IDimension dim = cube.getDimension(dimUname);
            IHierarchy hierarchy = dim.getHierarchy(hierUName, effectiveDate, null, null);
            String rx = "[v]([0-9]++)";
            Pattern pattern = Pattern.compile(rx);
            String validFrom = (String)hierarchy.getProperty("Valid_From");
            String validTo = (String)hierarchy.getProperty("Valid_To");
            validFrom = validFrom != null ? validFrom.substring(0, 10) : "";
            validTo = validTo != null ? validTo.substring(0, 10) : "";
            String caption = hierarchy.getCaption();
            int index = caption.lastIndexOf(space);
            if (index != -1 && index < caption.length() - 1 && validFrom.length() == 0 && validTo.length() == 0 && (m = pattern.matcher(caption = caption.substring(index + 1))).matches()) {
                return SBWODPUtility.makeEffectiveKeyDateRange(effectiveDate, effectiveDate);
            }
            if (validFrom.length() == 0 && validTo.length() == 0) {
                List hierarchySet = dim.getHierarchies();
                for (IHierarchy hier : hierarchySet) {
                    Matcher m2;
                    caption = hier.getCaption();
                    index = caption.lastIndexOf(space);
                    if (index == -1 || index >= caption.length() - 1 || !(m2 = pattern.matcher(caption = caption.substring(index + 1))).matches()) continue;
                    return SBWODPUtility.makeEffectiveKeyDateRange(effectiveDate, effectiveDate);
                }
            }
            if (validFrom.length() == 0 && SBWODPUtility.DateUtils.compareDates(effectiveDate, validTo) <= 0) {
                return SBWODPUtility.makeEffectiveKeyDateRange("10000101", validTo);
            }
            if (validTo.length() == 0 && SBWODPUtility.DateUtils.compareDates(effectiveDate, validFrom) >= 0) {
                return SBWODPUtility.makeEffectiveKeyDateRange(validFrom, "99991231");
            }
            if (SBWODPUtility.DateUtils.compareDates(effectiveDate, validFrom) >= 0 && SBWODPUtility.DateUtils.compareDates(effectiveDate, validTo) <= 0) {
                return SBWODPUtility.makeEffectiveKeyDateRange(validFrom, validTo);
            }
        }
        return result;
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }
}

