/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.DecimalValue;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.FloatValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.LongValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.dom4j.Element;

@Deprecated
public final class DataValues {
    public static StringValue wrapString(String value) {
        return new StringValue(value);
    }

    public static IntegerValue wrapInteger(int value) {
        return new IntegerValue(value);
    }

    public static LongValue wrapLong(long value) {
        return new LongValue(value);
    }

    public static FloatValue wrapFloat(float value) {
        return new FloatValue(value);
    }

    public static DoubleValue wrapDouble(double value) {
        return new DoubleValue(value);
    }

    public static DecimalValue wrapBigDecimal(BigDecimal value) {
        return new DecimalValue(value);
    }

    public static DecimalValue wrapBigDecimal(BigDecimal value, int precision, int scale) {
        return new DecimalValue(DataTypes.getDecimalType(precision, scale), value);
    }

    public static BooleanValue wrapBoolean(boolean value) {
        return new BooleanValue(value);
    }

    public static DateValue wrapDate(Date value) {
        return new DateValue(value);
    }

    public static DateValue wrapDate(Date value, TimeZone tz) {
        return new DateValue(value, tz);
    }

    public static DateValue wrapDate(Calendar cal) {
        return new DateValue(cal);
    }

    public static TimeValue wrapTime(Date value) {
        return new TimeValue(value);
    }

    public static TimeValue wrapTime(Date value, TimeZone tz) {
        return new TimeValue(value, tz);
    }

    public static TimeValue wrapTime(Calendar cal) {
        return new TimeValue(cal);
    }

    public static TimestampValue wrapTimestamp(Date value) {
        return new TimestampValue(value);
    }

    public static TimestampValue wrapTimestamp(Date value, TimeZone tz) {
        return new TimestampValue(value, tz);
    }

    public static TimestampValue wrapTimestamp(Calendar cal) {
        return new TimestampValue(cal);
    }

    public static IValue wrap(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return DataValues.wrapString((String)value);
        }
        if (value instanceof Number) {
            Number numValue = (Number)value;
            if (value instanceof BigDecimal) {
                return DataValues.wrapBigDecimal((BigDecimal)value);
            }
            if (value instanceof Integer) {
                return DataValues.wrapInteger(numValue.intValue());
            }
            if (value instanceof Long) {
                return DataValues.wrapLong(numValue.longValue());
            }
            if (value instanceof Float) {
                return DataValues.wrapFloat(numValue.floatValue());
            }
            return DataValues.wrapDouble(numValue.doubleValue());
        }
        if (value instanceof Boolean) {
            return DataValues.wrapBoolean((Boolean)value);
        }
        if (value instanceof Date) {
            return DataValues.wrapTimestamp((Date)value);
        }
        if (value instanceof Calendar) {
            return DataValues.wrapTimestamp((Calendar)value);
        }
        throw new IllegalArgumentException("Unsupported data type: " + value.getClass().toString());
    }

    public static void encodeBinary(DataOutput out, EncoderContext ctx, IValue value) throws IOException {
        DataTypes.encodeBinary(out, ctx, value.getType());
        value.encodeBinary(out, ctx);
    }

    public static IValue decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        IDataType dataType = DataTypes.decodeBinary(in, ctx);
        IValue value = dataType.newValue();
        value.decodeBinary(in, null);
        return value;
    }

    public static void encodeElement(Element elem, EncoderContext ctx, IValue value) {
        DataTypes.encodeElement(elem, ctx, value.getType());
        value.encodeElement(elem, ctx);
    }

    public static IValue decodeElement(Element elem, EncoderContext ctx) {
        IDataType dataType = DataTypes.decodeElement(elem, ctx);
        IValue value = dataType.newValue();
        value.decodeElement(elem, ctx);
        return value;
    }

    private DataValues() {
    }
}

