/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

public class DoubleValue
extends ValueBase {
    private double mValue;

    public DoubleValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public DoubleValue(double value, ValueStatus status) {
        this.set(value, status);
    }

    public DoubleValue(double value) {
        this.set(value);
    }

    @Override
    public IDataType getType() {
        return DataTypes.getDoubleType();
    }

    public void set(double value, ValueStatus status) {
        this.mValue = value;
        this.setStatus(status);
    }

    public void set(double value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Double value) {
        if (null == value) {
            this.set(Double.NaN, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue;
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return Double.toString(this.mValue);
    }

    @Override
    public float floatValue() {
        if (!this.isOK()) {
            return 0.0f;
        }
        return (float)this.mValue;
    }

    @Override
    public double doubleValue() {
        if (!this.isOK()) {
            return 0.0;
        }
        return this.mValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return new BigDecimal(this.mValue);
    }

    @Override
    public Number numberValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.doubleValue();
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (int)this.mValue;
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return (long)this.mValue;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return 0.0 != this.mValue;
    }

    public int hashCode() {
        return this.getStatus().hashCode() + (int)Double.doubleToLongBits(this.mValue);
    }

    @Override
    public int compareTo(IValue other) {
        double rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.DOUBLE) {
            return DoubleValue.compareValue(this, other);
        }
        int c = DoubleValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        double leftValue = this.doubleValue();
        if (leftValue < (rightValue = other.doubleValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(0.0, ValueStatus.NULL);
        } else {
            this.set(value.doubleValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(0.0, ValueStatus.NULL);
        } else {
            try {
                this.set(Double.parseDouble(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            out.writeDouble(this.mValue);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            this.mValue = in.readDouble();
        }
    }

    protected static double convertNegativeZeroToZero(double dValue) {
        if (dValue == 0.0) {
            return 0.0;
        }
        return dValue;
    }
}

