/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.storage.waypoint;

import com.ibm.cognos.aurora.api.storage.waypoint.AnnotationRecord;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class WaypointRecord {
    private final String mId;
    private final String mParentId;
    private final String mTrailId;
    private final String mName;
    private final String mAuthor;
    private final Date mCreationDate;
    private final String mCanvasState;
    private final String[] mTags;
    private final Map<String, String> mMetaInfo;
    private final AnnotationRecord[] mAnnotations;

    public WaypointRecord(String id, String parentId, String trailId, String name, String author, Date creationDate, String canvasState, String[] tags, Map<String, String> metaInfo, AnnotationRecord[] annotations) {
        this.mId = id;
        this.mParentId = parentId;
        this.mTrailId = trailId;
        this.mName = name;
        this.mAuthor = author;
        this.mCreationDate = creationDate;
        this.mCanvasState = canvasState;
        this.mTags = tags;
        this.mMetaInfo = metaInfo;
        this.mAnnotations = annotations;
    }

    public String getId() {
        return this.mId;
    }

    public String getParentId() {
        return this.mParentId;
    }

    public WaypointRecord withParentId(String parentId) {
        return new WaypointRecord(this.mId, parentId, this.mTrailId, this.mName, this.mAuthor, this.mCreationDate, this.mCanvasState, this.mTags, this.mMetaInfo, this.mAnnotations);
    }

    public String getTrailId() {
        return this.mTrailId;
    }

    public WaypointRecord withTrailId(String trailId) {
        return new WaypointRecord(this.mId, this.mParentId, trailId, this.mName, this.mAuthor, this.mCreationDate, this.mCanvasState, this.mTags, this.mMetaInfo, this.mAnnotations);
    }

    public String getName() {
        return this.mName;
    }

    public WaypointRecord withName(String name) {
        return new WaypointRecord(this.mId, this.mParentId, this.mTrailId, name, this.mAuthor, this.mCreationDate, this.mCanvasState, this.mTags, this.mMetaInfo, this.mAnnotations);
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public String getCanvasState() {
        return this.mCanvasState;
    }

    public String[] getTags() {
        return this.mTags;
    }

    public Map<String, String> getMetaInfo() {
        return this.mMetaInfo;
    }

    public AnnotationRecord[] getAnnotations() {
        return this.mAnnotations;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

