/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.bi.crypto.tunnel.TunnelSession;
import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jdbc.adaptor.IConnectionAttributeSetter;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.ibm.cognos.jdbc.adaptor.util.LoggingProxyBuilder;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseConnectionAdaptor
extends AbstractAdaptor
implements IAdaptorConnection {
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    protected Connection con;
    private Connection proxiedCon = null;
    Logger logger;
    public static final String JDBC_INTERFACES_FILTER = "^(java\\.sql\\..+)|(javax\\.sql\\..+)";
    private static final String QUERY_PLAN_SQL_KEY = "query.plan.sql";
    private static final String QUERY_PLAN_COLUMN_KEY = "query.plan.column";
    private static final String QUERY_PLAN_FORMATTER_KEY = "query.plan.formatter";
    private static final int DEFAULT_QUERY_PLAN_COLUMN = 1;
    private static final String DEFAULT_QUERY_PLAN_FORMATTER = "%1$s\n";
    private static final String DRIVER_VERSION_BLACKLIST_KEY = "blacklist.driverVersion";
    private static final String DRIVER_VERSION_TEXT_BLACKLIST_KEY = "blacklist.driverVersionText";
    private static final String DRIVER_NAME_BLACKLIST_KEY = "blacklist.driverName";
    private static final String SERVER_VERSION_BLACKLIST_KEY = "blacklist.serverVersion";
    private static final String SERVER_VERSION_TEXT_BLACKLIST_KEY = "blacklist.serverVersionText";
    private static final String SERVER_NAME_BLACKLIST_KEY = "blacklist.serverName";
    private static final String DRIVER_VERSION_GREYLIST_KEY = "greylist.driverVersion";
    private static final String DRIVER_VERSION_TEXT_GREYLIST_KEY = "greylist.driverVersionText";
    private static final String DRIVER_NAME_GREYLIST_KEY = "greylist.driverName";
    private static final String SERVER_VERSION_GREYLIST_KEY = "greylist.serverVersion";
    private static final String SERVER_VERSION_TEXT_GREYLIST_KEY = "greylist.serverVersionText";
    private static final String SERVER_NAME_GREYLIST_KEY = "greylist.serverName";
    protected static final String DATABASE_PRODUCT_VERSION_TEXT_KEY = "databaseProductVersionText";
    private static final String CNX_ATTR_SETTER_CLASS = "connection.attribute.setter";
    private Map<String, Object> extraInformation = null;
    private String connectionURL;
    private final IConnectionAttributeSetter attributeSetter;
    private List<String> qualifierList;
    private TunnelSession tunnelSeesion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseConnectionAdaptor(Connection connection, AdaptorFactory factory) {
        super(factory);
        this.con = connection;
        IConnectionAttributeSetter setter = null;
        String setterName = this.getAdaptorFactory().getAdaptorProperties().getProperty(CNX_ATTR_SETTER_CLASS);
        if (setterName == null || setterName.isEmpty()) {
            this.attributeSetter = new DummyAttributeSetter();
        } else {
            try {
                Class<?> clazz = Class.forName(setterName);
                setter = (IConnectionAttributeSetter)clazz.newInstance();
            }
            catch (Exception e) {
                setter = null;
            }
            finally {
                this.attributeSetter = setter != null ? setter : new DummyAttributeSetter();
            }
        }
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.con.close();
        if (this.tunnelSeesion != null) {
            try {
                this.tunnelSeesion.close();
            }
            catch (Exception e) {
                this.logger.info("Tunnel close problem");
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        this.con.commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.con.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.con.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.con.createSQLXML();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        Statement stmt = this.createStatementImpl();
        if (null == stmt) {
            return stmt;
        }
        return this.factory.wrapStatement(stmt);
    }

    protected Statement createStatementImpl() throws SQLException {
        return this.con.createStatement();
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = this.createStatementImpl(resultSetType, resultSetConcurrency);
        if (null == stmt) {
            return stmt;
        }
        return this.factory.wrapStatement(stmt);
    }

    protected Statement createStatementImpl(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = this.createStatementImpl(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (null == stmt) {
            return stmt;
        }
        return this.factory.wrapStatement(stmt);
    }

    protected Statement createStatementImpl(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.con.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.con.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData dmd = this.getMetaDataImpl();
        if (null == dmd) {
            return dmd;
        }
        return this.factory.wrapDatabaseMetadata(dmd);
    }

    protected DatabaseMetaData getMetaDataImpl() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.con.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cstmt = this.prepareCallImpl(sql);
        if (null == cstmt) {
            return cstmt;
        }
        return this.factory.wrapCallableStatement(cstmt);
    }

    protected CallableStatement prepareCallImpl(String sql) throws SQLException {
        return this.con.prepareCall(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cstmt = this.prepareCallImpl(sql, resultSetType, resultSetConcurrency);
        if (null == cstmt) {
            return cstmt;
        }
        return this.factory.wrapCallableStatement(cstmt);
    }

    protected CallableStatement prepareCallImpl(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cstmt = this.prepareCallImpl(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (null == cstmt) {
            return cstmt;
        }
        return this.factory.wrapCallableStatement(cstmt);
    }

    protected CallableStatement prepareCallImpl(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql) throws SQLException {
        return this.con.prepareStatement(sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql, autoGeneratedKeys);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql, int autoGeneratedKeys) throws SQLException {
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql, columnIndexes);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql, int[] columnIndexes) throws SQLException {
        return this.con.prepareStatement(sql, columnIndexes);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql, columnNames);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql, String[] columnNames) throws SQLException {
        return this.con.prepareStatement(sql, columnNames);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql, resultSetType, resultSetConcurrency);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = this.prepareStatementImpl(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (null == pstmt) {
            return pstmt;
        }
        return this.factory.wrapPreparedStatement(pstmt);
    }

    protected PreparedStatement prepareStatementImpl(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.con.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.con.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.con.unwrap(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQueryPlan(String query) throws SQLException {
        StringBuilder plan = new StringBuilder();
        String queryPlanSQL = this.findProperty(QUERY_PLAN_SQL_KEY);
        String formatter = null;
        int column = 1;
        if (queryPlanSQL != null) {
            String temp = this.findProperty(QUERY_PLAN_COLUMN_KEY);
            if (temp != null) {
                column = Integer.parseInt(temp);
            }
            if ((formatter = this.findProperty(QUERY_PLAN_FORMATTER_KEY)) == null) {
                formatter = DEFAULT_QUERY_PLAN_FORMATTER;
            }
            Statement stmt = null;
            ResultSet result = null;
            try {
                stmt = this.getConnection().createStatement();
                result = stmt.executeQuery(String.format(queryPlanSQL, query));
                while (result.next()) {
                    plan.append(String.format(formatter, result.getString(column)));
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return plan.toString();
    }

    @Override
    public String getSubType() {
        return this.factory.getSubType();
    }

    @Override
    public Map<String, Object> getExtraInformation() {
        if (this.extraInformation == null) {
            this.extraInformation = new HashMap<String, Object>();
            this.getSubminorVersion();
            this.checkConnectionBlacklist();
            this.checkConnectionGreylist();
            this.extraInformation.put("dbsubtype", this.getSubType());
        }
        return this.extraInformation;
    }

    private void checkConnectionBlacklist() {
        this.checkConnectionVersionInfo(DRIVER_VERSION_BLACKLIST_KEY, DRIVER_VERSION_TEXT_BLACKLIST_KEY, DRIVER_NAME_BLACKLIST_KEY, "blacklistDriver", SERVER_VERSION_BLACKLIST_KEY, SERVER_VERSION_TEXT_BLACKLIST_KEY, SERVER_NAME_BLACKLIST_KEY, "blacklistServer");
    }

    private void checkConnectionGreylist() {
        this.checkConnectionVersionInfo(DRIVER_VERSION_GREYLIST_KEY, DRIVER_VERSION_TEXT_GREYLIST_KEY, DRIVER_NAME_GREYLIST_KEY, "greylistDriver", SERVER_VERSION_GREYLIST_KEY, SERVER_VERSION_TEXT_GREYLIST_KEY, SERVER_NAME_GREYLIST_KEY, "greylistServer");
    }

    private void checkConnectionVersionInfo(String driverVersionKey, String driverVersionTextKey, String driverNameKey, String infoDriverKey, String serverVersionKey, String serverVersionTextKey, String serverNameKey, String infoServerKey) {
        block25: {
            String[] info = null;
            try {
                String text2;
                DatabaseMetaData metadata = this.getMetaData();
                String patternString = this.findProperty(driverVersionKey);
                if (patternString != null && (text2 = String.valueOf(metadata.getDriverMajorVersion()) + "." + String.valueOf(metadata.getDriverMinorVersion())).matches(patternString)) {
                    info = new String[]{text2, driverVersionKey};
                    this.extraInformation.put(infoDriverKey, info);
                }
                if ((patternString = this.findProperty(driverVersionTextKey)) != null) {
                    try {
                        text2 = metadata.getDriverVersion();
                        if (text2 != null && text2.matches(patternString)) {
                            info = new String[]{text2, driverVersionTextKey};
                            this.extraInformation.put(infoDriverKey, info);
                        }
                    }
                    catch (SQLException text2) {
                        // empty catch block
                    }
                }
                if ((patternString = this.findProperty(driverNameKey)) != null) {
                    try {
                        text2 = metadata.getDriverName();
                        if (text2 != null && text2.matches(patternString)) {
                            info = new String[]{text2, driverNameKey};
                            this.extraInformation.put(infoDriverKey, info);
                        }
                    }
                    catch (SQLException text3) {
                        // empty catch block
                    }
                }
                if ((patternString = this.findProperty(serverVersionKey)) != null) {
                    try {
                        text2 = String.valueOf(metadata.getDatabaseMajorVersion()) + "." + String.valueOf(metadata.getDatabaseMinorVersion());
                        if (text2.matches(patternString)) {
                            info = new String[]{text2, serverVersionKey};
                            this.extraInformation.put(infoServerKey, info);
                        } else {
                            String subminorVersion = null;
                            if (this.extraInformation.containsKey("dbSubminorVersion")) {
                                subminorVersion = (String)this.extraInformation.get("dbSubminorVersion");
                            }
                            if (subminorVersion != null && (text2 = text2 + "." + subminorVersion).matches(patternString)) {
                                info = new String[]{text2, serverVersionKey};
                                this.extraInformation.put(infoServerKey, info);
                            }
                        }
                    }
                    catch (SQLException text4) {
                        // empty catch block
                    }
                }
                if ((patternString = this.findProperty(serverVersionTextKey)) != null) {
                    try {
                        text2 = metadata.getDatabaseProductVersion();
                        if (text2 != null && text2.matches(patternString)) {
                            info = new String[3];
                            info[0] = text2;
                            info[1] = serverVersionTextKey;
                            this.extraInformation.put(infoServerKey, info);
                        }
                    }
                    catch (SQLException text5) {
                        // empty catch block
                    }
                }
                if ((patternString = this.findProperty(serverNameKey)) == null) break block25;
                try {
                    text2 = metadata.getDatabaseProductName();
                    if (text2 != null && text2.matches(patternString)) {
                        info = new String[]{text2, serverNameKey};
                        this.extraInformation.put(infoServerKey, info);
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    private void getSubminorVersion() {
        try {
            String drVersion;
            String[] tokens;
            DatabaseMetaData metadata = this.getMetaData();
            String productVersion = this.findProperty(DATABASE_PRODUCT_VERSION_TEXT_KEY);
            if (productVersion != null) {
                String[] parts = productVersion.split("::");
                String patternString = parts[0];
                int indexOfSubminorVersion = Integer.parseInt(parts[1]);
                if (patternString != null) {
                    String databaseProductVersion = String.valueOf(metadata.getDatabaseProductVersion());
                    Pattern pattern = Pattern.compile(patternString);
                    Matcher matcher = pattern.matcher(databaseProductVersion);
                    if (matcher.find()) {
                        try {
                            this.extraInformation.put("dbSubminorVersion", matcher.group(indexOfSubminorVersion));
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    }
                }
            } else {
                String databaseProductVersion = metadata.getDatabaseProductVersion();
                tokens = databaseProductVersion.split("\\.");
                if (tokens.length > 2) {
                    try {
                        Integer.parseInt(tokens[2]);
                        this.extraInformation.put("dbSubminorVersion", tokens[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((tokens = (drVersion = metadata.getDriverVersion()).split("\\.")).length > 2) {
                try {
                    Integer.parseInt(tokens[2]);
                    this.extraInformation.put("driverSubminorVersion", tokens[2]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void switchUser(Boolean isSessionStart, String useID, String passWd, String registry) throws SQLException {
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public void setConnectionAttributes(Properties attributes) throws SQLException {
        this.attributeSetter.setAttributes(this.getConnection(), attributes);
    }

    @Override
    public SQLException processSQLException(SQLException t) {
        return this.factory.processSQLException(t);
    }

    @Override
    public void startTrace(Handler handler, boolean identify, String interfaceFilterRegex) {
        this.stopTrace();
        handler.setLevel(Level.ALL);
        this.logger = Logger.getAnonymousLogger();
        this.logger.addHandler(handler);
        this.logger.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        if (identify) {
            try {
                DatabaseMetaData dmd = this.con.getMetaData();
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDatabaseMajorVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDatabaseMinorVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDatabaseProductName"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDatabaseProductVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDriverName"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDriverVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDriverMajorVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDriverMinorVersion"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getDriverName"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getURL"));
                this.logger.info(this.makeLogInfo(dmd, DatabaseMetaData.class, "getUserName"));
            }
            catch (Throwable t) {
                this.logger.info("Cannot get DatabaseMetaData object");
            }
        }
        try {
            Connection proxy = (Connection)LoggingProxyBuilder.getProxy(this.logger, Pattern.compile(JDBC_INTERFACES_FILTER), Pattern.compile(interfaceFilterRegex), this.con);
            this.proxiedCon = this.con;
            this.con = proxy;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stopTrace() {
        if (this.isTracing()) {
            this.logger.info("tracing stopped");
            this.con = this.proxiedCon;
            this.proxiedCon = null;
            for (Handler h : this.logger.getHandlers()) {
                h.flush();
            }
            this.logger.setLevel(Level.OFF);
            this.logger = null;
        }
    }

    @Override
    public boolean isTracing() {
        return this.proxiedCon != null;
    }

    private String makeLogInfo(Object o, Class<?> c, String methodName) {
        String result;
        try {
            Method m = c.getMethod(methodName, new Class[0]);
            result = String.valueOf(m.invoke(o, new Object[0]));
        }
        catch (Exception e) {
            result = "THROW: " + e.getMessage();
        }
        return methodName + "=" + result;
    }

    @Override
    public List<String> getQualifierList() {
        return this.qualifierList;
    }

    @Override
    public void setQualifierList(List<String> qList) {
        this.qualifierList = qList;
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    public void setTunnelSession(TunnelSession tunnelSeesion) {
        this.tunnelSeesion = tunnelSeesion;
    }

    public static final class Wrapper
    implements IWrapper {
        @Override
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new BaseConnectionAdaptor((Connection)toWrap, factory);
        }
    }

    private static final class DummyAttributeSetter
    implements IConnectionAttributeSetter {
        private DummyAttributeSetter() {
        }

        @Override
        public void setAttributes(Connection cnx, Properties attributes) throws SQLException {
        }
    }
}

