/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.EmptyResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.ibm.cognos.jdbc.adaptor.resultset.MetadataResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseDatabaseMetadataAdaptor
extends AbstractAdaptor
implements IAdaptorDBMetadata {
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    protected DatabaseMetaData dmd;
    public static final String TABLETYPE_KEY = "tabletype.%1$s";
    public static final String OIDC_KEY = "oidc.%1$s";

    public BaseDatabaseMetadataAdaptor(DatabaseMetaData raw, AdaptorFactory adaptorFactory) {
        super(adaptorFactory);
        this.dmd = raw;
    }

    @Override
    public final boolean allProceduresAreCallable() throws SQLException {
        Boolean value = this.checkOverrideBoolean("allProceduresAreCallable", new Object[0]);
        if (value == null) {
            value = this.allProceduresAreCallableImpl();
        }
        return value;
    }

    protected boolean allProceduresAreCallableImpl() throws SQLException {
        return this.dmd.allProceduresAreCallable();
    }

    @Override
    public final boolean allTablesAreSelectable() throws SQLException {
        Boolean value = this.checkOverrideBoolean("allTablesAreSelectable", new Object[0]);
        if (value == null) {
            value = this.allTablesAreSelectableImpl();
        }
        return value;
    }

    protected boolean allTablesAreSelectableImpl() throws SQLException {
        return this.dmd.allTablesAreSelectable();
    }

    @Override
    public final boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        Boolean value = this.checkOverrideBoolean("autoCommitFailureClosesAllResultSets", new Object[0]);
        if (value == null) {
            value = this.autoCommitFailureClosesAllResultSetsImpl();
        }
        return value;
    }

    protected boolean autoCommitFailureClosesAllResultSetsImpl() throws SQLException {
        return this.dmd.autoCommitFailureClosesAllResultSets();
    }

    @Override
    public final boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Boolean value = this.checkOverrideBoolean("dataDefinitionCausesTransactionCommit", new Object[0]);
        if (value == null) {
            value = this.dataDefinitionCausesTransactionCommitImpl();
        }
        return value;
    }

    protected boolean dataDefinitionCausesTransactionCommitImpl() throws SQLException {
        return this.dmd.dataDefinitionCausesTransactionCommit();
    }

    @Override
    public final boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("dataDefinitionIgnoredInTransactions", new Object[0]);
        if (value == null) {
            value = this.dataDefinitionIgnoredInTransactionsImpl();
        }
        return value;
    }

    protected boolean dataDefinitionIgnoredInTransactionsImpl() throws SQLException {
        return this.dmd.dataDefinitionIgnoredInTransactions();
    }

    @Override
    public final boolean deletesAreDetected(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("deletesAreDetected", type);
        if (value == null) {
            value = this.deletesAreDetectedImpl(type);
        }
        return value;
    }

    protected boolean deletesAreDetectedImpl(int type) throws SQLException {
        return this.dmd.deletesAreDetected(type);
    }

    @Override
    public final boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Boolean value = this.checkOverrideBoolean("doesMaxRowSizeIncludeBlobs", new Object[0]);
        if (value == null) {
            value = this.doesMaxRowSizeIncludeBlobsImpl();
        }
        return value;
    }

    protected boolean doesMaxRowSizeIncludeBlobsImpl() throws SQLException {
        return this.dmd.doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public final ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        if (null == rs) {
            rs = this.getAttributesImpl(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getAttributes"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getAttributesImpl(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.dmd.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public final ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getBestRowIdentifier", catalog, schema, table, scope, nullable);
        if (null == rs) {
            rs = this.getBestRowIdentifierImpl(catalog, schema, table, scope, nullable);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getBestRowIdentifier"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getBestRowIdentifierImpl(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.dmd.getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    @Override
    public final String getCatalogSeparator() throws SQLException {
        String value = this.checkOverrideString("getCatalogSeparator", new Object[0]);
        if (value == null) {
            value = this.getCatalogSeparatorImpl();
        }
        return value;
    }

    protected String getCatalogSeparatorImpl() throws SQLException {
        return this.dmd.getCatalogSeparator();
    }

    @Override
    public final String getCatalogTerm() throws SQLException {
        String value = this.checkOverrideString("getCatalogTerm", new Object[0]);
        if (value == null) {
            value = this.getCatalogTermImpl();
        }
        return value;
    }

    protected String getCatalogTermImpl() throws SQLException {
        return this.dmd.getCatalogTerm();
    }

    @Override
    public final ResultSet getCatalogs() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getCatalogs", new Object[0]);
        if (null == rs) {
            rs = this.getCatalogsImpl();
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getCatalogs"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getCatalogsImpl() throws SQLException {
        return this.dmd.getCatalogs();
    }

    @Override
    public final ResultSet getClientInfoProperties() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getClientInfoProperties", new Object[0]);
        if (null == rs) {
            rs = this.getClientInfoPropertiesImpl();
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getClientInfoProperties"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getClientInfoPropertiesImpl() throws SQLException {
        return this.dmd.getClientInfoProperties();
    }

    @Override
    public final ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getColumnPrivileges", catalog, schema, table, columnNamePattern);
        if (null == rs) {
            rs = this.getColumnPrivilegesImpl(catalog, schema, table, columnNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getColumnPrivileges"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getColumnPrivilegesImpl(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.dmd.getColumnPrivileges(catalog, schema, table, columnNamePattern);
    }

    @Override
    public final ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        if (null == rs) {
            rs = this.getColumnsImpl(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getColumns"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getColumnsImpl(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public final ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        if (null == rs) {
            rs = this.getCrossReferenceImpl(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getCrossReference"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getCrossReferenceImpl(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.dmd.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public final int getDatabaseMajorVersion() throws SQLException {
        Integer value = (Integer)this.getFirstObjectFromSqlStatement("getDatabaseMajorVersion", new Object[0]);
        if (value == null) {
            value = this.getDatabaseMajorVersionImpl();
        }
        return value;
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        try {
            return this.dmd.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            return this.getDatabaseVersionFromProductVersionText()[0];
        }
    }

    @Override
    public final int getDatabaseMinorVersion() throws SQLException {
        Integer value = (Integer)this.getFirstObjectFromSqlStatement("getDatabaseMinorVersion", new Object[0]);
        if (value == null) {
            value = this.getDatabaseMinorVersionImpl();
        }
        return value;
    }

    protected int getDatabaseMinorVersionImpl() throws SQLException {
        try {
            return this.dmd.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            return this.getDatabaseVersionFromProductVersionText()[1];
        }
    }

    protected int[] getDatabaseVersionFromProductVersionText() throws SQLException {
        int[] version = new int[2];
        try {
            Pattern pattern;
            Matcher matcher;
            String databaseProductVersion = this.dmd.getDatabaseProductVersion();
            String[] parts = this.findProperty("databaseProductVersionText").split("::");
            String patternString = parts[0];
            if (patternString != null && (matcher = (pattern = Pattern.compile(patternString)).matcher(databaseProductVersion)).find()) {
                version[0] = Integer.parseInt(matcher.group(1));
                version[1] = Integer.parseInt(matcher.group(2));
                return version;
            }
            String[] tokens = databaseProductVersion.split("\\.");
            if (tokens.length > 1) {
                version[0] = Integer.parseInt(tokens[0]);
                version[1] = Integer.parseInt(tokens[1]);
                return version;
            }
            throw new SQLException("Can not get db version by parsing the product version");
        }
        catch (Exception e) {
            throw new SQLException("Can not get db version", e);
        }
    }

    @Override
    public final String getDatabaseProductName() throws SQLException {
        String value = this.checkOverrideString("getDatabaseProductName", new Object[0]);
        if (value == null) {
            value = this.getDatabaseProductNameImpl();
        }
        return value;
    }

    protected String getDatabaseProductNameImpl() throws SQLException {
        return this.dmd.getDatabaseProductName();
    }

    @Override
    public final String getDatabaseProductVersion() throws SQLException {
        String value = this.checkOverrideString("getDatabaseProductVersion", new Object[0]);
        if (value == null) {
            value = this.getDatabaseProductVersionImpl();
        }
        return value;
    }

    protected String getDatabaseProductVersionImpl() throws SQLException {
        return this.dmd.getDatabaseProductVersion();
    }

    @Override
    public final int getDefaultTransactionIsolation() throws SQLException {
        Integer value = this.checkOverrideInteger("getDefaultTransactionIsolation", new Object[0]);
        if (value == null) {
            value = this.getDefaultTransactionIsolationImpl();
        }
        return value;
    }

    protected int getDefaultTransactionIsolationImpl() throws SQLException {
        return this.dmd.getDefaultTransactionIsolation();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.dmd.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.dmd.getDriverMinorVersion();
    }

    @Override
    public final String getDriverName() throws SQLException {
        String value = this.checkOverrideString("getDriverName", new Object[0]);
        if (value == null) {
            value = this.getDriverNameImpl();
        }
        return value;
    }

    protected String getDriverNameImpl() throws SQLException {
        return this.dmd.getDriverName();
    }

    @Override
    public final String getDriverVersion() throws SQLException {
        String value = this.checkOverrideString("getDriverVersion", new Object[0]);
        if (value == null) {
            value = this.getDriverVersionImpl();
        }
        return value;
    }

    protected String getDriverVersionImpl() throws SQLException {
        return this.dmd.getDriverVersion();
    }

    @Override
    public final ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getExportedKeys", catalog, schema, table);
        if (null == rs) {
            rs = this.getExportedKeysImpl(catalog, schema, table);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getExportedKeys"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getExportedKeysImpl(String catalog, String schema, String table) throws SQLException {
        return this.dmd.getExportedKeys(catalog, schema, table);
    }

    @Override
    public final String getExtraNameCharacters() throws SQLException {
        String value = this.checkOverrideString("getExtraNameCharacters", new Object[0]);
        if (value == null) {
            value = this.getExtraNameCharactersImpl();
        }
        return value;
    }

    protected String getExtraNameCharactersImpl() throws SQLException {
        return this.dmd.getExtraNameCharacters();
    }

    @Override
    public final String getIdentifierQuoteString() throws SQLException {
        String value = this.checkOverrideString("getIdentifierQuoteString", new Object[0]);
        if (value == null) {
            value = this.getIdentifierQuoteStringImpl();
        }
        return value;
    }

    protected String getIdentifierQuoteStringImpl() throws SQLException {
        return this.dmd.getIdentifierQuoteString();
    }

    @Override
    public final ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getImportedKeys", catalog, schema, table);
        if (null == rs) {
            rs = this.getImportedKeysImpl(catalog, schema, table);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getImportedKeys"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getImportedKeysImpl(String catalog, String schema, String table) throws SQLException {
        return this.dmd.getImportedKeys(catalog, schema, table);
    }

    @Override
    public final ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getIndexInfo", catalog, schema, table, unique, approximate);
        if (null == rs) {
            rs = this.getIndexInfoImpl(catalog, schema, table, unique, approximate);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getIndexInfo"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getIndexInfoImpl(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.dmd.getIndexInfo(catalog, schema, table, unique, approximate);
    }

    @Override
    public final int getJDBCMajorVersion() throws SQLException {
        Integer value = this.checkOverrideInteger("getJDBCMajorVersion", new Object[0]);
        if (value == null) {
            value = this.getJDBCMajorVersionImpl();
        }
        return value;
    }

    protected int getJDBCMajorVersionImpl() throws SQLException {
        return this.dmd.getJDBCMajorVersion();
    }

    @Override
    public final int getJDBCMinorVersion() throws SQLException {
        Integer value = this.checkOverrideInteger("getJDBCMinorVersion", new Object[0]);
        if (value == null) {
            value = this.getJDBCMinorVersionImpl();
        }
        return value;
    }

    protected int getJDBCMinorVersionImpl() throws SQLException {
        return this.dmd.getJDBCMinorVersion();
    }

    @Override
    public final int getMaxBinaryLiteralLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxBinaryLiteralLength", new Object[0]);
        if (value == null) {
            value = this.getMaxBinaryLiteralLengthImpl();
        }
        return value;
    }

    protected int getMaxBinaryLiteralLengthImpl() throws SQLException {
        return this.dmd.getMaxBinaryLiteralLength();
    }

    @Override
    public final int getMaxCatalogNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxCatalogNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxCatalogNameLengthImpl();
        }
        return value;
    }

    protected int getMaxCatalogNameLengthImpl() throws SQLException {
        return this.dmd.getMaxCatalogNameLength();
    }

    @Override
    public final int getMaxCharLiteralLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxCharLiteralLength", new Object[0]);
        if (value == null) {
            value = this.getMaxCharLiteralLengthImpl();
        }
        return value;
    }

    protected int getMaxCharLiteralLengthImpl() throws SQLException {
        return this.dmd.getMaxCharLiteralLength();
    }

    @Override
    public final int getMaxColumnNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnNameLengthImpl();
        }
        return value;
    }

    protected int getMaxColumnNameLengthImpl() throws SQLException {
        return this.dmd.getMaxColumnNameLength();
    }

    @Override
    public final int getMaxColumnsInGroupBy() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnsInGroupBy", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnsInGroupByImpl();
        }
        return value;
    }

    protected int getMaxColumnsInGroupByImpl() throws SQLException {
        return this.dmd.getMaxColumnsInGroupBy();
    }

    @Override
    public final int getMaxColumnsInIndex() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnsInIndex", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnsInIndexImpl();
        }
        return value;
    }

    protected int getMaxColumnsInIndexImpl() throws SQLException {
        return this.dmd.getMaxColumnsInIndex();
    }

    @Override
    public final int getMaxColumnsInOrderBy() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnsInOrderBy", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnsInOrderByImpl();
        }
        return value;
    }

    protected int getMaxColumnsInOrderByImpl() throws SQLException {
        return this.dmd.getMaxColumnsInOrderBy();
    }

    @Override
    public final int getMaxColumnsInSelect() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnsInSelect", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnsInSelectImpl();
        }
        return value;
    }

    protected int getMaxColumnsInSelectImpl() throws SQLException {
        return this.dmd.getMaxColumnsInSelect();
    }

    @Override
    public final int getMaxColumnsInTable() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxColumnsInTable", new Object[0]);
        if (value == null) {
            value = this.getMaxColumnsInTableImpl();
        }
        return value;
    }

    protected int getMaxColumnsInTableImpl() throws SQLException {
        return this.dmd.getMaxColumnsInTable();
    }

    @Override
    public final int getMaxConnections() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxConnections", new Object[0]);
        if (value == null) {
            value = this.getMaxConnectionsImpl();
        }
        return value;
    }

    protected int getMaxConnectionsImpl() throws SQLException {
        return this.dmd.getMaxConnections();
    }

    @Override
    public final int getMaxCursorNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxCursorNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxCursorNameLengthImpl();
        }
        return value;
    }

    protected int getMaxCursorNameLengthImpl() throws SQLException {
        return this.dmd.getMaxCursorNameLength();
    }

    @Override
    public final int getMaxIndexLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxIndexLength", new Object[0]);
        if (value == null) {
            value = this.getMaxIndexLengthImpl();
        }
        return value;
    }

    protected int getMaxIndexLengthImpl() throws SQLException {
        return this.dmd.getMaxIndexLength();
    }

    @Override
    public final int getMaxProcedureNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxProcedureNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxProcedureNameLengthImpl();
        }
        return value;
    }

    protected int getMaxProcedureNameLengthImpl() throws SQLException {
        return this.dmd.getMaxProcedureNameLength();
    }

    @Override
    public final int getMaxRowSize() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxRowSize", new Object[0]);
        if (value == null) {
            value = this.getMaxRowSizeImpl();
        }
        return value;
    }

    protected int getMaxRowSizeImpl() throws SQLException {
        return this.dmd.getMaxRowSize();
    }

    @Override
    public final int getMaxSchemaNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxSchemaNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxSchemaNameLengthImpl();
        }
        return value;
    }

    protected int getMaxSchemaNameLengthImpl() throws SQLException {
        return this.dmd.getMaxSchemaNameLength();
    }

    @Override
    public final int getMaxStatementLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxStatementLength", new Object[0]);
        if (value == null) {
            value = this.getMaxStatementLengthImpl();
        }
        return value;
    }

    protected int getMaxStatementLengthImpl() throws SQLException {
        return this.dmd.getMaxStatementLength();
    }

    @Override
    public final int getMaxStatements() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxStatements", new Object[0]);
        if (value == null) {
            value = this.getMaxStatementsImpl();
        }
        return value;
    }

    protected int getMaxStatementsImpl() throws SQLException {
        return this.dmd.getMaxStatements();
    }

    @Override
    public final int getMaxTableNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxTableNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxTableNameLengthImpl();
        }
        return value;
    }

    protected int getMaxTableNameLengthImpl() throws SQLException {
        return this.dmd.getMaxTableNameLength();
    }

    @Override
    public final int getMaxTablesInSelect() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxTablesInSelect", new Object[0]);
        if (value == null) {
            value = this.getMaxTablesInSelectImpl();
        }
        return value;
    }

    protected int getMaxTablesInSelectImpl() throws SQLException {
        return this.dmd.getMaxTablesInSelect();
    }

    @Override
    public final int getMaxUserNameLength() throws SQLException {
        Integer value = this.checkOverrideInteger("getMaxUserNameLength", new Object[0]);
        if (value == null) {
            value = this.getMaxUserNameLengthImpl();
        }
        return value;
    }

    protected int getMaxUserNameLengthImpl() throws SQLException {
        return this.dmd.getMaxUserNameLength();
    }

    @Override
    public final String getNumericFunctions() throws SQLException {
        String value = this.checkOverrideString("getNumericFunctions", new Object[0]);
        if (value == null) {
            value = this.getNumericFunctionsImpl();
        }
        return value;
    }

    protected String getNumericFunctionsImpl() throws SQLException {
        return this.dmd.getNumericFunctions();
    }

    @Override
    public final ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getPrimaryKeys", catalog, schema, table);
        if (null == rs) {
            rs = this.getPrimaryKeysImpl(catalog, schema, table);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getPrimaryKeys"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getPrimaryKeysImpl(String catalog, String schema, String table) throws SQLException {
        return this.dmd.getPrimaryKeys(catalog, schema, table);
    }

    @Override
    public final ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        if (null == rs) {
            rs = this.getProcedureColumnsImpl(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getProcedureColumns"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getProcedureColumnsImpl(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.dmd.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public final String getProcedureTerm() throws SQLException {
        String value = this.checkOverrideString("getProcedureTerm", new Object[0]);
        if (value == null) {
            value = this.getProcedureTermImpl();
        }
        return value;
    }

    protected String getProcedureTermImpl() throws SQLException {
        return this.dmd.getProcedureTerm();
    }

    @Override
    public final ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getProcedures", catalog, schemaPattern, procedureNamePattern);
        if (null == rs) {
            rs = this.getProceduresImpl(catalog, schemaPattern, procedureNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getProcedures"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getProceduresImpl(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.dmd.getProcedures(catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        Integer value = this.checkOverrideInteger("getResultSetHoldability", new Object[0]);
        if (value == null) {
            value = this.getResultSetHoldabilityImpl();
        }
        return value;
    }

    protected int getResultSetHoldabilityImpl() throws SQLException {
        return this.dmd.getResultSetHoldability();
    }

    @Override
    public final RowIdLifetime getRowIdLifetime() throws SQLException {
        RowIdLifetime value = this.checkOverrideRowIdLifeTime("getRowIdLifetime", new Object[0]);
        if (value == null) {
            value = this.getRowIdLifetimeImpl();
        }
        return value;
    }

    protected RowIdLifetime getRowIdLifetimeImpl() throws SQLException {
        return this.dmd.getRowIdLifetime();
    }

    @Override
    public final String getSQLKeywords() throws SQLException {
        String value = this.checkOverrideString("getSQLKeywords", new Object[0]);
        if (value == null) {
            value = this.getSQLKeywordsImpl();
        }
        return value;
    }

    protected String getSQLKeywordsImpl() throws SQLException {
        return this.dmd.getSQLKeywords();
    }

    @Override
    public final int getSQLStateType() throws SQLException {
        Integer value = this.checkOverrideInteger("getSQLStateType", new Object[0]);
        if (value == null) {
            value = this.getSQLStateTypeImpl();
        }
        return value;
    }

    protected int getSQLStateTypeImpl() throws SQLException {
        return this.dmd.getSQLStateType();
    }

    @Override
    public final String getSchemaTerm() throws SQLException {
        String value = this.checkOverrideString("getSchemaTerm", new Object[0]);
        if (value == null) {
            value = this.getSchemaTermImpl();
        }
        return value;
    }

    protected String getSchemaTermImpl() throws SQLException {
        return this.dmd.getSchemaTerm();
    }

    @Override
    public final ResultSet getSchemas() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getSchemas", new Object[0]);
        if (null == rs) {
            rs = this.getSchemasImpl();
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSchemas"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getSchemasImpl() throws SQLException {
        return this.dmd.getSchemas();
    }

    @Override
    public final ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getSchemas", catalog, schemaPattern);
        if (null == rs) {
            rs = this.getSchemasImpl(catalog, schemaPattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSchemas"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getSchemasImpl(String catalog, String schemaPattern) throws SQLException {
        if (this.dmd.getJDBCMajorVersion() < 4) {
            return this.dmd.getSchemas();
        }
        try {
            return this.dmd.getSchemas(catalog, schemaPattern);
        }
        catch (SQLException e) {
            return this.dmd.getSchemas();
        }
    }

    @Override
    public final String getSearchStringEscape() throws SQLException {
        String value = this.checkOverrideString("getSearchStringEscape", new Object[0]);
        if (value == null) {
            value = this.getSearchStringEscapeImpl();
        }
        return value;
    }

    protected String getSearchStringEscapeImpl() throws SQLException {
        return this.dmd.getSearchStringEscape();
    }

    @Override
    public final String getStringFunctions() throws SQLException {
        String value = this.checkOverrideString("getStringFunctions", new Object[0]);
        if (value == null) {
            value = this.getStringFunctionsImpl();
        }
        return value;
    }

    protected String getStringFunctionsImpl() throws SQLException {
        return this.dmd.getStringFunctions();
    }

    @Override
    public final ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getSuperTables", catalog, schemaPattern, tableNamePattern);
        if (null == rs) {
            rs = this.getSuperTablesImpl(catalog, schemaPattern, tableNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSuperTables"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getSuperTablesImpl(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.dmd.getSuperTables(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public final ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getSuperTypes", catalog, schemaPattern, typeNamePattern);
        if (null == rs) {
            rs = this.getSuperTypesImpl(catalog, schemaPattern, typeNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSuperTypes"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getSuperTypesImpl(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.dmd.getSuperTypes(catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public final String getSystemFunctions() throws SQLException {
        String value = this.checkOverrideString("getSystemFunctions", new Object[0]);
        if (value == null) {
            value = this.getSystemFunctionsImpl();
        }
        return value;
    }

    protected String getSystemFunctionsImpl() throws SQLException {
        return this.dmd.getSystemFunctions();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getTablePrivileges", catalog, schemaPattern, tableNamePattern);
        if (null == rs) {
            rs = this.getTablePrivilegesImpl(catalog, schemaPattern, tableNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getTablePrivileges"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected final ResultSet getTablePrivilegesImpl(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.dmd.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public final ResultSet getTableTypes() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getTableTypes", new Object[0]);
        if (null == rs) {
            rs = this.getTableTypesImpl();
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getTableTypes"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getTableTypesImpl() throws SQLException {
        return this.dmd.getTableTypes();
    }

    @Override
    public final ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getTables", catalog, schemaPattern, tableNamePattern, types);
        if (null == rs) {
            rs = this.getTablesImpl(catalog, schemaPattern, tableNamePattern, types);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getTables"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getTablesImpl(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.dmd.getTables(catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public final String getTimeDateFunctions() throws SQLException {
        String value = this.checkOverrideString("getTimeDateFunctions", new Object[0]);
        if (value == null) {
            value = this.getTimeDateFunctionsImpl();
        }
        return value;
    }

    protected String getTimeDateFunctionsImpl() throws SQLException {
        return this.dmd.getTimeDateFunctions();
    }

    @Override
    public final ResultSet getTypeInfo() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getTypeInfo", new Object[0]);
        if (null == rs) {
            rs = this.getTypeInfoImpl();
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getTypeInfo"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getTypeInfoImpl() throws SQLException {
        return this.dmd.getTypeInfo();
    }

    @Override
    public final ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getUDTs", catalog, schemaPattern, typeNamePattern, types);
        if (null == rs) {
            rs = this.getUDTsImpl(catalog, schemaPattern, typeNamePattern, types);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getUDTs"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getUDTsImpl(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.dmd.getUDTs(catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public final String getURL() throws SQLException {
        String value = this.checkOverrideString("getURL", new Object[0]);
        if (value == null) {
            value = this.getURLImpl();
        }
        return value;
    }

    protected String getURLImpl() throws SQLException {
        return this.dmd.getURL();
    }

    @Override
    public final String getUserName() throws SQLException {
        String value = this.checkOverrideString("getUserName", new Object[0]);
        if (value == null) {
            value = this.getUserNameImpl();
        }
        return value;
    }

    protected String getUserNameImpl() throws SQLException {
        return this.dmd.getUserName();
    }

    @Override
    public final ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getVersionColumns", catalog, schema, table);
        if (null == rs) {
            rs = this.getVersionColumnsImpl(catalog, schema, table);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getVersionColumns"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getVersionColumnsImpl(String catalog, String schema, String table) throws SQLException {
        return this.dmd.getVersionColumns(catalog, schema, table);
    }

    @Override
    public final boolean insertsAreDetected(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("insertsAreDetected", type);
        if (value == null) {
            value = this.insertsAreDetectedImpl(type);
        }
        return value;
    }

    protected boolean insertsAreDetectedImpl(int type) throws SQLException {
        return this.dmd.insertsAreDetected(type);
    }

    @Override
    public final boolean isCatalogAtStart() throws SQLException {
        Boolean value = this.checkOverrideBoolean("isCatalogAtStart", new Object[0]);
        if (value == null) {
            value = this.isCatalogAtStartImpl();
        }
        return value;
    }

    protected boolean isCatalogAtStartImpl() throws SQLException {
        return this.dmd.isCatalogAtStart();
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        Boolean value = this.checkOverrideBoolean("isReadOnly", new Object[0]);
        if (value == null) {
            value = this.isReadOnlyImpl();
        }
        return value;
    }

    protected boolean isReadOnlyImpl() throws SQLException {
        return this.dmd.isReadOnly();
    }

    @Override
    public final boolean locatorsUpdateCopy() throws SQLException {
        Boolean value = this.checkOverrideBoolean("locatorsUpdateCopy", new Object[0]);
        if (value == null) {
            value = this.locatorsUpdateCopyImpl();
        }
        return value;
    }

    protected boolean locatorsUpdateCopyImpl() throws SQLException {
        return this.dmd.locatorsUpdateCopy();
    }

    @Override
    public final boolean nullPlusNonNullIsNull() throws SQLException {
        Boolean value = this.checkOverrideBoolean("nullPlusNonNullIsNull", new Object[0]);
        if (value == null) {
            value = this.nullPlusNonNullIsNullImpl();
        }
        return value;
    }

    protected boolean nullPlusNonNullIsNullImpl() throws SQLException {
        return this.dmd.nullPlusNonNullIsNull();
    }

    @Override
    public final boolean nullsAreSortedAtEnd() throws SQLException {
        Boolean value = this.checkOverrideBoolean("nullsAreSortedAtEnd", new Object[0]);
        if (value == null) {
            value = this.nullsAreSortedAtEndImpl();
        }
        return value;
    }

    protected boolean nullsAreSortedAtEndImpl() throws SQLException {
        return this.dmd.nullsAreSortedAtEnd();
    }

    @Override
    public final boolean nullsAreSortedAtStart() throws SQLException {
        Boolean value = this.checkOverrideBoolean("nullsAreSortedAtStart", new Object[0]);
        if (value == null) {
            value = this.nullsAreSortedAtStartImpl();
        }
        return value;
    }

    protected boolean nullsAreSortedAtStartImpl() throws SQLException {
        return this.dmd.nullsAreSortedAtStart();
    }

    @Override
    public final boolean nullsAreSortedHigh() throws SQLException {
        Boolean value = this.checkOverrideBoolean("nullsAreSortedHigh", new Object[0]);
        if (value == null) {
            value = this.nullsAreSortedHighImpl();
        }
        return value;
    }

    protected boolean nullsAreSortedHighImpl() throws SQLException {
        return this.dmd.nullsAreSortedHigh();
    }

    @Override
    public final boolean nullsAreSortedLow() throws SQLException {
        Boolean value = this.checkOverrideBoolean("nullsAreSortedLow", new Object[0]);
        if (value == null) {
            value = this.nullsAreSortedLowImpl();
        }
        return value;
    }

    protected boolean nullsAreSortedLowImpl() throws SQLException {
        return this.dmd.nullsAreSortedLow();
    }

    @Override
    public final boolean othersDeletesAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("othersDeletesAreVisible", type);
        if (value == null) {
            value = this.othersDeletesAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean othersDeletesAreVisibleImpl(int type) throws SQLException {
        return this.dmd.othersDeletesAreVisible(type);
    }

    @Override
    public final boolean othersInsertsAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("othersInsertsAreVisible", type);
        if (value == null) {
            value = this.othersInsertsAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean othersInsertsAreVisibleImpl(int type) throws SQLException {
        return this.dmd.othersInsertsAreVisible(type);
    }

    @Override
    public final boolean othersUpdatesAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("othersUpdatesAreVisible", type);
        if (value == null) {
            value = this.othersUpdatesAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean othersUpdatesAreVisibleImpl(int type) throws SQLException {
        return this.dmd.othersUpdatesAreVisible(type);
    }

    @Override
    public final boolean ownDeletesAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("ownDeletesAreVisible", type);
        if (value == null) {
            value = this.ownDeletesAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean ownDeletesAreVisibleImpl(int type) throws SQLException {
        return this.dmd.ownDeletesAreVisible(type);
    }

    @Override
    public final boolean ownInsertsAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("ownInsertsAreVisible", type);
        if (value == null) {
            value = this.ownInsertsAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean ownInsertsAreVisibleImpl(int type) throws SQLException {
        return this.dmd.ownInsertsAreVisible(type);
    }

    @Override
    public final boolean ownUpdatesAreVisible(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("ownUpdatesAreVisible", type);
        if (value == null) {
            value = this.ownUpdatesAreVisibleImpl(type);
        }
        return value;
    }

    protected boolean ownUpdatesAreVisibleImpl(int type) throws SQLException {
        return this.dmd.ownUpdatesAreVisible(type);
    }

    @Override
    public final boolean storesLowerCaseIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesLowerCaseIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesLowerCaseIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesLowerCaseIdentifiersImpl() throws SQLException {
        return this.dmd.storesLowerCaseIdentifiers();
    }

    @Override
    public final boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesLowerCaseQuotedIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesLowerCaseQuotedIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesLowerCaseQuotedIdentifiersImpl() throws SQLException {
        return this.dmd.storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public final boolean storesMixedCaseIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesMixedCaseIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesMixedCaseIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesMixedCaseIdentifiersImpl() throws SQLException {
        return this.dmd.storesMixedCaseIdentifiers();
    }

    @Override
    public final boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesMixedCaseQuotedIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesMixedCaseQuotedIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesMixedCaseQuotedIdentifiersImpl() throws SQLException {
        return this.dmd.storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public final boolean storesUpperCaseIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesUpperCaseIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesUpperCaseIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesUpperCaseIdentifiersImpl() throws SQLException {
        return this.dmd.storesUpperCaseIdentifiers();
    }

    @Override
    public final boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("storesUpperCaseQuotedIdentifiers", new Object[0]);
        if (value == null) {
            value = this.storesUpperCaseQuotedIdentifiersImpl();
        }
        return value;
    }

    protected boolean storesUpperCaseQuotedIdentifiersImpl() throws SQLException {
        return this.dmd.storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public final boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsANSI92EntryLevelSQL", new Object[0]);
        if (value == null) {
            value = this.supportsANSI92EntryLevelSQLImpl();
        }
        return value;
    }

    protected boolean supportsANSI92EntryLevelSQLImpl() throws SQLException {
        return this.dmd.supportsANSI92EntryLevelSQL();
    }

    @Override
    public final boolean supportsANSI92FullSQL() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsANSI92FullSQL", new Object[0]);
        if (value == null) {
            value = this.supportsANSI92FullSQLImpl();
        }
        return value;
    }

    protected boolean supportsANSI92FullSQLImpl() throws SQLException {
        return this.dmd.supportsANSI92FullSQL();
    }

    @Override
    public final boolean supportsANSI92IntermediateSQL() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsANSI92IntermediateSQL", new Object[0]);
        if (value == null) {
            value = this.supportsANSI92IntermediateSQLImpl();
        }
        return value;
    }

    protected boolean supportsANSI92IntermediateSQLImpl() throws SQLException {
        return this.dmd.supportsANSI92IntermediateSQL();
    }

    @Override
    public final boolean supportsAlterTableWithAddColumn() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsAlterTableWithAddColumn", new Object[0]);
        if (value == null) {
            value = this.supportsAlterTableWithAddColumnImpl();
        }
        return value;
    }

    protected boolean supportsAlterTableWithAddColumnImpl() throws SQLException {
        return this.dmd.supportsAlterTableWithAddColumn();
    }

    @Override
    public final boolean supportsAlterTableWithDropColumn() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsAlterTableWithDropColumn", new Object[0]);
        if (value == null) {
            value = this.supportsAlterTableWithDropColumnImpl();
        }
        return value;
    }

    protected boolean supportsAlterTableWithDropColumnImpl() throws SQLException {
        return this.dmd.supportsAlterTableWithDropColumn();
    }

    @Override
    public final boolean supportsBatchUpdates() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsBatchUpdates", new Object[0]);
        if (value == null) {
            value = this.supportsBatchUpdatesImpl();
        }
        return value;
    }

    protected boolean supportsBatchUpdatesImpl() throws SQLException {
        return this.dmd.supportsBatchUpdates();
    }

    @Override
    public final boolean supportsCatalogsInDataManipulation() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCatalogsInDataManipulation", new Object[0]);
        if (value == null) {
            value = this.supportsCatalogsInDataManipulationImpl();
        }
        return value;
    }

    protected boolean supportsCatalogsInDataManipulationImpl() throws SQLException {
        return this.dmd.supportsCatalogsInDataManipulation();
    }

    @Override
    public final boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCatalogsInIndexDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsCatalogsInIndexDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsCatalogsInIndexDefinitionsImpl() throws SQLException {
        return this.dmd.supportsCatalogsInIndexDefinitions();
    }

    @Override
    public final boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCatalogsInPrivilegeDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsCatalogsInPrivilegeDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsCatalogsInPrivilegeDefinitionsImpl() throws SQLException {
        return this.dmd.supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public final boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCatalogsInProcedureCalls", new Object[0]);
        if (value == null) {
            value = this.supportsCatalogsInProcedureCallsImpl();
        }
        return value;
    }

    protected boolean supportsCatalogsInProcedureCallsImpl() throws SQLException {
        return this.dmd.supportsCatalogsInProcedureCalls();
    }

    @Override
    public final boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCatalogsInTableDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsCatalogsInTableDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsCatalogsInTableDefinitionsImpl() throws SQLException {
        return this.dmd.supportsCatalogsInTableDefinitions();
    }

    @Override
    public final boolean supportsColumnAliasing() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsColumnAliasing", new Object[0]);
        if (value == null) {
            value = this.supportsColumnAliasingImpl();
        }
        return value;
    }

    protected boolean supportsColumnAliasingImpl() throws SQLException {
        return this.dmd.supportsColumnAliasing();
    }

    @Override
    public final boolean supportsConvert() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsConvert", new Object[0]);
        if (value == null) {
            value = this.supportsConvertImpl();
        }
        return value;
    }

    protected boolean supportsConvertImpl() throws SQLException {
        return this.dmd.supportsConvert();
    }

    @Override
    public final boolean supportsConvert(int fromType, int toType) throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsConvert", fromType, toType);
        if (value == null) {
            value = this.supportsConvertImpl();
        }
        return value;
    }

    protected boolean supportsConvertImpl(int fromType, int toType) throws SQLException {
        return this.dmd.supportsConvert(fromType, toType);
    }

    @Override
    public final boolean supportsCoreSQLGrammar() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCoreSQLGrammar", new Object[0]);
        if (value == null) {
            value = this.supportsCoreSQLGrammarImpl();
        }
        return value;
    }

    protected boolean supportsCoreSQLGrammarImpl() throws SQLException {
        return this.dmd.supportsCoreSQLGrammar();
    }

    @Override
    public final boolean supportsCorrelatedSubqueries() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsCorrelatedSubqueries", new Object[0]);
        if (value == null) {
            value = this.supportsCorrelatedSubqueriesImpl();
        }
        return value;
    }

    protected boolean supportsCorrelatedSubqueriesImpl() throws SQLException {
        return this.dmd.supportsCorrelatedSubqueries();
    }

    @Override
    public final boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsDataDefinitionAndDataManipulationTransactions", new Object[0]);
        if (value == null) {
            value = this.supportsDataDefinitionAndDataManipulationTransactionsImpl();
        }
        return value;
    }

    protected boolean supportsDataDefinitionAndDataManipulationTransactionsImpl() throws SQLException {
        return this.dmd.supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public final boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsDataManipulationTransactionsOnly", new Object[0]);
        if (value == null) {
            value = this.supportsDataManipulationTransactionsOnlyImpl();
        }
        return value;
    }

    protected boolean supportsDataManipulationTransactionsOnlyImpl() throws SQLException {
        return this.dmd.supportsDataManipulationTransactionsOnly();
    }

    @Override
    public final boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsDifferentTableCorrelationNames", new Object[0]);
        if (value == null) {
            value = this.supportsDifferentTableCorrelationNamesImpl();
        }
        return value;
    }

    protected boolean supportsDifferentTableCorrelationNamesImpl() throws SQLException {
        return this.dmd.supportsDifferentTableCorrelationNames();
    }

    @Override
    public final boolean supportsExpressionsInOrderBy() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsExpressionsInOrderBy", new Object[0]);
        if (value == null) {
            value = this.supportsExpressionsInOrderByImpl();
        }
        return value;
    }

    protected boolean supportsExpressionsInOrderByImpl() throws SQLException {
        return this.dmd.supportsExpressionsInOrderBy();
    }

    @Override
    public final boolean supportsExtendedSQLGrammar() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsExtendedSQLGrammar", new Object[0]);
        if (value == null) {
            value = this.supportsExtendedSQLGrammarImpl();
        }
        return value;
    }

    protected boolean supportsExtendedSQLGrammarImpl() throws SQLException {
        return this.dmd.supportsExtendedSQLGrammar();
    }

    @Override
    public final boolean supportsFullOuterJoins() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsFullOuterJoins", new Object[0]);
        if (value == null) {
            value = this.supportsFullOuterJoinsImpl();
        }
        return value;
    }

    protected boolean supportsFullOuterJoinsImpl() throws SQLException {
        return this.dmd.supportsFullOuterJoins();
    }

    @Override
    public final boolean supportsGetGeneratedKeys() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsGetGeneratedKeys", new Object[0]);
        if (value == null) {
            value = this.supportsGetGeneratedKeysImpl();
        }
        return value;
    }

    protected boolean supportsGetGeneratedKeysImpl() throws SQLException {
        return this.dmd.supportsGetGeneratedKeys();
    }

    @Override
    public final boolean supportsGroupBy() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsGroupBy", new Object[0]);
        if (value == null) {
            value = this.supportsGroupByImpl();
        }
        return value;
    }

    protected boolean supportsGroupByImpl() throws SQLException {
        return this.dmd.supportsGroupBy();
    }

    @Override
    public final boolean supportsGroupByBeyondSelect() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsGroupByBeyondSelect", new Object[0]);
        if (value == null) {
            value = this.supportsGroupByBeyondSelectImpl();
        }
        return value;
    }

    protected boolean supportsGroupByBeyondSelectImpl() throws SQLException {
        return this.dmd.supportsGroupByBeyondSelect();
    }

    @Override
    public final boolean supportsGroupByUnrelated() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsGroupByUnrelated", new Object[0]);
        if (value == null) {
            value = this.supportsGroupByUnrelatedImpl();
        }
        return value;
    }

    protected boolean supportsGroupByUnrelatedImpl() throws SQLException {
        return this.dmd.supportsGroupByUnrelated();
    }

    @Override
    public final boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsIntegrityEnhancementFacility", new Object[0]);
        if (value == null) {
            value = this.supportsIntegrityEnhancementFacilityImpl();
        }
        return value;
    }

    protected boolean supportsIntegrityEnhancementFacilityImpl() throws SQLException {
        return this.dmd.supportsIntegrityEnhancementFacility();
    }

    @Override
    public final boolean supportsLikeEscapeClause() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsLikeEscapeClause", new Object[0]);
        if (value == null) {
            value = this.supportsLikeEscapeClauseImpl();
        }
        return value;
    }

    protected boolean supportsLikeEscapeClauseImpl() throws SQLException {
        return this.dmd.supportsLikeEscapeClause();
    }

    @Override
    public final boolean supportsLimitedOuterJoins() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsLimitedOuterJoins", new Object[0]);
        if (value == null) {
            value = this.supportsLimitedOuterJoinsImpl();
        }
        return value;
    }

    protected boolean supportsLimitedOuterJoinsImpl() throws SQLException {
        return this.dmd.supportsLimitedOuterJoins();
    }

    @Override
    public final boolean supportsMinimumSQLGrammar() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMinimumSQLGrammar", new Object[0]);
        if (value == null) {
            value = this.supportsMinimumSQLGrammarImpl();
        }
        return value;
    }

    protected boolean supportsMinimumSQLGrammarImpl() throws SQLException {
        return this.dmd.supportsMinimumSQLGrammar();
    }

    @Override
    public final boolean supportsMixedCaseIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMixedCaseIdentifiers", new Object[0]);
        if (value == null) {
            value = this.supportsMixedCaseIdentifiersImpl();
        }
        return value;
    }

    protected boolean supportsMixedCaseIdentifiersImpl() throws SQLException {
        return this.dmd.supportsMixedCaseIdentifiers();
    }

    @Override
    public final boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMixedCaseQuotedIdentifiers", new Object[0]);
        if (value == null) {
            value = this.supportsMixedCaseQuotedIdentifiersImpl();
        }
        return value;
    }

    protected boolean supportsMixedCaseQuotedIdentifiersImpl() throws SQLException {
        return this.dmd.supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public final boolean supportsMultipleOpenResults() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMultipleOpenResults", new Object[0]);
        if (value == null) {
            value = this.supportsMultipleOpenResultsImpl();
        }
        return value;
    }

    protected boolean supportsMultipleOpenResultsImpl() throws SQLException {
        return this.dmd.supportsMultipleOpenResults();
    }

    @Override
    public final boolean supportsMultipleResultSets() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMultipleResultSets", new Object[0]);
        if (value == null) {
            value = this.supportsMultipleResultSetsImpl();
        }
        return value;
    }

    protected boolean supportsMultipleResultSetsImpl() throws SQLException {
        return this.dmd.supportsMultipleResultSets();
    }

    @Override
    public final boolean supportsMultipleTransactions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsMultipleTransactions", new Object[0]);
        if (value == null) {
            value = this.supportsMultipleTransactionsImpl();
        }
        return value;
    }

    protected boolean supportsMultipleTransactionsImpl() throws SQLException {
        return this.dmd.supportsMultipleTransactions();
    }

    @Override
    public final boolean supportsNamedParameters() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsNamedParameters", new Object[0]);
        if (value == null) {
            value = this.supportsNamedParametersImpl();
        }
        return value;
    }

    protected boolean supportsNamedParametersImpl() throws SQLException {
        return this.dmd.supportsNamedParameters();
    }

    @Override
    public final boolean supportsNonNullableColumns() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsNonNullableColumns", new Object[0]);
        if (value == null) {
            value = this.supportsNonNullableColumnsImpl();
        }
        return value;
    }

    protected boolean supportsNonNullableColumnsImpl() throws SQLException {
        return this.dmd.supportsNonNullableColumns();
    }

    @Override
    public final boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOpenCursorsAcrossCommit", new Object[0]);
        if (value == null) {
            value = this.supportsOpenCursorsAcrossCommitImpl();
        }
        return value;
    }

    protected boolean supportsOpenCursorsAcrossCommitImpl() throws SQLException {
        return this.dmd.supportsOpenCursorsAcrossCommit();
    }

    @Override
    public final boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOpenCursorsAcrossRollback", new Object[0]);
        if (value == null) {
            value = this.supportsOpenCursorsAcrossRollbackImpl();
        }
        return value;
    }

    protected boolean supportsOpenCursorsAcrossRollbackImpl() throws SQLException {
        return this.dmd.supportsOpenCursorsAcrossRollback();
    }

    @Override
    public final boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOpenStatementsAcrossCommit", new Object[0]);
        if (value == null) {
            value = this.supportsOpenStatementsAcrossCommitImpl();
        }
        return value;
    }

    protected boolean supportsOpenStatementsAcrossCommitImpl() throws SQLException {
        return this.dmd.supportsOpenStatementsAcrossCommit();
    }

    @Override
    public final boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOpenStatementsAcrossRollback", new Object[0]);
        if (value == null) {
            value = this.supportsOpenStatementsAcrossRollbackImpl();
        }
        return value;
    }

    protected boolean supportsOpenStatementsAcrossRollbackImpl() throws SQLException {
        return this.dmd.supportsOpenCursorsAcrossRollback();
    }

    @Override
    public final boolean supportsOrderByUnrelated() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOrderByUnrelated", new Object[0]);
        if (value == null) {
            value = this.supportsOrderByUnrelatedImpl();
        }
        return value;
    }

    protected boolean supportsOrderByUnrelatedImpl() throws SQLException {
        return this.dmd.supportsOrderByUnrelated();
    }

    @Override
    public final boolean supportsOuterJoins() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsOuterJoins", new Object[0]);
        if (value == null) {
            value = this.supportsOuterJoinsImpl();
        }
        return value;
    }

    protected boolean supportsOuterJoinsImpl() throws SQLException {
        return this.dmd.supportsOuterJoins();
    }

    @Override
    public final boolean supportsPositionedDelete() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsPositionedDelete", new Object[0]);
        if (value == null) {
            value = this.supportsPositionedDeleteImpl();
        }
        return value;
    }

    protected boolean supportsPositionedDeleteImpl() throws SQLException {
        return this.dmd.supportsPositionedDelete();
    }

    @Override
    public final boolean supportsPositionedUpdate() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsPositionedUpdate", new Object[0]);
        if (value == null) {
            value = this.supportsPositionedUpdateImpl();
        }
        return value;
    }

    protected boolean supportsPositionedUpdateImpl() throws SQLException {
        return this.dmd.supportsPositionedUpdate();
    }

    @Override
    public final boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsResultSetConcurrency", type, concurrency);
        if (value == null) {
            value = this.supportsResultSetConcurrencyImpl(type, concurrency);
        }
        return value;
    }

    protected boolean supportsResultSetConcurrencyImpl(int type, int concurrency) throws SQLException {
        return this.dmd.supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public final boolean supportsResultSetHoldability(int holdability) throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsResultSetHoldability", holdability);
        if (value == null) {
            value = this.supportsResultSetHoldabilityImpl(holdability);
        }
        return value;
    }

    protected boolean supportsResultSetHoldabilityImpl(int holdability) throws SQLException {
        return this.dmd.supportsResultSetHoldability(holdability);
    }

    @Override
    public final boolean supportsResultSetType(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsResultSetType", type);
        if (value == null) {
            value = this.supportsResultSetTypeImpl(type);
        }
        return value;
    }

    protected boolean supportsResultSetTypeImpl(int type) throws SQLException {
        return this.dmd.supportsResultSetType(type);
    }

    @Override
    public final boolean supportsSavepoints() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSavepoints", new Object[0]);
        if (value == null) {
            value = this.supportsSavepointsImpl();
        }
        return value;
    }

    protected boolean supportsSavepointsImpl() throws SQLException {
        return this.dmd.supportsSavepoints();
    }

    @Override
    public final boolean supportsSchemasInDataManipulation() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSchemasInDataManipulation", new Object[0]);
        if (value == null) {
            value = this.supportsSchemasInDataManipulationImpl();
        }
        return value;
    }

    protected boolean supportsSchemasInDataManipulationImpl() throws SQLException {
        return this.dmd.supportsSchemasInDataManipulation();
    }

    @Override
    public final boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSchemasInIndexDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsSchemasInIndexDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsSchemasInIndexDefinitionsImpl() throws SQLException {
        return this.dmd.supportsSchemasInIndexDefinitions();
    }

    @Override
    public final boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSchemasInPrivilegeDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsSchemasInPrivilegeDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsSchemasInPrivilegeDefinitionsImpl() throws SQLException {
        return this.dmd.supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public final boolean supportsSchemasInProcedureCalls() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSchemasInProcedureCalls", new Object[0]);
        if (value == null) {
            value = this.supportsSchemasInProcedureCallsImpl();
        }
        return value;
    }

    protected boolean supportsSchemasInProcedureCallsImpl() throws SQLException {
        return this.dmd.supportsSchemasInProcedureCalls();
    }

    @Override
    public final boolean supportsSchemasInTableDefinitions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSchemasInTableDefinitions", new Object[0]);
        if (value == null) {
            value = this.supportsSchemasInTableDefinitionsImpl();
        }
        return value;
    }

    protected boolean supportsSchemasInTableDefinitionsImpl() throws SQLException {
        return this.dmd.supportsSchemasInTableDefinitions();
    }

    @Override
    public final boolean supportsSelectForUpdate() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSelectForUpdate", new Object[0]);
        if (value == null) {
            value = this.supportsSelectForUpdateImpl();
        }
        return value;
    }

    protected boolean supportsSelectForUpdateImpl() throws SQLException {
        return this.dmd.supportsSelectForUpdate();
    }

    @Override
    public final boolean supportsStatementPooling() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsStatementPooling", new Object[0]);
        if (value == null) {
            value = this.supportsStatementPoolingImpl();
        }
        return value;
    }

    protected boolean supportsStatementPoolingImpl() throws SQLException {
        return this.dmd.supportsStatementPooling();
    }

    @Override
    public final boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsStoredFunctionsUsingCallSyntax", new Object[0]);
        if (value == null) {
            value = this.supportsStoredFunctionsUsingCallSyntaxImpl();
        }
        return value;
    }

    protected boolean supportsStoredFunctionsUsingCallSyntaxImpl() throws SQLException {
        return this.dmd.supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public final boolean supportsStoredProcedures() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsStoredProcedures", new Object[0]);
        if (value == null) {
            value = this.supportsStoredProceduresImpl();
        }
        return value;
    }

    protected boolean supportsStoredProceduresImpl() throws SQLException {
        return this.dmd.supportsStoredProcedures();
    }

    @Override
    public final boolean supportsSubqueriesInComparisons() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSubqueriesInComparisons", new Object[0]);
        if (value == null) {
            value = this.supportsSubqueriesInComparisonsImpl();
        }
        return value;
    }

    protected boolean supportsSubqueriesInComparisonsImpl() throws SQLException {
        return this.dmd.supportsSubqueriesInComparisons();
    }

    @Override
    public final boolean supportsSubqueriesInExists() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSubqueriesInExists", new Object[0]);
        if (value == null) {
            value = this.supportsSubqueriesInExistsImpl();
        }
        return value;
    }

    protected boolean supportsSubqueriesInExistsImpl() throws SQLException {
        return this.dmd.supportsSubqueriesInExists();
    }

    @Override
    public final boolean supportsSubqueriesInIns() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSubqueriesInIns", new Object[0]);
        if (value == null) {
            value = this.supportsSubqueriesInInsImpl();
        }
        return value;
    }

    protected boolean supportsSubqueriesInInsImpl() throws SQLException {
        return this.dmd.supportsSubqueriesInIns();
    }

    @Override
    public final boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsSubqueriesInQuantifieds", new Object[0]);
        if (value == null) {
            value = this.supportsSubqueriesInQuantifiedsImpl();
        }
        return value;
    }

    protected boolean supportsSubqueriesInQuantifiedsImpl() throws SQLException {
        return this.dmd.supportsSubqueriesInQuantifieds();
    }

    @Override
    public final boolean supportsTableCorrelationNames() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsTableCorrelationNames", new Object[0]);
        if (value == null) {
            value = this.supportsTableCorrelationNamesImpl();
        }
        return value;
    }

    protected boolean supportsTableCorrelationNamesImpl() throws SQLException {
        return this.dmd.supportsTableCorrelationNames();
    }

    @Override
    public final boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsTransactionIsolationLevel", level);
        if (value == null) {
            value = this.supportsTransactionIsolationLevelImpl(level);
        }
        return value;
    }

    protected boolean supportsTransactionIsolationLevelImpl(int level) throws SQLException {
        return this.dmd.supportsTransactionIsolationLevel(level);
    }

    @Override
    public final boolean supportsTransactions() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsTransactions", new Object[0]);
        if (value == null) {
            value = this.supportsTransactionsImpl();
        }
        return value;
    }

    protected boolean supportsTransactionsImpl() throws SQLException {
        return this.dmd.supportsTransactions();
    }

    @Override
    public final boolean supportsUnion() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsUnion", new Object[0]);
        if (value == null) {
            value = this.supportsUnionImpl();
        }
        return value;
    }

    protected boolean supportsUnionImpl() throws SQLException {
        return this.dmd.supportsUnion();
    }

    @Override
    public final boolean supportsUnionAll() throws SQLException {
        Boolean value = this.checkOverrideBoolean("supportsUnionAll", new Object[0]);
        if (value == null) {
            value = this.supportsUnionAllImpl();
        }
        return value;
    }

    protected boolean supportsUnionAllImpl() throws SQLException {
        return this.dmd.supportsUnionAll();
    }

    @Override
    public final boolean updatesAreDetected(int type) throws SQLException {
        Boolean value = this.checkOverrideBoolean("updatesAreDetected", type);
        if (value == null) {
            value = this.updatesAreDetectedImpl(type);
        }
        return value;
    }

    protected boolean updatesAreDetectedImpl(int type) throws SQLException {
        return this.dmd.updatesAreDetected(type);
    }

    @Override
    public final boolean usesLocalFilePerTable() throws SQLException {
        Boolean value = this.checkOverrideBoolean("usesLocalFilePerTable", new Object[0]);
        if (value == null) {
            value = this.usesLocalFilePerTableImpl();
        }
        return value;
    }

    protected boolean usesLocalFilePerTableImpl() throws SQLException {
        return this.dmd.usesLocalFilePerTable();
    }

    @Override
    public final boolean usesLocalFiles() throws SQLException {
        Boolean value = this.checkOverrideBoolean("usesLocalFiles", new Object[0]);
        if (value == null) {
            value = this.usesLocalFilesImpl();
        }
        return value;
    }

    protected boolean usesLocalFilesImpl() throws SQLException {
        return this.dmd.usesLocalFiles();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.dmd.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.dmd.unwrap(arg0);
    }

    @Override
    public ResultSet getSynonyms(String catalog, String schemaPattern, String synNamePattern, String[] types) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getSynonyms", catalog, schemaPattern, synNamePattern, this.getSearchStringEscape(), types);
        if (null == rs) {
            rs = this.getSynonymsImpl(catalog, schemaPattern, synNamePattern, types);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSynonyms"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getSynonymsImpl(String catalog, String schemaPattern, String synNamePattern, String[] types) throws SQLException {
        return new EmptyResultSetAdaptor();
    }

    @Override
    public final ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getFunctions", catalog, schemaPattern, functionNamePattern);
        if (null == rs) {
            rs = this.getFunctionsImpl(catalog, schemaPattern, functionNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getFunctions"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getFunctionsImpl(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.dmd.getFunctions(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public final ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        if (null == rs) {
            rs = this.getFunctionColumnsImpl(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getFunctionColumns"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getFunctionColumnsImpl(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.dmd.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public String getEffectiveTableType(String reportedType) {
        String mappedType = this.findProperty(String.format(TABLETYPE_KEY, reportedType));
        if (mappedType == null) {
            return reportedType;
        }
        return mappedType;
    }

    @Override
    public String[] getDefaultCatalogSchemaName(String tableName) throws SQLException {
        String[] defaultCatalogSchema = new String[2];
        ResultSet rs = this.executeSqlStatement("getDefaultCatalogSchemaName", new Object[0]);
        if (null != rs && rs.next()) {
            defaultCatalogSchema[0] = rs.getString(1);
            defaultCatalogSchema[1] = rs.getString(2);
        } else {
            SQLException exception;
            block12: {
                Statement st;
                block11: {
                    st = null;
                    ResultSet rset = null;
                    exception = null;
                    try {
                        String sql = "select * from " + tableName + " where 1=2";
                        st = this.getConnection().createStatement();
                        rset = st.executeQuery(sql);
                        ResultSetMetaData desc = rset.getMetaData();
                        defaultCatalogSchema[0] = desc.getCatalogName(1);
                        defaultCatalogSchema[1] = desc.getSchemaName(1);
                    }
                    catch (SQLException e) {
                        exception = e;
                    }
                    if (rset != null) {
                        try {
                            rset.close();
                            rset = null;
                        }
                        catch (SQLException e1) {
                            if (exception != null) break block11;
                            exception = e1;
                        }
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                        st = null;
                    }
                    catch (SQLException e2) {
                        if (exception != null) break block12;
                        exception = e2;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        return defaultCatalogSchema;
    }

    @Override
    public final boolean isOIDCSupported() {
        String isSupported = this.findProperty(String.format(OIDC_KEY, "supported"));
        if (isSupported != null && !isSupported.isEmpty()) {
            return Boolean.parseBoolean(isSupported);
        }
        return false;
    }

    @Override
    public String getOIDCKey(String oidcKey) {
        String mappedType = this.findProperty(String.format(OIDC_KEY, oidcKey));
        if (mappedType == null) {
            return oidcKey;
        }
        return mappedType;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dmd.getConnection();
    }

    private RowIdLifetime checkOverrideRowIdLifeTime(String function, Object ... args) throws SQLException {
        String stringValue = this.findProperty(String.format("adaptor.method.override.%1$s", function));
        RowIdLifetime value = stringValue != null ? RowIdLifetime.valueOf(stringValue) : (RowIdLifetime)((Object)this.getFirstObjectFromSqlStatement(function, args));
        return value;
    }

    private Boolean checkOverrideBoolean(String function, Object ... args) throws SQLException {
        String stringValue = this.findProperty(String.format("adaptor.method.override.%1$s", function));
        Boolean value = stringValue != null ? Boolean.valueOf(stringValue) : (Boolean)this.getFirstObjectFromSqlStatement(function, args);
        return value;
    }

    private Integer checkOverrideInteger(String function, Object ... args) throws SQLException {
        String stringValue = this.findProperty(String.format("adaptor.method.override.%1$s", function));
        Integer value = stringValue != null ? Integer.valueOf(stringValue) : (Integer)this.getFirstObjectFromSqlStatement(function, args);
        return value;
    }

    private String checkOverrideString(String function, Object ... args) throws SQLException {
        String value = this.findProperty(String.format("adaptor.method.override.%1$s", function));
        if (value == null) {
            value = (String)this.getFirstObjectFromSqlStatement(function, args);
        }
        return value;
    }

    private Object getFirstObjectFromSqlStatement(String function, Object ... args) throws SQLException {
        ResultSet rs = this.executeSqlStatement(function, args);
        Object value = null;
        if (rs != null && rs.next()) {
            value = rs.getObject(1);
        }
        return value;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getPseudoColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public ResultSet getTableParameters(String catalog, String schemaPattern, String tableNamePattern, String parameterNamePattern) throws SQLException {
        ResultSet rs = this.executeSqlStatement("getTableParameters", catalog, schemaPattern, tableNamePattern, parameterNamePattern, this.getSearchStringEscape());
        if (null == rs) {
            rs = this.getTableParametersImpl(catalog, schemaPattern, tableNamePattern, parameterNamePattern);
        }
        if (null == rs) {
            return rs;
        }
        String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getSynonyms"));
        if (wrapMetadataRS != null) {
            rs = MetadataResultSet.wrapResultSet(rs, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getTableParametersImpl(String catalog, String schemaPattern, String tableNamePattern, String parameterNamePattern) throws SQLException {
        return new EmptyResultSetAdaptor();
    }

    public static final class Wrapper
    implements IWrapper {
        @Override
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new BaseDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

