/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.SDKAdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.TlsTunnel;
import com.ibm.cognos.jdbc.adaptor.util.AdaptorException;
import com.ibm.cognos.jdbc.adaptor.util.UncertifiedAdaptorException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ConnectionFactory {
    private static final String MOCK_URL = "ibmcognos.mockurl";
    private static final String MOCK_DRIVER = "com.ibm.cognos.jdbc.mock.MockDriver";
    private static final String IBM_COGNOS_PREFIX = "ibmcognos.";
    private static final String SUBPROTOCOL_CLEANER = "(_)|(-)|(\\s)";
    private static final String CERTIFIED_ADAPTOR = "com.ibm.cognos.jdbc.adaptor.generic.CertifiedAdaptorFactory";
    private static final String ADAPTOR_FACTORY_LOAD_FRMT = "%1$s.cognos.adaptor.%3$s%2$sAdaptorFactory";
    private static final String OIDC_SUPPORTED = "oidc.supported";
    private static final String OIDC_NAMESPACE = "oidc.namespace";
    private static final String OIDC_ATOKEN = "oidc.atoken";
    private static final String OIDC_ATOKEN_FORMAT = "oidc.atoken.format";
    private static final String OIDC_PREFIX = "oidc.";
    private static final String OIDC_IDTOKEN = "oidc.idtoken";
    private static final String APITOKEN_AUTHKEY = "authKey";
    private static final String APITOKEN_SECRETKEY = "secretKey";
    private static final String APITOKEN_TOKEN = "token";
    private static final String APITOKEN_APIKEY = "apikey";

    public static Connection createAndWrapConnection(Driver driver, String url, Properties connectionProperties) throws Exception {
        return ConnectionFactory.createAndWrapConnection(driver, url, connectionProperties, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection createAndWrapConnection(Driver driver, String url, Properties connectionProperties, boolean returnOriginalCon) throws Exception {
        String[] factoryNames;
        AdaptorFactory factory = null;
        String factoryName = ConnectionFactory.makeFactoryName(driver, url);
        String propertyFilebaseName = factoryName.substring(factoryName.lastIndexOf(46) + 1);
        for (String name : factoryNames = new String[]{factoryName, CERTIFIED_ADAPTOR}) {
            try {
                Class<?> factoryClass = Class.forName(name);
                factory = (AdaptorFactory)factoryClass.newInstance();
                break;
            }
            catch (Throwable t1) {
                factory = null;
            }
        }
        if (factory == null) {
            factory = new SDKAdaptorFactory();
        }
        try {
            factory.setAdaptorProperties(propertyFilebaseName, null, null, null, null, null, null, null, null);
        }
        catch (UncertifiedAdaptorException uncertifiedAdaptorException) {
            // empty catch block
        }
        TlsTunnel tlsTunnel = null;
        Connection connection = null;
        boolean workingWithMock = connectionProperties.containsKey(MOCK_URL);
        if (workingWithMock) {
            Driver mockDriver = (Driver)Class.forName(MOCK_DRIVER).newInstance();
            connection = mockDriver.connect(url, connectionProperties);
            connection.setTransactionIsolation(0);
        } else {
            try {
                String secureGateway;
                Properties driverProperties = ConnectionFactory.filterIBMCognosProperties(false, connectionProperties);
                Properties ibmProperties = ConnectionFactory.filterIBMCognosProperties(true, connectionProperties);
                if (connectionProperties.containsKey("JGSSCredential")) {
                    String gssPropertyName = factory.getAdaptorProperties().getProperty("JGSSCredential");
                    if (gssPropertyName == null) {
                        throw new RuntimeException("JGSSCredential property not matched in adaptor property file. The driver doesn't support constrained delegation.");
                    }
                    Object value = connectionProperties.remove("JGSSCredential");
                    driverProperties.put(gssPropertyName, value);
                }
                if (connectionProperties.containsKey(OIDC_NAMESPACE)) {
                    Properties adaptorProperties = factory.getAdaptorProperties();
                    String oidcSupportedValue = adaptorProperties.getProperty(OIDC_SUPPORTED);
                    if (oidcSupportedValue == null) throw new AdaptorException("The driver doesn't support OIDC.");
                    boolean isOidcSupported = Boolean.parseBoolean(oidcSupportedValue);
                    if (!isOidcSupported) throw new AdaptorException("The driver doesn't support OIDC");
                    ConnectionFactory.mapOIDCToDriverProperty(adaptorProperties, driverProperties, connectionProperties);
                }
                if ((secureGateway = connectionProperties.getProperty("IBMCOGNOS_SG_DEST")) != null) {
                    tlsTunnel = new TlsTunnel();
                    url = tlsTunnel.createTunnelIfNeeded(url, connectionProperties);
                }
                if (connectionProperties.containsKey(APITOKEN_AUTHKEY)) {
                    Properties adaptorProperties = factory.getAdaptorProperties();
                    driverProperties.clear();
                    ConnectionFactory.mapApiTokenToDriverProperty(adaptorProperties, driverProperties, connectionProperties);
                }
                connection = factory.connect(driver, url, driverProperties, ibmProperties);
            }
            catch (SQLException e) {
                SQLException ex = factory.processSQLException(e);
                throw ex;
            }
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("adaptorClass", factory.getClass().getName());
        info.put("adaptorVersion", factory.getVersion());
        try {
            Map<String, Object> extraInfo;
            factory.determineSubType(connection);
            String serverMajor = null;
            String serverMinor = null;
            String serverSubMinor = null;
            String driverMajor = null;
            String driverMinor = null;
            String driverSubMinor = null;
            try {
                serverMajor = String.valueOf(connection.getMetaData().getDatabaseMajorVersion());
                serverMinor = String.valueOf(connection.getMetaData().getDatabaseMinorVersion());
                driverMajor = String.valueOf(connection.getMetaData().getDriverMajorVersion());
                driverMinor = String.valueOf(connection.getMetaData().getDriverMinorVersion());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (factory.getSubType() != null || tlsTunnel == null || tlsTunnel.getTunnelSeesion() == null) {
                factory.setAdaptorProperties(propertyFilebaseName, null, null, null, factory.getSubType(), info, null, null, null);
            }
            connection = factory.wrapConnection(connection);
            ((BaseConnectionAdaptor)connection).setConnectionURL(url);
            ((BaseConnectionAdaptor)connection).getExtraInformation().putAll(info);
            if (tlsTunnel != null) {
                ((BaseConnectionAdaptor)connection).setTunnelSession(tlsTunnel.getTunnelSeesion());
            }
            if ((extraInfo = ((BaseConnectionAdaptor)connection).getExtraInformation()) != null) {
                if (extraInfo.get("dbSubminorVersion") != null) {
                    serverSubMinor = String.valueOf(extraInfo.get("dbSubminorVersion"));
                }
                if (extraInfo.get("driverSubminorVersion") != null) {
                    driverSubMinor = String.valueOf(extraInfo.get("driverSubminorVersion"));
                }
            }
            if (factory.getSubType() != null || tlsTunnel == null || tlsTunnel.getTunnelSeesion() == null) {
                factory.setAdaptorProperties(propertyFilebaseName, serverMajor, serverMinor, serverSubMinor, factory.getSubType(), info, driverMajor, driverMinor, driverSubMinor);
            }
        }
        catch (UncertifiedAdaptorException e) {
            if (!returnOriginalCon) throw e;
            return connection;
        }
        if (!workingWithMock) return connection;
        connection.setTransactionIsolation(0);
        return connection;
    }

    public static String makeFactoryName(Driver driver, String url) {
        Class<?> driverClass = driver.getClass();
        String driverPackage = driverClass.getPackage().getName();
        String driverName = driverClass.getSimpleName();
        return ConnectionFactory.makeFactoryName(driverName, driverPackage, url);
    }

    public static String makeFactoryName(String driverName, String driverPackage, String url) {
        String name;
        if (url != null) {
            String subprotocol = url.split(":")[1].replaceAll(SUBPROTOCOL_CLEANER, "");
            subprotocol = subprotocol.substring(0, 1).toUpperCase() + subprotocol.substring(1);
            name = String.format(ADAPTOR_FACTORY_LOAD_FRMT, driverPackage, subprotocol, driverName);
        } else {
            name = String.format(ADAPTOR_FACTORY_LOAD_FRMT, driverPackage, "", driverName);
        }
        return name;
    }

    private ConnectionFactory() {
    }

    private static Properties filterIBMCognosProperties(boolean inclusive, Properties props) {
        Properties filteredProps = new Properties();
        if (props != null) {
            for (String name : props.stringPropertyNames()) {
                boolean match = name.startsWith(IBM_COGNOS_PREFIX);
                boolean isOidc = name.startsWith(OIDC_PREFIX);
                if ((!match || !inclusive) && (match || inclusive || isOidc) || name.startsWith(OIDC_PREFIX) && !name.startsWith(OIDC_PREFIX)) continue;
                filteredProps.setProperty(name, props.getProperty(name));
            }
        }
        filteredProps.remove("IBMCOGNOS_SG_DEST");
        filteredProps.remove("SecuregatewayTrust");
        filteredProps.remove("secureKey");
        filteredProps.remove("IBMCOGNOS_SG_JDBC_DEST");
        filteredProps.remove("IBMCOGNOS_PASSPORT");
        return filteredProps;
    }

    private static void mapOIDCToDriverProperty(Properties adaptorProperties, Properties driverProperties, Properties connectionProperties) {
        String namespacePropertyName;
        String iTokenPropertyName;
        String aTokenPropertyName;
        boolean mapped = false;
        String aTokenFormatPropertyName = adaptorProperties.getProperty(OIDC_ATOKEN_FORMAT);
        if (null == aTokenFormatPropertyName) {
            aTokenFormatPropertyName = "%1$s";
        }
        if ((aTokenPropertyName = adaptorProperties.getProperty(OIDC_ATOKEN)) != null && connectionProperties.containsKey(OIDC_ATOKEN)) {
            mapped = true;
            driverProperties.put(aTokenPropertyName, String.format(aTokenFormatPropertyName, connectionProperties.getProperty(OIDC_ATOKEN)));
        }
        if ((iTokenPropertyName = adaptorProperties.getProperty(OIDC_IDTOKEN)) != null && connectionProperties.containsKey(OIDC_IDTOKEN)) {
            mapped = true;
            driverProperties.put(iTokenPropertyName, connectionProperties.getProperty(OIDC_IDTOKEN));
        }
        if ((namespacePropertyName = adaptorProperties.getProperty(OIDC_NAMESPACE)) != null && connectionProperties.containsKey(OIDC_NAMESPACE)) {
            mapped = true;
            driverProperties.put(namespacePropertyName, connectionProperties.getProperty(OIDC_NAMESPACE));
        }
        if (!mapped) {
            throw new RuntimeException("Invalid Access Token, IdToken or Namespace.");
        }
    }

    private static void mapApiTokenToDriverProperty(Properties adaptorProperties, Properties driverProperties, Properties connectionProperties) {
        boolean mapped = false;
        String tokenName = adaptorProperties.getProperty(APITOKEN_TOKEN);
        if (tokenName != null && connectionProperties.containsKey(APITOKEN_AUTHKEY)) {
            mapped = true;
            String keyValue = connectionProperties.getProperty(APITOKEN_AUTHKEY);
            driverProperties.setProperty(tokenName, keyValue);
            String apikeyName = adaptorProperties.getProperty(APITOKEN_APIKEY);
            if (apikeyName != null) {
                driverProperties.setProperty(apikeyName, APITOKEN_APIKEY);
            }
        }
        if (!mapped) {
            throw new RuntimeException("Security token required, but not provided.");
        }
    }
}

