/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FilePropertyLoader
extends AbstractPropertyLoader {
    private String location;

    public FilePropertyLoader(String resourceDir) {
        this.location = resourceDir;
        File dir = new File(this.location);
        if (dir.isDirectory()) {
            for (String propFilename : dir.list()) {
                if (!propFilename.matches(".*AdaptorFactory.*\\.xml$")) continue;
                this.propertiesCache.put(propFilename.substring(0, propFilename.length() - ".xml".length()), null);
            }
        }
    }

    @Override
    protected InputStream getPropertyInputStream(String name) {
        try {
            return new FileInputStream(this.location + File.separator + name + ".xml");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    protected String getResourceLocation() {
        return this.location;
    }

    @Override
    public String getResourceVersion() {
        return "No version info available";
    }
}

