/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.ibm.bi.crypto.tunnel.TlsCredentials;
import com.ibm.bi.crypto.tunnel.TlsCredentialsException;
import com.ibm.bi.crypto.tunnel.TunnelSession;
import com.ibm.bi.crypto.tunnel.Tunnels;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelSessionParams;
import com.ibm.bi.crypto.tunnel.tls.ClientTlsCredentials;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.cognos.jdbc.adaptor.util.AdaptorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.util.Base64;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class TlsTunnel {
    private static final String TRUSTED_SERVICE_NAME = "moser";
    public static final String IBMCOGNOS_SG_DEST = "IBMCOGNOS_SG_DEST";
    public static final String SECURE_KEY = "secureKey";
    private static final String SECURE_KEY_API = "/bi/v1/securegateways/securekey/";
    public static final String SECURE_GATEWAY_TRUST = "SecuregatewayTrust";
    public static final String IBMCOGNOS_SG_JDBC_DEST = "IBMCOGNOS_SG_JDBC_DEST";
    public static final String IBMCOGNOS_SG_JDBC_OVERRIDE = "IBMCOGNOS_SG_JDBC_OVERRIDE";
    public static final String IBMCOGNOS_PASSPORT = "IBMCOGNOS_PASSPORT";
    public static final String CREDENTIAL_SECURE_KEY = "<secureKey>";
    public static final String CREDENTIAL_SECURE_KEY_END = "</secureKey>";
    private static String CERT_ERROR = "Can not get the Secure Gateway certificate:";
    public static final String UTF_8_CHARSET = "UTF-8";
    static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>XQE</serviceID></initializeDocument>";
    private boolean trusted = true;
    private TunnelSession sgTunnelSession = null;

    public TunnelSession getTunnelSeesion() {
        return this.sgTunnelSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getTheSecureKey(String destId, String passport) {
        byte[] secureKey;
        block16: {
            if (destId == null) {
                return null;
            }
            secureKey = null;
            try {
                RESTClient client = null;
                Integer statusCode = 0;
                try {
                    RESTClientConfig config = new RESTClientConfig();
                    config.setCookie(new HttpCookie("XSRF-TOKEN", "XSRF-TOKEN"));
                    config.setRequestHeader("X-XSRF-TOKEN", "XSRF-TOKEN");
                    client = RESTClientFactory.getInstance().getClient(config);
                    String urlStr = SECURE_KEY_API;
                    urlStr = urlStr + destId;
                    if (!client.makeTrusted(TRUSTED_SERVICE_NAME)) {
                        throw new AdaptorException("Failed to make request trusted");
                    }
                    if (passport != null) {
                        client.setPassportCookie(passport);
                    }
                    if ((statusCode = Integer.valueOf(client.getResource(urlStr))) == 200) {
                        String rt = new String(IOUtils.toByteArray((InputStream)client.getResponseStream()), UTF_8_CHARSET);
                        secureKey = TlsTunnel.getStringWithKey(rt);
                        break block16;
                    }
                    throw new AdaptorException("Get secure Key failed , code :" + statusCode + " -- " + client.getErrorResponseString());
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        finally {
                            client = null;
                        }
                    }
                }
            }
            catch (AdaptorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AdaptorException(ex);
            }
        }
        return secureKey;
    }

    public static byte[] getStringWithKey(String rt) {
        rt = rt.replaceAll("\\s", "");
        String startString = "\"secureKey\":\"";
        int isEncrypted = rt.indexOf("isEncrypted");
        int beginIndex = rt.indexOf(startString) + startString.length();
        String secureKey = "";
        try {
            if (isEncrypted > 0) {
                secureKey = rt.substring(beginIndex, rt.indexOf("\","));
                return TlsTunnel.decryptString(secureKey);
            }
        }
        catch (Exception e) {
            throw new AdaptorException(e);
        }
        return TlsTunnel.hexStringToByteArray(rt.substring(beginIndex, rt.indexOf("\"}]}")));
    }

    public static byte[] decryptString(String data) throws UnsupportedEncodingException, CAMCryptoException {
        byte[] encrypted = TlsTunnel.hexStringToByteArray(data);
        EncryptingSession es = new CAMFactory("JDBCADAPTERSDK").createEncryptingSession();
        byte[] decrypted = es.decryptData(encrypted);
        String result = new String(decrypted, "utf-8");
        result = result.substring(result.indexOf(CREDENTIAL_SECURE_KEY) + CREDENTIAL_SECURE_KEY.length(), result.indexOf(CREDENTIAL_SECURE_KEY_END));
        return Base64.getDecoder().decode(result.getBytes());
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public String createTunnelIfNeeded(String url, Properties connectionProperties) {
        String secureGateway = connectionProperties.getProperty(IBMCOGNOS_SG_DEST);
        if (secureGateway != null) {
            String[] secureGatewayParams = secureGateway.split(":");
            if (secureGatewayParams.length != 3) {
                throw new AdaptorException("Can not parse the Secure Gateway destination parameters :'" + secureGateway + "'");
            }
            String secureGatewayDestinationObjectId = secureGatewayParams[0];
            String secureGatewayDestinationHost = secureGatewayParams[1];
            String secureGatewayDestinationPort = secureGatewayParams[2];
            String secureGatewayTrust = connectionProperties.getProperty(SECURE_GATEWAY_TRUST);
            if (secureGatewayTrust != null) {
                this.trusted = Boolean.valueOf(secureGatewayTrust);
            }
            String secureGatewayCert = connectionProperties.getProperty(SECURE_KEY);
            byte[] secureGatewayCertByte = null;
            if (secureGatewayCert != null) {
                secureGatewayCertByte = TlsTunnel.hexStringToByteArray(secureGatewayCert);
            } else {
                String passport = connectionProperties.getProperty(IBMCOGNOS_PASSPORT);
                secureGatewayCertByte = TlsTunnel.getTheSecureKey(secureGatewayDestinationObjectId, passport);
                if (secureGatewayCertByte == null) {
                    throw new AdaptorException("empty certificate for the id  '" + secureGatewayDestinationObjectId + "'");
                }
            }
            String jdbcConnectionDest = connectionProperties.getProperty(IBMCOGNOS_SG_JDBC_DEST);
            if (jdbcConnectionDest == null) {
                throw new AdaptorException("Secure Gateway connection is not valids.");
            }
            ClientTlsCredentials deserializedMutualAuthClientTlsCredentials = null;
            try (ByteArrayInputStream someInputStream = new ByteArrayInputStream(secureGatewayCertByte);){
                deserializedMutualAuthClientTlsCredentials = ClientTlsCredentials.deserialize((InputStream)someInputStream);
            }
            catch (TlsCredentialsException e) {
                throw new AdaptorException(e);
            }
            catch (IOException e) {
                throw new AdaptorException(CERT_ERROR, e);
            }
            this.sgTunnelSession = Tunnels.tcpTunnelSession((TcpTunnelSessionParams)new TcpTunnelSessionParams(secureGatewayDestinationHost, Integer.parseInt(secureGatewayDestinationPort), this.trusted, (TlsCredentials)deserializedMutualAuthClientTlsCredentials));
            String secureGatewayLocalDestination = this.sgTunnelSession.localHostname() + ":" + this.sgTunnelSession.localPort();
            if (!connectionProperties.containsKey(IBMCOGNOS_SG_JDBC_OVERRIDE)) {
                return url.replaceAll(jdbcConnectionDest, secureGatewayLocalDestination);
            }
            secureGateway = secureGatewayDestinationHost + ":" + secureGatewayDestinationPort;
            return url.replaceAll(secureGateway, secureGatewayLocalDestination);
        }
        return url;
    }
}

