/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver;

import com.cognos.jdbc.driver.AsyncJdbcResultSet;
import com.cognos.jdbc.driver.EOFRow;
import com.cognos.jdbc.driver.Row;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public class AsyncJdbcForwardOnlyResultSet
extends AsyncJdbcResultSet {
    private Row mNextRow = null;

    public AsyncJdbcForwardOnlyResultSet(List<String> columnNames, BlockingQueue<Row> queue) {
        super(columnNames, queue);
    }

    @Override
    public boolean first() throws SQLException {
        if (!this.eof) {
            return this.next();
        }
        return false;
    }

    @Override
    protected String getValue(String columnName) throws SQLException {
        if (this.mNextRow != null) {
            Map<String, String> rowData = this.mNextRow.getRowData();
            return rowData.get(columnName);
        }
        return null;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.eof) {
            try {
                this.mNextRow = (Row)this.mRowQueue.take();
                if (this.mNextRow instanceof EOFRow) {
                    this.eof = true;
                    return false;
                }
                return true;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }
}

