/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver;

import com.cognos.jdbc.driver.EOFRow;
import com.cognos.jdbc.driver.JdbcResultSet;
import com.cognos.jdbc.driver.Row;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class AsyncJdbcResultSet
extends JdbcResultSet {
    protected BlockingQueue<Row> mRowQueue = null;

    public AsyncJdbcResultSet(List<String> columnNames, BlockingQueue<Row> queue) {
        super(columnNames);
        this.mRowQueue = queue;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentIndex + 1 < this.mResults.size()) {
            ++this.currentIndex;
            return true;
        }
        try {
            if (this.eof) {
                return false;
            }
            Row row = this.mRowQueue.take();
            if (row instanceof EOFRow) {
                this.eof = true;
                return false;
            }
            this.addResult(row);
            ++this.currentIndex;
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }
}

