/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver;

import com.cognos.jdbc.driver.AbstractJdbcResultSet;
import com.cognos.jdbc.driver.Row;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JdbcResultSet
extends AbstractJdbcResultSet {
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    protected int currentIndex = -1;
    protected List<Row> mResults = new ArrayList<Row>();

    public JdbcResultSet(List<String> columnNames) {
        super(columnNames);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentIndex + 1 < this.mResults.size()) {
            ++this.currentIndex;
            return true;
        }
        return false;
    }

    @Override
    protected String getValue(String columnName) throws SQLException {
        if (this.currentIndex >= 0) {
            Map<String, String> row = this.mResults.get(this.currentIndex).getRowData();
            return row.get(columnName);
        }
        throw new SQLException("Resultset pointer is positioned at improper index ");
    }

    public void addResult(Row row) {
        this.mResults.add(row);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.currentIndex > 0) {
            --this.currentIndex;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }
}

