/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SAPObjectHandler {
    public static final String ABAPQUQERY_HANDLER = "ABAP Queries";
    public static final String INFOSET_HANDLER = "Infosets";
    public static final String BAPI_HANDLER = "BAPIs";
    public static final String RFC_HANDLER = "RFCs";
    public static final String TABLE_HANDLER = "Tables";
    private String mName = null;
    private static ConcurrentHashMap<String, SAPObjectHandler> handlers = new ConcurrentHashMap();

    public SAPObjectHandler(String name) {
        this.mName = name;
        this.registerHandler(name, this);
    }

    protected void registerHandler(String name, SAPObjectHandler handler) {
        handlers.put(name, handler);
    }

    public abstract List<String> getCatalogs();

    public abstract List<String> getSchemas(String var1);

    public abstract void getTables(String var1, String var2, String var3, List<String> var4, List<String> var5);

    public abstract List<SAPFieldMetadata> getColumns(String var1, String var2, String var3);

    public List<SAPFieldMetadata> getPKColumns() {
        return null;
    }

    protected String mergeTwoLevel(String level1, String level2) {
        return level1 + "::" + level2;
    }

    protected String extractLevelOne(String mergedLevels) {
        if (mergedLevels != null) {
            return mergedLevels.substring(0, mergedLevels.lastIndexOf("::"));
        }
        return null;
    }

    protected String extractLevelTwo(String mergedLevels) {
        if (mergedLevels != null) {
            return mergedLevels.substring(mergedLevels.lastIndexOf("::") + 2);
        }
        return null;
    }

    protected boolean canHandle(String catalogName) {
        return this.mName.equals(catalogName);
    }

    public static SAPObjectHandler getHandler(String name) {
        return handlers.get(name);
    }
}

