/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sap;

import com.cognos.jdbc.driver.sap.SAPObjectHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPRFCIntrpspectorBean;
import java.util.ArrayList;
import java.util.List;

public class SAPRFCHandler
extends SAPObjectHandler {
    private SAPRFCIntrpspectorBean mIntrospector = null;

    public SAPRFCHandler(SAPRFCIntrpspectorBean bean) {
        super("RFCs");
        this.mIntrospector = bean;
    }

    @Override
    public List<String> getCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add("RFCs");
        return catalogs;
    }

    @Override
    public List<String> getSchemas(String catalogName) {
        if (!this.canHandle(catalogName)) {
            return null;
        }
        List schemaNames = this.mIntrospector.getRFCDevClassNames("%");
        return schemaNames;
    }

    @Override
    public void getTables(String catalogName, String schemaName, String tableNameFilter, List<String> tableNames, List<String> remarks) {
        if (tableNames == null) {
            throw new RuntimeException("List<String> tableNames cannot be null");
        }
        if (!this.canHandle(catalogName)) {
            return;
        }
        List funcGrps = this.mIntrospector.getRFCFunctionGroups(schemaName);
        if (funcGrps == null || funcGrps.size() == 0) {
            return;
        }
        for (String grp : funcGrps) {
            List rfcNames = this.mIntrospector.getRFCTableNames(grp, tableNameFilter);
            if (rfcNames == null) continue;
            tableNames.addAll(rfcNames);
        }
    }

    @Override
    public List<SAPFieldMetadata> getColumns(String catalogName, String schemaName, String tableName) {
        return this.mIntrospector.getRFCTableFields(tableName);
    }
}

