/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sfdc;

import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.cognos.jdbc.driver.sfdc.SFDCJdbcResultSet;
import java.util.HashMap;
import java.util.Map;

public class SFDCDataTypeHelper {
    private static Map<String, Integer> map = new HashMap<String, Integer>();

    public static String getTypeName(SForceTableColumn field) {
        switch (SFDCDataTypeHelper.getSQLType(field.getDataType())) {
            case 12: {
                return "VARCHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 3: {
                return "DECIMAL";
            }
            case -5: {
                return "BIGINT";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case 1: {
                return "CHAR";
            }
            case -7: {
                return "BIT";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 1111: {
                return "OTHER";
            }
        }
        return "NULL";
    }

    public static int getSQLType(String fieldType) {
        Integer sqlType = map.get(fieldType);
        if (sqlType != null) {
            return sqlType;
        }
        return 0;
    }

    public static int getColumnSize(SForceTableColumn field) {
        switch (SFDCDataTypeHelper.getSQLType(field.getDataType())) {
            case -5: {
                return field.getDigits();
            }
            case 3: {
                return field.getPrecision();
            }
            case 1: {
                if (!field.getDataType().equals(SFDCJdbcResultSet.SFORCE_DATATYPE_BOOLEAN)) break;
                return 5;
            }
        }
        return field.getLength();
    }

    public static int getDecimalDigits(SForceTableColumn field) {
        if (SFDCDataTypeHelper.getSQLType(field.getDataType()) == 3) {
            return field.getScale();
        }
        return 0;
    }

    static {
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_ID, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_REFERENCE, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_STRING, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_PHONE, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_URL, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_EMAIL, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_COMBOBOX, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_MULTIPICKLIST, -9);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_PICKLIST, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_ANYTYPE, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_TIME, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_TEXTAREA, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_BASE64, 12);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_BOOLEAN, 16);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_DOUBLE, 3);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_CURRENCY, 3);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_PERCENT, 3);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_INT, -5);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_DATETIME, 93);
        map.put(SFDCJdbcResultSet.SFORCE_DATATYPE_DATE, 91);
    }
}

