/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sfdc;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.cognos.jdbc.driver.sfdc.AbstractJdbcDriver;
import com.cognos.jdbc.driver.sfdc.SFDCJdbcConnection;
import com.cognos.jdbc.driver.sfdc.SFDCOptionEnum;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SFDCJdbcDriver
extends AbstractJdbcDriver {
    private static final int DEFAULT_CON_TIMEOUT = 60;
    private static final int DEFAULT_CONC_CALLS_LIMIT = 25;
    private static final int DEFAULT_USER_CONC_CALLS_LIMIT = 10;
    static Pattern pattern = Pattern.compile("sfdc:http(s)?://((.)+\\.)?salesforce.com(:[0-9]+)?((/(.)+)*|/)");

    private SForceConnectionParams getSFDCConnParams(Properties info) {
        SForceConnectionParams params = new SForceConnectionParams();
        String user = info.getProperty("user");
        params.setUserName(user);
        String password = info.getProperty("password");
        params.setPassword(password);
        params.setConcurrentCallsLimit(25);
        params.setUserConcurrentCallsLimit(10);
        params.setConnectionTimeOut(60);
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(params.getClass());
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                pdMap.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException beanInfo) {
            // empty catch block
        }
        Set<Map.Entry<Object, Object>> entrySet = info.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String optionName = (String)entry.getKey();
            String optionValue = (String)entry.getValue();
            try {
                SFDCOptionEnum optionEnum = SFDCOptionEnum.lookup(optionName);
                if (optionEnum == null) continue;
                String sForceKey = optionEnum.getSForceKey();
                PropertyDescriptor pd = (PropertyDescriptor)pdMap.get(sForceKey);
                if (pd.getPropertyType().getName() == "int" || pd.getPropertyType() == Integer.class) {
                    pd.getWriteMethod().invoke((Object)params, Integer.valueOf(optionValue));
                    continue;
                }
                if (pd.getPropertyType().getName() == "boolean" || pd.getPropertyType() == Boolean.class) {
                    pd.getWriteMethod().invoke((Object)params, Boolean.valueOf(optionValue));
                    continue;
                }
                if (pd.getPropertyType() != String.class) continue;
                pd.getWriteMethod().invoke((Object)params, optionValue);
            }
            catch (InvocationTargetException ite) {
                System.err.println(optionName);
                ite.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return params;
    }

    @Override
    protected boolean matchesPattern(String url) {
        return pattern.matcher(url).matches();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String[] parts = url.split(";");
        if (parts != null && parts.length > 0 && this.matchesPattern(parts[0])) {
            String sfdcURL = parts[0].substring(5);
            String[] options = new String[parts.length - 1];
            System.arraycopy(parts, 1, options, 0, options.length);
            this.mergeURLOptions(options, info);
            info.put(SFDCOptionEnum.URL.getOptionName(), sfdcURL);
            SForceConnectionParams sfdcConnParams = this.getSFDCConnParams(info);
            try {
                SForceRequestManager.getInstance().validateConnection(sfdcConnParams);
                SFDCJdbcConnection conn = new SFDCJdbcConnection(sfdcConnParams);
                return conn;
            }
            catch (SForceException sfe) {
                throw new SQLException(sfe);
            }
        }
        throw new SQLException("Malformed url = " + url);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported.");
    }

    static {
        SFDCJdbcDriver thisDriver = new SFDCJdbcDriver();
        try {
            DriverManager.registerDriver(thisDriver);
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
    }
}

