/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.sfdc;

import com.cognos.cdms.ds.sforce.introspect.objects.SForceChildRelationShipInfo;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.cognos.jdbc.driver.AbstractJdbcDatabaseMetadata;
import com.cognos.jdbc.driver.EOFRow;
import com.cognos.jdbc.driver.JdbcResultSet;
import com.cognos.jdbc.driver.Row;
import com.cognos.jdbc.driver.sfdc.SFDCDataTypeHelper;
import com.cognos.jdbc.driver.sfdc.SFDCJdbcResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SFDCJdbcMetadata
extends AbstractJdbcDatabaseMetadata {
    private SForceConnectionParams mParams = null;
    private SForceTable[] tableList = null;
    private HashMap<String, SForceTableInfo> tablecolumnInfo = null;
    private HashMap<String, ArrayList<SForceParentRelationshipInfo>> parentChildRelInfo = null;

    public SFDCJdbcMetadata(SForceConnectionParams params) {
        this.mParams = params;
    }

    private synchronized void initTable() {
        if (this.tableList == null) {
            this.tableList = SForceRequestManager.getInstance().describeGlobal(this.mParams);
        }
    }

    private synchronized void initColumn() {
        this.initTable();
        String[] tableNames = new String[this.tableList.length];
        int index = 0;
        for (SForceTable table : this.tableList) {
            tableNames[index++] = table.getName();
        }
        this.tablecolumnInfo = SForceRequestManager.getInstance().describeSObjects(this.mParams, tableNames);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new SFDCJdbcResultSet(CATALOG_MD_COLUMNS, this.getNoResultsQueue());
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return new SFDCJdbcResultSet(SCHEMA_MD_COLUMNS, this.getNoResultsQueue());
    }

    @Override
    public ResultSet getSchemas(String catalogName, String schemaNamePattern) throws SQLException {
        return new SFDCJdbcResultSet(SCHEMA_MD_COLUMNS, this.getNoResultsQueue());
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaName, final String tablePattern, final String[] tableTypes) throws SQLException {
        this.initTable();
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(TABLE_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                if (tableTypes != null) {
                    for (String tableType : tableTypes) {
                        if (!"TABLE".equals(tableType)) continue;
                        SFDCJdbcMetadata.this.populateTableRows(tablePattern, tableType, queue);
                    }
                } else {
                    SFDCJdbcMetadata.this.populateTableRows(tablePattern, "TABLE", queue);
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getColumns(String catalogName, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.tableList == null || this.tablecolumnInfo == null) {
            this.initColumn();
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(COLUMN_MD_COLUMNS, queue);
        new TableBatchProcessor(queue, tableNamePattern){

            @Override
            protected List<Row> getRows(SForceTableInfo result) {
                ArrayList<Row> rows = new ArrayList<Row>();
                for (SForceTableColumn field : result.getFields()) {
                    HashMap<String, String> row = new HashMap<String, String>();
                    String columnName = field.getName();
                    String typeName = SFDCDataTypeHelper.getTypeName(field);
                    if (typeName.equals("BOOLEAN")) continue;
                    row.put("TABLE_NAME", result.getName());
                    row.put("COLUMN_NAME", columnName);
                    row.put("REMARKS", "NATIVE_DATA_TYPE=" + field.getDataType());
                    row.put("DATA_TYPE", String.valueOf(SFDCDataTypeHelper.getSQLType(field.getDataType())));
                    row.put("TYPE_NAME", typeName);
                    row.put("COLUMN_SIZE", String.valueOf(SFDCDataTypeHelper.getColumnSize(field)));
                    row.put("DECIMAL_DIGITS", String.valueOf(SFDCDataTypeHelper.getDecimalDigits(field)));
                    row.put("NULLABLE", field.isNillable() ? String.valueOf(1) : String.valueOf(0));
                    row.put("IS_NULLABLE", field.isNillable() ? "YES" : "NO");
                    rows.add(new Row(row));
                }
                return rows;
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalogName, String schemaName, final String tableName) throws SQLException {
        if (this.tableList == null || this.tablecolumnInfo == null) {
            this.initColumn();
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(PK_MD_COLUMNS, queue);
        new TableBatchProcessor(queue, tableName){

            @Override
            protected List<Row> getRows(SForceTableInfo result) {
                ArrayList<Row> rows = new ArrayList<Row>();
                for (SForceTableColumn field : result.getFields()) {
                    if (!field.getName().equalsIgnoreCase("id")) continue;
                    HashMap<String, String> row = new HashMap<String, String>();
                    String pkTableName = tableName;
                    String pkName = pkTableName + "_PK";
                    row.put("TABLE_NAME", pkTableName);
                    row.put("COLUMN_NAME", field.getName());
                    row.put("KEY_SEQ", String.valueOf(1));
                    row.put("PK_NAME", pkName);
                    rows.add(new Row(row));
                    break;
                }
                return rows;
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalogName, String schemaName, String tableName, boolean unique, boolean approximate) throws SQLException {
        if (this.tableList == null || this.tablecolumnInfo == null) {
            this.initColumn();
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(IDX_MD_COLUMNS, queue);
        new TableBatchProcessor(queue, tableName){

            @Override
            protected List<Row> getRows(SForceTableInfo result) {
                ArrayList<Row> rows = new ArrayList<Row>();
                for (SForceTableColumn field : result.getFields()) {
                    if (!field.isIdLookup()) continue;
                    HashMap<String, String> row = new HashMap<String, String>();
                    row.put("TABLE_NAME", result.getName());
                    row.put("NON_UNIQUE", "false");
                    row.put("TYPE", String.valueOf(2));
                    row.put("ORDINAL_POSITION", String.valueOf(1));
                    row.put("COLUMN_NAME", field.getName());
                    row.put("ASC_OR_DESC", "A");
                    row.put("INDEX_NAME", field.getName() + "_IDX");
                    rows.add(new Row(row));
                }
                return rows;
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tableName) throws SQLException {
        if (this.tableList == null || this.tablecolumnInfo == null) {
            this.initColumn();
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(FK_MD_COLUMNS, queue);
        new TableBatchProcessor(queue, tableName){

            @Override
            protected List<Row> getRows(SForceTableInfo result) {
                ArrayList<Row> rows = new ArrayList<Row>();
                SForceChildRelationShipInfo[] childRelations = result.getChildRelationships();
                if (childRelations != null) {
                    for (SForceChildRelationShipInfo childRelation : childRelations) {
                        HashMap<String, String> row = new HashMap<String, String>();
                        String pkTableName = result.getName();
                        String fkTableName = childRelation.getChildSobject();
                        String fkColumnName = childRelation.getField();
                        String pkName = pkTableName + "_PK";
                        String fkName = childRelation.getRelationShipName();
                        fkName = fkName == null ? pkTableName + "_" + fkTableName + "_" + fkColumnName : fkName + "_" + pkTableName;
                        row.put("PKTABLE_NAME", pkTableName);
                        row.put("PKCOLUMN_NAME", "Id");
                        row.put("FKTABLE_NAME", fkTableName);
                        row.put("FKCOLUMN_NAME", fkColumnName);
                        row.put("KEY_SEQ", String.valueOf(1));
                        row.put("PK_NAME", pkName);
                        row.put("FK_NAME", fkName);
                        rows.add(new Row(row));
                    }
                }
                return rows;
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, final String tableName) throws SQLException {
        if (this.tableList == null || this.tablecolumnInfo == null) {
            this.initColumn();
        }
        if (this.parentChildRelInfo == null) {
            this.processSForceChildRelationshipInfo();
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        SFDCJdbcResultSet rs = new SFDCJdbcResultSet(FK_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                ArrayList parentRelations = (ArrayList)SFDCJdbcMetadata.this.parentChildRelInfo.get(tableName);
                if (parentRelations != null) {
                    Collections.sort(parentRelations);
                    for (SForceParentRelationshipInfo parentRelation : parentRelations) {
                        HashMap<String, String> row = new HashMap<String, String>();
                        String pkTableName = parentRelation.getParentSobject();
                        String fkTableName = tableName;
                        String fkColumnName = parentRelation.getField();
                        String pkName = pkTableName + "_PK";
                        String fkName = parentRelation.getRelationShipName();
                        fkName = fkName == null ? pkTableName + "_" + fkTableName + "_" + fkColumnName : fkName + "_" + pkTableName;
                        row.put("PKTABLE_NAME", pkTableName);
                        row.put("PKCOLUMN_NAME", "Id");
                        row.put("FKTABLE_NAME", fkTableName);
                        row.put("FKCOLUMN_NAME", fkColumnName);
                        row.put("KEY_SEQ", String.valueOf(1));
                        row.put("PK_NAME", pkName);
                        row.put("FK_NAME", fkName);
                        queue.add(new Row(row));
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new JdbcResultSet(PROC_COLS_MD_COLUMNS);
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        return new JdbcResultSet(PROC_MD_COLUMNS);
    }

    private void processSForceChildRelationshipInfo() {
        this.parentChildRelInfo = new HashMap();
        for (String tableName : this.tablecolumnInfo.keySet()) {
            SForceChildRelationShipInfo[] childInfo;
            SForceTableInfo tableInfo = this.tablecolumnInfo.get(tableName);
            for (SForceChildRelationShipInfo cInfo : childInfo = tableInfo.getChildRelationships()) {
                String childObject = cInfo.getChildSobject();
                SForceParentRelationshipInfo pInfo = new SForceParentRelationshipInfo(tableName, cInfo);
                if (!this.parentChildRelInfo.containsKey(childObject)) {
                    this.parentChildRelInfo.put(childObject, new ArrayList(5));
                }
                this.parentChildRelInfo.get(childObject).add(pInfo);
            }
        }
    }

    private void populateTableRows(String tablePattern, String tableType, BlockingQueue<Row> queue) {
        try {
            SForceTable[] result = this.tableList;
            for (int i = 0; i < result.length; ++i) {
                if (!result[i].isQueryable()) continue;
                String tableName = result[i].getName();
                if (tablePattern != null && !tablePattern.equals(tableName)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TABLE_NAME", tableName);
                map.put("TABLE_TYPE", "TABLE");
                queue.add(new Row(map));
            }
        }
        catch (SForceException sfe) {
            for (Throwable cause = sfe.getCause(); cause != null; cause = cause.getCause()) {
                StackTraceElement[] traceElements = cause.getStackTrace();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TABLE_NAME", cause.getMessage());
                queue.add(new Row(map));
                for (StackTraceElement trace : traceElements) {
                    map = new HashMap();
                    map.put("TABLE_NAME", trace.toString());
                    queue.add(new Row(map));
                }
                map = new HashMap();
                map.put("TABLE_NAME", "--------------------------------------------");
                queue.add(new Row(map));
            }
            queue.add(new EOFRow());
            System.out.println(sfe.getCause());
            sfe.printStackTrace();
            throw sfe;
        }
    }

    private abstract class TableBatchProcessor
    extends Thread {
        private static final int DESCRIBE_OBJECTS_BATCH_SIZE = 75;
        private BlockingQueue<Row> mQueue = null;
        private String mTableNamePattern = null;

        public TableBatchProcessor(BlockingQueue<Row> q, String pattern) {
            this.mQueue = q;
            this.mTableNamePattern = pattern;
        }

        @Override
        public void run() {
            String[] tableNames = this.getTableNames(this.mTableNamePattern);
            boolean batchSize = false;
            this.addRows(this.mQueue, tableNames);
            this.mQueue.add(new EOFRow());
        }

        protected final void addRows(BlockingQueue<Row> queue, String[] tableNames) {
            HashMap results = null;
            try {
                results = SFDCJdbcMetadata.this.tablecolumnInfo;
            }
            catch (SForceException sfe) {
                sfe.printStackTrace();
                return;
            }
            for (String tableName : tableNames) {
                List<Row> rows = this.getRows((SForceTableInfo)results.get(tableName));
                for (Row row : rows) {
                    queue.add(row);
                }
            }
        }

        private String[] getTableNames(String tableNamePattern) {
            String[] tableNames = null;
            if (tableNamePattern == null) {
                try {
                    SForceTable[] result = SFDCJdbcMetadata.this.tableList;
                    ArrayList<String> tableNamesList = new ArrayList<String>();
                    for (int i = 0; i < result.length; ++i) {
                        if (!result[i].isQueryable()) continue;
                        String tableName = result[i].getName();
                        tableNamesList.add(tableName);
                    }
                    tableNames = tableNamesList.toArray(new String[0]);
                }
                catch (SForceException sfe) {
                    System.out.println(sfe.getCause());
                    sfe.printStackTrace();
                }
            } else {
                tableNames = new String[]{tableNamePattern};
            }
            return tableNames;
        }

        protected abstract List<Row> getRows(SForceTableInfo var1);
    }

    private static class SForceParentRelationshipInfo
    implements Comparable<SForceParentRelationshipInfo> {
        private String parentSObject;
        private SForceChildRelationShipInfo cInfo;

        private SForceParentRelationshipInfo(String parentSObject, SForceChildRelationShipInfo cInfo) {
            this.parentSObject = parentSObject;
            this.cInfo = cInfo;
        }

        public String getField() {
            return this.cInfo.getField();
        }

        public boolean isDeprecatedAndHidden() {
            return this.cInfo.isDeprecatedAndHidden();
        }

        public String getRelationShipName() {
            return this.cInfo.getRelationShipName();
        }

        public String getParentSobject() {
            return this.parentSObject;
        }

        @Override
        public int compareTo(SForceParentRelationshipInfo o) {
            return this.parentSObject.compareTo(o.getParentSobject());
        }
    }
}

