/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.siebel;

import com.cognos.cdms.ds.siebel.sdb.SDBConnection;
import com.cognos.cdms.ds.siebel.sdb.SDBException;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBConnectionImpl;
import com.cognos.jdbc.driver.sfdc.AbstractJdbcDriver;
import com.cognos.jdbc.driver.siebel.SiebelJdbcConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SiebelJdbcDriver
extends AbstractJdbcDriver {
    private static final String DEFAULT_SIEBEL_REPOSITORY = "Siebel Repository";
    private static final Pattern mURLPattern = Pattern.compile("siebel(([.]{1}\\w*){3}|)://([a-z0-9_.])+([:]{1}[0-9]+)?/\\w+/\\w+", 2);
    private static final String LOGIN_RETRY_COUNT = "LOGIN_RETRY_COUNT";
    private static final String LOGIN_RETRY_DELAY = "LOGIN_RETRY_DELAY";
    private static final String REPOSITORY_NAME = "REPOSITORY_NAME";

    @Override
    protected boolean matchesPattern(String url) {
        return mURLPattern.matcher(url).matches();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String siebelConnectStr;
        String[] parts = url.split(";");
        if (parts.length > 0 && this.matchesPattern(siebelConnectStr = parts[0])) {
            String[] options = new String[parts.length - 1];
            System.arraycopy(parts, 1, options, 0, options.length);
            this.mergeURLOptions(options, info);
            String user = (String)info.get("user");
            String password = (String)info.get("password");
            String repositoryName = (String)info.get(REPOSITORY_NAME);
            String retryCountStr = (String)info.get(LOGIN_RETRY_COUNT);
            int retryCount = 0;
            int retryDelay = 0;
            if (retryCountStr != null) {
                try {
                    retryCount = new Integer(retryCountStr);
                    if (retryCount > 0) {
                        String retryDelayStr = (String)info.get(LOGIN_RETRY_DELAY);
                        retryDelay = new Integer(retryDelayStr);
                    }
                }
                catch (NumberFormatException nfe) {
                    retryCount = 0;
                }
            }
            SDBConnectionImpl sdbConn = new SDBConnectionImpl(siebelConnectStr, user, password);
            try {
                sdbConn.connect(retryCount, retryDelay, "utf8");
            }
            catch (SDBException sdbe) {
                throw new SQLException(sdbe);
            }
            if (repositoryName == null || repositoryName.length() == 0) {
                repositoryName = DEFAULT_SIEBEL_REPOSITORY;
            }
            return new SiebelJdbcConnection((SDBConnection)sdbConn, repositoryName);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported.");
    }

    static {
        SiebelJdbcDriver thisDriver = new SiebelJdbcDriver();
        try {
            DriverManager.registerDriver(thisDriver);
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
    }
}

