/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.jdbc.driver.siebel;

import com.cognos.cdms.ds.siebel.beans.SiebelFieldBean;
import com.cognos.cdms.ds.siebel.beans.SiebelMethodParamBean;
import com.cognos.cdms.ds.siebel.sdb.SDBConnection;
import com.cognos.jdbc.driver.AbstractJdbcDatabaseMetadata;
import com.cognos.jdbc.driver.AsyncJdbcForwardOnlyResultSet;
import com.cognos.jdbc.driver.EOFRow;
import com.cognos.jdbc.driver.JdbcResultSet;
import com.cognos.jdbc.driver.Row;
import com.cognos.jdbc.driver.siebel.SiebelDataTypeHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class SiebelJdbcMetadata
extends AbstractJdbcDatabaseMetadata {
    private static final String PERIOD = ".";
    private static final String OPEN_BRACE = "(";
    private static final String CLOSE_BRACE = ")";
    private static final String PRIMARYJOIN = "P";
    private static final String MVC = "M";
    private SDBConnection mSDBConn = null;
    private String mRepositoryName = null;
    public static final String CATALOG_BUSINESS_OBJECTS = "Business Objects";
    public static final String CATALOG_BUSINESS_SERVICES = "Business Services";
    private Map<String, List<SiebelFieldBean>> tableColumnsCache = new LinkedHashMap<String, List<SiebelFieldBean>>(1000, 0.8f, true);
    private static final int COLUMN_CACHE_SIZE = 1000;

    public SiebelJdbcMetadata(SDBConnection conn, String repoName) {
        this.mSDBConn = conn;
        this.mRepositoryName = repoName;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        JdbcResultSet catalogsRS = new JdbcResultSet(CATALOG_MD_COLUMNS);
        for (String catalogName : this.getCatalogNames()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TABLE_CAT", catalogName);
            catalogsRS.addResult(new Row(map));
        }
        return catalogsRS;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        LinkedBlockingQueue<EOFRow> queue = new LinkedBlockingQueue<EOFRow>();
        JdbcResultSet rs = new JdbcResultSet(SCHEMA_MD_COLUMNS);
        for (String catalogName : this.getCatalogNames()) {
            this.addSchemaRows(catalogName, rs);
        }
        queue.add(new EOFRow());
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalogName, String schemaNamePattern) throws SQLException {
        LinkedBlockingQueue<EOFRow> queue = new LinkedBlockingQueue<EOFRow>();
        JdbcResultSet rs = new JdbcResultSet(SCHEMA_MD_COLUMNS);
        this.addSchemaRows(catalogName, rs);
        queue.add(new EOFRow());
        return rs;
    }

    private void addSchemaRows(String catalogName, JdbcResultSet rs) {
        List<String> schemaNames = this.getSchemaNames(catalogName);
        if (schemaNames != null) {
            for (String schemaName : schemaNames) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                rowMap.put("TABLE_CATALOG", catalogName);
                rowMap.put("TABLE_SCHEM", schemaName);
                rs.addResult(new Row(rowMap));
            }
        }
    }

    private List<String> getCatalogNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CATALOG_BUSINESS_OBJECTS);
        return names;
    }

    private List<String> getSchemaNames() {
        ArrayList<String> schemaNames = new ArrayList<String>();
        for (String catalogName : this.getCatalogNames()) {
            List<String> schemaList = this.getSchemaNames(catalogName);
            if (schemaList == null) continue;
            schemaNames.addAll(schemaList);
        }
        return schemaNames;
    }

    private List<String> getSchemaNames(String catalogName) {
        if (CATALOG_BUSINESS_OBJECTS.equals(catalogName)) {
            return this.mSDBConn.getBusinessObjectNames("*", this.mRepositoryName);
        }
        if (CATALOG_BUSINESS_SERVICES.equals(catalogName)) {
            return this.mSDBConn.getBusinessServiceNames("*", this.mRepositoryName);
        }
        return null;
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaPattern, final String tablePattern, String[] types) throws SQLException {
        if (catalogName == null) {
            return this.getCatalogs();
        }
        if (schemaPattern == null) {
            return this.getSchemas();
        }
        boolean isTableTypeSearch = false;
        if (types == null) {
            types = new String[]{"TABLE"};
        }
        for (String type : types) {
            if (!"TABLE".equals(type)) continue;
            isTableTypeSearch = true;
            break;
        }
        if (!isTableTypeSearch || catalogName != null && !CATALOG_BUSINESS_OBJECTS.equals(catalogName)) {
            return new JdbcResultSet(TABLE_MD_COLUMNS);
        }
        final ArrayList<String> schemaNames = new ArrayList<String>();
        if (schemaPattern == null) {
            List<String> busObjNames = this.getSchemaNames(CATALOG_BUSINESS_OBJECTS);
            if (busObjNames != null) {
                schemaNames.addAll(busObjNames);
            }
        } else {
            schemaNames.add(schemaPattern);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(TABLE_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                for (String schemaName : schemaNames) {
                    List tableNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessComponentNames(schemaName, tablePattern, SiebelJdbcMetadata.this.mRepositoryName);
                    if (tableNames == null) continue;
                    for (String tableName : tableNames) {
                        HashMap<String, String> rowMap = new HashMap<String, String>();
                        rowMap.put("TABLE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                        rowMap.put("TABLE_SCHEM", schemaName);
                        rowMap.put("TABLE_NAME", tableName);
                        rowMap.put("TABLE_TYPE", "TABLE");
                        queue.add(new Row(rowMap));
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalogName, final String schemaName, final String tableName) throws SQLException {
        if (catalogName != null && !CATALOG_BUSINESS_OBJECTS.equals(catalogName)) {
            return new JdbcResultSet(PK_MD_COLUMNS);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(PK_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                List<String> schemaNames = null;
                if (schemaName == null) {
                    schemaNames = SiebelJdbcMetadata.this.getSchemaNames(SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                } else {
                    schemaNames = new ArrayList();
                    schemaNames.add(schemaName);
                }
                if (schemaNames != null) {
                    for (String schemaName2 : schemaNames) {
                        List tableNames = null;
                        if (tableName == null) {
                            tableNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessComponentNames(schemaName2, null, SiebelJdbcMetadata.this.mRepositoryName);
                        } else {
                            tableNames = new ArrayList<String>();
                            tableNames.add(tableName);
                        }
                        if (tableNames == null) continue;
                        for (String tableName2 : tableNames) {
                            HashMap<String, String> rowMap = new HashMap<String, String>();
                            rowMap.put("TABLE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                            rowMap.put("TABLE_SCHEM", schemaName2);
                            rowMap.put("TABLE_NAME", tableName2);
                            rowMap.put("COLUMN_NAME", "Id");
                            rowMap.put("KEY_SEQ", String.valueOf(0));
                            rowMap.put("PK_NAME", tableName2 + "_PK");
                            queue.add(new Row(rowMap));
                        }
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getExportedKeys(String catalogName, String schemaName, String tableName) throws SQLException {
        return new JdbcResultSet(FK_MD_COLUMNS);
    }

    @Override
    public ResultSet getIndexInfo(String catalogName, final String schemaName, final String tableName, boolean unique, boolean approximate) throws SQLException {
        if (catalogName != null && !CATALOG_BUSINESS_OBJECTS.equals(catalogName)) {
            return new JdbcResultSet(IDX_MD_COLUMNS);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(IDX_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                List<String> schemaNames = null;
                if (schemaName == null) {
                    schemaNames = SiebelJdbcMetadata.this.getSchemaNames(SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                } else {
                    schemaNames = new ArrayList();
                    schemaNames.add(schemaName);
                }
                if (schemaNames != null) {
                    for (String schemaName2 : schemaNames) {
                        List tableNames = null;
                        if (tableName == null) {
                            tableNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessComponentNames(schemaName2, null, SiebelJdbcMetadata.this.mRepositoryName);
                        } else {
                            tableNames = new ArrayList<String>();
                            tableNames.add(tableName);
                        }
                        if (tableNames == null) continue;
                        for (String tableName2 : tableNames) {
                            HashMap<String, String> rowMap = new HashMap<String, String>();
                            rowMap.put("TABLE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                            rowMap.put("TABLE_SCHEM", schemaName2);
                            rowMap.put("TABLE_NAME", tableName2);
                            rowMap.put("COLUMN_NAME", "Id");
                            rowMap.put("NON_UNIQUE", String.valueOf(false));
                            rowMap.put("TYPE", String.valueOf(3));
                            rowMap.put("ORDINAL_POSITION", String.valueOf(1));
                            rowMap.put("ASC_OR_DESC", "A");
                            rowMap.put("INDEX_NAME", tableName2 + "_IDX");
                            queue.add(new Row(rowMap));
                        }
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    private List<SiebelFieldBean> getColumnsFromCache(String tableName) {
        return this.tableColumnsCache.get(tableName);
    }

    private void cacheColumns(String tableName, List<SiebelFieldBean> fields) {
        if (this.tableColumnsCache.size() > 1000) {
            this.tableColumnsCache.remove(this.tableColumnsCache.entrySet().iterator().next().getKey());
        }
        this.tableColumnsCache.put(tableName, fields);
    }

    @Override
    public ResultSet getColumns(String catalogName, final String schemaName, final String tableName, String columnName) throws SQLException {
        if (catalogName != null && !catalogName.equals(CATALOG_BUSINESS_OBJECTS)) {
            return new JdbcResultSet(COLUMN_MD_COLUMNS);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(COLUMN_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                List schemaNames = null;
                if (schemaName == null) {
                    schemaNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessObjectNames(null, SiebelJdbcMetadata.this.mRepositoryName);
                } else {
                    schemaNames = new ArrayList<String>();
                    schemaNames.add(schemaName);
                }
                for (String schemaName2 : schemaNames) {
                    List tableNames = null;
                    if (tableName == null) {
                        tableNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessComponentNames(schemaName2, null, SiebelJdbcMetadata.this.mRepositoryName);
                    } else {
                        tableNames = new ArrayList<String>();
                        tableNames.add(tableName);
                    }
                    for (String tableName2 : tableNames) {
                        List fields = SiebelJdbcMetadata.this.getColumnsFromCache(tableName2);
                        if (fields == null) {
                            fields = SiebelJdbcMetadata.this.mSDBConn.getFields(tableName2, SiebelJdbcMetadata.this.mRepositoryName);
                            if (fields == null) continue;
                            SiebelJdbcMetadata.this.cacheColumns(tableName2, fields);
                        }
                        for (SiebelFieldBean field : fields) {
                            HashMap<String, String> rowMap = new HashMap<String, String>();
                            String typeName = SiebelDataTypeHelper.getTypeName(field);
                            if (typeName.toUpperCase().equals("BOOLEAN") || typeName.toUpperCase().equals("BOOL")) continue;
                            rowMap.put("TABLE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_OBJECTS);
                            rowMap.put("TABLE_SCHEM", schemaName2);
                            rowMap.put("TABLE_NAME", tableName2);
                            rowMap.put("COLUMN_NAME", SiebelJdbcMetadata.this.getTechnicalName(field));
                            rowMap.put("TYPE_NAME", typeName);
                            rowMap.put("DATA_TYPE", String.valueOf(SiebelDataTypeHelper.getSQLType(field)));
                            rowMap.put("COLUMN_SIZE", String.valueOf(SiebelDataTypeHelper.getColumnSize(field)));
                            rowMap.put("NULLABLE", field.isRequired() ? String.valueOf(0) : String.valueOf(1));
                            rowMap.put("IS_NULLABLE", field.isRequired() ? "NO" : "YES");
                            rowMap.put("DECIMAL_DIGITS", String.valueOf(SiebelDataTypeHelper.getDecimalDigits(field)));
                            String remarks = "MultiValuedColumn=" + String.valueOf(field.isMultiValued());
                            remarks = remarks + ",UsePrimaryJoin=" + String.valueOf(field.isUsePrimaryJoin());
                            rowMap.put("REMARKS", remarks);
                            queue.add(new Row(rowMap));
                        }
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getProcedures(String catalogName, String schemaNamePattern, String procedureNamePattern) throws SQLException {
        if (catalogName != null && !catalogName.equals(CATALOG_BUSINESS_SERVICES)) {
            return new JdbcResultSet(PROC_MD_COLUMNS);
        }
        final ArrayList<String> schemaNames = new ArrayList<String>();
        if (schemaNamePattern == null) {
            List<String> busServiceNames = this.getSchemaNames(CATALOG_BUSINESS_SERVICES);
            if (busServiceNames != null) {
                schemaNames.addAll(busServiceNames);
            }
        } else {
            schemaNames.add(schemaNamePattern);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(PROC_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                for (String schemaName : schemaNames) {
                    List procNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessMethodNames(schemaName, null, SiebelJdbcMetadata.this.mRepositoryName);
                    if (procNames == null) continue;
                    for (String procName : procNames) {
                        HashMap<String, String> rowMap = new HashMap<String, String>();
                        rowMap.put("PROCEDURE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_SERVICES);
                        rowMap.put("PROCEDURE_SCHEM", schemaName);
                        rowMap.put("PROCEDURE_NAME", procName);
                        rowMap.put("PROCEDURE_TYPE", String.valueOf(0));
                        queue.add(new Row(rowMap));
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, final String schemaPattern, final String procNamePattern, String columnNamePattern) throws SQLException {
        if (catalog != null && !catalog.equals(CATALOG_BUSINESS_SERVICES)) {
            return new JdbcResultSet(PROC_COLS_MD_COLUMNS);
        }
        final LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        AsyncJdbcForwardOnlyResultSet rs = new AsyncJdbcForwardOnlyResultSet(PROC_COLS_MD_COLUMNS, queue);
        new Thread(){

            @Override
            public void run() {
                List<String> schemaNames = null;
                if (schemaPattern == null) {
                    schemaNames = SiebelJdbcMetadata.this.getSchemaNames(SiebelJdbcMetadata.CATALOG_BUSINESS_SERVICES);
                } else {
                    schemaNames = new ArrayList();
                    schemaNames.add(schemaPattern);
                }
                if (schemaNames != null) {
                    for (String schemaName : schemaNames) {
                        List procNames = null;
                        if (procNamePattern == null) {
                            procNames = SiebelJdbcMetadata.this.mSDBConn.getBusinessMethodNames(schemaName, null, SiebelJdbcMetadata.this.mRepositoryName);
                        } else {
                            procNames = new ArrayList<String>();
                            procNames.add(procNamePattern);
                        }
                        if (procNames == null) continue;
                        for (String procName : procNames) {
                            List params = null;
                            if (params == null) {
                                params = SiebelJdbcMetadata.this.mSDBConn.getMethodParams(schemaName, procName, SiebelJdbcMetadata.this.mRepositoryName);
                            }
                            if (params == null) continue;
                            for (SiebelMethodParamBean param : params) {
                                HashMap<String, String> rowMap = new HashMap<String, String>();
                                rowMap.put("PROCEDURE_CAT", SiebelJdbcMetadata.CATALOG_BUSINESS_SERVICES);
                                rowMap.put("PROCEDURE_SCHEM", schemaName);
                                rowMap.put("PROCEDURE_NAME", procName);
                                rowMap.put("COLUMN_NAME", param.getName());
                                rowMap.put("COLUMN_TYPE", String.valueOf(SiebelJdbcMetadata.this.getProcColumnType(param)));
                                rowMap.put("DATA_TYPE", String.valueOf(SiebelJdbcMetadata.this.getProcColumnSQLType(param)));
                                rowMap.put("TYPE_NAME", SiebelJdbcMetadata.this.getProcColumnSQLTypeName(param));
                                rowMap.put("NULLABLE", param.isRequired() ? String.valueOf(0) : String.valueOf(1));
                                queue.add(new Row(rowMap));
                            }
                        }
                    }
                }
                queue.add(new EOFRow());
            }
        }.start();
        return rs;
    }

    private short getProcColumnType(SiebelMethodParamBean param) {
        switch (param.getDirection()) {
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private int getProcColumnSQLType(SiebelMethodParamBean param) {
        switch (param.getParameterType()) {
            case 0: {
                return 12;
            }
            case 2: {
                return 91;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 2009;
            }
            case 4: {
                return 2009;
            }
        }
        return 1111;
    }

    private String getProcColumnSQLTypeName(SiebelMethodParamBean param) {
        switch (param.getParameterType()) {
            case 0: {
                return "VARCHAR";
            }
            case 2: {
                return "DATE";
            }
            case 1: {
                return "NUMERIC";
            }
            case 3: {
                return "XML";
            }
            case 4: {
                return "XML";
            }
        }
        return "OTHER";
    }

    private String getTechnicalName(SiebelFieldBean fld) {
        StringBuilder name = new StringBuilder();
        name.append(fld.getName());
        if (fld.isMultiValued() && fld.isUsePrimaryJoin()) {
            name.append(OPEN_BRACE);
            name.append(MVC);
            name.append(PRIMARYJOIN);
            name.append(CLOSE_BRACE);
        } else if (fld.isUsePrimaryJoin()) {
            name.append(OPEN_BRACE);
            name.append(PRIMARYJOIN);
            name.append(CLOSE_BRACE);
        } else if (fld.isMultiValued()) {
            name.append(OPEN_BRACE);
            name.append(MVC);
            name.append(CLOSE_BRACE);
        } else if (name.toString().endsWith("(M)") || name.toString().endsWith("(P)") || name.toString().endsWith("(MP)")) {
            name.append(PERIOD);
        }
        return name.toString();
    }
}

