/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.olap.common;

import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.metadata.ActionTypeEnum;
import java.util.EnumSet;

public final class MSASCommonActions {
    public static final String CONTENT = "CONTENT";
    private static final int MDACTION_TYPE_URL = 1;
    private static final int MDACTION_TYPE_HTML = 2;
    private static final int MDACTION_TYPE_STATEMENT = 4;
    private static final int MDACTION_TYPE_DATASET = 8;
    private static final int MDACTION_TYPE_ROWSET = 16;
    private static final int MDACTION_TYPE_COMMANDLINE = 32;
    private static final int MDACTION_TYPE_PROPRIETARY = 64;
    private static final int MDACTION_TYPE_REPORT = 128;
    private static final int MDACTION_TYPE_DRILLTHROUGH = 256;
    private static final int MDACTION_COORDINATE_CUBE = 1;
    private static final int MDACTION_COORDINATE_DIMENSION = 2;
    private static final int MDACTION_COORDINATE_LEVEL = 3;
    private static final int MDACTION_COORDINATE_MEMBER = 4;
    private static final int MDACTION_COORDINATE_CELL = 6;

    private MSASCommonActions() {
    }

    public static ActionTypeEnum convertIntToActionTypeEnum(int actionType) {
        ActionTypeEnum answer = ActionTypeEnum.URL;
        switch (actionType) {
            case 1: {
                answer = ActionTypeEnum.URL;
                break;
            }
            case 2: {
                answer = ActionTypeEnum.HTML;
                break;
            }
            case 4: {
                answer = ActionTypeEnum.STATEMENT;
                break;
            }
            case 8: {
                answer = ActionTypeEnum.DATASET;
                break;
            }
            case 16: {
                answer = ActionTypeEnum.ROWSET;
                break;
            }
            case 32: {
                answer = ActionTypeEnum.COMMANDLINE;
                break;
            }
            case 64: {
                answer = ActionTypeEnum.PROPRIETARY;
                break;
            }
            case 128: {
                answer = ActionTypeEnum.REPORT;
                break;
            }
            case 256: {
                answer = ActionTypeEnum.DRILLTHROUGH;
                break;
            }
            default: {
                StringBuilder buffer = new StringBuilder("Unexpected action type specified: ");
                buffer.append(actionType);
                throw new IllegalArgumentException(buffer.toString());
            }
        }
        return answer;
    }

    public static int convertActionCoordinateTypeEnumSetToInt(EnumSet<ActionCoordinateTypeEnum> coordinateTypeSet) {
        int answer = 0;
        block7: for (ActionCoordinateTypeEnum coordinateType : coordinateTypeSet) {
            switch (coordinateType) {
                case CUBE: {
                    answer |= 1;
                    continue block7;
                }
                case DIMENSION: {
                    answer |= 2;
                    continue block7;
                }
                case LEVEL: {
                    answer |= 3;
                    continue block7;
                }
                case MEMBER: {
                    answer |= 4;
                    continue block7;
                }
                case CELL: {
                    answer |= 6;
                    continue block7;
                }
            }
            StringBuilder buffer = new StringBuilder("Unexpected action coordinate type specified: ");
            buffer.append(coordinateType.toString());
            throw new IllegalArgumentException(buffer.toString());
        }
        return answer;
    }

    public static ActionCoordinateTypeEnum convertIntToActionCoordinateTypeEnumSet(int coordinateType) {
        ActionCoordinateTypeEnum answer;
        switch (coordinateType) {
            case 1: {
                answer = ActionCoordinateTypeEnum.CUBE;
                break;
            }
            case 2: {
                answer = ActionCoordinateTypeEnum.DIMENSION;
                break;
            }
            case 3: {
                answer = ActionCoordinateTypeEnum.LEVEL;
                break;
            }
            case 4: {
                answer = ActionCoordinateTypeEnum.MEMBER;
                break;
            }
            case 6: {
                answer = ActionCoordinateTypeEnum.CELL;
                break;
            }
            default: {
                StringBuilder buffer = new StringBuilder("Unexpected action coordinate type found: ");
                buffer.append(coordinateType);
                throw new IllegalArgumentException(buffer.toString());
            }
        }
        return answer;
    }
}

